---
id: "global-base"
title: "Global Base Rules"
tags: ["global", "base"]
priority: 100
paths: ["**/*"]
---

# Global Project Rules

## Core Principles
- **DRY (Don't Repeat Yourself)**: Avoid duplication. Extract reusable logic.
- **KISS (Keep It Simple, Stupid)**: Prefer simple solutions over complex ones.
- **Clean Code**: Write code that is readable and maintainable.

## Security (Non-Negotiable)
> [!IMPORTANT]
> - Never hardcode secrets (API keys, tokens, passwords). Use environment variables.
> - Validate all user inputs at the API boundary.
> - Ensure dependencies are audited for vulnerabilities.

## Git & Version Control
- Commit messages must be descriptive (e.g., `feat: check user permissions`).
- Do not commit generated files or secrets.
