---
id: "frontend-react"
title: "React Best Practices"
tags: ["frontend", "react", "tsx", "ui"]
priority: 90
paths: ["**/*.tsx", "**/components/**"]
applies_when: ["frontend", "component"]
---

# React Best Practices

## Components
- **Functional Components**: Use functional components with hooks. Avoid class components.
- **PascalCase**: Component filenames and names must use PascalCase (e.g., `UserProfile.tsx`).
- **Props Interface**: Define a `Props` interface for component props.

```typescript
interface Props {
  userId: string;
  isActive?: boolean;
}

export const UserProfile = ({ userId, isActive = false }: Props) => {
  // ...
};
```

## State Management
- Use `useState` for local state and `useContext` or global state managers (like Jotai/Zustand) for shared state.
- Avoid prop drilling deeper than 2 levels.

## Performance
- Use `useMemo` and `useCallback` only when necessary to prevent expensive re-renders or stabilize references.
- Lazy load routes and heavy components using `React.lazy`.
