import { minimatch } from 'minimatch';
import { glob } from 'glob';

export const findMarkdownFiles = async (cwd: string): Promise<string[]> => {
    // Find all markdown files, ignoring node_modules and dot folders
    const files = await glob('**/*.md', {
        cwd,
        ignore: ['**/node_modules/**', '**/.*/**'],
        absolute: true,
    });
    return files;
};

export const matchGlob = (filePath: string, patterns: string[]): boolean => {
    if (!patterns || patterns.length === 0) return false;

    // Normalize windows paths for matching
    const normalizedPath = filePath.replace(/\\/g, '/');

    for (const pattern of patterns) {
        if (minimatch(normalizedPath, pattern, { dot: true, matchBase: true })) return true;
    }
    return false;
};
