---
id: "style-typescript"
title: "TypeScript Style Guide"
tags: ["typescript", "style", "lint"]
priority: 80
paths: ["**/*.ts", "**/*.tsx"]
---

# TypeScript Style Guide

## Typing
- **Explicit Types**: Avoid `any`. Define interfaces or types for all data structures.
- **Strict Mode**: `tsconfig.json` must have `"strict": true`.
- **Inference**: Rely on type inference for simple variable assignments.

## Naming Conventions
- **Variables/Functions**: camelCase
- **Classes/Interfaces/Types**: PascalCase
- **Constants**: UPPER_CASE for global constants, camelCase for local readonly variables.

## Async/Await
- Prefer `async/await` over raw `.then()` chains.
- Always handle errors in async functions with `try/catch` or return rejection.
