export interface RuleFrontmatter {
    id?: string;
    title?: string;
    tags?: string[];
    priority?: number;
    paths?: string[];
    applies_when?: string[];
    avoid?: string[];
}

export interface Rule {
    id: string;
    path: string;
    relativePath: string;
    title: string;
    content: string;
    tags: string[];
    priority: number;
    paths: string[]; // glob patterns
    applies_when: string[];
    avoid: string[];
    lastModified: number;
}

export interface SearchResult {
    rule: Rule;
    score: number;
    scoreBreakdown: {
        text: number;
        path: number;
        tag: number;
        priority: number;
    };
}

export interface RuleBundle {
    content: string;
    used: { id: string; path: string; title: string }[];
    truncated: boolean;
    notes: string[];
}
