import { minimatch } from 'minimatch';
import { glob } from 'glob';
import * as fs from 'fs';
export const findMarkdownFiles = async (cwd) => {
    // Find all markdown files, ignoring node_modules and dot folders
    const files = await glob('**/*.md', {
        cwd,
        ignore: ['**/node_modules/**', '**/.*/**', '**/Library/**', '**/Library/Application Support/**'],
        absolute: true,
        follow: false, // Don't follow symlinks to avoid duplication
    });
    // Use realpath to deduplicate and ensure unique files
    const uniqueFiles = Array.from(new Set(files.map(f => {
        try {
            return fs.realpathSync(f);
        }
        catch {
            return f;
        }
    })));
    return uniqueFiles;
};
export const matchGlob = (filePath, patterns) => {
    if (!patterns || patterns.length === 0)
        return false;
    // Normalize windows paths for matching
    const normalizedPath = filePath.replace(/\\/g, '/');
    for (const pattern of patterns) {
        if (minimatch(normalizedPath, pattern, { dot: true, matchBase: true }))
            return true;
    }
    return false;
};
