---
id: "backend-api"
title: "Backend API Standards"
tags: ["backend", "api", "node", "express"]
priority: 85
paths: ["**/api/**", "**/server/**", "**/controllers/**"]
---

# Backend API Standards

## RESTful Design
- Use standard HTTP methods: `GET` for retrieval, `POST` for creation, `PUT/PATCH` for updates, `DELETE` for removal.
- Resource URLs should be plural nouns (e.g., `/api/users`, not `/api/getUser`).

## Error Handling
- Return standardized error responses.
- Use HTTP status codes correctly (200 OK, 201 Created, 400 Bad Request, 401 Unauthorized, 404 Not Found, 500 Internal Server Error).

```json
{
  "error": {
    "code": "INVALID_INPUT",
    "message": "Email is required."
  }
}
```

## Database Interaction
- Use an ORM or Query Builder (e.g., Prisma, Drizzle) to prevent SQL injection.
- Do not perform database queries inside loops. Use batching.
