# Awing Rules MCP Server for Claude Code

A Model Context Protocol (MCP) server designed to help Claude Code dynamically find, filter, and compose project-specific rules from a large repository of Markdown files.

## Features

- **Smart Search**: Finds relevant rules using a weighted scoring algorithm:
  - **Text Match** (TF-IDF/BM25 approximation)
  - **Context Aware** (Prioritizes rules matching currently open or changed files)
  - **Tag & Priority System** (Weights tags and rule priority)
- **Rule Composition**: Dynamically bundles a global `base.md` with selected rules into a single, deduplicated Markdown prompt.
- **Deduplication**: Automatically removes duplicate generic bullet points to keep the context window efficient.
- **Diversification**: Ensures results are not dominated by a single category/folder.

## Installation

### Prerequisites
- Node.js v16+ (v18+ recommended)
- NPM

### Build

```bash
git clone <repo-url> awing-rules-claudecode-mcp
cd awing-rules-claudecode-mcp
npm install
npm run build
```

## Configuration

To use this with Claude Code or Claude Desktop, add it to your MCP configuration file (e.g., `claude_desktop_config.json` or equivalent for Claude Code).

```json
{
  "mcpServers": {
    "awing-rules-claudecode-mcp": {
      "command": "npx",
      "args": [
        "-y",
        "git+https://gitlab.awing.vn/awing-mcp/awing-rules-claudecode-mcp.git"
      ]
    }
  }
}
```

*Note: Replace the path with the absolute path to your `dist/index.js` file.*

## Usage with Claude Code

Once configured, Claude can use the following tools:

### 1. `rules.search`
Searches for rules relevant to the current task.
- **Inputs**: `query` (task description), `openFiles`, `changedFiles`, `tags`.
- **Outputs**: List of ranked rules with their IDs and scores.

### 2. `rules.compose`
Creates the final rule bundle.
- **Inputs**: `selected` (list of rule IDs/paths obtained from search).
- **Outputs**: A single markdown string containing the `base.md` content followed by the selected rules, optimized for the context window.

### Example Workflow
1. User asks: "Refactor the login component to use the new hook."
2. Claude calls `rules.search(query="refactor login hook", openFiles=["src/Login.tsx"], ...)`
3. Server returns top relevant rules (e.g., `frontend/react-hooks.md`, `style/typescript.md`).
4. Claude calls `rules.compose(selected=[{id: "react-hooks"}, {id: "typescript"}])`.
5. Server returns the combined markdown bundle.
6. Claude reads the bundle and executes the refactoring task following the rules.

## Rule File Structure

Place your markdown rule files in the root directory or subdirectories.
`base.md` in the root key is always included first.

**Example `frontend/react-components.md`:**

```markdown
---
id: "react-components"
title: "React Component Guidelines"
tags: ["frontend", "react", "tsx"]
priority: 80
paths: ["**/*.tsx"]
---

# React Component Rules

- Use functional components.
- Avoid default exports.
```
