---
id: "testing-jest"
title: "Testing Guidelines (Jest/Vitest)"
tags: ["testing", "jest", "vitest", "unit-test"]
priority: 70
paths: ["**/*.test.ts", "**/*.spec.ts", "**/tests/**"]
applies_when: ["test", "verify"]
---

# Testing Guidelines

## Unit Tests
- Write unit tests for all utility functions and shared logic.
- Mock external dependencies (API calls, DB) to keep tests fast and deterministic.

## Test Structure
- Use `describe` to group tests by function or module.
- Use `it` or `test` for individual test cases. Descriptions should be readable sentences.

```typescript
describe('calculateTotal', () => {
  it('should return 0 for empty cart', () => {
    expect(calculateTotal([])).toBe(0);
  });
});
```

## Coverage
- Aim for high branch coverage on critical business logic.
- Do not test implementation details, test public behavior.
