# ACM GraphQL MCP Server

MCP (Model Context Protocol) Server để gọi GraphQL API của ACM.

## Cài đặt

```bash
cd mcp-server
npm install
npm run build
```

## Cấu hình MCP

Thêm vào file cấu hình MCP của bạn (thường là `mcp.json` hoặc trong settings của AI assistant):

```json
{
    "servers": {
        "acm-graphql": {
            "command": "node",
            "args": ["e:/Project/ProjectByAuthor/Awing/acm/mcp-server/dist/index.js"],
            "env": {
                "GRAPHQL_ENDPOINT": "https://acm.awifi.com.vn/graphql",
                "AUTH_TOKEN": "YOUR_BEARER_TOKEN_HERE",
                "WORKSPACE_ID": "11"
            }
        }
    }
}
```

## Tools có sẵn

### Query Tools (15 tools)

| Tool | Mô tả |
|------|-------|
| `get_role_by_id` | Lấy Role theo ID |
| `get_roles` | Lấy danh sách Roles |
| `get_user_by_id` | Lấy User theo ID |
| `get_users` | Lấy danh sách Users |
| `get_place_by_id` | Lấy Place theo ID |
| `get_places` | Lấy danh sách Places |
| `get_group_by_id` | Lấy Group theo ID |
| `get_groups` | Lấy danh sách Groups |
| `get_campaign_by_id` | Lấy Campaign theo ID |
| `get_campaigns` | Lấy danh sách Campaigns |
| `get_template_by_id` | Lấy Template theo ID |
| `get_templates` | Lấy danh sách Templates |
| `get_workspace_by_id` | Lấy Workspace theo ID |
| `get_workspaces` | Lấy danh sách Workspaces |
| `execute_graphql` | Thực thi custom GraphQL query/mutation |

### Mutation Tools (14 tools)

| Tool | Mô tả |
|------|-------|
| `create_role` | Tạo mới Role |
| `update_role` | Cập nhật Role |
| `delete_role` | Xóa Role |
| `create_group` | Tạo mới Group |
| `update_group` | Cập nhật Group |
| `delete_group` | Xóa Group |
| `update_user` | Cập nhật User |
| `delete_user` | Xóa User |
| `add_user_to_workspace` | Thêm User vào Workspace |
| `create_place` | Tạo mới Place |
| `update_place` | Cập nhật Place |
| `create_campaign` | Tạo mới Campaign |
| `update_campaign` | Cập nhật Campaign |
| `delete_campaign` | Xóa Campaign |

## Ví dụ sử dụng

### Queries
```
"Lấy role có id là 10"
→ Gọi get_role_by_id(id: 10)

"Lấy 20 users đầu tiên"
→ Gọi get_users(pageSize: 20, pageIndex: 0)
```

### Mutations
```
"Tạo role mới tên Admin"
→ Gọi create_role(name: "Admin", description: "Admin role")

"Xóa role có id 5"
→ Gọi delete_role(id: 5)
```

### Custom GraphQL
```
"Thực thi query: { menus { id name } }"
→ Gọi execute_graphql(query: "{ menus { id name } }")
```

## Development

```bash
# Chạy trực tiếp TypeScript (dev mode)
npm run dev

# Build production
npm run build

# Start production
npm start
```
