# MCP Server Submission Template

## [Server Submission]: MCP Atlassian Server (by phuc-nt)

**GitHub Repo URL:**  
https://github.com/phuc-nt/mcp-jira-server

**Logo Image:**  
![Atlassian MCP Server Logo](../../assets/logo_icon.png)

**Reason for Addition:**  
This MCP server connects AI assistants to Atlassian Jira & Confluence, enabling natural language interaction with project management tools. It helps users manage issues, projects, and documentation without switching contexts during deep work.

### Key Features
- Connects AI assistants to Atlassian Jira and Confluence
- Provides both Resources (read-only data) and Tools (action endpoints)
- Local-first design for personal development environments
- Optimized for integration with Cline AI assistant
- Comprehensive documentation for users and developers

### Use Cases
- Query Jira issues, projects, and user information directly through AI
- Create and update issues, transition states, assign tasks seamlessly
- Create Confluence pages and add comments without context-switching
- Generate reports and summaries from Atlassian data using natural language
- Manage your daily Atlassian workflows through conversational interfaces

### Installation
The server includes comprehensive installation instructions in README.md and a detailed llms-install.md specifically designed for AI-assisted installation. Users can simply ask Cline to "Install MCP Atlassian Server (by phuc-nt)" for one-click setup.

### Requirements
- Node.js 16+ and npm
- Atlassian Cloud account with API token
- Compatible with Cline and other MCP-compatible clients

### Additional Notes
This server follows MCP best practices and is ready for one-click installation via Marketplace. It aims to enhance developer productivity by eliminating the need to context-switch between development environments and Atlassian tools. The project is actively maintained with a clear roadmap for future enhancements.

---

*This submission is intended for the Cline MCP Marketplace and follows the specified template format.* 