#!/usr/bin/env node
import { createRequire } from "node:module";
var __create = Object.create;
var __getProtoOf = Object.getPrototypeOf;
var __defProp = Object.defineProperty;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __toESM = (mod, isNodeMode, target) => {
  target = mod != null ? __create(__getProtoOf(mod)) : {};
  const to = isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target;
  for (let key of __getOwnPropNames(mod))
    if (!__hasOwnProp.call(to, key))
      __defProp(to, key, {
        get: () => mod[key],
        enumerable: true
      });
  return to;
};
var __commonJS = (cb, mod) => () => (mod || cb((mod = { exports: {} }).exports, mod), mod.exports);
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, {
      get: all[name],
      enumerable: true,
      configurable: true,
      set: (newValue) => all[name] = () => newValue
    });
};
var __esm = (fn, res) => () => (fn && (res = fn(fn = 0)), res);
var __require = /* @__PURE__ */ createRequire(import.meta.url);

// node_modules/dotenv/package.json
var require_package = __commonJS((exports, module) => {
  module.exports = {
    name: "dotenv",
    version: "16.5.0",
    description: "Loads environment variables from .env file",
    main: "lib/main.js",
    types: "lib/main.d.ts",
    exports: {
      ".": {
        types: "./lib/main.d.ts",
        require: "./lib/main.js",
        default: "./lib/main.js"
      },
      "./config": "./config.js",
      "./config.js": "./config.js",
      "./lib/env-options": "./lib/env-options.js",
      "./lib/env-options.js": "./lib/env-options.js",
      "./lib/cli-options": "./lib/cli-options.js",
      "./lib/cli-options.js": "./lib/cli-options.js",
      "./package.json": "./package.json"
    },
    scripts: {
      "dts-check": "tsc --project tests/types/tsconfig.json",
      lint: "standard",
      pretest: "npm run lint && npm run dts-check",
      test: "tap run --allow-empty-coverage --disable-coverage --timeout=60000",
      "test:coverage": "tap run --show-full-coverage --timeout=60000 --coverage-report=lcov",
      prerelease: "npm test",
      release: "standard-version"
    },
    repository: {
      type: "git",
      url: "git://github.com/motdotla/dotenv.git"
    },
    homepage: "https://github.com/motdotla/dotenv#readme",
    funding: "https://dotenvx.com",
    keywords: [
      "dotenv",
      "env",
      ".env",
      "environment",
      "variables",
      "config",
      "settings"
    ],
    readmeFilename: "README.md",
    license: "BSD-2-Clause",
    devDependencies: {
      "@types/node": "^18.11.3",
      decache: "^4.6.2",
      sinon: "^14.0.1",
      standard: "^17.0.0",
      "standard-version": "^9.5.0",
      tap: "^19.2.0",
      typescript: "^4.8.4"
    },
    engines: {
      node: ">=12"
    },
    browser: {
      fs: false
    }
  };
});

// node_modules/dotenv/lib/main.js
var require_main = __commonJS((exports, module) => {
  var fs = __require("fs");
  var path = __require("path");
  var os = __require("os");
  var crypto2 = __require("crypto");
  var packageJson = require_package();
  var version = packageJson.version;
  var LINE = /(?:^|^)\s*(?:export\s+)?([\w.-]+)(?:\s*=\s*?|:\s+?)(\s*'(?:\\'|[^'])*'|\s*"(?:\\"|[^"])*"|\s*`(?:\\`|[^`])*`|[^#\r\n]+)?\s*(?:#.*)?(?:$|$)/mg;
  function parse(src) {
    const obj2 = {};
    let lines = src.toString();
    lines = lines.replace(/\r\n?/mg, `
`);
    let match;
    while ((match = LINE.exec(lines)) != null) {
      const key = match[1];
      let value = match[2] || "";
      value = value.trim();
      const maybeQuote = value[0];
      value = value.replace(/^(['"`])([\s\S]*)\1$/mg, "$2");
      if (maybeQuote === '"') {
        value = value.replace(/\\n/g, `
`);
        value = value.replace(/\\r/g, "\r");
      }
      obj2[key] = value;
    }
    return obj2;
  }
  function _parseVault(options) {
    const vaultPath = _vaultPath(options);
    const result = DotenvModule.configDotenv({ path: vaultPath });
    if (!result.parsed) {
      const err = new Error(`MISSING_DATA: Cannot parse ${vaultPath} for an unknown reason`);
      err.code = "MISSING_DATA";
      throw err;
    }
    const keys = _dotenvKey(options).split(",");
    const length = keys.length;
    let decrypted;
    for (let i = 0;i < length; i++) {
      try {
        const key = keys[i].trim();
        const attrs = _instructions(result, key);
        decrypted = DotenvModule.decrypt(attrs.ciphertext, attrs.key);
        break;
      } catch (error) {
        if (i + 1 >= length) {
          throw error;
        }
      }
    }
    return DotenvModule.parse(decrypted);
  }
  function _warn(message) {
    console.log(`[dotenv@${version}][WARN] ${message}`);
  }
  function _debug(message) {
    console.log(`[dotenv@${version}][DEBUG] ${message}`);
  }
  function _dotenvKey(options) {
    if (options && options.DOTENV_KEY && options.DOTENV_KEY.length > 0) {
      return options.DOTENV_KEY;
    }
    if (process.env.DOTENV_KEY && process.env.DOTENV_KEY.length > 0) {
      return process.env.DOTENV_KEY;
    }
    return "";
  }
  function _instructions(result, dotenvKey) {
    let uri;
    try {
      uri = new URL(dotenvKey);
    } catch (error) {
      if (error.code === "ERR_INVALID_URL") {
        const err = new Error("INVALID_DOTENV_KEY: Wrong format. Must be in valid uri format like dotenv://:key_1234@dotenvx.com/vault/.env.vault?environment=development");
        err.code = "INVALID_DOTENV_KEY";
        throw err;
      }
      throw error;
    }
    const key = uri.password;
    if (!key) {
      const err = new Error("INVALID_DOTENV_KEY: Missing key part");
      err.code = "INVALID_DOTENV_KEY";
      throw err;
    }
    const environment = uri.searchParams.get("environment");
    if (!environment) {
      const err = new Error("INVALID_DOTENV_KEY: Missing environment part");
      err.code = "INVALID_DOTENV_KEY";
      throw err;
    }
    const environmentKey = `DOTENV_VAULT_${environment.toUpperCase()}`;
    const ciphertext = result.parsed[environmentKey];
    if (!ciphertext) {
      const err = new Error(`NOT_FOUND_DOTENV_ENVIRONMENT: Cannot locate environment ${environmentKey} in your .env.vault file.`);
      err.code = "NOT_FOUND_DOTENV_ENVIRONMENT";
      throw err;
    }
    return { ciphertext, key };
  }
  function _vaultPath(options) {
    let possibleVaultPath = null;
    if (options && options.path && options.path.length > 0) {
      if (Array.isArray(options.path)) {
        for (const filepath of options.path) {
          if (fs.existsSync(filepath)) {
            possibleVaultPath = filepath.endsWith(".vault") ? filepath : `${filepath}.vault`;
          }
        }
      } else {
        possibleVaultPath = options.path.endsWith(".vault") ? options.path : `${options.path}.vault`;
      }
    } else {
      possibleVaultPath = path.resolve(process.cwd(), ".env.vault");
    }
    if (fs.existsSync(possibleVaultPath)) {
      return possibleVaultPath;
    }
    return null;
  }
  function _resolveHome(envPath) {
    return envPath[0] === "~" ? path.join(os.homedir(), envPath.slice(1)) : envPath;
  }
  function _configVault(options) {
    const debug = Boolean(options && options.debug);
    if (debug) {
      _debug("Loading env from encrypted .env.vault");
    }
    const parsed = DotenvModule._parseVault(options);
    let processEnv = process.env;
    if (options && options.processEnv != null) {
      processEnv = options.processEnv;
    }
    DotenvModule.populate(processEnv, parsed, options);
    return { parsed };
  }
  function configDotenv(options) {
    const dotenvPath = path.resolve(process.cwd(), ".env");
    let encoding = "utf8";
    const debug = Boolean(options && options.debug);
    if (options && options.encoding) {
      encoding = options.encoding;
    } else {
      if (debug) {
        _debug("No encoding is specified. UTF-8 is used by default");
      }
    }
    let optionPaths = [dotenvPath];
    if (options && options.path) {
      if (!Array.isArray(options.path)) {
        optionPaths = [_resolveHome(options.path)];
      } else {
        optionPaths = [];
        for (const filepath of options.path) {
          optionPaths.push(_resolveHome(filepath));
        }
      }
    }
    let lastError;
    const parsedAll = {};
    for (const path2 of optionPaths) {
      try {
        const parsed = DotenvModule.parse(fs.readFileSync(path2, { encoding }));
        DotenvModule.populate(parsedAll, parsed, options);
      } catch (e) {
        if (debug) {
          _debug(`Failed to load ${path2} ${e.message}`);
        }
        lastError = e;
      }
    }
    let processEnv = process.env;
    if (options && options.processEnv != null) {
      processEnv = options.processEnv;
    }
    DotenvModule.populate(processEnv, parsedAll, options);
    if (lastError) {
      return { parsed: parsedAll, error: lastError };
    } else {
      return { parsed: parsedAll };
    }
  }
  function config(options) {
    if (_dotenvKey(options).length === 0) {
      return DotenvModule.configDotenv(options);
    }
    const vaultPath = _vaultPath(options);
    if (!vaultPath) {
      _warn(`You set DOTENV_KEY but you are missing a .env.vault file at ${vaultPath}. Did you forget to build it?`);
      return DotenvModule.configDotenv(options);
    }
    return DotenvModule._configVault(options);
  }
  function decrypt(encrypted, keyStr) {
    const key = Buffer.from(keyStr.slice(-64), "hex");
    let ciphertext = Buffer.from(encrypted, "base64");
    const nonce = ciphertext.subarray(0, 12);
    const authTag = ciphertext.subarray(-16);
    ciphertext = ciphertext.subarray(12, -16);
    try {
      const aesgcm = crypto2.createDecipheriv("aes-256-gcm", key, nonce);
      aesgcm.setAuthTag(authTag);
      return `${aesgcm.update(ciphertext)}${aesgcm.final()}`;
    } catch (error) {
      const isRange = error instanceof RangeError;
      const invalidKeyLength = error.message === "Invalid key length";
      const decryptionFailed = error.message === "Unsupported state or unable to authenticate data";
      if (isRange || invalidKeyLength) {
        const err = new Error("INVALID_DOTENV_KEY: It must be 64 characters long (or more)");
        err.code = "INVALID_DOTENV_KEY";
        throw err;
      } else if (decryptionFailed) {
        const err = new Error("DECRYPTION_FAILED: Please check your DOTENV_KEY");
        err.code = "DECRYPTION_FAILED";
        throw err;
      } else {
        throw error;
      }
    }
  }
  function populate(processEnv, parsed, options = {}) {
    const debug = Boolean(options && options.debug);
    const override = Boolean(options && options.override);
    if (typeof parsed !== "object") {
      const err = new Error("OBJECT_REQUIRED: Please check the processEnv argument being passed to populate");
      err.code = "OBJECT_REQUIRED";
      throw err;
    }
    for (const key of Object.keys(parsed)) {
      if (Object.prototype.hasOwnProperty.call(processEnv, key)) {
        if (override === true) {
          processEnv[key] = parsed[key];
        }
        if (debug) {
          if (override === true) {
            _debug(`"${key}" is already defined and WAS overwritten`);
          } else {
            _debug(`"${key}" is already defined and was NOT overwritten`);
          }
        }
      } else {
        processEnv[key] = parsed[key];
      }
    }
  }
  var DotenvModule = {
    configDotenv,
    _configVault,
    _parseVault,
    config,
    decrypt,
    parse,
    populate
  };
  exports.configDotenv = DotenvModule.configDotenv;
  exports._configVault = DotenvModule._configVault;
  exports._parseVault = DotenvModule._parseVault;
  exports.config = DotenvModule.config;
  exports.decrypt = DotenvModule.decrypt;
  exports.parse = DotenvModule.parse;
  exports.populate = DotenvModule.populate;
  module.exports = DotenvModule;
});

// node_modules/tslib/tslib.js
var require_tslib = __commonJS((exports, module) => {
  var __extends;
  var __assign;
  var __rest;
  var __decorate;
  var __param;
  var __esDecorate;
  var __runInitializers;
  var __propKey;
  var __setFunctionName;
  var __metadata;
  var __awaiter;
  var __generator;
  var __exportStar;
  var __values;
  var __read;
  var __spread;
  var __spreadArrays;
  var __spreadArray;
  var __await;
  var __asyncGenerator;
  var __asyncDelegator;
  var __asyncValues;
  var __makeTemplateObject;
  var __importStar;
  var __importDefault;
  var __classPrivateFieldGet2;
  var __classPrivateFieldSet2;
  var __classPrivateFieldIn;
  var __createBinding;
  var __addDisposableResource;
  var __disposeResources;
  var __rewriteRelativeImportExtension;
  (function(factory) {
    var root = typeof global === "object" ? global : typeof self === "object" ? self : typeof this === "object" ? this : {};
    if (typeof define === "function" && define.amd) {
      define("tslib", ["exports"], function(exports2) {
        factory(createExporter(root, createExporter(exports2)));
      });
    } else if (typeof module === "object" && typeof exports === "object") {
      factory(createExporter(root, createExporter(exports)));
    } else {
      factory(createExporter(root));
    }
    function createExporter(exports2, previous) {
      if (exports2 !== root) {
        if (typeof Object.create === "function") {
          Object.defineProperty(exports2, "__esModule", { value: true });
        } else {
          exports2.__esModule = true;
        }
      }
      return function(id, v) {
        return exports2[id] = previous ? previous(id, v) : v;
      };
    }
  })(function(exporter) {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d, b) {
      d.__proto__ = b;
    } || function(d, b) {
      for (var p in b)
        if (Object.prototype.hasOwnProperty.call(b, p))
          d[p] = b[p];
    };
    __extends = function(d, b) {
      if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
      extendStatics(d, b);
      function __() {
        this.constructor = d;
      }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __);
    };
    __assign = Object.assign || function(t) {
      for (var s, i = 1, n = arguments.length;i < n; i++) {
        s = arguments[i];
        for (var p in s)
          if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
      }
      return t;
    };
    __rest = function(s, e) {
      var t = {};
      for (var p in s)
        if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
          t[p] = s[p];
      if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s);i < p.length; i++) {
          if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
            t[p[i]] = s[p[i]];
        }
      return t;
    };
    __decorate = function(decorators, target, key, desc) {
      var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
      if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
      else
        for (var i = decorators.length - 1;i >= 0; i--)
          if (d = decorators[i])
            r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
      return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    __param = function(paramIndex, decorator) {
      return function(target, key) {
        decorator(target, key, paramIndex);
      };
    };
    __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
      function accept(f) {
        if (f !== undefined && typeof f !== "function")
          throw new TypeError("Function expected");
        return f;
      }
      var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
      var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
      var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
      var _, done = false;
      for (var i = decorators.length - 1;i >= 0; i--) {
        var context = {};
        for (var p in contextIn)
          context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access)
          context.access[p] = contextIn.access[p];
        context.addInitializer = function(f) {
          if (done)
            throw new TypeError("Cannot add initializers after decoration has completed");
          extraInitializers.push(accept(f || null));
        };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
          if (result === undefined)
            continue;
          if (result === null || typeof result !== "object")
            throw new TypeError("Object expected");
          if (_ = accept(result.get))
            descriptor.get = _;
          if (_ = accept(result.set))
            descriptor.set = _;
          if (_ = accept(result.init))
            initializers.unshift(_);
        } else if (_ = accept(result)) {
          if (kind === "field")
            initializers.unshift(_);
          else
            descriptor[key] = _;
        }
      }
      if (target)
        Object.defineProperty(target, contextIn.name, descriptor);
      done = true;
    };
    __runInitializers = function(thisArg, initializers, value) {
      var useValue = arguments.length > 2;
      for (var i = 0;i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
      }
      return useValue ? value : undefined;
    };
    __propKey = function(x) {
      return typeof x === "symbol" ? x : "".concat(x);
    };
    __setFunctionName = function(f, name, prefix) {
      if (typeof name === "symbol")
        name = name.description ? "[".concat(name.description, "]") : "";
      return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
    };
    __metadata = function(metadataKey, metadataValue) {
      if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
        return Reflect.metadata(metadataKey, metadataValue);
    };
    __awaiter = function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    __generator = function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1)
          throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
      return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f)
          throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _)
          try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
              return t;
            if (y = 0, t)
              op = [op[0] & 2, t.value];
            switch (op[0]) {
              case 0:
              case 1:
                t = op;
                break;
              case 4:
                _.label++;
                return { value: op[1], done: false };
              case 5:
                _.label++;
                y = op[1];
                op = [0];
                continue;
              case 7:
                op = _.ops.pop();
                _.trys.pop();
                continue;
              default:
                if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                  _ = 0;
                  continue;
                }
                if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                  _.label = op[1];
                  break;
                }
                if (op[0] === 6 && _.label < t[1]) {
                  _.label = t[1];
                  t = op;
                  break;
                }
                if (t && _.label < t[2]) {
                  _.label = t[2];
                  _.ops.push(op);
                  break;
                }
                if (t[2])
                  _.ops.pop();
                _.trys.pop();
                continue;
            }
            op = body.call(thisArg, _);
          } catch (e) {
            op = [6, e];
            y = 0;
          } finally {
            f = t = 0;
          }
        if (op[0] & 5)
          throw op[1];
        return { value: op[0] ? op[1] : undefined, done: true };
      }
    };
    __exportStar = function(m, o) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p))
          __createBinding(o, m, p);
    };
    __createBinding = Object.create ? function(o, m, k, k2) {
      if (k2 === undefined)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === undefined)
        k2 = k;
      o[k2] = m[k];
    };
    __values = function(o) {
      var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
      if (m)
        return m.call(o);
      if (o && typeof o.length === "number")
        return {
          next: function() {
            if (o && i >= o.length)
              o = undefined;
            return { value: o && o[i++], done: !o };
          }
        };
      throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __read = function(o, n) {
      var m = typeof Symbol === "function" && o[Symbol.iterator];
      if (!m)
        return o;
      var i = m.call(o), r, ar = [], e;
      try {
        while ((n === undefined || n-- > 0) && !(r = i.next()).done)
          ar.push(r.value);
      } catch (error) {
        e = { error };
      } finally {
        try {
          if (r && !r.done && (m = i["return"]))
            m.call(i);
        } finally {
          if (e)
            throw e.error;
        }
      }
      return ar;
    };
    __spread = function() {
      for (var ar = [], i = 0;i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
      return ar;
    };
    __spreadArrays = function() {
      for (var s = 0, i = 0, il = arguments.length;i < il; i++)
        s += arguments[i].length;
      for (var r = Array(s), k = 0, i = 0;i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length;j < jl; j++, k++)
          r[k] = a[j];
      return r;
    };
    __spreadArray = function(to, from, pack) {
      if (pack || arguments.length === 2)
        for (var i = 0, l2 = from.length, ar;i < l2; i++) {
          if (ar || !(i in from)) {
            if (!ar)
              ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
          }
        }
      return to.concat(ar || Array.prototype.slice.call(from));
    };
    __await = function(v) {
      return this instanceof __await ? (this.v = v, this) : new __await(v);
    };
    __asyncGenerator = function(thisArg, _arguments, generator) {
      if (!Symbol.asyncIterator)
        throw new TypeError("Symbol.asyncIterator is not defined.");
      var g = generator.apply(thisArg, _arguments || []), i, q = [];
      return i = Object.create((typeof AsyncIterator === "function" ? AsyncIterator : Object).prototype), verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function() {
        return this;
      }, i;
      function awaitReturn(f) {
        return function(v) {
          return Promise.resolve(v).then(f, reject);
        };
      }
      function verb(n, f) {
        if (g[n]) {
          i[n] = function(v) {
            return new Promise(function(a, b) {
              q.push([n, v, a, b]) > 1 || resume(n, v);
            });
          };
          if (f)
            i[n] = f(i[n]);
        }
      }
      function resume(n, v) {
        try {
          step(g[n](v));
        } catch (e) {
          settle(q[0][3], e);
        }
      }
      function step(r) {
        r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);
      }
      function fulfill(value) {
        resume("next", value);
      }
      function reject(value) {
        resume("throw", value);
      }
      function settle(f, v) {
        if (f(v), q.shift(), q.length)
          resume(q[0][0], q[0][1]);
      }
    };
    __asyncDelegator = function(o) {
      var i, p;
      return i = {}, verb("next"), verb("throw", function(e) {
        throw e;
      }), verb("return"), i[Symbol.iterator] = function() {
        return this;
      }, i;
      function verb(n, f) {
        i[n] = o[n] ? function(v) {
          return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v;
        } : f;
      }
    };
    __asyncValues = function(o) {
      if (!Symbol.asyncIterator)
        throw new TypeError("Symbol.asyncIterator is not defined.");
      var m = o[Symbol.asyncIterator], i;
      return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function() {
        return this;
      }, i);
      function verb(n) {
        i[n] = o[n] && function(v) {
          return new Promise(function(resolve, reject) {
            v = o[n](v), settle(resolve, reject, v.done, v.value);
          });
        };
      }
      function settle(resolve, reject, d, v) {
        Promise.resolve(v).then(function(v2) {
          resolve({ value: v2, done: d });
        }, reject);
      }
    };
    __makeTemplateObject = function(cooked, raw) {
      if (Object.defineProperty) {
        Object.defineProperty(cooked, "raw", { value: raw });
      } else {
        cooked.raw = raw;
      }
      return cooked;
    };
    var __setModuleDefault = Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    };
    var ownKeys = function(o) {
      ownKeys = Object.getOwnPropertyNames || function(o2) {
        var ar = [];
        for (var k in o2)
          if (Object.prototype.hasOwnProperty.call(o2, k))
            ar[ar.length] = k;
        return ar;
      };
      return ownKeys(o);
    };
    __importStar = function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k = ownKeys(mod), i = 0;i < k.length; i++)
          if (k[i] !== "default")
            __createBinding(result, mod, k[i]);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    __importDefault = function(mod) {
      return mod && mod.__esModule ? mod : { default: mod };
    };
    __classPrivateFieldGet2 = function(receiver, state, kind, f) {
      if (kind === "a" && !f)
        throw new TypeError("Private accessor was defined without a getter");
      if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
        throw new TypeError("Cannot read private member from an object whose class did not declare it");
      return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
    };
    __classPrivateFieldSet2 = function(receiver, state, value, kind, f) {
      if (kind === "m")
        throw new TypeError("Private method is not writable");
      if (kind === "a" && !f)
        throw new TypeError("Private accessor was defined without a setter");
      if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
        throw new TypeError("Cannot write private member to an object whose class did not declare it");
      return kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value), value;
    };
    __classPrivateFieldIn = function(state, receiver) {
      if (receiver === null || typeof receiver !== "object" && typeof receiver !== "function")
        throw new TypeError("Cannot use 'in' operator on non-object");
      return typeof state === "function" ? receiver === state : state.has(receiver);
    };
    __addDisposableResource = function(env, value, async) {
      if (value !== null && value !== undefined) {
        if (typeof value !== "object" && typeof value !== "function")
          throw new TypeError("Object expected.");
        var dispose, inner;
        if (async) {
          if (!Symbol.asyncDispose)
            throw new TypeError("Symbol.asyncDispose is not defined.");
          dispose = value[Symbol.asyncDispose];
        }
        if (dispose === undefined) {
          if (!Symbol.dispose)
            throw new TypeError("Symbol.dispose is not defined.");
          dispose = value[Symbol.dispose];
          if (async)
            inner = dispose;
        }
        if (typeof dispose !== "function")
          throw new TypeError("Object not disposable.");
        if (inner)
          dispose = function() {
            try {
              inner.call(this);
            } catch (e) {
              return Promise.reject(e);
            }
          };
        env.stack.push({ value, dispose, async });
      } else if (async) {
        env.stack.push({ async: true });
      }
      return value;
    };
    var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function(error, suppressed, message) {
      var e = new Error(message);
      return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
    };
    __disposeResources = function(env) {
      function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
      }
      var r, s = 0;
      function next() {
        while (r = env.stack.pop()) {
          try {
            if (!r.async && s === 1)
              return s = 0, env.stack.push(r), Promise.resolve().then(next);
            if (r.dispose) {
              var result = r.dispose.call(r.value);
              if (r.async)
                return s |= 2, Promise.resolve(result).then(next, function(e) {
                  fail(e);
                  return next();
                });
            } else
              s |= 1;
          } catch (e) {
            fail(e);
          }
        }
        if (s === 1)
          return env.hasError ? Promise.reject(env.error) : Promise.resolve();
        if (env.hasError)
          throw env.error;
      }
      return next();
    };
    __rewriteRelativeImportExtension = function(path, preserveJsx) {
      if (typeof path === "string" && /^\.\.?\//.test(path)) {
        return path.replace(/\.(tsx)$|((?:\.d)?)((?:\.[^./]+?)?)\.([cm]?)ts$/i, function(m, tsx, d, ext, cm) {
          return tsx ? preserveJsx ? ".jsx" : ".js" : d && (!ext || !cm) ? m : d + ext + "." + cm.toLowerCase() + "js";
        });
      }
      return path;
    };
    exporter("__extends", __extends);
    exporter("__assign", __assign);
    exporter("__rest", __rest);
    exporter("__decorate", __decorate);
    exporter("__param", __param);
    exporter("__esDecorate", __esDecorate);
    exporter("__runInitializers", __runInitializers);
    exporter("__propKey", __propKey);
    exporter("__setFunctionName", __setFunctionName);
    exporter("__metadata", __metadata);
    exporter("__awaiter", __awaiter);
    exporter("__generator", __generator);
    exporter("__exportStar", __exportStar);
    exporter("__createBinding", __createBinding);
    exporter("__values", __values);
    exporter("__read", __read);
    exporter("__spread", __spread);
    exporter("__spreadArrays", __spreadArrays);
    exporter("__spreadArray", __spreadArray);
    exporter("__await", __await);
    exporter("__asyncGenerator", __asyncGenerator);
    exporter("__asyncDelegator", __asyncDelegator);
    exporter("__asyncValues", __asyncValues);
    exporter("__makeTemplateObject", __makeTemplateObject);
    exporter("__importStar", __importStar);
    exporter("__importDefault", __importDefault);
    exporter("__classPrivateFieldGet", __classPrivateFieldGet2);
    exporter("__classPrivateFieldSet", __classPrivateFieldSet2);
    exporter("__classPrivateFieldIn", __classPrivateFieldIn);
    exporter("__addDisposableResource", __addDisposableResource);
    exporter("__disposeResources", __disposeResources);
    exporter("__rewriteRelativeImportExtension", __rewriteRelativeImportExtension);
  });
});

// node_modules/jira.js/out/agile/backlog.js
var require_backlog = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Backlog = undefined;
  var tslib_1 = require_tslib();

  class Backlog {
    constructor(client) {
      this.client = client;
    }
    moveIssuesToBacklog(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/agile/1.0/backlog/issue",
          method: "POST",
          data: {
            issues: parameters.issues
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    moveIssuesToBacklogForBoard(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/backlog/${parameters.boardId}/issue`,
          method: "POST",
          data: {
            issues: parameters.issues,
            rankBeforeIssue: parameters.rankBeforeIssue,
            rankAfterIssue: parameters.rankAfterIssue,
            rankCustomFieldId: parameters.rankCustomFieldId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Backlog = Backlog;
});

// node_modules/jira.js/out/agile/board.js
var require_board = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Board = undefined;
  var tslib_1 = require_tslib();

  class Board {
    constructor(client) {
      this.client = client;
    }
    getAllBoards(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/agile/1.0/board",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            type: parameters === null || parameters === undefined ? undefined : parameters.type,
            name: parameters === null || parameters === undefined ? undefined : parameters.name,
            projectKeyOrId: parameters === null || parameters === undefined ? undefined : parameters.projectKeyOrId,
            accountIdLocation: parameters === null || parameters === undefined ? undefined : parameters.accountIdLocation,
            projectLocation: parameters === null || parameters === undefined ? undefined : parameters.projectLocation,
            includePrivate: parameters === null || parameters === undefined ? undefined : parameters.includePrivate,
            negateLocationFiltering: parameters === null || parameters === undefined ? undefined : parameters.negateLocationFiltering,
            orderBy: parameters === null || parameters === undefined ? undefined : parameters.orderBy,
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand,
            filterId: parameters === null || parameters === undefined ? undefined : parameters.filterId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createBoard(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/agile/1.0/board",
          method: "POST",
          data: {
            name: parameters.name,
            type: parameters.type,
            filterId: parameters.filterId,
            location: parameters.location
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getBoardByFilterId(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/filter/${parameters.filterId}`,
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getBoard(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteBoard(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssuesForBacklog(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/backlog`,
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults,
            jql: parameters.jql,
            validateQuery: parameters.validateQuery,
            fields: parameters.fields,
            expand: parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getConfiguration(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/configuration`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getEpics(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/epic`,
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults,
            done: parameters.done
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssuesWithoutEpicForBoard(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/epic/none/issue`,
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults,
            jql: parameters.jql,
            validateQuery: parameters.validateQuery,
            fields: parameters.fields,
            expand: parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getBoardIssuesForEpic(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/epic/${parameters.epicId}/issue`,
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults,
            jql: parameters.jql,
            validateQuery: parameters.validateQuery,
            fields: parameters.fields,
            expand: parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getFeaturesForBoard(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/features`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    toggleFeatures(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/features`,
          method: "PUT",
          data: parameters.body
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssuesForBoard(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/issue`,
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults,
            jql: parameters.jql,
            validateQuery: parameters.validateQuery,
            fields: parameters.fields,
            expand: parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    moveIssuesToBoard(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/issue`,
          method: "POST",
          data: {
            issues: parameters.issues,
            rankBeforeIssue: parameters.rankBeforeIssue,
            rankAfterIssue: parameters.rankAfterIssue,
            rankCustomFieldId: parameters.rankCustomFieldId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getProjects(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/project`,
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getProjectsFull(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/project/full`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getBoardPropertyKeys(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/properties`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getBoardProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/properties/${parameters.propertyKey}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setBoardProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/properties/${parameters.propertyKey}`,
          method: "PUT"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteBoardProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/properties/${parameters.propertyKey}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAllQuickFilters(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/quickfilter`,
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getQuickFilter(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/quickfilter/${parameters.quickFilterId}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getReportsForBoard(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/reports`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAllSprints(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/sprint`,
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults,
            state: parameters.state
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getBoardIssuesForSprint(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/sprint/${parameters.sprintId}/issue`,
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults,
            jql: parameters.jql,
            validateQuery: parameters.validateQuery,
            fields: parameters.fields,
            expand: parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAllVersions(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/board/${parameters.boardId}/version`,
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults,
            released: parameters.released
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Board = Board;
});

// node_modules/jira.js/out/agile/builds.js
var require_builds = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Builds = undefined;
  var tslib_1 = require_tslib();

  class Builds {
    constructor(client) {
      this.client = client;
    }
    submitBuilds(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/builds/0.1/bulk",
          method: "POST",
          data: {
            properties: parameters.properties,
            builds: parameters.builds,
            providerMetadata: parameters.providerMetadata
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteBuildsByProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/builds/0.1/bulkByProperties",
          method: "DELETE",
          params: {
            _updateSequenceNumber: parameters.updateSequenceNumber
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getBuildByKey(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/builds/0.1/pipelines/${parameters.pipelineId}/builds/${parameters.buildNumber}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteBuildByKey(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/builds/0.1/pipelines/${parameters.pipelineId}/builds/${parameters.buildNumber}`,
          method: "DELETE",
          params: {
            _updateSequenceNumber: parameters.updateSequenceNumber
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Builds = Builds;
});

// node_modules/jira.js/out/agile/deployments.js
var require_deployments = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Deployments = undefined;
  var tslib_1 = require_tslib();

  class Deployments {
    constructor(client) {
      this.client = client;
    }
    submitDeployments(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/deployments/0.1/bulk",
          method: "POST",
          data: {
            properties: parameters.properties,
            deployments: parameters.deployments,
            providerMetadata: parameters.providerMetadata
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteDeploymentsByProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/deployments/0.1/bulkByProperties",
          method: "DELETE",
          params: {
            _updateSequenceNumber: parameters.updateSequenceNumber
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getDeploymentByKey(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/deployments/0.1/pipelines/${parameters.pipelineId}/environments/${parameters.environmentId}/deployments/${parameters.deploymentSequenceNumber}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteDeploymentByKey(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/deployments/0.1/pipelines/${parameters.pipelineId}/environments/${parameters.environmentId}/deployments/${parameters.deploymentSequenceNumber}`,
          method: "DELETE",
          params: {
            _updateSequenceNumber: parameters.updateSequenceNumber
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getDeploymentGatingStatusByKey(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/deployments/0.1/pipelines/${parameters.pipelineId}/environments/${parameters.environmentId}/deployments/${parameters.deploymentSequenceNumber}/gating-status`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Deployments = Deployments;
});

// node_modules/jira.js/out/agile/developmentInformation.js
var require_developmentInformation = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.DevelopmentInformation = undefined;
  var tslib_1 = require_tslib();

  class DevelopmentInformation {
    constructor(client) {
      this.client = client;
    }
    storeDevelopmentInformation(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/devinfo/0.10/bulk",
          method: "POST",
          data: {
            repositories: parameters.repositories,
            preventTransitions: parameters.preventTransitions,
            operationType: parameters.operationType,
            properties: parameters.properties,
            providerMetadata: parameters.providerMetadata
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getRepository(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/devinfo/0.10/repository/${parameters.repositoryId}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteRepository(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/devinfo/0.10/repository/${parameters.repositoryId}`,
          method: "DELETE",
          params: {
            _updateSequenceId: parameters.updateSequenceId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteByProperties(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/devinfo/0.10/bulkByProperties",
          method: "DELETE",
          params: {
            _updateSequenceId: parameters.updateSequenceId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    existsByProperties(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/devinfo/0.10/existsByProperties",
          method: "GET",
          params: {
            _updateSequenceId: parameters.updateSequenceId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteEntity(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/devinfo/0.10/repository/${parameters.repositoryId}/${parameters.entityType}/${parameters.entityId}`,
          method: "DELETE",
          params: {
            _updateSequenceId: parameters.updateSequenceId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.DevelopmentInformation = DevelopmentInformation;
});

// node_modules/jira.js/out/agile/epic.js
var require_epic = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Epic = undefined;
  var tslib_1 = require_tslib();

  class Epic {
    constructor(client) {
      this.client = client;
    }
    getIssuesWithoutEpic(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/agile/1.0/epic/none/issue",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            jql: parameters === null || parameters === undefined ? undefined : parameters.jql,
            validateQuery: parameters === null || parameters === undefined ? undefined : parameters.validateQuery,
            fields: parameters === null || parameters === undefined ? undefined : parameters.fields,
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeIssuesFromEpic(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/agile/1.0/epic/none/issue",
          method: "POST",
          data: {
            issues: parameters === null || parameters === undefined ? undefined : parameters.issues
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    searchEpics(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/agile/1.0/epic/search",
          method: "GET",
          params: {
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            excludeDone: parameters === null || parameters === undefined ? undefined : parameters.excludeDone,
            query: parameters === null || parameters === undefined ? undefined : parameters.query,
            projectKey: parameters === null || parameters === undefined ? undefined : parameters.projectKey
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getEpic(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/epic/${parameters.epicIdOrKey}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    partiallyUpdateEpic(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/epic/${parameters.epicIdOrKey}`,
          method: "POST",
          data: {
            name: parameters.name,
            summary: parameters.summary,
            color: parameters.color,
            done: parameters.done
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssuesForEpic(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/epic/${parameters.epicIdOrKey}/issue`,
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults,
            jql: parameters.jql,
            validateQuery: parameters.validateQuery,
            fields: parameters.fields,
            expand: parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    moveIssuesToEpic(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/epic/${parameters.epicIdOrKey}/issue`,
          method: "POST",
          data: {
            issues: parameters.issues
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    rankEpics(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/epic/${parameters.epicIdOrKey}/rank`,
          method: "PUT",
          data: {
            rankBeforeEpic: parameters.rankBeforeEpic,
            rankAfterEpic: parameters.rankAfterEpic,
            rankCustomFieldId: parameters.rankCustomFieldId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Epic = Epic;
});

// node_modules/jira.js/out/agile/featureFlags.js
var require_featureFlags = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.FeatureFlags = undefined;
  var tslib_1 = require_tslib();

  class FeatureFlags {
    constructor(client) {
      this.client = client;
    }
    submitFeatureFlags(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/featureflags/0.1/bulk",
          method: "POST",
          data: {
            properties: parameters.properties,
            flags: parameters.flags,
            providerMetadata: parameters.providerMetadata
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteFeatureFlagsByProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/featureflags/0.1/bulkByProperties",
          method: "DELETE",
          params: {
            _updateSequenceId: parameters === null || parameters === undefined ? undefined : parameters.updateSequenceId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getFeatureFlagById(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/featureflags/0.1/flag/${parameters.featureFlagId}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteFeatureFlagById(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/featureflags/0.1/flag/${parameters.featureFlagId}`,
          method: "DELETE",
          params: {
            _updateSequenceId: parameters.updateSequenceId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.FeatureFlags = FeatureFlags;
});

// node_modules/jira.js/out/agile/issue.js
var require_issue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Issue = undefined;
  var tslib_1 = require_tslib();

  class Issue {
    constructor(client) {
      this.client = client;
    }
    rankIssues(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/agile/1.0/issue/rank",
          method: "PUT",
          data: {
            issues: parameters === null || parameters === undefined ? undefined : parameters.issues,
            rankBeforeIssue: parameters === null || parameters === undefined ? undefined : parameters.rankBeforeIssue,
            rankAfterIssue: parameters === null || parameters === undefined ? undefined : parameters.rankAfterIssue,
            rankCustomFieldId: parameters === null || parameters === undefined ? undefined : parameters.rankCustomFieldId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssue(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/issue/${parameters.issueIdOrKey}`,
          method: "GET",
          params: {
            fields: parameters.fields,
            expand: parameters.expand,
            updateHistory: parameters.updateHistory
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssueEstimationForBoard(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/issue/${parameters.issueIdOrKey}/estimation`,
          method: "GET",
          params: {
            boardId: parameters.boardId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    estimateIssueForBoard(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/issue/${parameters.issueIdOrKey}/estimation`,
          method: "PUT",
          params: {
            boardId: parameters.boardId
          },
          data: {
            value: parameters.value
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Issue = Issue;
});

// node_modules/jira.js/out/agile/remoteLinks.js
var require_remoteLinks = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.RemoteLinks = undefined;
  var tslib_1 = require_tslib();

  class RemoteLinks {
    constructor(client) {
      this.client = client;
    }
    submitRemoteLinks(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/remotelinks/1.0/bulk",
          method: "POST",
          data: {
            properties: parameters.properties,
            remoteLinks: parameters.remoteLinks,
            providerMetadata: parameters.providerMetadata
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteRemoteLinksByProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/remotelinks/1.0/bulkByProperties",
          method: "DELETE",
          params: {
            _updateSequenceNumber: parameters.updateSequenceNumber,
            params: parameters.params
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getRemoteLinkById(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/remotelinks/1.0/remotelink/${parameters.remoteLinkId}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteRemoteLinkById(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/remotelinks/1.0/remotelink/${parameters.remoteLinkId}`,
          method: "DELETE",
          params: {
            _updateSequenceNumber: parameters.updateSequenceNumber
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.RemoteLinks = RemoteLinks;
});

// node_modules/jira.js/out/agile/securityInformation.js
var require_securityInformation = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.SecurityInformation = undefined;
  var tslib_1 = require_tslib();

  class SecurityInformation {
    constructor(client) {
      this.client = client;
    }
    submitWorkspaces(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/security/1.0/linkedWorkspaces/bulk",
          method: "POST",
          data: {
            workspaceIds: parameters.workspaceIds
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteLinkedWorkspaces(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/security/1.0/linkedWorkspaces/bulk",
          method: "DELETE",
          params: {
            workspaceIds: parameters.workspaceIds
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getLinkedWorkspaces(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/security/1.0/linkedWorkspaces",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getLinkedWorkspaceById(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/security/1.0/linkedWorkspaces/${parameters.workspaceId}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    submitVulnerabilities(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/security/1.0/bulk",
          method: "POST",
          data: {
            properties: parameters.properties,
            vulnerabilities: parameters.vulnerabilities,
            providerMetadata: parameters.providerMetadata
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteVulnerabilitiesByProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/security/1.0/bulkByProperties",
          method: "DELETE",
          params: parameters
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getVulnerabilityById(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/security/1.0/vulnerability/${parameters.vulnerabilityId}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteVulnerabilityById(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/security/1.0/vulnerability/${parameters.vulnerabilityId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.SecurityInformation = SecurityInformation;
});

// node_modules/jira.js/out/agile/sprint.js
var require_sprint = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Sprint = undefined;
  var tslib_1 = require_tslib();

  class Sprint {
    constructor(client) {
      this.client = client;
    }
    createSprint(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/agile/1.0/sprint",
          method: "POST",
          data: {
            name: parameters.name,
            startDate: parameters.startDate,
            endDate: parameters.endDate,
            originBoardId: parameters.originBoardId,
            goal: parameters.goal
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getSprint(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/sprint/${parameters.sprintId}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    partiallyUpdateSprint(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/sprint/${parameters.sprintId}`,
          method: "POST",
          data: {
            id: parameters.id,
            self: parameters.self,
            state: parameters.state,
            name: parameters.name,
            startDate: parameters.startDate,
            endDate: parameters.endDate,
            completeDate: parameters.completeDate,
            createdDate: parameters.createdDate,
            originBoardId: parameters.originBoardId,
            goal: parameters.goal
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateSprint(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/sprint/${parameters.sprintId}`,
          method: "PUT",
          data: {
            id: parameters.id,
            self: parameters.self,
            state: parameters.state,
            name: parameters.name,
            startDate: parameters.startDate,
            endDate: parameters.endDate,
            completeDate: parameters.completeDate,
            createdDate: parameters.createdDate,
            originBoardId: parameters.originBoardId,
            goal: parameters.goal
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteSprint(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/sprint/${parameters.sprintId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssuesForSprint(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/sprint/${parameters.sprintId}/issue`,
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults,
            jql: parameters.jql,
            validateQuery: parameters.validateQuery,
            fields: parameters.fields,
            expand: parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    moveIssuesToSprintAndRank(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/sprint/${parameters.sprintId}/issue`,
          method: "POST",
          data: {
            issues: parameters.issues,
            rankBeforeIssue: parameters.rankBeforeIssue,
            rankAfterIssue: parameters.rankAfterIssue,
            rankCustomFieldId: parameters.rankCustomFieldId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getPropertiesKeys(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/sprint/${parameters.sprintId}/properties`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/sprint/${parameters.sprintId}/properties/${parameters.propertyKey}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/sprint/${parameters.sprintId}/properties/${parameters.propertyKey}`,
          method: "PUT"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/sprint/${parameters.sprintId}/properties/${parameters.propertyKey}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    swapSprint(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/agile/1.0/sprint/${parameters.sprintId}/swap`,
          method: "POST",
          data: {
            sprintToSwapWith: parameters.sprintToSwapWith
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Sprint = Sprint;
});

// node_modules/jira.js/out/agile/models/avatarUrls.js
var require_avatarUrls = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/board.js
var require_board2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/createBoard.js
var require_createBoard = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/epic.js
var require_epic2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/existsByProperties.js
var require_existsByProperties = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/fields.js
var require_fields = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/fixVersion.js
var require_fixVersion = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/getAllBoards.js
var require_getAllBoards = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/getAllQuickFilters.js
var require_getAllQuickFilters = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/getBoard.js
var require_getBoard = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/getBoardByFilterId.js
var require_getBoardByFilterId = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/getBuildByKey.js
var require_getBuildByKey = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/getConfiguration.js
var require_getConfiguration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/getDeploymentByKey.js
var require_getDeploymentByKey = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/getDeploymentGatingStatusByKey.js
var require_getDeploymentGatingStatusByKey = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/getFeatureFlagById.js
var require_getFeatureFlagById = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/getFeaturesForBoard.js
var require_getFeaturesForBoard = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/getQuickFilter.js
var require_getQuickFilter = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/getRemoteLinkById.js
var require_getRemoteLinkById = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/getReportsForBoard.js
var require_getReportsForBoard = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/getRepository.js
var require_getRepository = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/group.js
var require_group = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/issue.js
var require_issue2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/issueTransition.js
var require_issueTransition = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/issueType.js
var require_issueType = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/jsonType.js
var require_jsonType = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/linkedSecurityWorkspaceIds.js
var require_linkedSecurityWorkspaceIds = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/linkedWorkspace.js
var require_linkedWorkspace = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/linkGroup.js
var require_linkGroup = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/operations.js
var require_operations = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/progress.js
var require_progress = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/project.js
var require_project = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/projects.js
var require_projects = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/searchResults.js
var require_searchResults = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/sprint.js
var require_sprint2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/status.js
var require_status = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/statusCategory.js
var require_statusCategory = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/storeDevelopmentInformation.js
var require_storeDevelopmentInformation = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/submitBuilds.js
var require_submitBuilds = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/submitDeployments.js
var require_submitDeployments = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/submitFeatureFlags.js
var require_submitFeatureFlags = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/submitRemoteLinks.js
var require_submitRemoteLinks = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/submittedVulnerabilitiesResult.js
var require_submittedVulnerabilitiesResult = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/toggleFeatures.js
var require_toggleFeatures = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/user.js
var require_user = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/version.js
var require_version = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/vulnerability.js
var require_vulnerability = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/models/index.js
var require_models = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  var tslib_1 = require_tslib();
  tslib_1.__exportStar(require_avatarUrls(), exports);
  tslib_1.__exportStar(require_board2(), exports);
  tslib_1.__exportStar(require_createBoard(), exports);
  tslib_1.__exportStar(require_epic2(), exports);
  tslib_1.__exportStar(require_existsByProperties(), exports);
  tslib_1.__exportStar(require_fields(), exports);
  tslib_1.__exportStar(require_fixVersion(), exports);
  tslib_1.__exportStar(require_getAllBoards(), exports);
  tslib_1.__exportStar(require_getAllQuickFilters(), exports);
  tslib_1.__exportStar(require_getBoard(), exports);
  tslib_1.__exportStar(require_getBoardByFilterId(), exports);
  tslib_1.__exportStar(require_getBuildByKey(), exports);
  tslib_1.__exportStar(require_getConfiguration(), exports);
  tslib_1.__exportStar(require_getDeploymentByKey(), exports);
  tslib_1.__exportStar(require_getDeploymentGatingStatusByKey(), exports);
  tslib_1.__exportStar(require_getFeatureFlagById(), exports);
  tslib_1.__exportStar(require_getFeaturesForBoard(), exports);
  tslib_1.__exportStar(require_getQuickFilter(), exports);
  tslib_1.__exportStar(require_getRemoteLinkById(), exports);
  tslib_1.__exportStar(require_getReportsForBoard(), exports);
  tslib_1.__exportStar(require_getRepository(), exports);
  tslib_1.__exportStar(require_group(), exports);
  tslib_1.__exportStar(require_issue2(), exports);
  tslib_1.__exportStar(require_issueTransition(), exports);
  tslib_1.__exportStar(require_issueType(), exports);
  tslib_1.__exportStar(require_jsonType(), exports);
  tslib_1.__exportStar(require_linkedSecurityWorkspaceIds(), exports);
  tslib_1.__exportStar(require_linkedWorkspace(), exports);
  tslib_1.__exportStar(require_linkGroup(), exports);
  tslib_1.__exportStar(require_operations(), exports);
  tslib_1.__exportStar(require_progress(), exports);
  tslib_1.__exportStar(require_project(), exports);
  tslib_1.__exportStar(require_projects(), exports);
  tslib_1.__exportStar(require_searchResults(), exports);
  tslib_1.__exportStar(require_sprint2(), exports);
  tslib_1.__exportStar(require_status(), exports);
  tslib_1.__exportStar(require_statusCategory(), exports);
  tslib_1.__exportStar(require_storeDevelopmentInformation(), exports);
  tslib_1.__exportStar(require_submitBuilds(), exports);
  tslib_1.__exportStar(require_submitDeployments(), exports);
  tslib_1.__exportStar(require_submitFeatureFlags(), exports);
  tslib_1.__exportStar(require_submitRemoteLinks(), exports);
  tslib_1.__exportStar(require_submittedVulnerabilitiesResult(), exports);
  tslib_1.__exportStar(require_toggleFeatures(), exports);
  tslib_1.__exportStar(require_user(), exports);
  tslib_1.__exportStar(require_version(), exports);
  tslib_1.__exportStar(require_vulnerability(), exports);
});

// node_modules/jira.js/out/agile/parameters/createBoard.js
var require_createBoard2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/createSprint.js
var require_createSprint = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteBoard.js
var require_deleteBoard = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteBoardProperty.js
var require_deleteBoardProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteBuildByKey.js
var require_deleteBuildByKey = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteBuildsByProperty.js
var require_deleteBuildsByProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteByProperties.js
var require_deleteByProperties = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteDeploymentByKey.js
var require_deleteDeploymentByKey = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteDeploymentsByProperty.js
var require_deleteDeploymentsByProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteEntity.js
var require_deleteEntity = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteFeatureFlagById.js
var require_deleteFeatureFlagById = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteFeatureFlagsByProperty.js
var require_deleteFeatureFlagsByProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteLinkedWorkspaces.js
var require_deleteLinkedWorkspaces = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteProperty.js
var require_deleteProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteRemoteLinkById.js
var require_deleteRemoteLinkById = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteRemoteLinksByProperty.js
var require_deleteRemoteLinksByProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteRepository.js
var require_deleteRepository = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteSprint.js
var require_deleteSprint = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteVulnerabilitiesByProperty.js
var require_deleteVulnerabilitiesByProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/deleteVulnerabilityById.js
var require_deleteVulnerabilityById = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/estimateIssueForBoard.js
var require_estimateIssueForBoard = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/existsByProperties.js
var require_existsByProperties2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getAllBoards.js
var require_getAllBoards2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getAllQuickFilters.js
var require_getAllQuickFilters2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getAllSprints.js
var require_getAllSprints = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getAllVersions.js
var require_getAllVersions = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getBoard.js
var require_getBoard2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getBoardByFilterId.js
var require_getBoardByFilterId2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getBoardIssuesForEpic.js
var require_getBoardIssuesForEpic = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getBoardIssuesForSprint.js
var require_getBoardIssuesForSprint = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getBoardProperty.js
var require_getBoardProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getBoardPropertyKeys.js
var require_getBoardPropertyKeys = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getBuildByKey.js
var require_getBuildByKey2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getConfiguration.js
var require_getConfiguration2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getDeploymentByKey.js
var require_getDeploymentByKey2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getDeploymentGatingStatusByKey.js
var require_getDeploymentGatingStatusByKey2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getEpic.js
var require_getEpic = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getEpics.js
var require_getEpics = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getFeatureFlagById.js
var require_getFeatureFlagById2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getFeaturesForBoard.js
var require_getFeaturesForBoard2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getIssue.js
var require_getIssue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getIssueEstimationForBoard.js
var require_getIssueEstimationForBoard = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getIssuesForBacklog.js
var require_getIssuesForBacklog = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getIssuesForBoard.js
var require_getIssuesForBoard = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getIssuesForEpic.js
var require_getIssuesForEpic = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getIssuesForSprint.js
var require_getIssuesForSprint = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getIssuesWithoutEpic.js
var require_getIssuesWithoutEpic = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getIssuesWithoutEpicForBoard.js
var require_getIssuesWithoutEpicForBoard = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getLinkedWorkspaceById.js
var require_getLinkedWorkspaceById = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getProjects.js
var require_getProjects = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getProjectsFull.js
var require_getProjectsFull = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getPropertiesKeys.js
var require_getPropertiesKeys = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getProperty.js
var require_getProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getQuickFilter.js
var require_getQuickFilter2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getRemoteLinkById.js
var require_getRemoteLinkById2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getReportsForBoard.js
var require_getReportsForBoard2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getRepository.js
var require_getRepository2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getSprint.js
var require_getSprint = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/getVulnerabilityById.js
var require_getVulnerabilityById = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/moveIssuesToBacklog.js
var require_moveIssuesToBacklog = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/moveIssuesToBacklogForBoard.js
var require_moveIssuesToBacklogForBoard = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/moveIssuesToBoard.js
var require_moveIssuesToBoard = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/moveIssuesToEpic.js
var require_moveIssuesToEpic = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/moveIssuesToSprintAndRank.js
var require_moveIssuesToSprintAndRank = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/partiallyUpdateEpic.js
var require_partiallyUpdateEpic = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/partiallyUpdateSprint.js
var require_partiallyUpdateSprint = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/rankEpics.js
var require_rankEpics = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/rankIssues.js
var require_rankIssues = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/removeIssuesFromEpic.js
var require_removeIssuesFromEpic = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/searchEpics.js
var require_searchEpics = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/setBoardProperty.js
var require_setBoardProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/setProperty.js
var require_setProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/storeDevelopmentInformation.js
var require_storeDevelopmentInformation2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/submitBuilds.js
var require_submitBuilds2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/submitDeployments.js
var require_submitDeployments2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/submitFeatureFlags.js
var require_submitFeatureFlags2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/submitRemoteLinks.js
var require_submitRemoteLinks2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/submitVulnerabilities.js
var require_submitVulnerabilities = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/submitWorkspaces.js
var require_submitWorkspaces = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/swapSprint.js
var require_swapSprint = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/toggleFeatures.js
var require_toggleFeatures2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/updateSprint.js
var require_updateSprint = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/agile/parameters/index.js
var require_parameters = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  var tslib_1 = require_tslib();
  tslib_1.__exportStar(require_createBoard2(), exports);
  tslib_1.__exportStar(require_createSprint(), exports);
  tslib_1.__exportStar(require_deleteBoard(), exports);
  tslib_1.__exportStar(require_deleteBoardProperty(), exports);
  tslib_1.__exportStar(require_deleteBuildByKey(), exports);
  tslib_1.__exportStar(require_deleteBuildsByProperty(), exports);
  tslib_1.__exportStar(require_deleteByProperties(), exports);
  tslib_1.__exportStar(require_deleteDeploymentByKey(), exports);
  tslib_1.__exportStar(require_deleteDeploymentsByProperty(), exports);
  tslib_1.__exportStar(require_deleteEntity(), exports);
  tslib_1.__exportStar(require_deleteFeatureFlagById(), exports);
  tslib_1.__exportStar(require_deleteFeatureFlagsByProperty(), exports);
  tslib_1.__exportStar(require_deleteLinkedWorkspaces(), exports);
  tslib_1.__exportStar(require_deleteProperty(), exports);
  tslib_1.__exportStar(require_deleteRemoteLinkById(), exports);
  tslib_1.__exportStar(require_deleteRemoteLinksByProperty(), exports);
  tslib_1.__exportStar(require_deleteRepository(), exports);
  tslib_1.__exportStar(require_deleteSprint(), exports);
  tslib_1.__exportStar(require_deleteVulnerabilitiesByProperty(), exports);
  tslib_1.__exportStar(require_deleteVulnerabilityById(), exports);
  tslib_1.__exportStar(require_estimateIssueForBoard(), exports);
  tslib_1.__exportStar(require_existsByProperties2(), exports);
  tslib_1.__exportStar(require_getAllBoards2(), exports);
  tslib_1.__exportStar(require_getAllQuickFilters2(), exports);
  tslib_1.__exportStar(require_getAllSprints(), exports);
  tslib_1.__exportStar(require_getAllVersions(), exports);
  tslib_1.__exportStar(require_getBoard2(), exports);
  tslib_1.__exportStar(require_getBoardByFilterId2(), exports);
  tslib_1.__exportStar(require_getBoardIssuesForEpic(), exports);
  tslib_1.__exportStar(require_getBoardIssuesForSprint(), exports);
  tslib_1.__exportStar(require_getBoardProperty(), exports);
  tslib_1.__exportStar(require_getBoardPropertyKeys(), exports);
  tslib_1.__exportStar(require_getBuildByKey2(), exports);
  tslib_1.__exportStar(require_getConfiguration2(), exports);
  tslib_1.__exportStar(require_getDeploymentByKey2(), exports);
  tslib_1.__exportStar(require_getDeploymentGatingStatusByKey2(), exports);
  tslib_1.__exportStar(require_getEpic(), exports);
  tslib_1.__exportStar(require_getEpics(), exports);
  tslib_1.__exportStar(require_getFeatureFlagById2(), exports);
  tslib_1.__exportStar(require_getFeaturesForBoard2(), exports);
  tslib_1.__exportStar(require_getIssue(), exports);
  tslib_1.__exportStar(require_getIssueEstimationForBoard(), exports);
  tslib_1.__exportStar(require_getIssuesForBacklog(), exports);
  tslib_1.__exportStar(require_getIssuesForBoard(), exports);
  tslib_1.__exportStar(require_getIssuesForEpic(), exports);
  tslib_1.__exportStar(require_getIssuesForSprint(), exports);
  tslib_1.__exportStar(require_getIssuesWithoutEpic(), exports);
  tslib_1.__exportStar(require_getIssuesWithoutEpicForBoard(), exports);
  tslib_1.__exportStar(require_getLinkedWorkspaceById(), exports);
  tslib_1.__exportStar(require_getProjects(), exports);
  tslib_1.__exportStar(require_getProjectsFull(), exports);
  tslib_1.__exportStar(require_getPropertiesKeys(), exports);
  tslib_1.__exportStar(require_getProperty(), exports);
  tslib_1.__exportStar(require_getQuickFilter2(), exports);
  tslib_1.__exportStar(require_getRemoteLinkById2(), exports);
  tslib_1.__exportStar(require_getReportsForBoard2(), exports);
  tslib_1.__exportStar(require_getRepository2(), exports);
  tslib_1.__exportStar(require_getSprint(), exports);
  tslib_1.__exportStar(require_getVulnerabilityById(), exports);
  tslib_1.__exportStar(require_moveIssuesToBacklog(), exports);
  tslib_1.__exportStar(require_moveIssuesToBacklogForBoard(), exports);
  tslib_1.__exportStar(require_moveIssuesToBoard(), exports);
  tslib_1.__exportStar(require_moveIssuesToEpic(), exports);
  tslib_1.__exportStar(require_moveIssuesToSprintAndRank(), exports);
  tslib_1.__exportStar(require_partiallyUpdateEpic(), exports);
  tslib_1.__exportStar(require_partiallyUpdateSprint(), exports);
  tslib_1.__exportStar(require_rankEpics(), exports);
  tslib_1.__exportStar(require_rankIssues(), exports);
  tslib_1.__exportStar(require_removeIssuesFromEpic(), exports);
  tslib_1.__exportStar(require_searchEpics(), exports);
  tslib_1.__exportStar(require_setBoardProperty(), exports);
  tslib_1.__exportStar(require_setProperty(), exports);
  tslib_1.__exportStar(require_storeDevelopmentInformation2(), exports);
  tslib_1.__exportStar(require_submitBuilds2(), exports);
  tslib_1.__exportStar(require_submitDeployments2(), exports);
  tslib_1.__exportStar(require_submitFeatureFlags2(), exports);
  tslib_1.__exportStar(require_submitRemoteLinks2(), exports);
  tslib_1.__exportStar(require_submitVulnerabilities(), exports);
  tslib_1.__exportStar(require_submitWorkspaces(), exports);
  tslib_1.__exportStar(require_swapSprint(), exports);
  tslib_1.__exportStar(require_toggleFeatures2(), exports);
  tslib_1.__exportStar(require_updateSprint(), exports);
});

// node_modules/delayed-stream/lib/delayed_stream.js
var require_delayed_stream = __commonJS((exports, module) => {
  var Stream = __require("stream").Stream;
  var util2 = __require("util");
  module.exports = DelayedStream;
  function DelayedStream() {
    this.source = null;
    this.dataSize = 0;
    this.maxDataSize = 1024 * 1024;
    this.pauseStream = true;
    this._maxDataSizeExceeded = false;
    this._released = false;
    this._bufferedEvents = [];
  }
  util2.inherits(DelayedStream, Stream);
  DelayedStream.create = function(source, options) {
    var delayedStream = new this;
    options = options || {};
    for (var option in options) {
      delayedStream[option] = options[option];
    }
    delayedStream.source = source;
    var realEmit = source.emit;
    source.emit = function() {
      delayedStream._handleEmit(arguments);
      return realEmit.apply(source, arguments);
    };
    source.on("error", function() {});
    if (delayedStream.pauseStream) {
      source.pause();
    }
    return delayedStream;
  };
  Object.defineProperty(DelayedStream.prototype, "readable", {
    configurable: true,
    enumerable: true,
    get: function() {
      return this.source.readable;
    }
  });
  DelayedStream.prototype.setEncoding = function() {
    return this.source.setEncoding.apply(this.source, arguments);
  };
  DelayedStream.prototype.resume = function() {
    if (!this._released) {
      this.release();
    }
    this.source.resume();
  };
  DelayedStream.prototype.pause = function() {
    this.source.pause();
  };
  DelayedStream.prototype.release = function() {
    this._released = true;
    this._bufferedEvents.forEach(function(args) {
      this.emit.apply(this, args);
    }.bind(this));
    this._bufferedEvents = [];
  };
  DelayedStream.prototype.pipe = function() {
    var r = Stream.prototype.pipe.apply(this, arguments);
    this.resume();
    return r;
  };
  DelayedStream.prototype._handleEmit = function(args) {
    if (this._released) {
      this.emit.apply(this, args);
      return;
    }
    if (args[0] === "data") {
      this.dataSize += args[1].length;
      this._checkIfMaxDataSizeExceeded();
    }
    this._bufferedEvents.push(args);
  };
  DelayedStream.prototype._checkIfMaxDataSizeExceeded = function() {
    if (this._maxDataSizeExceeded) {
      return;
    }
    if (this.dataSize <= this.maxDataSize) {
      return;
    }
    this._maxDataSizeExceeded = true;
    var message = "DelayedStream#maxDataSize of " + this.maxDataSize + " bytes exceeded.";
    this.emit("error", new Error(message));
  };
});

// node_modules/combined-stream/lib/combined_stream.js
var require_combined_stream = __commonJS((exports, module) => {
  var util2 = __require("util");
  var Stream = __require("stream").Stream;
  var DelayedStream = require_delayed_stream();
  module.exports = CombinedStream;
  function CombinedStream() {
    this.writable = false;
    this.readable = true;
    this.dataSize = 0;
    this.maxDataSize = 2 * 1024 * 1024;
    this.pauseStreams = true;
    this._released = false;
    this._streams = [];
    this._currentStream = null;
    this._insideLoop = false;
    this._pendingNext = false;
  }
  util2.inherits(CombinedStream, Stream);
  CombinedStream.create = function(options) {
    var combinedStream = new this;
    options = options || {};
    for (var option in options) {
      combinedStream[option] = options[option];
    }
    return combinedStream;
  };
  CombinedStream.isStreamLike = function(stream) {
    return typeof stream !== "function" && typeof stream !== "string" && typeof stream !== "boolean" && typeof stream !== "number" && !Buffer.isBuffer(stream);
  };
  CombinedStream.prototype.append = function(stream) {
    var isStreamLike = CombinedStream.isStreamLike(stream);
    if (isStreamLike) {
      if (!(stream instanceof DelayedStream)) {
        var newStream = DelayedStream.create(stream, {
          maxDataSize: Infinity,
          pauseStream: this.pauseStreams
        });
        stream.on("data", this._checkDataSize.bind(this));
        stream = newStream;
      }
      this._handleErrors(stream);
      if (this.pauseStreams) {
        stream.pause();
      }
    }
    this._streams.push(stream);
    return this;
  };
  CombinedStream.prototype.pipe = function(dest, options) {
    Stream.prototype.pipe.call(this, dest, options);
    this.resume();
    return dest;
  };
  CombinedStream.prototype._getNext = function() {
    this._currentStream = null;
    if (this._insideLoop) {
      this._pendingNext = true;
      return;
    }
    this._insideLoop = true;
    try {
      do {
        this._pendingNext = false;
        this._realGetNext();
      } while (this._pendingNext);
    } finally {
      this._insideLoop = false;
    }
  };
  CombinedStream.prototype._realGetNext = function() {
    var stream = this._streams.shift();
    if (typeof stream == "undefined") {
      this.end();
      return;
    }
    if (typeof stream !== "function") {
      this._pipeNext(stream);
      return;
    }
    var getStream = stream;
    getStream(function(stream2) {
      var isStreamLike = CombinedStream.isStreamLike(stream2);
      if (isStreamLike) {
        stream2.on("data", this._checkDataSize.bind(this));
        this._handleErrors(stream2);
      }
      this._pipeNext(stream2);
    }.bind(this));
  };
  CombinedStream.prototype._pipeNext = function(stream) {
    this._currentStream = stream;
    var isStreamLike = CombinedStream.isStreamLike(stream);
    if (isStreamLike) {
      stream.on("end", this._getNext.bind(this));
      stream.pipe(this, { end: false });
      return;
    }
    var value = stream;
    this.write(value);
    this._getNext();
  };
  CombinedStream.prototype._handleErrors = function(stream) {
    var self2 = this;
    stream.on("error", function(err) {
      self2._emitError(err);
    });
  };
  CombinedStream.prototype.write = function(data) {
    this.emit("data", data);
  };
  CombinedStream.prototype.pause = function() {
    if (!this.pauseStreams) {
      return;
    }
    if (this.pauseStreams && this._currentStream && typeof this._currentStream.pause == "function")
      this._currentStream.pause();
    this.emit("pause");
  };
  CombinedStream.prototype.resume = function() {
    if (!this._released) {
      this._released = true;
      this.writable = true;
      this._getNext();
    }
    if (this.pauseStreams && this._currentStream && typeof this._currentStream.resume == "function")
      this._currentStream.resume();
    this.emit("resume");
  };
  CombinedStream.prototype.end = function() {
    this._reset();
    this.emit("end");
  };
  CombinedStream.prototype.destroy = function() {
    this._reset();
    this.emit("close");
  };
  CombinedStream.prototype._reset = function() {
    this.writable = false;
    this._streams = [];
    this._currentStream = null;
  };
  CombinedStream.prototype._checkDataSize = function() {
    this._updateDataSize();
    if (this.dataSize <= this.maxDataSize) {
      return;
    }
    var message = "DelayedStream#maxDataSize of " + this.maxDataSize + " bytes exceeded.";
    this._emitError(new Error(message));
  };
  CombinedStream.prototype._updateDataSize = function() {
    this.dataSize = 0;
    var self2 = this;
    this._streams.forEach(function(stream) {
      if (!stream.dataSize) {
        return;
      }
      self2.dataSize += stream.dataSize;
    });
    if (this._currentStream && this._currentStream.dataSize) {
      this.dataSize += this._currentStream.dataSize;
    }
  };
  CombinedStream.prototype._emitError = function(err) {
    this._reset();
    this.emit("error", err);
  };
});

// node_modules/mime-db/db.json
var require_db = __commonJS((exports, module) => {
  module.exports = {
    "application/1d-interleaved-parityfec": {
      source: "iana"
    },
    "application/3gpdash-qoe-report+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/3gpp-ims+xml": {
      source: "iana",
      compressible: true
    },
    "application/3gpphal+json": {
      source: "iana",
      compressible: true
    },
    "application/3gpphalforms+json": {
      source: "iana",
      compressible: true
    },
    "application/a2l": {
      source: "iana"
    },
    "application/ace+cbor": {
      source: "iana"
    },
    "application/activemessage": {
      source: "iana"
    },
    "application/activity+json": {
      source: "iana",
      compressible: true
    },
    "application/alto-costmap+json": {
      source: "iana",
      compressible: true
    },
    "application/alto-costmapfilter+json": {
      source: "iana",
      compressible: true
    },
    "application/alto-directory+json": {
      source: "iana",
      compressible: true
    },
    "application/alto-endpointcost+json": {
      source: "iana",
      compressible: true
    },
    "application/alto-endpointcostparams+json": {
      source: "iana",
      compressible: true
    },
    "application/alto-endpointprop+json": {
      source: "iana",
      compressible: true
    },
    "application/alto-endpointpropparams+json": {
      source: "iana",
      compressible: true
    },
    "application/alto-error+json": {
      source: "iana",
      compressible: true
    },
    "application/alto-networkmap+json": {
      source: "iana",
      compressible: true
    },
    "application/alto-networkmapfilter+json": {
      source: "iana",
      compressible: true
    },
    "application/alto-updatestreamcontrol+json": {
      source: "iana",
      compressible: true
    },
    "application/alto-updatestreamparams+json": {
      source: "iana",
      compressible: true
    },
    "application/aml": {
      source: "iana"
    },
    "application/andrew-inset": {
      source: "iana",
      extensions: ["ez"]
    },
    "application/applefile": {
      source: "iana"
    },
    "application/applixware": {
      source: "apache",
      extensions: ["aw"]
    },
    "application/at+jwt": {
      source: "iana"
    },
    "application/atf": {
      source: "iana"
    },
    "application/atfx": {
      source: "iana"
    },
    "application/atom+xml": {
      source: "iana",
      compressible: true,
      extensions: ["atom"]
    },
    "application/atomcat+xml": {
      source: "iana",
      compressible: true,
      extensions: ["atomcat"]
    },
    "application/atomdeleted+xml": {
      source: "iana",
      compressible: true,
      extensions: ["atomdeleted"]
    },
    "application/atomicmail": {
      source: "iana"
    },
    "application/atomsvc+xml": {
      source: "iana",
      compressible: true,
      extensions: ["atomsvc"]
    },
    "application/atsc-dwd+xml": {
      source: "iana",
      compressible: true,
      extensions: ["dwd"]
    },
    "application/atsc-dynamic-event-message": {
      source: "iana"
    },
    "application/atsc-held+xml": {
      source: "iana",
      compressible: true,
      extensions: ["held"]
    },
    "application/atsc-rdt+json": {
      source: "iana",
      compressible: true
    },
    "application/atsc-rsat+xml": {
      source: "iana",
      compressible: true,
      extensions: ["rsat"]
    },
    "application/atxml": {
      source: "iana"
    },
    "application/auth-policy+xml": {
      source: "iana",
      compressible: true
    },
    "application/bacnet-xdd+zip": {
      source: "iana",
      compressible: false
    },
    "application/batch-smtp": {
      source: "iana"
    },
    "application/bdoc": {
      compressible: false,
      extensions: ["bdoc"]
    },
    "application/beep+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/calendar+json": {
      source: "iana",
      compressible: true
    },
    "application/calendar+xml": {
      source: "iana",
      compressible: true,
      extensions: ["xcs"]
    },
    "application/call-completion": {
      source: "iana"
    },
    "application/cals-1840": {
      source: "iana"
    },
    "application/captive+json": {
      source: "iana",
      compressible: true
    },
    "application/cbor": {
      source: "iana"
    },
    "application/cbor-seq": {
      source: "iana"
    },
    "application/cccex": {
      source: "iana"
    },
    "application/ccmp+xml": {
      source: "iana",
      compressible: true
    },
    "application/ccxml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["ccxml"]
    },
    "application/cdfx+xml": {
      source: "iana",
      compressible: true,
      extensions: ["cdfx"]
    },
    "application/cdmi-capability": {
      source: "iana",
      extensions: ["cdmia"]
    },
    "application/cdmi-container": {
      source: "iana",
      extensions: ["cdmic"]
    },
    "application/cdmi-domain": {
      source: "iana",
      extensions: ["cdmid"]
    },
    "application/cdmi-object": {
      source: "iana",
      extensions: ["cdmio"]
    },
    "application/cdmi-queue": {
      source: "iana",
      extensions: ["cdmiq"]
    },
    "application/cdni": {
      source: "iana"
    },
    "application/cea": {
      source: "iana"
    },
    "application/cea-2018+xml": {
      source: "iana",
      compressible: true
    },
    "application/cellml+xml": {
      source: "iana",
      compressible: true
    },
    "application/cfw": {
      source: "iana"
    },
    "application/city+json": {
      source: "iana",
      compressible: true
    },
    "application/clr": {
      source: "iana"
    },
    "application/clue+xml": {
      source: "iana",
      compressible: true
    },
    "application/clue_info+xml": {
      source: "iana",
      compressible: true
    },
    "application/cms": {
      source: "iana"
    },
    "application/cnrp+xml": {
      source: "iana",
      compressible: true
    },
    "application/coap-group+json": {
      source: "iana",
      compressible: true
    },
    "application/coap-payload": {
      source: "iana"
    },
    "application/commonground": {
      source: "iana"
    },
    "application/conference-info+xml": {
      source: "iana",
      compressible: true
    },
    "application/cose": {
      source: "iana"
    },
    "application/cose-key": {
      source: "iana"
    },
    "application/cose-key-set": {
      source: "iana"
    },
    "application/cpl+xml": {
      source: "iana",
      compressible: true,
      extensions: ["cpl"]
    },
    "application/csrattrs": {
      source: "iana"
    },
    "application/csta+xml": {
      source: "iana",
      compressible: true
    },
    "application/cstadata+xml": {
      source: "iana",
      compressible: true
    },
    "application/csvm+json": {
      source: "iana",
      compressible: true
    },
    "application/cu-seeme": {
      source: "apache",
      extensions: ["cu"]
    },
    "application/cwt": {
      source: "iana"
    },
    "application/cybercash": {
      source: "iana"
    },
    "application/dart": {
      compressible: true
    },
    "application/dash+xml": {
      source: "iana",
      compressible: true,
      extensions: ["mpd"]
    },
    "application/dash-patch+xml": {
      source: "iana",
      compressible: true,
      extensions: ["mpp"]
    },
    "application/dashdelta": {
      source: "iana"
    },
    "application/davmount+xml": {
      source: "iana",
      compressible: true,
      extensions: ["davmount"]
    },
    "application/dca-rft": {
      source: "iana"
    },
    "application/dcd": {
      source: "iana"
    },
    "application/dec-dx": {
      source: "iana"
    },
    "application/dialog-info+xml": {
      source: "iana",
      compressible: true
    },
    "application/dicom": {
      source: "iana"
    },
    "application/dicom+json": {
      source: "iana",
      compressible: true
    },
    "application/dicom+xml": {
      source: "iana",
      compressible: true
    },
    "application/dii": {
      source: "iana"
    },
    "application/dit": {
      source: "iana"
    },
    "application/dns": {
      source: "iana"
    },
    "application/dns+json": {
      source: "iana",
      compressible: true
    },
    "application/dns-message": {
      source: "iana"
    },
    "application/docbook+xml": {
      source: "apache",
      compressible: true,
      extensions: ["dbk"]
    },
    "application/dots+cbor": {
      source: "iana"
    },
    "application/dskpp+xml": {
      source: "iana",
      compressible: true
    },
    "application/dssc+der": {
      source: "iana",
      extensions: ["dssc"]
    },
    "application/dssc+xml": {
      source: "iana",
      compressible: true,
      extensions: ["xdssc"]
    },
    "application/dvcs": {
      source: "iana"
    },
    "application/ecmascript": {
      source: "iana",
      compressible: true,
      extensions: ["es", "ecma"]
    },
    "application/edi-consent": {
      source: "iana"
    },
    "application/edi-x12": {
      source: "iana",
      compressible: false
    },
    "application/edifact": {
      source: "iana",
      compressible: false
    },
    "application/efi": {
      source: "iana"
    },
    "application/elm+json": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/elm+xml": {
      source: "iana",
      compressible: true
    },
    "application/emergencycalldata.cap+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/emergencycalldata.comment+xml": {
      source: "iana",
      compressible: true
    },
    "application/emergencycalldata.control+xml": {
      source: "iana",
      compressible: true
    },
    "application/emergencycalldata.deviceinfo+xml": {
      source: "iana",
      compressible: true
    },
    "application/emergencycalldata.ecall.msd": {
      source: "iana"
    },
    "application/emergencycalldata.providerinfo+xml": {
      source: "iana",
      compressible: true
    },
    "application/emergencycalldata.serviceinfo+xml": {
      source: "iana",
      compressible: true
    },
    "application/emergencycalldata.subscriberinfo+xml": {
      source: "iana",
      compressible: true
    },
    "application/emergencycalldata.veds+xml": {
      source: "iana",
      compressible: true
    },
    "application/emma+xml": {
      source: "iana",
      compressible: true,
      extensions: ["emma"]
    },
    "application/emotionml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["emotionml"]
    },
    "application/encaprtp": {
      source: "iana"
    },
    "application/epp+xml": {
      source: "iana",
      compressible: true
    },
    "application/epub+zip": {
      source: "iana",
      compressible: false,
      extensions: ["epub"]
    },
    "application/eshop": {
      source: "iana"
    },
    "application/exi": {
      source: "iana",
      extensions: ["exi"]
    },
    "application/expect-ct-report+json": {
      source: "iana",
      compressible: true
    },
    "application/express": {
      source: "iana",
      extensions: ["exp"]
    },
    "application/fastinfoset": {
      source: "iana"
    },
    "application/fastsoap": {
      source: "iana"
    },
    "application/fdt+xml": {
      source: "iana",
      compressible: true,
      extensions: ["fdt"]
    },
    "application/fhir+json": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/fhir+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/fido.trusted-apps+json": {
      compressible: true
    },
    "application/fits": {
      source: "iana"
    },
    "application/flexfec": {
      source: "iana"
    },
    "application/font-sfnt": {
      source: "iana"
    },
    "application/font-tdpfr": {
      source: "iana",
      extensions: ["pfr"]
    },
    "application/font-woff": {
      source: "iana",
      compressible: false
    },
    "application/framework-attributes+xml": {
      source: "iana",
      compressible: true
    },
    "application/geo+json": {
      source: "iana",
      compressible: true,
      extensions: ["geojson"]
    },
    "application/geo+json-seq": {
      source: "iana"
    },
    "application/geopackage+sqlite3": {
      source: "iana"
    },
    "application/geoxacml+xml": {
      source: "iana",
      compressible: true
    },
    "application/gltf-buffer": {
      source: "iana"
    },
    "application/gml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["gml"]
    },
    "application/gpx+xml": {
      source: "apache",
      compressible: true,
      extensions: ["gpx"]
    },
    "application/gxf": {
      source: "apache",
      extensions: ["gxf"]
    },
    "application/gzip": {
      source: "iana",
      compressible: false,
      extensions: ["gz"]
    },
    "application/h224": {
      source: "iana"
    },
    "application/held+xml": {
      source: "iana",
      compressible: true
    },
    "application/hjson": {
      extensions: ["hjson"]
    },
    "application/http": {
      source: "iana"
    },
    "application/hyperstudio": {
      source: "iana",
      extensions: ["stk"]
    },
    "application/ibe-key-request+xml": {
      source: "iana",
      compressible: true
    },
    "application/ibe-pkg-reply+xml": {
      source: "iana",
      compressible: true
    },
    "application/ibe-pp-data": {
      source: "iana"
    },
    "application/iges": {
      source: "iana"
    },
    "application/im-iscomposing+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/index": {
      source: "iana"
    },
    "application/index.cmd": {
      source: "iana"
    },
    "application/index.obj": {
      source: "iana"
    },
    "application/index.response": {
      source: "iana"
    },
    "application/index.vnd": {
      source: "iana"
    },
    "application/inkml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["ink", "inkml"]
    },
    "application/iotp": {
      source: "iana"
    },
    "application/ipfix": {
      source: "iana",
      extensions: ["ipfix"]
    },
    "application/ipp": {
      source: "iana"
    },
    "application/isup": {
      source: "iana"
    },
    "application/its+xml": {
      source: "iana",
      compressible: true,
      extensions: ["its"]
    },
    "application/java-archive": {
      source: "apache",
      compressible: false,
      extensions: ["jar", "war", "ear"]
    },
    "application/java-serialized-object": {
      source: "apache",
      compressible: false,
      extensions: ["ser"]
    },
    "application/java-vm": {
      source: "apache",
      compressible: false,
      extensions: ["class"]
    },
    "application/javascript": {
      source: "iana",
      charset: "UTF-8",
      compressible: true,
      extensions: ["js", "mjs"]
    },
    "application/jf2feed+json": {
      source: "iana",
      compressible: true
    },
    "application/jose": {
      source: "iana"
    },
    "application/jose+json": {
      source: "iana",
      compressible: true
    },
    "application/jrd+json": {
      source: "iana",
      compressible: true
    },
    "application/jscalendar+json": {
      source: "iana",
      compressible: true
    },
    "application/json": {
      source: "iana",
      charset: "UTF-8",
      compressible: true,
      extensions: ["json", "map"]
    },
    "application/json-patch+json": {
      source: "iana",
      compressible: true
    },
    "application/json-seq": {
      source: "iana"
    },
    "application/json5": {
      extensions: ["json5"]
    },
    "application/jsonml+json": {
      source: "apache",
      compressible: true,
      extensions: ["jsonml"]
    },
    "application/jwk+json": {
      source: "iana",
      compressible: true
    },
    "application/jwk-set+json": {
      source: "iana",
      compressible: true
    },
    "application/jwt": {
      source: "iana"
    },
    "application/kpml-request+xml": {
      source: "iana",
      compressible: true
    },
    "application/kpml-response+xml": {
      source: "iana",
      compressible: true
    },
    "application/ld+json": {
      source: "iana",
      compressible: true,
      extensions: ["jsonld"]
    },
    "application/lgr+xml": {
      source: "iana",
      compressible: true,
      extensions: ["lgr"]
    },
    "application/link-format": {
      source: "iana"
    },
    "application/load-control+xml": {
      source: "iana",
      compressible: true
    },
    "application/lost+xml": {
      source: "iana",
      compressible: true,
      extensions: ["lostxml"]
    },
    "application/lostsync+xml": {
      source: "iana",
      compressible: true
    },
    "application/lpf+zip": {
      source: "iana",
      compressible: false
    },
    "application/lxf": {
      source: "iana"
    },
    "application/mac-binhex40": {
      source: "iana",
      extensions: ["hqx"]
    },
    "application/mac-compactpro": {
      source: "apache",
      extensions: ["cpt"]
    },
    "application/macwriteii": {
      source: "iana"
    },
    "application/mads+xml": {
      source: "iana",
      compressible: true,
      extensions: ["mads"]
    },
    "application/manifest+json": {
      source: "iana",
      charset: "UTF-8",
      compressible: true,
      extensions: ["webmanifest"]
    },
    "application/marc": {
      source: "iana",
      extensions: ["mrc"]
    },
    "application/marcxml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["mrcx"]
    },
    "application/mathematica": {
      source: "iana",
      extensions: ["ma", "nb", "mb"]
    },
    "application/mathml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["mathml"]
    },
    "application/mathml-content+xml": {
      source: "iana",
      compressible: true
    },
    "application/mathml-presentation+xml": {
      source: "iana",
      compressible: true
    },
    "application/mbms-associated-procedure-description+xml": {
      source: "iana",
      compressible: true
    },
    "application/mbms-deregister+xml": {
      source: "iana",
      compressible: true
    },
    "application/mbms-envelope+xml": {
      source: "iana",
      compressible: true
    },
    "application/mbms-msk+xml": {
      source: "iana",
      compressible: true
    },
    "application/mbms-msk-response+xml": {
      source: "iana",
      compressible: true
    },
    "application/mbms-protection-description+xml": {
      source: "iana",
      compressible: true
    },
    "application/mbms-reception-report+xml": {
      source: "iana",
      compressible: true
    },
    "application/mbms-register+xml": {
      source: "iana",
      compressible: true
    },
    "application/mbms-register-response+xml": {
      source: "iana",
      compressible: true
    },
    "application/mbms-schedule+xml": {
      source: "iana",
      compressible: true
    },
    "application/mbms-user-service-description+xml": {
      source: "iana",
      compressible: true
    },
    "application/mbox": {
      source: "iana",
      extensions: ["mbox"]
    },
    "application/media-policy-dataset+xml": {
      source: "iana",
      compressible: true,
      extensions: ["mpf"]
    },
    "application/media_control+xml": {
      source: "iana",
      compressible: true
    },
    "application/mediaservercontrol+xml": {
      source: "iana",
      compressible: true,
      extensions: ["mscml"]
    },
    "application/merge-patch+json": {
      source: "iana",
      compressible: true
    },
    "application/metalink+xml": {
      source: "apache",
      compressible: true,
      extensions: ["metalink"]
    },
    "application/metalink4+xml": {
      source: "iana",
      compressible: true,
      extensions: ["meta4"]
    },
    "application/mets+xml": {
      source: "iana",
      compressible: true,
      extensions: ["mets"]
    },
    "application/mf4": {
      source: "iana"
    },
    "application/mikey": {
      source: "iana"
    },
    "application/mipc": {
      source: "iana"
    },
    "application/missing-blocks+cbor-seq": {
      source: "iana"
    },
    "application/mmt-aei+xml": {
      source: "iana",
      compressible: true,
      extensions: ["maei"]
    },
    "application/mmt-usd+xml": {
      source: "iana",
      compressible: true,
      extensions: ["musd"]
    },
    "application/mods+xml": {
      source: "iana",
      compressible: true,
      extensions: ["mods"]
    },
    "application/moss-keys": {
      source: "iana"
    },
    "application/moss-signature": {
      source: "iana"
    },
    "application/mosskey-data": {
      source: "iana"
    },
    "application/mosskey-request": {
      source: "iana"
    },
    "application/mp21": {
      source: "iana",
      extensions: ["m21", "mp21"]
    },
    "application/mp4": {
      source: "iana",
      extensions: ["mp4s", "m4p"]
    },
    "application/mpeg4-generic": {
      source: "iana"
    },
    "application/mpeg4-iod": {
      source: "iana"
    },
    "application/mpeg4-iod-xmt": {
      source: "iana"
    },
    "application/mrb-consumer+xml": {
      source: "iana",
      compressible: true
    },
    "application/mrb-publish+xml": {
      source: "iana",
      compressible: true
    },
    "application/msc-ivr+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/msc-mixer+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/msword": {
      source: "iana",
      compressible: false,
      extensions: ["doc", "dot"]
    },
    "application/mud+json": {
      source: "iana",
      compressible: true
    },
    "application/multipart-core": {
      source: "iana"
    },
    "application/mxf": {
      source: "iana",
      extensions: ["mxf"]
    },
    "application/n-quads": {
      source: "iana",
      extensions: ["nq"]
    },
    "application/n-triples": {
      source: "iana",
      extensions: ["nt"]
    },
    "application/nasdata": {
      source: "iana"
    },
    "application/news-checkgroups": {
      source: "iana",
      charset: "US-ASCII"
    },
    "application/news-groupinfo": {
      source: "iana",
      charset: "US-ASCII"
    },
    "application/news-transmission": {
      source: "iana"
    },
    "application/nlsml+xml": {
      source: "iana",
      compressible: true
    },
    "application/node": {
      source: "iana",
      extensions: ["cjs"]
    },
    "application/nss": {
      source: "iana"
    },
    "application/oauth-authz-req+jwt": {
      source: "iana"
    },
    "application/oblivious-dns-message": {
      source: "iana"
    },
    "application/ocsp-request": {
      source: "iana"
    },
    "application/ocsp-response": {
      source: "iana"
    },
    "application/octet-stream": {
      source: "iana",
      compressible: false,
      extensions: ["bin", "dms", "lrf", "mar", "so", "dist", "distz", "pkg", "bpk", "dump", "elc", "deploy", "exe", "dll", "deb", "dmg", "iso", "img", "msi", "msp", "msm", "buffer"]
    },
    "application/oda": {
      source: "iana",
      extensions: ["oda"]
    },
    "application/odm+xml": {
      source: "iana",
      compressible: true
    },
    "application/odx": {
      source: "iana"
    },
    "application/oebps-package+xml": {
      source: "iana",
      compressible: true,
      extensions: ["opf"]
    },
    "application/ogg": {
      source: "iana",
      compressible: false,
      extensions: ["ogx"]
    },
    "application/omdoc+xml": {
      source: "apache",
      compressible: true,
      extensions: ["omdoc"]
    },
    "application/onenote": {
      source: "apache",
      extensions: ["onetoc", "onetoc2", "onetmp", "onepkg"]
    },
    "application/opc-nodeset+xml": {
      source: "iana",
      compressible: true
    },
    "application/oscore": {
      source: "iana"
    },
    "application/oxps": {
      source: "iana",
      extensions: ["oxps"]
    },
    "application/p21": {
      source: "iana"
    },
    "application/p21+zip": {
      source: "iana",
      compressible: false
    },
    "application/p2p-overlay+xml": {
      source: "iana",
      compressible: true,
      extensions: ["relo"]
    },
    "application/parityfec": {
      source: "iana"
    },
    "application/passport": {
      source: "iana"
    },
    "application/patch-ops-error+xml": {
      source: "iana",
      compressible: true,
      extensions: ["xer"]
    },
    "application/pdf": {
      source: "iana",
      compressible: false,
      extensions: ["pdf"]
    },
    "application/pdx": {
      source: "iana"
    },
    "application/pem-certificate-chain": {
      source: "iana"
    },
    "application/pgp-encrypted": {
      source: "iana",
      compressible: false,
      extensions: ["pgp"]
    },
    "application/pgp-keys": {
      source: "iana",
      extensions: ["asc"]
    },
    "application/pgp-signature": {
      source: "iana",
      extensions: ["asc", "sig"]
    },
    "application/pics-rules": {
      source: "apache",
      extensions: ["prf"]
    },
    "application/pidf+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/pidf-diff+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/pkcs10": {
      source: "iana",
      extensions: ["p10"]
    },
    "application/pkcs12": {
      source: "iana"
    },
    "application/pkcs7-mime": {
      source: "iana",
      extensions: ["p7m", "p7c"]
    },
    "application/pkcs7-signature": {
      source: "iana",
      extensions: ["p7s"]
    },
    "application/pkcs8": {
      source: "iana",
      extensions: ["p8"]
    },
    "application/pkcs8-encrypted": {
      source: "iana"
    },
    "application/pkix-attr-cert": {
      source: "iana",
      extensions: ["ac"]
    },
    "application/pkix-cert": {
      source: "iana",
      extensions: ["cer"]
    },
    "application/pkix-crl": {
      source: "iana",
      extensions: ["crl"]
    },
    "application/pkix-pkipath": {
      source: "iana",
      extensions: ["pkipath"]
    },
    "application/pkixcmp": {
      source: "iana",
      extensions: ["pki"]
    },
    "application/pls+xml": {
      source: "iana",
      compressible: true,
      extensions: ["pls"]
    },
    "application/poc-settings+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/postscript": {
      source: "iana",
      compressible: true,
      extensions: ["ai", "eps", "ps"]
    },
    "application/ppsp-tracker+json": {
      source: "iana",
      compressible: true
    },
    "application/problem+json": {
      source: "iana",
      compressible: true
    },
    "application/problem+xml": {
      source: "iana",
      compressible: true
    },
    "application/provenance+xml": {
      source: "iana",
      compressible: true,
      extensions: ["provx"]
    },
    "application/prs.alvestrand.titrax-sheet": {
      source: "iana"
    },
    "application/prs.cww": {
      source: "iana",
      extensions: ["cww"]
    },
    "application/prs.cyn": {
      source: "iana",
      charset: "7-BIT"
    },
    "application/prs.hpub+zip": {
      source: "iana",
      compressible: false
    },
    "application/prs.nprend": {
      source: "iana"
    },
    "application/prs.plucker": {
      source: "iana"
    },
    "application/prs.rdf-xml-crypt": {
      source: "iana"
    },
    "application/prs.xsf+xml": {
      source: "iana",
      compressible: true
    },
    "application/pskc+xml": {
      source: "iana",
      compressible: true,
      extensions: ["pskcxml"]
    },
    "application/pvd+json": {
      source: "iana",
      compressible: true
    },
    "application/qsig": {
      source: "iana"
    },
    "application/raml+yaml": {
      compressible: true,
      extensions: ["raml"]
    },
    "application/raptorfec": {
      source: "iana"
    },
    "application/rdap+json": {
      source: "iana",
      compressible: true
    },
    "application/rdf+xml": {
      source: "iana",
      compressible: true,
      extensions: ["rdf", "owl"]
    },
    "application/reginfo+xml": {
      source: "iana",
      compressible: true,
      extensions: ["rif"]
    },
    "application/relax-ng-compact-syntax": {
      source: "iana",
      extensions: ["rnc"]
    },
    "application/remote-printing": {
      source: "iana"
    },
    "application/reputon+json": {
      source: "iana",
      compressible: true
    },
    "application/resource-lists+xml": {
      source: "iana",
      compressible: true,
      extensions: ["rl"]
    },
    "application/resource-lists-diff+xml": {
      source: "iana",
      compressible: true,
      extensions: ["rld"]
    },
    "application/rfc+xml": {
      source: "iana",
      compressible: true
    },
    "application/riscos": {
      source: "iana"
    },
    "application/rlmi+xml": {
      source: "iana",
      compressible: true
    },
    "application/rls-services+xml": {
      source: "iana",
      compressible: true,
      extensions: ["rs"]
    },
    "application/route-apd+xml": {
      source: "iana",
      compressible: true,
      extensions: ["rapd"]
    },
    "application/route-s-tsid+xml": {
      source: "iana",
      compressible: true,
      extensions: ["sls"]
    },
    "application/route-usd+xml": {
      source: "iana",
      compressible: true,
      extensions: ["rusd"]
    },
    "application/rpki-ghostbusters": {
      source: "iana",
      extensions: ["gbr"]
    },
    "application/rpki-manifest": {
      source: "iana",
      extensions: ["mft"]
    },
    "application/rpki-publication": {
      source: "iana"
    },
    "application/rpki-roa": {
      source: "iana",
      extensions: ["roa"]
    },
    "application/rpki-updown": {
      source: "iana"
    },
    "application/rsd+xml": {
      source: "apache",
      compressible: true,
      extensions: ["rsd"]
    },
    "application/rss+xml": {
      source: "apache",
      compressible: true,
      extensions: ["rss"]
    },
    "application/rtf": {
      source: "iana",
      compressible: true,
      extensions: ["rtf"]
    },
    "application/rtploopback": {
      source: "iana"
    },
    "application/rtx": {
      source: "iana"
    },
    "application/samlassertion+xml": {
      source: "iana",
      compressible: true
    },
    "application/samlmetadata+xml": {
      source: "iana",
      compressible: true
    },
    "application/sarif+json": {
      source: "iana",
      compressible: true
    },
    "application/sarif-external-properties+json": {
      source: "iana",
      compressible: true
    },
    "application/sbe": {
      source: "iana"
    },
    "application/sbml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["sbml"]
    },
    "application/scaip+xml": {
      source: "iana",
      compressible: true
    },
    "application/scim+json": {
      source: "iana",
      compressible: true
    },
    "application/scvp-cv-request": {
      source: "iana",
      extensions: ["scq"]
    },
    "application/scvp-cv-response": {
      source: "iana",
      extensions: ["scs"]
    },
    "application/scvp-vp-request": {
      source: "iana",
      extensions: ["spq"]
    },
    "application/scvp-vp-response": {
      source: "iana",
      extensions: ["spp"]
    },
    "application/sdp": {
      source: "iana",
      extensions: ["sdp"]
    },
    "application/secevent+jwt": {
      source: "iana"
    },
    "application/senml+cbor": {
      source: "iana"
    },
    "application/senml+json": {
      source: "iana",
      compressible: true
    },
    "application/senml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["senmlx"]
    },
    "application/senml-etch+cbor": {
      source: "iana"
    },
    "application/senml-etch+json": {
      source: "iana",
      compressible: true
    },
    "application/senml-exi": {
      source: "iana"
    },
    "application/sensml+cbor": {
      source: "iana"
    },
    "application/sensml+json": {
      source: "iana",
      compressible: true
    },
    "application/sensml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["sensmlx"]
    },
    "application/sensml-exi": {
      source: "iana"
    },
    "application/sep+xml": {
      source: "iana",
      compressible: true
    },
    "application/sep-exi": {
      source: "iana"
    },
    "application/session-info": {
      source: "iana"
    },
    "application/set-payment": {
      source: "iana"
    },
    "application/set-payment-initiation": {
      source: "iana",
      extensions: ["setpay"]
    },
    "application/set-registration": {
      source: "iana"
    },
    "application/set-registration-initiation": {
      source: "iana",
      extensions: ["setreg"]
    },
    "application/sgml": {
      source: "iana"
    },
    "application/sgml-open-catalog": {
      source: "iana"
    },
    "application/shf+xml": {
      source: "iana",
      compressible: true,
      extensions: ["shf"]
    },
    "application/sieve": {
      source: "iana",
      extensions: ["siv", "sieve"]
    },
    "application/simple-filter+xml": {
      source: "iana",
      compressible: true
    },
    "application/simple-message-summary": {
      source: "iana"
    },
    "application/simplesymbolcontainer": {
      source: "iana"
    },
    "application/sipc": {
      source: "iana"
    },
    "application/slate": {
      source: "iana"
    },
    "application/smil": {
      source: "iana"
    },
    "application/smil+xml": {
      source: "iana",
      compressible: true,
      extensions: ["smi", "smil"]
    },
    "application/smpte336m": {
      source: "iana"
    },
    "application/soap+fastinfoset": {
      source: "iana"
    },
    "application/soap+xml": {
      source: "iana",
      compressible: true
    },
    "application/sparql-query": {
      source: "iana",
      extensions: ["rq"]
    },
    "application/sparql-results+xml": {
      source: "iana",
      compressible: true,
      extensions: ["srx"]
    },
    "application/spdx+json": {
      source: "iana",
      compressible: true
    },
    "application/spirits-event+xml": {
      source: "iana",
      compressible: true
    },
    "application/sql": {
      source: "iana"
    },
    "application/srgs": {
      source: "iana",
      extensions: ["gram"]
    },
    "application/srgs+xml": {
      source: "iana",
      compressible: true,
      extensions: ["grxml"]
    },
    "application/sru+xml": {
      source: "iana",
      compressible: true,
      extensions: ["sru"]
    },
    "application/ssdl+xml": {
      source: "apache",
      compressible: true,
      extensions: ["ssdl"]
    },
    "application/ssml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["ssml"]
    },
    "application/stix+json": {
      source: "iana",
      compressible: true
    },
    "application/swid+xml": {
      source: "iana",
      compressible: true,
      extensions: ["swidtag"]
    },
    "application/tamp-apex-update": {
      source: "iana"
    },
    "application/tamp-apex-update-confirm": {
      source: "iana"
    },
    "application/tamp-community-update": {
      source: "iana"
    },
    "application/tamp-community-update-confirm": {
      source: "iana"
    },
    "application/tamp-error": {
      source: "iana"
    },
    "application/tamp-sequence-adjust": {
      source: "iana"
    },
    "application/tamp-sequence-adjust-confirm": {
      source: "iana"
    },
    "application/tamp-status-query": {
      source: "iana"
    },
    "application/tamp-status-response": {
      source: "iana"
    },
    "application/tamp-update": {
      source: "iana"
    },
    "application/tamp-update-confirm": {
      source: "iana"
    },
    "application/tar": {
      compressible: true
    },
    "application/taxii+json": {
      source: "iana",
      compressible: true
    },
    "application/td+json": {
      source: "iana",
      compressible: true
    },
    "application/tei+xml": {
      source: "iana",
      compressible: true,
      extensions: ["tei", "teicorpus"]
    },
    "application/tetra_isi": {
      source: "iana"
    },
    "application/thraud+xml": {
      source: "iana",
      compressible: true,
      extensions: ["tfi"]
    },
    "application/timestamp-query": {
      source: "iana"
    },
    "application/timestamp-reply": {
      source: "iana"
    },
    "application/timestamped-data": {
      source: "iana",
      extensions: ["tsd"]
    },
    "application/tlsrpt+gzip": {
      source: "iana"
    },
    "application/tlsrpt+json": {
      source: "iana",
      compressible: true
    },
    "application/tnauthlist": {
      source: "iana"
    },
    "application/token-introspection+jwt": {
      source: "iana"
    },
    "application/toml": {
      compressible: true,
      extensions: ["toml"]
    },
    "application/trickle-ice-sdpfrag": {
      source: "iana"
    },
    "application/trig": {
      source: "iana",
      extensions: ["trig"]
    },
    "application/ttml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["ttml"]
    },
    "application/tve-trigger": {
      source: "iana"
    },
    "application/tzif": {
      source: "iana"
    },
    "application/tzif-leap": {
      source: "iana"
    },
    "application/ubjson": {
      compressible: false,
      extensions: ["ubj"]
    },
    "application/ulpfec": {
      source: "iana"
    },
    "application/urc-grpsheet+xml": {
      source: "iana",
      compressible: true
    },
    "application/urc-ressheet+xml": {
      source: "iana",
      compressible: true,
      extensions: ["rsheet"]
    },
    "application/urc-targetdesc+xml": {
      source: "iana",
      compressible: true,
      extensions: ["td"]
    },
    "application/urc-uisocketdesc+xml": {
      source: "iana",
      compressible: true
    },
    "application/vcard+json": {
      source: "iana",
      compressible: true
    },
    "application/vcard+xml": {
      source: "iana",
      compressible: true
    },
    "application/vemmi": {
      source: "iana"
    },
    "application/vividence.scriptfile": {
      source: "apache"
    },
    "application/vnd.1000minds.decision-model+xml": {
      source: "iana",
      compressible: true,
      extensions: ["1km"]
    },
    "application/vnd.3gpp-prose+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp-prose-pc3ch+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp-v2x-local-service-information": {
      source: "iana"
    },
    "application/vnd.3gpp.5gnas": {
      source: "iana"
    },
    "application/vnd.3gpp.access-transfer-events+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.bsf+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.gmop+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.gtpc": {
      source: "iana"
    },
    "application/vnd.3gpp.interworking-data": {
      source: "iana"
    },
    "application/vnd.3gpp.lpp": {
      source: "iana"
    },
    "application/vnd.3gpp.mc-signalling-ear": {
      source: "iana"
    },
    "application/vnd.3gpp.mcdata-affiliation-command+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcdata-info+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcdata-payload": {
      source: "iana"
    },
    "application/vnd.3gpp.mcdata-service-config+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcdata-signalling": {
      source: "iana"
    },
    "application/vnd.3gpp.mcdata-ue-config+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcdata-user-profile+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcptt-affiliation-command+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcptt-floor-request+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcptt-info+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcptt-location-info+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcptt-mbms-usage-info+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcptt-service-config+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcptt-signed+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcptt-ue-config+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcptt-ue-init-config+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcptt-user-profile+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcvideo-affiliation-command+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcvideo-affiliation-info+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcvideo-info+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcvideo-location-info+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcvideo-mbms-usage-info+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcvideo-service-config+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcvideo-transmission-request+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcvideo-ue-config+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mcvideo-user-profile+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.mid-call+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.ngap": {
      source: "iana"
    },
    "application/vnd.3gpp.pfcp": {
      source: "iana"
    },
    "application/vnd.3gpp.pic-bw-large": {
      source: "iana",
      extensions: ["plb"]
    },
    "application/vnd.3gpp.pic-bw-small": {
      source: "iana",
      extensions: ["psb"]
    },
    "application/vnd.3gpp.pic-bw-var": {
      source: "iana",
      extensions: ["pvb"]
    },
    "application/vnd.3gpp.s1ap": {
      source: "iana"
    },
    "application/vnd.3gpp.sms": {
      source: "iana"
    },
    "application/vnd.3gpp.sms+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.srvcc-ext+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.srvcc-info+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.state-and-event-info+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp.ussd+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp2.bcmcsinfo+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.3gpp2.sms": {
      source: "iana"
    },
    "application/vnd.3gpp2.tcap": {
      source: "iana",
      extensions: ["tcap"]
    },
    "application/vnd.3lightssoftware.imagescal": {
      source: "iana"
    },
    "application/vnd.3m.post-it-notes": {
      source: "iana",
      extensions: ["pwn"]
    },
    "application/vnd.accpac.simply.aso": {
      source: "iana",
      extensions: ["aso"]
    },
    "application/vnd.accpac.simply.imp": {
      source: "iana",
      extensions: ["imp"]
    },
    "application/vnd.acucobol": {
      source: "iana",
      extensions: ["acu"]
    },
    "application/vnd.acucorp": {
      source: "iana",
      extensions: ["atc", "acutc"]
    },
    "application/vnd.adobe.air-application-installer-package+zip": {
      source: "apache",
      compressible: false,
      extensions: ["air"]
    },
    "application/vnd.adobe.flash.movie": {
      source: "iana"
    },
    "application/vnd.adobe.formscentral.fcdt": {
      source: "iana",
      extensions: ["fcdt"]
    },
    "application/vnd.adobe.fxp": {
      source: "iana",
      extensions: ["fxp", "fxpl"]
    },
    "application/vnd.adobe.partial-upload": {
      source: "iana"
    },
    "application/vnd.adobe.xdp+xml": {
      source: "iana",
      compressible: true,
      extensions: ["xdp"]
    },
    "application/vnd.adobe.xfdf": {
      source: "iana",
      extensions: ["xfdf"]
    },
    "application/vnd.aether.imp": {
      source: "iana"
    },
    "application/vnd.afpc.afplinedata": {
      source: "iana"
    },
    "application/vnd.afpc.afplinedata-pagedef": {
      source: "iana"
    },
    "application/vnd.afpc.cmoca-cmresource": {
      source: "iana"
    },
    "application/vnd.afpc.foca-charset": {
      source: "iana"
    },
    "application/vnd.afpc.foca-codedfont": {
      source: "iana"
    },
    "application/vnd.afpc.foca-codepage": {
      source: "iana"
    },
    "application/vnd.afpc.modca": {
      source: "iana"
    },
    "application/vnd.afpc.modca-cmtable": {
      source: "iana"
    },
    "application/vnd.afpc.modca-formdef": {
      source: "iana"
    },
    "application/vnd.afpc.modca-mediummap": {
      source: "iana"
    },
    "application/vnd.afpc.modca-objectcontainer": {
      source: "iana"
    },
    "application/vnd.afpc.modca-overlay": {
      source: "iana"
    },
    "application/vnd.afpc.modca-pagesegment": {
      source: "iana"
    },
    "application/vnd.age": {
      source: "iana",
      extensions: ["age"]
    },
    "application/vnd.ah-barcode": {
      source: "iana"
    },
    "application/vnd.ahead.space": {
      source: "iana",
      extensions: ["ahead"]
    },
    "application/vnd.airzip.filesecure.azf": {
      source: "iana",
      extensions: ["azf"]
    },
    "application/vnd.airzip.filesecure.azs": {
      source: "iana",
      extensions: ["azs"]
    },
    "application/vnd.amadeus+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.amazon.ebook": {
      source: "apache",
      extensions: ["azw"]
    },
    "application/vnd.amazon.mobi8-ebook": {
      source: "iana"
    },
    "application/vnd.americandynamics.acc": {
      source: "iana",
      extensions: ["acc"]
    },
    "application/vnd.amiga.ami": {
      source: "iana",
      extensions: ["ami"]
    },
    "application/vnd.amundsen.maze+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.android.ota": {
      source: "iana"
    },
    "application/vnd.android.package-archive": {
      source: "apache",
      compressible: false,
      extensions: ["apk"]
    },
    "application/vnd.anki": {
      source: "iana"
    },
    "application/vnd.anser-web-certificate-issue-initiation": {
      source: "iana",
      extensions: ["cii"]
    },
    "application/vnd.anser-web-funds-transfer-initiation": {
      source: "apache",
      extensions: ["fti"]
    },
    "application/vnd.antix.game-component": {
      source: "iana",
      extensions: ["atx"]
    },
    "application/vnd.apache.arrow.file": {
      source: "iana"
    },
    "application/vnd.apache.arrow.stream": {
      source: "iana"
    },
    "application/vnd.apache.thrift.binary": {
      source: "iana"
    },
    "application/vnd.apache.thrift.compact": {
      source: "iana"
    },
    "application/vnd.apache.thrift.json": {
      source: "iana"
    },
    "application/vnd.api+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.aplextor.warrp+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.apothekende.reservation+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.apple.installer+xml": {
      source: "iana",
      compressible: true,
      extensions: ["mpkg"]
    },
    "application/vnd.apple.keynote": {
      source: "iana",
      extensions: ["key"]
    },
    "application/vnd.apple.mpegurl": {
      source: "iana",
      extensions: ["m3u8"]
    },
    "application/vnd.apple.numbers": {
      source: "iana",
      extensions: ["numbers"]
    },
    "application/vnd.apple.pages": {
      source: "iana",
      extensions: ["pages"]
    },
    "application/vnd.apple.pkpass": {
      compressible: false,
      extensions: ["pkpass"]
    },
    "application/vnd.arastra.swi": {
      source: "iana"
    },
    "application/vnd.aristanetworks.swi": {
      source: "iana",
      extensions: ["swi"]
    },
    "application/vnd.artisan+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.artsquare": {
      source: "iana"
    },
    "application/vnd.astraea-software.iota": {
      source: "iana",
      extensions: ["iota"]
    },
    "application/vnd.audiograph": {
      source: "iana",
      extensions: ["aep"]
    },
    "application/vnd.autopackage": {
      source: "iana"
    },
    "application/vnd.avalon+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.avistar+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.balsamiq.bmml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["bmml"]
    },
    "application/vnd.balsamiq.bmpr": {
      source: "iana"
    },
    "application/vnd.banana-accounting": {
      source: "iana"
    },
    "application/vnd.bbf.usp.error": {
      source: "iana"
    },
    "application/vnd.bbf.usp.msg": {
      source: "iana"
    },
    "application/vnd.bbf.usp.msg+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.bekitzur-stech+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.bint.med-content": {
      source: "iana"
    },
    "application/vnd.biopax.rdf+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.blink-idb-value-wrapper": {
      source: "iana"
    },
    "application/vnd.blueice.multipass": {
      source: "iana",
      extensions: ["mpm"]
    },
    "application/vnd.bluetooth.ep.oob": {
      source: "iana"
    },
    "application/vnd.bluetooth.le.oob": {
      source: "iana"
    },
    "application/vnd.bmi": {
      source: "iana",
      extensions: ["bmi"]
    },
    "application/vnd.bpf": {
      source: "iana"
    },
    "application/vnd.bpf3": {
      source: "iana"
    },
    "application/vnd.businessobjects": {
      source: "iana",
      extensions: ["rep"]
    },
    "application/vnd.byu.uapi+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.cab-jscript": {
      source: "iana"
    },
    "application/vnd.canon-cpdl": {
      source: "iana"
    },
    "application/vnd.canon-lips": {
      source: "iana"
    },
    "application/vnd.capasystems-pg+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.cendio.thinlinc.clientconf": {
      source: "iana"
    },
    "application/vnd.century-systems.tcp_stream": {
      source: "iana"
    },
    "application/vnd.chemdraw+xml": {
      source: "iana",
      compressible: true,
      extensions: ["cdxml"]
    },
    "application/vnd.chess-pgn": {
      source: "iana"
    },
    "application/vnd.chipnuts.karaoke-mmd": {
      source: "iana",
      extensions: ["mmd"]
    },
    "application/vnd.ciedi": {
      source: "iana"
    },
    "application/vnd.cinderella": {
      source: "iana",
      extensions: ["cdy"]
    },
    "application/vnd.cirpack.isdn-ext": {
      source: "iana"
    },
    "application/vnd.citationstyles.style+xml": {
      source: "iana",
      compressible: true,
      extensions: ["csl"]
    },
    "application/vnd.claymore": {
      source: "iana",
      extensions: ["cla"]
    },
    "application/vnd.cloanto.rp9": {
      source: "iana",
      extensions: ["rp9"]
    },
    "application/vnd.clonk.c4group": {
      source: "iana",
      extensions: ["c4g", "c4d", "c4f", "c4p", "c4u"]
    },
    "application/vnd.cluetrust.cartomobile-config": {
      source: "iana",
      extensions: ["c11amc"]
    },
    "application/vnd.cluetrust.cartomobile-config-pkg": {
      source: "iana",
      extensions: ["c11amz"]
    },
    "application/vnd.coffeescript": {
      source: "iana"
    },
    "application/vnd.collabio.xodocuments.document": {
      source: "iana"
    },
    "application/vnd.collabio.xodocuments.document-template": {
      source: "iana"
    },
    "application/vnd.collabio.xodocuments.presentation": {
      source: "iana"
    },
    "application/vnd.collabio.xodocuments.presentation-template": {
      source: "iana"
    },
    "application/vnd.collabio.xodocuments.spreadsheet": {
      source: "iana"
    },
    "application/vnd.collabio.xodocuments.spreadsheet-template": {
      source: "iana"
    },
    "application/vnd.collection+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.collection.doc+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.collection.next+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.comicbook+zip": {
      source: "iana",
      compressible: false
    },
    "application/vnd.comicbook-rar": {
      source: "iana"
    },
    "application/vnd.commerce-battelle": {
      source: "iana"
    },
    "application/vnd.commonspace": {
      source: "iana",
      extensions: ["csp"]
    },
    "application/vnd.contact.cmsg": {
      source: "iana",
      extensions: ["cdbcmsg"]
    },
    "application/vnd.coreos.ignition+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.cosmocaller": {
      source: "iana",
      extensions: ["cmc"]
    },
    "application/vnd.crick.clicker": {
      source: "iana",
      extensions: ["clkx"]
    },
    "application/vnd.crick.clicker.keyboard": {
      source: "iana",
      extensions: ["clkk"]
    },
    "application/vnd.crick.clicker.palette": {
      source: "iana",
      extensions: ["clkp"]
    },
    "application/vnd.crick.clicker.template": {
      source: "iana",
      extensions: ["clkt"]
    },
    "application/vnd.crick.clicker.wordbank": {
      source: "iana",
      extensions: ["clkw"]
    },
    "application/vnd.criticaltools.wbs+xml": {
      source: "iana",
      compressible: true,
      extensions: ["wbs"]
    },
    "application/vnd.cryptii.pipe+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.crypto-shade-file": {
      source: "iana"
    },
    "application/vnd.cryptomator.encrypted": {
      source: "iana"
    },
    "application/vnd.cryptomator.vault": {
      source: "iana"
    },
    "application/vnd.ctc-posml": {
      source: "iana",
      extensions: ["pml"]
    },
    "application/vnd.ctct.ws+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.cups-pdf": {
      source: "iana"
    },
    "application/vnd.cups-postscript": {
      source: "iana"
    },
    "application/vnd.cups-ppd": {
      source: "iana",
      extensions: ["ppd"]
    },
    "application/vnd.cups-raster": {
      source: "iana"
    },
    "application/vnd.cups-raw": {
      source: "iana"
    },
    "application/vnd.curl": {
      source: "iana"
    },
    "application/vnd.curl.car": {
      source: "apache",
      extensions: ["car"]
    },
    "application/vnd.curl.pcurl": {
      source: "apache",
      extensions: ["pcurl"]
    },
    "application/vnd.cyan.dean.root+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.cybank": {
      source: "iana"
    },
    "application/vnd.cyclonedx+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.cyclonedx+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.d2l.coursepackage1p0+zip": {
      source: "iana",
      compressible: false
    },
    "application/vnd.d3m-dataset": {
      source: "iana"
    },
    "application/vnd.d3m-problem": {
      source: "iana"
    },
    "application/vnd.dart": {
      source: "iana",
      compressible: true,
      extensions: ["dart"]
    },
    "application/vnd.data-vision.rdz": {
      source: "iana",
      extensions: ["rdz"]
    },
    "application/vnd.datapackage+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.dataresource+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.dbf": {
      source: "iana",
      extensions: ["dbf"]
    },
    "application/vnd.debian.binary-package": {
      source: "iana"
    },
    "application/vnd.dece.data": {
      source: "iana",
      extensions: ["uvf", "uvvf", "uvd", "uvvd"]
    },
    "application/vnd.dece.ttml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["uvt", "uvvt"]
    },
    "application/vnd.dece.unspecified": {
      source: "iana",
      extensions: ["uvx", "uvvx"]
    },
    "application/vnd.dece.zip": {
      source: "iana",
      extensions: ["uvz", "uvvz"]
    },
    "application/vnd.denovo.fcselayout-link": {
      source: "iana",
      extensions: ["fe_launch"]
    },
    "application/vnd.desmume.movie": {
      source: "iana"
    },
    "application/vnd.dir-bi.plate-dl-nosuffix": {
      source: "iana"
    },
    "application/vnd.dm.delegation+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.dna": {
      source: "iana",
      extensions: ["dna"]
    },
    "application/vnd.document+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.dolby.mlp": {
      source: "apache",
      extensions: ["mlp"]
    },
    "application/vnd.dolby.mobile.1": {
      source: "iana"
    },
    "application/vnd.dolby.mobile.2": {
      source: "iana"
    },
    "application/vnd.doremir.scorecloud-binary-document": {
      source: "iana"
    },
    "application/vnd.dpgraph": {
      source: "iana",
      extensions: ["dpg"]
    },
    "application/vnd.dreamfactory": {
      source: "iana",
      extensions: ["dfac"]
    },
    "application/vnd.drive+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.ds-keypoint": {
      source: "apache",
      extensions: ["kpxx"]
    },
    "application/vnd.dtg.local": {
      source: "iana"
    },
    "application/vnd.dtg.local.flash": {
      source: "iana"
    },
    "application/vnd.dtg.local.html": {
      source: "iana"
    },
    "application/vnd.dvb.ait": {
      source: "iana",
      extensions: ["ait"]
    },
    "application/vnd.dvb.dvbisl+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.dvb.dvbj": {
      source: "iana"
    },
    "application/vnd.dvb.esgcontainer": {
      source: "iana"
    },
    "application/vnd.dvb.ipdcdftnotifaccess": {
      source: "iana"
    },
    "application/vnd.dvb.ipdcesgaccess": {
      source: "iana"
    },
    "application/vnd.dvb.ipdcesgaccess2": {
      source: "iana"
    },
    "application/vnd.dvb.ipdcesgpdd": {
      source: "iana"
    },
    "application/vnd.dvb.ipdcroaming": {
      source: "iana"
    },
    "application/vnd.dvb.iptv.alfec-base": {
      source: "iana"
    },
    "application/vnd.dvb.iptv.alfec-enhancement": {
      source: "iana"
    },
    "application/vnd.dvb.notif-aggregate-root+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.dvb.notif-container+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.dvb.notif-generic+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.dvb.notif-ia-msglist+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.dvb.notif-ia-registration-request+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.dvb.notif-ia-registration-response+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.dvb.notif-init+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.dvb.pfr": {
      source: "iana"
    },
    "application/vnd.dvb.service": {
      source: "iana",
      extensions: ["svc"]
    },
    "application/vnd.dxr": {
      source: "iana"
    },
    "application/vnd.dynageo": {
      source: "iana",
      extensions: ["geo"]
    },
    "application/vnd.dzr": {
      source: "iana"
    },
    "application/vnd.easykaraoke.cdgdownload": {
      source: "iana"
    },
    "application/vnd.ecdis-update": {
      source: "iana"
    },
    "application/vnd.ecip.rlp": {
      source: "iana"
    },
    "application/vnd.eclipse.ditto+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.ecowin.chart": {
      source: "iana",
      extensions: ["mag"]
    },
    "application/vnd.ecowin.filerequest": {
      source: "iana"
    },
    "application/vnd.ecowin.fileupdate": {
      source: "iana"
    },
    "application/vnd.ecowin.series": {
      source: "iana"
    },
    "application/vnd.ecowin.seriesrequest": {
      source: "iana"
    },
    "application/vnd.ecowin.seriesupdate": {
      source: "iana"
    },
    "application/vnd.efi.img": {
      source: "iana"
    },
    "application/vnd.efi.iso": {
      source: "iana"
    },
    "application/vnd.emclient.accessrequest+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.enliven": {
      source: "iana",
      extensions: ["nml"]
    },
    "application/vnd.enphase.envoy": {
      source: "iana"
    },
    "application/vnd.eprints.data+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.epson.esf": {
      source: "iana",
      extensions: ["esf"]
    },
    "application/vnd.epson.msf": {
      source: "iana",
      extensions: ["msf"]
    },
    "application/vnd.epson.quickanime": {
      source: "iana",
      extensions: ["qam"]
    },
    "application/vnd.epson.salt": {
      source: "iana",
      extensions: ["slt"]
    },
    "application/vnd.epson.ssf": {
      source: "iana",
      extensions: ["ssf"]
    },
    "application/vnd.ericsson.quickcall": {
      source: "iana"
    },
    "application/vnd.espass-espass+zip": {
      source: "iana",
      compressible: false
    },
    "application/vnd.eszigno3+xml": {
      source: "iana",
      compressible: true,
      extensions: ["es3", "et3"]
    },
    "application/vnd.etsi.aoc+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.etsi.asic-e+zip": {
      source: "iana",
      compressible: false
    },
    "application/vnd.etsi.asic-s+zip": {
      source: "iana",
      compressible: false
    },
    "application/vnd.etsi.cug+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.etsi.iptvcommand+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.etsi.iptvdiscovery+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.etsi.iptvprofile+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.etsi.iptvsad-bc+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.etsi.iptvsad-cod+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.etsi.iptvsad-npvr+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.etsi.iptvservice+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.etsi.iptvsync+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.etsi.iptvueprofile+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.etsi.mcid+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.etsi.mheg5": {
      source: "iana"
    },
    "application/vnd.etsi.overload-control-policy-dataset+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.etsi.pstn+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.etsi.sci+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.etsi.simservs+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.etsi.timestamp-token": {
      source: "iana"
    },
    "application/vnd.etsi.tsl+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.etsi.tsl.der": {
      source: "iana"
    },
    "application/vnd.eu.kasparian.car+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.eudora.data": {
      source: "iana"
    },
    "application/vnd.evolv.ecig.profile": {
      source: "iana"
    },
    "application/vnd.evolv.ecig.settings": {
      source: "iana"
    },
    "application/vnd.evolv.ecig.theme": {
      source: "iana"
    },
    "application/vnd.exstream-empower+zip": {
      source: "iana",
      compressible: false
    },
    "application/vnd.exstream-package": {
      source: "iana"
    },
    "application/vnd.ezpix-album": {
      source: "iana",
      extensions: ["ez2"]
    },
    "application/vnd.ezpix-package": {
      source: "iana",
      extensions: ["ez3"]
    },
    "application/vnd.f-secure.mobile": {
      source: "iana"
    },
    "application/vnd.familysearch.gedcom+zip": {
      source: "iana",
      compressible: false
    },
    "application/vnd.fastcopy-disk-image": {
      source: "iana"
    },
    "application/vnd.fdf": {
      source: "iana",
      extensions: ["fdf"]
    },
    "application/vnd.fdsn.mseed": {
      source: "iana",
      extensions: ["mseed"]
    },
    "application/vnd.fdsn.seed": {
      source: "iana",
      extensions: ["seed", "dataless"]
    },
    "application/vnd.ffsns": {
      source: "iana"
    },
    "application/vnd.ficlab.flb+zip": {
      source: "iana",
      compressible: false
    },
    "application/vnd.filmit.zfc": {
      source: "iana"
    },
    "application/vnd.fints": {
      source: "iana"
    },
    "application/vnd.firemonkeys.cloudcell": {
      source: "iana"
    },
    "application/vnd.flographit": {
      source: "iana",
      extensions: ["gph"]
    },
    "application/vnd.fluxtime.clip": {
      source: "iana",
      extensions: ["ftc"]
    },
    "application/vnd.font-fontforge-sfd": {
      source: "iana"
    },
    "application/vnd.framemaker": {
      source: "iana",
      extensions: ["fm", "frame", "maker", "book"]
    },
    "application/vnd.frogans.fnc": {
      source: "iana",
      extensions: ["fnc"]
    },
    "application/vnd.frogans.ltf": {
      source: "iana",
      extensions: ["ltf"]
    },
    "application/vnd.fsc.weblaunch": {
      source: "iana",
      extensions: ["fsc"]
    },
    "application/vnd.fujifilm.fb.docuworks": {
      source: "iana"
    },
    "application/vnd.fujifilm.fb.docuworks.binder": {
      source: "iana"
    },
    "application/vnd.fujifilm.fb.docuworks.container": {
      source: "iana"
    },
    "application/vnd.fujifilm.fb.jfi+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.fujitsu.oasys": {
      source: "iana",
      extensions: ["oas"]
    },
    "application/vnd.fujitsu.oasys2": {
      source: "iana",
      extensions: ["oa2"]
    },
    "application/vnd.fujitsu.oasys3": {
      source: "iana",
      extensions: ["oa3"]
    },
    "application/vnd.fujitsu.oasysgp": {
      source: "iana",
      extensions: ["fg5"]
    },
    "application/vnd.fujitsu.oasysprs": {
      source: "iana",
      extensions: ["bh2"]
    },
    "application/vnd.fujixerox.art-ex": {
      source: "iana"
    },
    "application/vnd.fujixerox.art4": {
      source: "iana"
    },
    "application/vnd.fujixerox.ddd": {
      source: "iana",
      extensions: ["ddd"]
    },
    "application/vnd.fujixerox.docuworks": {
      source: "iana",
      extensions: ["xdw"]
    },
    "application/vnd.fujixerox.docuworks.binder": {
      source: "iana",
      extensions: ["xbd"]
    },
    "application/vnd.fujixerox.docuworks.container": {
      source: "iana"
    },
    "application/vnd.fujixerox.hbpl": {
      source: "iana"
    },
    "application/vnd.fut-misnet": {
      source: "iana"
    },
    "application/vnd.futoin+cbor": {
      source: "iana"
    },
    "application/vnd.futoin+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.fuzzysheet": {
      source: "iana",
      extensions: ["fzs"]
    },
    "application/vnd.genomatix.tuxedo": {
      source: "iana",
      extensions: ["txd"]
    },
    "application/vnd.gentics.grd+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.geo+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.geocube+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.geogebra.file": {
      source: "iana",
      extensions: ["ggb"]
    },
    "application/vnd.geogebra.slides": {
      source: "iana"
    },
    "application/vnd.geogebra.tool": {
      source: "iana",
      extensions: ["ggt"]
    },
    "application/vnd.geometry-explorer": {
      source: "iana",
      extensions: ["gex", "gre"]
    },
    "application/vnd.geonext": {
      source: "iana",
      extensions: ["gxt"]
    },
    "application/vnd.geoplan": {
      source: "iana",
      extensions: ["g2w"]
    },
    "application/vnd.geospace": {
      source: "iana",
      extensions: ["g3w"]
    },
    "application/vnd.gerber": {
      source: "iana"
    },
    "application/vnd.globalplatform.card-content-mgt": {
      source: "iana"
    },
    "application/vnd.globalplatform.card-content-mgt-response": {
      source: "iana"
    },
    "application/vnd.gmx": {
      source: "iana",
      extensions: ["gmx"]
    },
    "application/vnd.google-apps.document": {
      compressible: false,
      extensions: ["gdoc"]
    },
    "application/vnd.google-apps.presentation": {
      compressible: false,
      extensions: ["gslides"]
    },
    "application/vnd.google-apps.spreadsheet": {
      compressible: false,
      extensions: ["gsheet"]
    },
    "application/vnd.google-earth.kml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["kml"]
    },
    "application/vnd.google-earth.kmz": {
      source: "iana",
      compressible: false,
      extensions: ["kmz"]
    },
    "application/vnd.gov.sk.e-form+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.gov.sk.e-form+zip": {
      source: "iana",
      compressible: false
    },
    "application/vnd.gov.sk.xmldatacontainer+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.grafeq": {
      source: "iana",
      extensions: ["gqf", "gqs"]
    },
    "application/vnd.gridmp": {
      source: "iana"
    },
    "application/vnd.groove-account": {
      source: "iana",
      extensions: ["gac"]
    },
    "application/vnd.groove-help": {
      source: "iana",
      extensions: ["ghf"]
    },
    "application/vnd.groove-identity-message": {
      source: "iana",
      extensions: ["gim"]
    },
    "application/vnd.groove-injector": {
      source: "iana",
      extensions: ["grv"]
    },
    "application/vnd.groove-tool-message": {
      source: "iana",
      extensions: ["gtm"]
    },
    "application/vnd.groove-tool-template": {
      source: "iana",
      extensions: ["tpl"]
    },
    "application/vnd.groove-vcard": {
      source: "iana",
      extensions: ["vcg"]
    },
    "application/vnd.hal+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.hal+xml": {
      source: "iana",
      compressible: true,
      extensions: ["hal"]
    },
    "application/vnd.handheld-entertainment+xml": {
      source: "iana",
      compressible: true,
      extensions: ["zmm"]
    },
    "application/vnd.hbci": {
      source: "iana",
      extensions: ["hbci"]
    },
    "application/vnd.hc+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.hcl-bireports": {
      source: "iana"
    },
    "application/vnd.hdt": {
      source: "iana"
    },
    "application/vnd.heroku+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.hhe.lesson-player": {
      source: "iana",
      extensions: ["les"]
    },
    "application/vnd.hl7cda+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/vnd.hl7v2+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/vnd.hp-hpgl": {
      source: "iana",
      extensions: ["hpgl"]
    },
    "application/vnd.hp-hpid": {
      source: "iana",
      extensions: ["hpid"]
    },
    "application/vnd.hp-hps": {
      source: "iana",
      extensions: ["hps"]
    },
    "application/vnd.hp-jlyt": {
      source: "iana",
      extensions: ["jlt"]
    },
    "application/vnd.hp-pcl": {
      source: "iana",
      extensions: ["pcl"]
    },
    "application/vnd.hp-pclxl": {
      source: "iana",
      extensions: ["pclxl"]
    },
    "application/vnd.httphone": {
      source: "iana"
    },
    "application/vnd.hydrostatix.sof-data": {
      source: "iana",
      extensions: ["sfd-hdstx"]
    },
    "application/vnd.hyper+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.hyper-item+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.hyperdrive+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.hzn-3d-crossword": {
      source: "iana"
    },
    "application/vnd.ibm.afplinedata": {
      source: "iana"
    },
    "application/vnd.ibm.electronic-media": {
      source: "iana"
    },
    "application/vnd.ibm.minipay": {
      source: "iana",
      extensions: ["mpy"]
    },
    "application/vnd.ibm.modcap": {
      source: "iana",
      extensions: ["afp", "listafp", "list3820"]
    },
    "application/vnd.ibm.rights-management": {
      source: "iana",
      extensions: ["irm"]
    },
    "application/vnd.ibm.secure-container": {
      source: "iana",
      extensions: ["sc"]
    },
    "application/vnd.iccprofile": {
      source: "iana",
      extensions: ["icc", "icm"]
    },
    "application/vnd.ieee.1905": {
      source: "iana"
    },
    "application/vnd.igloader": {
      source: "iana",
      extensions: ["igl"]
    },
    "application/vnd.imagemeter.folder+zip": {
      source: "iana",
      compressible: false
    },
    "application/vnd.imagemeter.image+zip": {
      source: "iana",
      compressible: false
    },
    "application/vnd.immervision-ivp": {
      source: "iana",
      extensions: ["ivp"]
    },
    "application/vnd.immervision-ivu": {
      source: "iana",
      extensions: ["ivu"]
    },
    "application/vnd.ims.imsccv1p1": {
      source: "iana"
    },
    "application/vnd.ims.imsccv1p2": {
      source: "iana"
    },
    "application/vnd.ims.imsccv1p3": {
      source: "iana"
    },
    "application/vnd.ims.lis.v2.result+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.ims.lti.v2.toolconsumerprofile+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.ims.lti.v2.toolproxy+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.ims.lti.v2.toolproxy.id+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.ims.lti.v2.toolsettings+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.ims.lti.v2.toolsettings.simple+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.informedcontrol.rms+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.informix-visionary": {
      source: "iana"
    },
    "application/vnd.infotech.project": {
      source: "iana"
    },
    "application/vnd.infotech.project+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.innopath.wamp.notification": {
      source: "iana"
    },
    "application/vnd.insors.igm": {
      source: "iana",
      extensions: ["igm"]
    },
    "application/vnd.intercon.formnet": {
      source: "iana",
      extensions: ["xpw", "xpx"]
    },
    "application/vnd.intergeo": {
      source: "iana",
      extensions: ["i2g"]
    },
    "application/vnd.intertrust.digibox": {
      source: "iana"
    },
    "application/vnd.intertrust.nncp": {
      source: "iana"
    },
    "application/vnd.intu.qbo": {
      source: "iana",
      extensions: ["qbo"]
    },
    "application/vnd.intu.qfx": {
      source: "iana",
      extensions: ["qfx"]
    },
    "application/vnd.iptc.g2.catalogitem+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.iptc.g2.conceptitem+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.iptc.g2.knowledgeitem+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.iptc.g2.newsitem+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.iptc.g2.newsmessage+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.iptc.g2.packageitem+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.iptc.g2.planningitem+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.ipunplugged.rcprofile": {
      source: "iana",
      extensions: ["rcprofile"]
    },
    "application/vnd.irepository.package+xml": {
      source: "iana",
      compressible: true,
      extensions: ["irp"]
    },
    "application/vnd.is-xpr": {
      source: "iana",
      extensions: ["xpr"]
    },
    "application/vnd.isac.fcs": {
      source: "iana",
      extensions: ["fcs"]
    },
    "application/vnd.iso11783-10+zip": {
      source: "iana",
      compressible: false
    },
    "application/vnd.jam": {
      source: "iana",
      extensions: ["jam"]
    },
    "application/vnd.japannet-directory-service": {
      source: "iana"
    },
    "application/vnd.japannet-jpnstore-wakeup": {
      source: "iana"
    },
    "application/vnd.japannet-payment-wakeup": {
      source: "iana"
    },
    "application/vnd.japannet-registration": {
      source: "iana"
    },
    "application/vnd.japannet-registration-wakeup": {
      source: "iana"
    },
    "application/vnd.japannet-setstore-wakeup": {
      source: "iana"
    },
    "application/vnd.japannet-verification": {
      source: "iana"
    },
    "application/vnd.japannet-verification-wakeup": {
      source: "iana"
    },
    "application/vnd.jcp.javame.midlet-rms": {
      source: "iana",
      extensions: ["rms"]
    },
    "application/vnd.jisp": {
      source: "iana",
      extensions: ["jisp"]
    },
    "application/vnd.joost.joda-archive": {
      source: "iana",
      extensions: ["joda"]
    },
    "application/vnd.jsk.isdn-ngn": {
      source: "iana"
    },
    "application/vnd.kahootz": {
      source: "iana",
      extensions: ["ktz", "ktr"]
    },
    "application/vnd.kde.karbon": {
      source: "iana",
      extensions: ["karbon"]
    },
    "application/vnd.kde.kchart": {
      source: "iana",
      extensions: ["chrt"]
    },
    "application/vnd.kde.kformula": {
      source: "iana",
      extensions: ["kfo"]
    },
    "application/vnd.kde.kivio": {
      source: "iana",
      extensions: ["flw"]
    },
    "application/vnd.kde.kontour": {
      source: "iana",
      extensions: ["kon"]
    },
    "application/vnd.kde.kpresenter": {
      source: "iana",
      extensions: ["kpr", "kpt"]
    },
    "application/vnd.kde.kspread": {
      source: "iana",
      extensions: ["ksp"]
    },
    "application/vnd.kde.kword": {
      source: "iana",
      extensions: ["kwd", "kwt"]
    },
    "application/vnd.kenameaapp": {
      source: "iana",
      extensions: ["htke"]
    },
    "application/vnd.kidspiration": {
      source: "iana",
      extensions: ["kia"]
    },
    "application/vnd.kinar": {
      source: "iana",
      extensions: ["kne", "knp"]
    },
    "application/vnd.koan": {
      source: "iana",
      extensions: ["skp", "skd", "skt", "skm"]
    },
    "application/vnd.kodak-descriptor": {
      source: "iana",
      extensions: ["sse"]
    },
    "application/vnd.las": {
      source: "iana"
    },
    "application/vnd.las.las+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.las.las+xml": {
      source: "iana",
      compressible: true,
      extensions: ["lasxml"]
    },
    "application/vnd.laszip": {
      source: "iana"
    },
    "application/vnd.leap+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.liberty-request+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.llamagraphics.life-balance.desktop": {
      source: "iana",
      extensions: ["lbd"]
    },
    "application/vnd.llamagraphics.life-balance.exchange+xml": {
      source: "iana",
      compressible: true,
      extensions: ["lbe"]
    },
    "application/vnd.logipipe.circuit+zip": {
      source: "iana",
      compressible: false
    },
    "application/vnd.loom": {
      source: "iana"
    },
    "application/vnd.lotus-1-2-3": {
      source: "iana",
      extensions: ["123"]
    },
    "application/vnd.lotus-approach": {
      source: "iana",
      extensions: ["apr"]
    },
    "application/vnd.lotus-freelance": {
      source: "iana",
      extensions: ["pre"]
    },
    "application/vnd.lotus-notes": {
      source: "iana",
      extensions: ["nsf"]
    },
    "application/vnd.lotus-organizer": {
      source: "iana",
      extensions: ["org"]
    },
    "application/vnd.lotus-screencam": {
      source: "iana",
      extensions: ["scm"]
    },
    "application/vnd.lotus-wordpro": {
      source: "iana",
      extensions: ["lwp"]
    },
    "application/vnd.macports.portpkg": {
      source: "iana",
      extensions: ["portpkg"]
    },
    "application/vnd.mapbox-vector-tile": {
      source: "iana",
      extensions: ["mvt"]
    },
    "application/vnd.marlin.drm.actiontoken+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.marlin.drm.conftoken+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.marlin.drm.license+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.marlin.drm.mdcf": {
      source: "iana"
    },
    "application/vnd.mason+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.maxar.archive.3tz+zip": {
      source: "iana",
      compressible: false
    },
    "application/vnd.maxmind.maxmind-db": {
      source: "iana"
    },
    "application/vnd.mcd": {
      source: "iana",
      extensions: ["mcd"]
    },
    "application/vnd.medcalcdata": {
      source: "iana",
      extensions: ["mc1"]
    },
    "application/vnd.mediastation.cdkey": {
      source: "iana",
      extensions: ["cdkey"]
    },
    "application/vnd.meridian-slingshot": {
      source: "iana"
    },
    "application/vnd.mfer": {
      source: "iana",
      extensions: ["mwf"]
    },
    "application/vnd.mfmp": {
      source: "iana",
      extensions: ["mfm"]
    },
    "application/vnd.micro+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.micrografx.flo": {
      source: "iana",
      extensions: ["flo"]
    },
    "application/vnd.micrografx.igx": {
      source: "iana",
      extensions: ["igx"]
    },
    "application/vnd.microsoft.portable-executable": {
      source: "iana"
    },
    "application/vnd.microsoft.windows.thumbnail-cache": {
      source: "iana"
    },
    "application/vnd.miele+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.mif": {
      source: "iana",
      extensions: ["mif"]
    },
    "application/vnd.minisoft-hp3000-save": {
      source: "iana"
    },
    "application/vnd.mitsubishi.misty-guard.trustweb": {
      source: "iana"
    },
    "application/vnd.mobius.daf": {
      source: "iana",
      extensions: ["daf"]
    },
    "application/vnd.mobius.dis": {
      source: "iana",
      extensions: ["dis"]
    },
    "application/vnd.mobius.mbk": {
      source: "iana",
      extensions: ["mbk"]
    },
    "application/vnd.mobius.mqy": {
      source: "iana",
      extensions: ["mqy"]
    },
    "application/vnd.mobius.msl": {
      source: "iana",
      extensions: ["msl"]
    },
    "application/vnd.mobius.plc": {
      source: "iana",
      extensions: ["plc"]
    },
    "application/vnd.mobius.txf": {
      source: "iana",
      extensions: ["txf"]
    },
    "application/vnd.mophun.application": {
      source: "iana",
      extensions: ["mpn"]
    },
    "application/vnd.mophun.certificate": {
      source: "iana",
      extensions: ["mpc"]
    },
    "application/vnd.motorola.flexsuite": {
      source: "iana"
    },
    "application/vnd.motorola.flexsuite.adsi": {
      source: "iana"
    },
    "application/vnd.motorola.flexsuite.fis": {
      source: "iana"
    },
    "application/vnd.motorola.flexsuite.gotap": {
      source: "iana"
    },
    "application/vnd.motorola.flexsuite.kmr": {
      source: "iana"
    },
    "application/vnd.motorola.flexsuite.ttc": {
      source: "iana"
    },
    "application/vnd.motorola.flexsuite.wem": {
      source: "iana"
    },
    "application/vnd.motorola.iprm": {
      source: "iana"
    },
    "application/vnd.mozilla.xul+xml": {
      source: "iana",
      compressible: true,
      extensions: ["xul"]
    },
    "application/vnd.ms-3mfdocument": {
      source: "iana"
    },
    "application/vnd.ms-artgalry": {
      source: "iana",
      extensions: ["cil"]
    },
    "application/vnd.ms-asf": {
      source: "iana"
    },
    "application/vnd.ms-cab-compressed": {
      source: "iana",
      extensions: ["cab"]
    },
    "application/vnd.ms-color.iccprofile": {
      source: "apache"
    },
    "application/vnd.ms-excel": {
      source: "iana",
      compressible: false,
      extensions: ["xls", "xlm", "xla", "xlc", "xlt", "xlw"]
    },
    "application/vnd.ms-excel.addin.macroenabled.12": {
      source: "iana",
      extensions: ["xlam"]
    },
    "application/vnd.ms-excel.sheet.binary.macroenabled.12": {
      source: "iana",
      extensions: ["xlsb"]
    },
    "application/vnd.ms-excel.sheet.macroenabled.12": {
      source: "iana",
      extensions: ["xlsm"]
    },
    "application/vnd.ms-excel.template.macroenabled.12": {
      source: "iana",
      extensions: ["xltm"]
    },
    "application/vnd.ms-fontobject": {
      source: "iana",
      compressible: true,
      extensions: ["eot"]
    },
    "application/vnd.ms-htmlhelp": {
      source: "iana",
      extensions: ["chm"]
    },
    "application/vnd.ms-ims": {
      source: "iana",
      extensions: ["ims"]
    },
    "application/vnd.ms-lrm": {
      source: "iana",
      extensions: ["lrm"]
    },
    "application/vnd.ms-office.activex+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.ms-officetheme": {
      source: "iana",
      extensions: ["thmx"]
    },
    "application/vnd.ms-opentype": {
      source: "apache",
      compressible: true
    },
    "application/vnd.ms-outlook": {
      compressible: false,
      extensions: ["msg"]
    },
    "application/vnd.ms-package.obfuscated-opentype": {
      source: "apache"
    },
    "application/vnd.ms-pki.seccat": {
      source: "apache",
      extensions: ["cat"]
    },
    "application/vnd.ms-pki.stl": {
      source: "apache",
      extensions: ["stl"]
    },
    "application/vnd.ms-playready.initiator+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.ms-powerpoint": {
      source: "iana",
      compressible: false,
      extensions: ["ppt", "pps", "pot"]
    },
    "application/vnd.ms-powerpoint.addin.macroenabled.12": {
      source: "iana",
      extensions: ["ppam"]
    },
    "application/vnd.ms-powerpoint.presentation.macroenabled.12": {
      source: "iana",
      extensions: ["pptm"]
    },
    "application/vnd.ms-powerpoint.slide.macroenabled.12": {
      source: "iana",
      extensions: ["sldm"]
    },
    "application/vnd.ms-powerpoint.slideshow.macroenabled.12": {
      source: "iana",
      extensions: ["ppsm"]
    },
    "application/vnd.ms-powerpoint.template.macroenabled.12": {
      source: "iana",
      extensions: ["potm"]
    },
    "application/vnd.ms-printdevicecapabilities+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.ms-printing.printticket+xml": {
      source: "apache",
      compressible: true
    },
    "application/vnd.ms-printschematicket+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.ms-project": {
      source: "iana",
      extensions: ["mpp", "mpt"]
    },
    "application/vnd.ms-tnef": {
      source: "iana"
    },
    "application/vnd.ms-windows.devicepairing": {
      source: "iana"
    },
    "application/vnd.ms-windows.nwprinting.oob": {
      source: "iana"
    },
    "application/vnd.ms-windows.printerpairing": {
      source: "iana"
    },
    "application/vnd.ms-windows.wsd.oob": {
      source: "iana"
    },
    "application/vnd.ms-wmdrm.lic-chlg-req": {
      source: "iana"
    },
    "application/vnd.ms-wmdrm.lic-resp": {
      source: "iana"
    },
    "application/vnd.ms-wmdrm.meter-chlg-req": {
      source: "iana"
    },
    "application/vnd.ms-wmdrm.meter-resp": {
      source: "iana"
    },
    "application/vnd.ms-word.document.macroenabled.12": {
      source: "iana",
      extensions: ["docm"]
    },
    "application/vnd.ms-word.template.macroenabled.12": {
      source: "iana",
      extensions: ["dotm"]
    },
    "application/vnd.ms-works": {
      source: "iana",
      extensions: ["wps", "wks", "wcm", "wdb"]
    },
    "application/vnd.ms-wpl": {
      source: "iana",
      extensions: ["wpl"]
    },
    "application/vnd.ms-xpsdocument": {
      source: "iana",
      compressible: false,
      extensions: ["xps"]
    },
    "application/vnd.msa-disk-image": {
      source: "iana"
    },
    "application/vnd.mseq": {
      source: "iana",
      extensions: ["mseq"]
    },
    "application/vnd.msign": {
      source: "iana"
    },
    "application/vnd.multiad.creator": {
      source: "iana"
    },
    "application/vnd.multiad.creator.cif": {
      source: "iana"
    },
    "application/vnd.music-niff": {
      source: "iana"
    },
    "application/vnd.musician": {
      source: "iana",
      extensions: ["mus"]
    },
    "application/vnd.muvee.style": {
      source: "iana",
      extensions: ["msty"]
    },
    "application/vnd.mynfc": {
      source: "iana",
      extensions: ["taglet"]
    },
    "application/vnd.nacamar.ybrid+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.ncd.control": {
      source: "iana"
    },
    "application/vnd.ncd.reference": {
      source: "iana"
    },
    "application/vnd.nearst.inv+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.nebumind.line": {
      source: "iana"
    },
    "application/vnd.nervana": {
      source: "iana"
    },
    "application/vnd.netfpx": {
      source: "iana"
    },
    "application/vnd.neurolanguage.nlu": {
      source: "iana",
      extensions: ["nlu"]
    },
    "application/vnd.nimn": {
      source: "iana"
    },
    "application/vnd.nintendo.nitro.rom": {
      source: "iana"
    },
    "application/vnd.nintendo.snes.rom": {
      source: "iana"
    },
    "application/vnd.nitf": {
      source: "iana",
      extensions: ["ntf", "nitf"]
    },
    "application/vnd.noblenet-directory": {
      source: "iana",
      extensions: ["nnd"]
    },
    "application/vnd.noblenet-sealer": {
      source: "iana",
      extensions: ["nns"]
    },
    "application/vnd.noblenet-web": {
      source: "iana",
      extensions: ["nnw"]
    },
    "application/vnd.nokia.catalogs": {
      source: "iana"
    },
    "application/vnd.nokia.conml+wbxml": {
      source: "iana"
    },
    "application/vnd.nokia.conml+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.nokia.iptv.config+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.nokia.isds-radio-presets": {
      source: "iana"
    },
    "application/vnd.nokia.landmark+wbxml": {
      source: "iana"
    },
    "application/vnd.nokia.landmark+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.nokia.landmarkcollection+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.nokia.n-gage.ac+xml": {
      source: "iana",
      compressible: true,
      extensions: ["ac"]
    },
    "application/vnd.nokia.n-gage.data": {
      source: "iana",
      extensions: ["ngdat"]
    },
    "application/vnd.nokia.n-gage.symbian.install": {
      source: "iana",
      extensions: ["n-gage"]
    },
    "application/vnd.nokia.ncd": {
      source: "iana"
    },
    "application/vnd.nokia.pcd+wbxml": {
      source: "iana"
    },
    "application/vnd.nokia.pcd+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.nokia.radio-preset": {
      source: "iana",
      extensions: ["rpst"]
    },
    "application/vnd.nokia.radio-presets": {
      source: "iana",
      extensions: ["rpss"]
    },
    "application/vnd.novadigm.edm": {
      source: "iana",
      extensions: ["edm"]
    },
    "application/vnd.novadigm.edx": {
      source: "iana",
      extensions: ["edx"]
    },
    "application/vnd.novadigm.ext": {
      source: "iana",
      extensions: ["ext"]
    },
    "application/vnd.ntt-local.content-share": {
      source: "iana"
    },
    "application/vnd.ntt-local.file-transfer": {
      source: "iana"
    },
    "application/vnd.ntt-local.ogw_remote-access": {
      source: "iana"
    },
    "application/vnd.ntt-local.sip-ta_remote": {
      source: "iana"
    },
    "application/vnd.ntt-local.sip-ta_tcp_stream": {
      source: "iana"
    },
    "application/vnd.oasis.opendocument.chart": {
      source: "iana",
      extensions: ["odc"]
    },
    "application/vnd.oasis.opendocument.chart-template": {
      source: "iana",
      extensions: ["otc"]
    },
    "application/vnd.oasis.opendocument.database": {
      source: "iana",
      extensions: ["odb"]
    },
    "application/vnd.oasis.opendocument.formula": {
      source: "iana",
      extensions: ["odf"]
    },
    "application/vnd.oasis.opendocument.formula-template": {
      source: "iana",
      extensions: ["odft"]
    },
    "application/vnd.oasis.opendocument.graphics": {
      source: "iana",
      compressible: false,
      extensions: ["odg"]
    },
    "application/vnd.oasis.opendocument.graphics-template": {
      source: "iana",
      extensions: ["otg"]
    },
    "application/vnd.oasis.opendocument.image": {
      source: "iana",
      extensions: ["odi"]
    },
    "application/vnd.oasis.opendocument.image-template": {
      source: "iana",
      extensions: ["oti"]
    },
    "application/vnd.oasis.opendocument.presentation": {
      source: "iana",
      compressible: false,
      extensions: ["odp"]
    },
    "application/vnd.oasis.opendocument.presentation-template": {
      source: "iana",
      extensions: ["otp"]
    },
    "application/vnd.oasis.opendocument.spreadsheet": {
      source: "iana",
      compressible: false,
      extensions: ["ods"]
    },
    "application/vnd.oasis.opendocument.spreadsheet-template": {
      source: "iana",
      extensions: ["ots"]
    },
    "application/vnd.oasis.opendocument.text": {
      source: "iana",
      compressible: false,
      extensions: ["odt"]
    },
    "application/vnd.oasis.opendocument.text-master": {
      source: "iana",
      extensions: ["odm"]
    },
    "application/vnd.oasis.opendocument.text-template": {
      source: "iana",
      extensions: ["ott"]
    },
    "application/vnd.oasis.opendocument.text-web": {
      source: "iana",
      extensions: ["oth"]
    },
    "application/vnd.obn": {
      source: "iana"
    },
    "application/vnd.ocf+cbor": {
      source: "iana"
    },
    "application/vnd.oci.image.manifest.v1+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oftn.l10n+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oipf.contentaccessdownload+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oipf.contentaccessstreaming+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oipf.cspg-hexbinary": {
      source: "iana"
    },
    "application/vnd.oipf.dae.svg+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oipf.dae.xhtml+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oipf.mippvcontrolmessage+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oipf.pae.gem": {
      source: "iana"
    },
    "application/vnd.oipf.spdiscovery+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oipf.spdlist+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oipf.ueprofile+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oipf.userprofile+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.olpc-sugar": {
      source: "iana",
      extensions: ["xo"]
    },
    "application/vnd.oma-scws-config": {
      source: "iana"
    },
    "application/vnd.oma-scws-http-request": {
      source: "iana"
    },
    "application/vnd.oma-scws-http-response": {
      source: "iana"
    },
    "application/vnd.oma.bcast.associated-procedure-parameter+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.bcast.drm-trigger+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.bcast.imd+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.bcast.ltkm": {
      source: "iana"
    },
    "application/vnd.oma.bcast.notification+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.bcast.provisioningtrigger": {
      source: "iana"
    },
    "application/vnd.oma.bcast.sgboot": {
      source: "iana"
    },
    "application/vnd.oma.bcast.sgdd+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.bcast.sgdu": {
      source: "iana"
    },
    "application/vnd.oma.bcast.simple-symbol-container": {
      source: "iana"
    },
    "application/vnd.oma.bcast.smartcard-trigger+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.bcast.sprov+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.bcast.stkm": {
      source: "iana"
    },
    "application/vnd.oma.cab-address-book+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.cab-feature-handler+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.cab-pcc+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.cab-subs-invite+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.cab-user-prefs+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.dcd": {
      source: "iana"
    },
    "application/vnd.oma.dcdc": {
      source: "iana"
    },
    "application/vnd.oma.dd2+xml": {
      source: "iana",
      compressible: true,
      extensions: ["dd2"]
    },
    "application/vnd.oma.drm.risd+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.group-usage-list+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.lwm2m+cbor": {
      source: "iana"
    },
    "application/vnd.oma.lwm2m+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.lwm2m+tlv": {
      source: "iana"
    },
    "application/vnd.oma.pal+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.poc.detailed-progress-report+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.poc.final-report+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.poc.groups+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.poc.invocation-descriptor+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.poc.optimized-progress-report+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.push": {
      source: "iana"
    },
    "application/vnd.oma.scidm.messages+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oma.xcap-directory+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.omads-email+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/vnd.omads-file+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/vnd.omads-folder+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/vnd.omaloc-supl-init": {
      source: "iana"
    },
    "application/vnd.onepager": {
      source: "iana"
    },
    "application/vnd.onepagertamp": {
      source: "iana"
    },
    "application/vnd.onepagertamx": {
      source: "iana"
    },
    "application/vnd.onepagertat": {
      source: "iana"
    },
    "application/vnd.onepagertatp": {
      source: "iana"
    },
    "application/vnd.onepagertatx": {
      source: "iana"
    },
    "application/vnd.openblox.game+xml": {
      source: "iana",
      compressible: true,
      extensions: ["obgx"]
    },
    "application/vnd.openblox.game-binary": {
      source: "iana"
    },
    "application/vnd.openeye.oeb": {
      source: "iana"
    },
    "application/vnd.openofficeorg.extension": {
      source: "apache",
      extensions: ["oxt"]
    },
    "application/vnd.openstreetmap.data+xml": {
      source: "iana",
      compressible: true,
      extensions: ["osm"]
    },
    "application/vnd.opentimestamps.ots": {
      source: "iana"
    },
    "application/vnd.openxmlformats-officedocument.custom-properties+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.customxmlproperties+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.drawing+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.drawingml.diagramcolors+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.drawingml.diagramdata+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.drawingml.diagramlayout+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.drawingml.diagramstyle+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.extended-properties+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.commentauthors+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.comments+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.handoutmaster+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.notesmaster+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.notesslide+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.presentation": {
      source: "iana",
      compressible: false,
      extensions: ["pptx"]
    },
    "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.presprops+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.slide": {
      source: "iana",
      extensions: ["sldx"]
    },
    "application/vnd.openxmlformats-officedocument.presentationml.slide+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.slidelayout+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.slidemaster+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.slideshow": {
      source: "iana",
      extensions: ["ppsx"]
    },
    "application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.slideupdateinfo+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.tablestyles+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.tags+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.template": {
      source: "iana",
      extensions: ["potx"]
    },
    "application/vnd.openxmlformats-officedocument.presentationml.template.main+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.viewprops+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.calcchain+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.externallink+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotcachedefinition+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotcacherecords+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.pivottable+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.querytable+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.revisionheaders+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.revisionlog+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedstrings+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": {
      source: "iana",
      compressible: false,
      extensions: ["xlsx"]
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.sheetmetadata+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.tablesinglecells+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.template": {
      source: "iana",
      extensions: ["xltx"]
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.usernames+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.volatiledependencies+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.theme+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.themeoverride+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.vmldrawing": {
      source: "iana"
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.document": {
      source: "iana",
      compressible: false,
      extensions: ["docx"]
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.fonttable+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.template": {
      source: "iana",
      extensions: ["dotx"]
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.websettings+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-package.core-properties+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.openxmlformats-package.relationships+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oracle.resource+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.orange.indata": {
      source: "iana"
    },
    "application/vnd.osa.netdeploy": {
      source: "iana"
    },
    "application/vnd.osgeo.mapguide.package": {
      source: "iana",
      extensions: ["mgp"]
    },
    "application/vnd.osgi.bundle": {
      source: "iana"
    },
    "application/vnd.osgi.dp": {
      source: "iana",
      extensions: ["dp"]
    },
    "application/vnd.osgi.subsystem": {
      source: "iana",
      extensions: ["esa"]
    },
    "application/vnd.otps.ct-kip+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.oxli.countgraph": {
      source: "iana"
    },
    "application/vnd.pagerduty+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.palm": {
      source: "iana",
      extensions: ["pdb", "pqa", "oprc"]
    },
    "application/vnd.panoply": {
      source: "iana"
    },
    "application/vnd.paos.xml": {
      source: "iana"
    },
    "application/vnd.patentdive": {
      source: "iana"
    },
    "application/vnd.patientecommsdoc": {
      source: "iana"
    },
    "application/vnd.pawaafile": {
      source: "iana",
      extensions: ["paw"]
    },
    "application/vnd.pcos": {
      source: "iana"
    },
    "application/vnd.pg.format": {
      source: "iana",
      extensions: ["str"]
    },
    "application/vnd.pg.osasli": {
      source: "iana",
      extensions: ["ei6"]
    },
    "application/vnd.piaccess.application-licence": {
      source: "iana"
    },
    "application/vnd.picsel": {
      source: "iana",
      extensions: ["efif"]
    },
    "application/vnd.pmi.widget": {
      source: "iana",
      extensions: ["wg"]
    },
    "application/vnd.poc.group-advertisement+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.pocketlearn": {
      source: "iana",
      extensions: ["plf"]
    },
    "application/vnd.powerbuilder6": {
      source: "iana",
      extensions: ["pbd"]
    },
    "application/vnd.powerbuilder6-s": {
      source: "iana"
    },
    "application/vnd.powerbuilder7": {
      source: "iana"
    },
    "application/vnd.powerbuilder7-s": {
      source: "iana"
    },
    "application/vnd.powerbuilder75": {
      source: "iana"
    },
    "application/vnd.powerbuilder75-s": {
      source: "iana"
    },
    "application/vnd.preminet": {
      source: "iana"
    },
    "application/vnd.previewsystems.box": {
      source: "iana",
      extensions: ["box"]
    },
    "application/vnd.proteus.magazine": {
      source: "iana",
      extensions: ["mgz"]
    },
    "application/vnd.psfs": {
      source: "iana"
    },
    "application/vnd.publishare-delta-tree": {
      source: "iana",
      extensions: ["qps"]
    },
    "application/vnd.pvi.ptid1": {
      source: "iana",
      extensions: ["ptid"]
    },
    "application/vnd.pwg-multiplexed": {
      source: "iana"
    },
    "application/vnd.pwg-xhtml-print+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.qualcomm.brew-app-res": {
      source: "iana"
    },
    "application/vnd.quarantainenet": {
      source: "iana"
    },
    "application/vnd.quark.quarkxpress": {
      source: "iana",
      extensions: ["qxd", "qxt", "qwd", "qwt", "qxl", "qxb"]
    },
    "application/vnd.quobject-quoxdocument": {
      source: "iana"
    },
    "application/vnd.radisys.moml+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.radisys.msml+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.radisys.msml-audit+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.radisys.msml-audit-conf+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.radisys.msml-audit-conn+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.radisys.msml-audit-dialog+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.radisys.msml-audit-stream+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.radisys.msml-conf+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.radisys.msml-dialog+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.radisys.msml-dialog-base+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.radisys.msml-dialog-fax-detect+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.radisys.msml-dialog-fax-sendrecv+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.radisys.msml-dialog-group+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.radisys.msml-dialog-speech+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.radisys.msml-dialog-transform+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.rainstor.data": {
      source: "iana"
    },
    "application/vnd.rapid": {
      source: "iana"
    },
    "application/vnd.rar": {
      source: "iana",
      extensions: ["rar"]
    },
    "application/vnd.realvnc.bed": {
      source: "iana",
      extensions: ["bed"]
    },
    "application/vnd.recordare.musicxml": {
      source: "iana",
      extensions: ["mxl"]
    },
    "application/vnd.recordare.musicxml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["musicxml"]
    },
    "application/vnd.renlearn.rlprint": {
      source: "iana"
    },
    "application/vnd.resilient.logic": {
      source: "iana"
    },
    "application/vnd.restful+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.rig.cryptonote": {
      source: "iana",
      extensions: ["cryptonote"]
    },
    "application/vnd.rim.cod": {
      source: "apache",
      extensions: ["cod"]
    },
    "application/vnd.rn-realmedia": {
      source: "apache",
      extensions: ["rm"]
    },
    "application/vnd.rn-realmedia-vbr": {
      source: "apache",
      extensions: ["rmvb"]
    },
    "application/vnd.route66.link66+xml": {
      source: "iana",
      compressible: true,
      extensions: ["link66"]
    },
    "application/vnd.rs-274x": {
      source: "iana"
    },
    "application/vnd.ruckus.download": {
      source: "iana"
    },
    "application/vnd.s3sms": {
      source: "iana"
    },
    "application/vnd.sailingtracker.track": {
      source: "iana",
      extensions: ["st"]
    },
    "application/vnd.sar": {
      source: "iana"
    },
    "application/vnd.sbm.cid": {
      source: "iana"
    },
    "application/vnd.sbm.mid2": {
      source: "iana"
    },
    "application/vnd.scribus": {
      source: "iana"
    },
    "application/vnd.sealed.3df": {
      source: "iana"
    },
    "application/vnd.sealed.csf": {
      source: "iana"
    },
    "application/vnd.sealed.doc": {
      source: "iana"
    },
    "application/vnd.sealed.eml": {
      source: "iana"
    },
    "application/vnd.sealed.mht": {
      source: "iana"
    },
    "application/vnd.sealed.net": {
      source: "iana"
    },
    "application/vnd.sealed.ppt": {
      source: "iana"
    },
    "application/vnd.sealed.tiff": {
      source: "iana"
    },
    "application/vnd.sealed.xls": {
      source: "iana"
    },
    "application/vnd.sealedmedia.softseal.html": {
      source: "iana"
    },
    "application/vnd.sealedmedia.softseal.pdf": {
      source: "iana"
    },
    "application/vnd.seemail": {
      source: "iana",
      extensions: ["see"]
    },
    "application/vnd.seis+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.sema": {
      source: "iana",
      extensions: ["sema"]
    },
    "application/vnd.semd": {
      source: "iana",
      extensions: ["semd"]
    },
    "application/vnd.semf": {
      source: "iana",
      extensions: ["semf"]
    },
    "application/vnd.shade-save-file": {
      source: "iana"
    },
    "application/vnd.shana.informed.formdata": {
      source: "iana",
      extensions: ["ifm"]
    },
    "application/vnd.shana.informed.formtemplate": {
      source: "iana",
      extensions: ["itp"]
    },
    "application/vnd.shana.informed.interchange": {
      source: "iana",
      extensions: ["iif"]
    },
    "application/vnd.shana.informed.package": {
      source: "iana",
      extensions: ["ipk"]
    },
    "application/vnd.shootproof+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.shopkick+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.shp": {
      source: "iana"
    },
    "application/vnd.shx": {
      source: "iana"
    },
    "application/vnd.sigrok.session": {
      source: "iana"
    },
    "application/vnd.simtech-mindmapper": {
      source: "iana",
      extensions: ["twd", "twds"]
    },
    "application/vnd.siren+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.smaf": {
      source: "iana",
      extensions: ["mmf"]
    },
    "application/vnd.smart.notebook": {
      source: "iana"
    },
    "application/vnd.smart.teacher": {
      source: "iana",
      extensions: ["teacher"]
    },
    "application/vnd.snesdev-page-table": {
      source: "iana"
    },
    "application/vnd.software602.filler.form+xml": {
      source: "iana",
      compressible: true,
      extensions: ["fo"]
    },
    "application/vnd.software602.filler.form-xml-zip": {
      source: "iana"
    },
    "application/vnd.solent.sdkm+xml": {
      source: "iana",
      compressible: true,
      extensions: ["sdkm", "sdkd"]
    },
    "application/vnd.spotfire.dxp": {
      source: "iana",
      extensions: ["dxp"]
    },
    "application/vnd.spotfire.sfs": {
      source: "iana",
      extensions: ["sfs"]
    },
    "application/vnd.sqlite3": {
      source: "iana"
    },
    "application/vnd.sss-cod": {
      source: "iana"
    },
    "application/vnd.sss-dtf": {
      source: "iana"
    },
    "application/vnd.sss-ntf": {
      source: "iana"
    },
    "application/vnd.stardivision.calc": {
      source: "apache",
      extensions: ["sdc"]
    },
    "application/vnd.stardivision.draw": {
      source: "apache",
      extensions: ["sda"]
    },
    "application/vnd.stardivision.impress": {
      source: "apache",
      extensions: ["sdd"]
    },
    "application/vnd.stardivision.math": {
      source: "apache",
      extensions: ["smf"]
    },
    "application/vnd.stardivision.writer": {
      source: "apache",
      extensions: ["sdw", "vor"]
    },
    "application/vnd.stardivision.writer-global": {
      source: "apache",
      extensions: ["sgl"]
    },
    "application/vnd.stepmania.package": {
      source: "iana",
      extensions: ["smzip"]
    },
    "application/vnd.stepmania.stepchart": {
      source: "iana",
      extensions: ["sm"]
    },
    "application/vnd.street-stream": {
      source: "iana"
    },
    "application/vnd.sun.wadl+xml": {
      source: "iana",
      compressible: true,
      extensions: ["wadl"]
    },
    "application/vnd.sun.xml.calc": {
      source: "apache",
      extensions: ["sxc"]
    },
    "application/vnd.sun.xml.calc.template": {
      source: "apache",
      extensions: ["stc"]
    },
    "application/vnd.sun.xml.draw": {
      source: "apache",
      extensions: ["sxd"]
    },
    "application/vnd.sun.xml.draw.template": {
      source: "apache",
      extensions: ["std"]
    },
    "application/vnd.sun.xml.impress": {
      source: "apache",
      extensions: ["sxi"]
    },
    "application/vnd.sun.xml.impress.template": {
      source: "apache",
      extensions: ["sti"]
    },
    "application/vnd.sun.xml.math": {
      source: "apache",
      extensions: ["sxm"]
    },
    "application/vnd.sun.xml.writer": {
      source: "apache",
      extensions: ["sxw"]
    },
    "application/vnd.sun.xml.writer.global": {
      source: "apache",
      extensions: ["sxg"]
    },
    "application/vnd.sun.xml.writer.template": {
      source: "apache",
      extensions: ["stw"]
    },
    "application/vnd.sus-calendar": {
      source: "iana",
      extensions: ["sus", "susp"]
    },
    "application/vnd.svd": {
      source: "iana",
      extensions: ["svd"]
    },
    "application/vnd.swiftview-ics": {
      source: "iana"
    },
    "application/vnd.sycle+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.syft+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.symbian.install": {
      source: "apache",
      extensions: ["sis", "sisx"]
    },
    "application/vnd.syncml+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true,
      extensions: ["xsm"]
    },
    "application/vnd.syncml.dm+wbxml": {
      source: "iana",
      charset: "UTF-8",
      extensions: ["bdm"]
    },
    "application/vnd.syncml.dm+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true,
      extensions: ["xdm"]
    },
    "application/vnd.syncml.dm.notification": {
      source: "iana"
    },
    "application/vnd.syncml.dmddf+wbxml": {
      source: "iana"
    },
    "application/vnd.syncml.dmddf+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true,
      extensions: ["ddf"]
    },
    "application/vnd.syncml.dmtnds+wbxml": {
      source: "iana"
    },
    "application/vnd.syncml.dmtnds+xml": {
      source: "iana",
      charset: "UTF-8",
      compressible: true
    },
    "application/vnd.syncml.ds.notification": {
      source: "iana"
    },
    "application/vnd.tableschema+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.tao.intent-module-archive": {
      source: "iana",
      extensions: ["tao"]
    },
    "application/vnd.tcpdump.pcap": {
      source: "iana",
      extensions: ["pcap", "cap", "dmp"]
    },
    "application/vnd.think-cell.ppttc+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.tmd.mediaflex.api+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.tml": {
      source: "iana"
    },
    "application/vnd.tmobile-livetv": {
      source: "iana",
      extensions: ["tmo"]
    },
    "application/vnd.tri.onesource": {
      source: "iana"
    },
    "application/vnd.trid.tpt": {
      source: "iana",
      extensions: ["tpt"]
    },
    "application/vnd.triscape.mxs": {
      source: "iana",
      extensions: ["mxs"]
    },
    "application/vnd.trueapp": {
      source: "iana",
      extensions: ["tra"]
    },
    "application/vnd.truedoc": {
      source: "iana"
    },
    "application/vnd.ubisoft.webplayer": {
      source: "iana"
    },
    "application/vnd.ufdl": {
      source: "iana",
      extensions: ["ufd", "ufdl"]
    },
    "application/vnd.uiq.theme": {
      source: "iana",
      extensions: ["utz"]
    },
    "application/vnd.umajin": {
      source: "iana",
      extensions: ["umj"]
    },
    "application/vnd.unity": {
      source: "iana",
      extensions: ["unityweb"]
    },
    "application/vnd.uoml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["uoml"]
    },
    "application/vnd.uplanet.alert": {
      source: "iana"
    },
    "application/vnd.uplanet.alert-wbxml": {
      source: "iana"
    },
    "application/vnd.uplanet.bearer-choice": {
      source: "iana"
    },
    "application/vnd.uplanet.bearer-choice-wbxml": {
      source: "iana"
    },
    "application/vnd.uplanet.cacheop": {
      source: "iana"
    },
    "application/vnd.uplanet.cacheop-wbxml": {
      source: "iana"
    },
    "application/vnd.uplanet.channel": {
      source: "iana"
    },
    "application/vnd.uplanet.channel-wbxml": {
      source: "iana"
    },
    "application/vnd.uplanet.list": {
      source: "iana"
    },
    "application/vnd.uplanet.list-wbxml": {
      source: "iana"
    },
    "application/vnd.uplanet.listcmd": {
      source: "iana"
    },
    "application/vnd.uplanet.listcmd-wbxml": {
      source: "iana"
    },
    "application/vnd.uplanet.signal": {
      source: "iana"
    },
    "application/vnd.uri-map": {
      source: "iana"
    },
    "application/vnd.valve.source.material": {
      source: "iana"
    },
    "application/vnd.vcx": {
      source: "iana",
      extensions: ["vcx"]
    },
    "application/vnd.vd-study": {
      source: "iana"
    },
    "application/vnd.vectorworks": {
      source: "iana"
    },
    "application/vnd.vel+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.verimatrix.vcas": {
      source: "iana"
    },
    "application/vnd.veritone.aion+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.veryant.thin": {
      source: "iana"
    },
    "application/vnd.ves.encrypted": {
      source: "iana"
    },
    "application/vnd.vidsoft.vidconference": {
      source: "iana"
    },
    "application/vnd.visio": {
      source: "iana",
      extensions: ["vsd", "vst", "vss", "vsw"]
    },
    "application/vnd.visionary": {
      source: "iana",
      extensions: ["vis"]
    },
    "application/vnd.vividence.scriptfile": {
      source: "iana"
    },
    "application/vnd.vsf": {
      source: "iana",
      extensions: ["vsf"]
    },
    "application/vnd.wap.sic": {
      source: "iana"
    },
    "application/vnd.wap.slc": {
      source: "iana"
    },
    "application/vnd.wap.wbxml": {
      source: "iana",
      charset: "UTF-8",
      extensions: ["wbxml"]
    },
    "application/vnd.wap.wmlc": {
      source: "iana",
      extensions: ["wmlc"]
    },
    "application/vnd.wap.wmlscriptc": {
      source: "iana",
      extensions: ["wmlsc"]
    },
    "application/vnd.webturbo": {
      source: "iana",
      extensions: ["wtb"]
    },
    "application/vnd.wfa.dpp": {
      source: "iana"
    },
    "application/vnd.wfa.p2p": {
      source: "iana"
    },
    "application/vnd.wfa.wsc": {
      source: "iana"
    },
    "application/vnd.windows.devicepairing": {
      source: "iana"
    },
    "application/vnd.wmc": {
      source: "iana"
    },
    "application/vnd.wmf.bootstrap": {
      source: "iana"
    },
    "application/vnd.wolfram.mathematica": {
      source: "iana"
    },
    "application/vnd.wolfram.mathematica.package": {
      source: "iana"
    },
    "application/vnd.wolfram.player": {
      source: "iana",
      extensions: ["nbp"]
    },
    "application/vnd.wordperfect": {
      source: "iana",
      extensions: ["wpd"]
    },
    "application/vnd.wqd": {
      source: "iana",
      extensions: ["wqd"]
    },
    "application/vnd.wrq-hp3000-labelled": {
      source: "iana"
    },
    "application/vnd.wt.stf": {
      source: "iana",
      extensions: ["stf"]
    },
    "application/vnd.wv.csp+wbxml": {
      source: "iana"
    },
    "application/vnd.wv.csp+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.wv.ssp+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.xacml+json": {
      source: "iana",
      compressible: true
    },
    "application/vnd.xara": {
      source: "iana",
      extensions: ["xar"]
    },
    "application/vnd.xfdl": {
      source: "iana",
      extensions: ["xfdl"]
    },
    "application/vnd.xfdl.webform": {
      source: "iana"
    },
    "application/vnd.xmi+xml": {
      source: "iana",
      compressible: true
    },
    "application/vnd.xmpie.cpkg": {
      source: "iana"
    },
    "application/vnd.xmpie.dpkg": {
      source: "iana"
    },
    "application/vnd.xmpie.plan": {
      source: "iana"
    },
    "application/vnd.xmpie.ppkg": {
      source: "iana"
    },
    "application/vnd.xmpie.xlim": {
      source: "iana"
    },
    "application/vnd.yamaha.hv-dic": {
      source: "iana",
      extensions: ["hvd"]
    },
    "application/vnd.yamaha.hv-script": {
      source: "iana",
      extensions: ["hvs"]
    },
    "application/vnd.yamaha.hv-voice": {
      source: "iana",
      extensions: ["hvp"]
    },
    "application/vnd.yamaha.openscoreformat": {
      source: "iana",
      extensions: ["osf"]
    },
    "application/vnd.yamaha.openscoreformat.osfpvg+xml": {
      source: "iana",
      compressible: true,
      extensions: ["osfpvg"]
    },
    "application/vnd.yamaha.remote-setup": {
      source: "iana"
    },
    "application/vnd.yamaha.smaf-audio": {
      source: "iana",
      extensions: ["saf"]
    },
    "application/vnd.yamaha.smaf-phrase": {
      source: "iana",
      extensions: ["spf"]
    },
    "application/vnd.yamaha.through-ngn": {
      source: "iana"
    },
    "application/vnd.yamaha.tunnel-udpencap": {
      source: "iana"
    },
    "application/vnd.yaoweme": {
      source: "iana"
    },
    "application/vnd.yellowriver-custom-menu": {
      source: "iana",
      extensions: ["cmp"]
    },
    "application/vnd.youtube.yt": {
      source: "iana"
    },
    "application/vnd.zul": {
      source: "iana",
      extensions: ["zir", "zirz"]
    },
    "application/vnd.zzazz.deck+xml": {
      source: "iana",
      compressible: true,
      extensions: ["zaz"]
    },
    "application/voicexml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["vxml"]
    },
    "application/voucher-cms+json": {
      source: "iana",
      compressible: true
    },
    "application/vq-rtcpxr": {
      source: "iana"
    },
    "application/wasm": {
      source: "iana",
      compressible: true,
      extensions: ["wasm"]
    },
    "application/watcherinfo+xml": {
      source: "iana",
      compressible: true,
      extensions: ["wif"]
    },
    "application/webpush-options+json": {
      source: "iana",
      compressible: true
    },
    "application/whoispp-query": {
      source: "iana"
    },
    "application/whoispp-response": {
      source: "iana"
    },
    "application/widget": {
      source: "iana",
      extensions: ["wgt"]
    },
    "application/winhlp": {
      source: "apache",
      extensions: ["hlp"]
    },
    "application/wita": {
      source: "iana"
    },
    "application/wordperfect5.1": {
      source: "iana"
    },
    "application/wsdl+xml": {
      source: "iana",
      compressible: true,
      extensions: ["wsdl"]
    },
    "application/wspolicy+xml": {
      source: "iana",
      compressible: true,
      extensions: ["wspolicy"]
    },
    "application/x-7z-compressed": {
      source: "apache",
      compressible: false,
      extensions: ["7z"]
    },
    "application/x-abiword": {
      source: "apache",
      extensions: ["abw"]
    },
    "application/x-ace-compressed": {
      source: "apache",
      extensions: ["ace"]
    },
    "application/x-amf": {
      source: "apache"
    },
    "application/x-apple-diskimage": {
      source: "apache",
      extensions: ["dmg"]
    },
    "application/x-arj": {
      compressible: false,
      extensions: ["arj"]
    },
    "application/x-authorware-bin": {
      source: "apache",
      extensions: ["aab", "x32", "u32", "vox"]
    },
    "application/x-authorware-map": {
      source: "apache",
      extensions: ["aam"]
    },
    "application/x-authorware-seg": {
      source: "apache",
      extensions: ["aas"]
    },
    "application/x-bcpio": {
      source: "apache",
      extensions: ["bcpio"]
    },
    "application/x-bdoc": {
      compressible: false,
      extensions: ["bdoc"]
    },
    "application/x-bittorrent": {
      source: "apache",
      extensions: ["torrent"]
    },
    "application/x-blorb": {
      source: "apache",
      extensions: ["blb", "blorb"]
    },
    "application/x-bzip": {
      source: "apache",
      compressible: false,
      extensions: ["bz"]
    },
    "application/x-bzip2": {
      source: "apache",
      compressible: false,
      extensions: ["bz2", "boz"]
    },
    "application/x-cbr": {
      source: "apache",
      extensions: ["cbr", "cba", "cbt", "cbz", "cb7"]
    },
    "application/x-cdlink": {
      source: "apache",
      extensions: ["vcd"]
    },
    "application/x-cfs-compressed": {
      source: "apache",
      extensions: ["cfs"]
    },
    "application/x-chat": {
      source: "apache",
      extensions: ["chat"]
    },
    "application/x-chess-pgn": {
      source: "apache",
      extensions: ["pgn"]
    },
    "application/x-chrome-extension": {
      extensions: ["crx"]
    },
    "application/x-cocoa": {
      source: "nginx",
      extensions: ["cco"]
    },
    "application/x-compress": {
      source: "apache"
    },
    "application/x-conference": {
      source: "apache",
      extensions: ["nsc"]
    },
    "application/x-cpio": {
      source: "apache",
      extensions: ["cpio"]
    },
    "application/x-csh": {
      source: "apache",
      extensions: ["csh"]
    },
    "application/x-deb": {
      compressible: false
    },
    "application/x-debian-package": {
      source: "apache",
      extensions: ["deb", "udeb"]
    },
    "application/x-dgc-compressed": {
      source: "apache",
      extensions: ["dgc"]
    },
    "application/x-director": {
      source: "apache",
      extensions: ["dir", "dcr", "dxr", "cst", "cct", "cxt", "w3d", "fgd", "swa"]
    },
    "application/x-doom": {
      source: "apache",
      extensions: ["wad"]
    },
    "application/x-dtbncx+xml": {
      source: "apache",
      compressible: true,
      extensions: ["ncx"]
    },
    "application/x-dtbook+xml": {
      source: "apache",
      compressible: true,
      extensions: ["dtb"]
    },
    "application/x-dtbresource+xml": {
      source: "apache",
      compressible: true,
      extensions: ["res"]
    },
    "application/x-dvi": {
      source: "apache",
      compressible: false,
      extensions: ["dvi"]
    },
    "application/x-envoy": {
      source: "apache",
      extensions: ["evy"]
    },
    "application/x-eva": {
      source: "apache",
      extensions: ["eva"]
    },
    "application/x-font-bdf": {
      source: "apache",
      extensions: ["bdf"]
    },
    "application/x-font-dos": {
      source: "apache"
    },
    "application/x-font-framemaker": {
      source: "apache"
    },
    "application/x-font-ghostscript": {
      source: "apache",
      extensions: ["gsf"]
    },
    "application/x-font-libgrx": {
      source: "apache"
    },
    "application/x-font-linux-psf": {
      source: "apache",
      extensions: ["psf"]
    },
    "application/x-font-pcf": {
      source: "apache",
      extensions: ["pcf"]
    },
    "application/x-font-snf": {
      source: "apache",
      extensions: ["snf"]
    },
    "application/x-font-speedo": {
      source: "apache"
    },
    "application/x-font-sunos-news": {
      source: "apache"
    },
    "application/x-font-type1": {
      source: "apache",
      extensions: ["pfa", "pfb", "pfm", "afm"]
    },
    "application/x-font-vfont": {
      source: "apache"
    },
    "application/x-freearc": {
      source: "apache",
      extensions: ["arc"]
    },
    "application/x-futuresplash": {
      source: "apache",
      extensions: ["spl"]
    },
    "application/x-gca-compressed": {
      source: "apache",
      extensions: ["gca"]
    },
    "application/x-glulx": {
      source: "apache",
      extensions: ["ulx"]
    },
    "application/x-gnumeric": {
      source: "apache",
      extensions: ["gnumeric"]
    },
    "application/x-gramps-xml": {
      source: "apache",
      extensions: ["gramps"]
    },
    "application/x-gtar": {
      source: "apache",
      extensions: ["gtar"]
    },
    "application/x-gzip": {
      source: "apache"
    },
    "application/x-hdf": {
      source: "apache",
      extensions: ["hdf"]
    },
    "application/x-httpd-php": {
      compressible: true,
      extensions: ["php"]
    },
    "application/x-install-instructions": {
      source: "apache",
      extensions: ["install"]
    },
    "application/x-iso9660-image": {
      source: "apache",
      extensions: ["iso"]
    },
    "application/x-iwork-keynote-sffkey": {
      extensions: ["key"]
    },
    "application/x-iwork-numbers-sffnumbers": {
      extensions: ["numbers"]
    },
    "application/x-iwork-pages-sffpages": {
      extensions: ["pages"]
    },
    "application/x-java-archive-diff": {
      source: "nginx",
      extensions: ["jardiff"]
    },
    "application/x-java-jnlp-file": {
      source: "apache",
      compressible: false,
      extensions: ["jnlp"]
    },
    "application/x-javascript": {
      compressible: true
    },
    "application/x-keepass2": {
      extensions: ["kdbx"]
    },
    "application/x-latex": {
      source: "apache",
      compressible: false,
      extensions: ["latex"]
    },
    "application/x-lua-bytecode": {
      extensions: ["luac"]
    },
    "application/x-lzh-compressed": {
      source: "apache",
      extensions: ["lzh", "lha"]
    },
    "application/x-makeself": {
      source: "nginx",
      extensions: ["run"]
    },
    "application/x-mie": {
      source: "apache",
      extensions: ["mie"]
    },
    "application/x-mobipocket-ebook": {
      source: "apache",
      extensions: ["prc", "mobi"]
    },
    "application/x-mpegurl": {
      compressible: false
    },
    "application/x-ms-application": {
      source: "apache",
      extensions: ["application"]
    },
    "application/x-ms-shortcut": {
      source: "apache",
      extensions: ["lnk"]
    },
    "application/x-ms-wmd": {
      source: "apache",
      extensions: ["wmd"]
    },
    "application/x-ms-wmz": {
      source: "apache",
      extensions: ["wmz"]
    },
    "application/x-ms-xbap": {
      source: "apache",
      extensions: ["xbap"]
    },
    "application/x-msaccess": {
      source: "apache",
      extensions: ["mdb"]
    },
    "application/x-msbinder": {
      source: "apache",
      extensions: ["obd"]
    },
    "application/x-mscardfile": {
      source: "apache",
      extensions: ["crd"]
    },
    "application/x-msclip": {
      source: "apache",
      extensions: ["clp"]
    },
    "application/x-msdos-program": {
      extensions: ["exe"]
    },
    "application/x-msdownload": {
      source: "apache",
      extensions: ["exe", "dll", "com", "bat", "msi"]
    },
    "application/x-msmediaview": {
      source: "apache",
      extensions: ["mvb", "m13", "m14"]
    },
    "application/x-msmetafile": {
      source: "apache",
      extensions: ["wmf", "wmz", "emf", "emz"]
    },
    "application/x-msmoney": {
      source: "apache",
      extensions: ["mny"]
    },
    "application/x-mspublisher": {
      source: "apache",
      extensions: ["pub"]
    },
    "application/x-msschedule": {
      source: "apache",
      extensions: ["scd"]
    },
    "application/x-msterminal": {
      source: "apache",
      extensions: ["trm"]
    },
    "application/x-mswrite": {
      source: "apache",
      extensions: ["wri"]
    },
    "application/x-netcdf": {
      source: "apache",
      extensions: ["nc", "cdf"]
    },
    "application/x-ns-proxy-autoconfig": {
      compressible: true,
      extensions: ["pac"]
    },
    "application/x-nzb": {
      source: "apache",
      extensions: ["nzb"]
    },
    "application/x-perl": {
      source: "nginx",
      extensions: ["pl", "pm"]
    },
    "application/x-pilot": {
      source: "nginx",
      extensions: ["prc", "pdb"]
    },
    "application/x-pkcs12": {
      source: "apache",
      compressible: false,
      extensions: ["p12", "pfx"]
    },
    "application/x-pkcs7-certificates": {
      source: "apache",
      extensions: ["p7b", "spc"]
    },
    "application/x-pkcs7-certreqresp": {
      source: "apache",
      extensions: ["p7r"]
    },
    "application/x-pki-message": {
      source: "iana"
    },
    "application/x-rar-compressed": {
      source: "apache",
      compressible: false,
      extensions: ["rar"]
    },
    "application/x-redhat-package-manager": {
      source: "nginx",
      extensions: ["rpm"]
    },
    "application/x-research-info-systems": {
      source: "apache",
      extensions: ["ris"]
    },
    "application/x-sea": {
      source: "nginx",
      extensions: ["sea"]
    },
    "application/x-sh": {
      source: "apache",
      compressible: true,
      extensions: ["sh"]
    },
    "application/x-shar": {
      source: "apache",
      extensions: ["shar"]
    },
    "application/x-shockwave-flash": {
      source: "apache",
      compressible: false,
      extensions: ["swf"]
    },
    "application/x-silverlight-app": {
      source: "apache",
      extensions: ["xap"]
    },
    "application/x-sql": {
      source: "apache",
      extensions: ["sql"]
    },
    "application/x-stuffit": {
      source: "apache",
      compressible: false,
      extensions: ["sit"]
    },
    "application/x-stuffitx": {
      source: "apache",
      extensions: ["sitx"]
    },
    "application/x-subrip": {
      source: "apache",
      extensions: ["srt"]
    },
    "application/x-sv4cpio": {
      source: "apache",
      extensions: ["sv4cpio"]
    },
    "application/x-sv4crc": {
      source: "apache",
      extensions: ["sv4crc"]
    },
    "application/x-t3vm-image": {
      source: "apache",
      extensions: ["t3"]
    },
    "application/x-tads": {
      source: "apache",
      extensions: ["gam"]
    },
    "application/x-tar": {
      source: "apache",
      compressible: true,
      extensions: ["tar"]
    },
    "application/x-tcl": {
      source: "apache",
      extensions: ["tcl", "tk"]
    },
    "application/x-tex": {
      source: "apache",
      extensions: ["tex"]
    },
    "application/x-tex-tfm": {
      source: "apache",
      extensions: ["tfm"]
    },
    "application/x-texinfo": {
      source: "apache",
      extensions: ["texinfo", "texi"]
    },
    "application/x-tgif": {
      source: "apache",
      extensions: ["obj"]
    },
    "application/x-ustar": {
      source: "apache",
      extensions: ["ustar"]
    },
    "application/x-virtualbox-hdd": {
      compressible: true,
      extensions: ["hdd"]
    },
    "application/x-virtualbox-ova": {
      compressible: true,
      extensions: ["ova"]
    },
    "application/x-virtualbox-ovf": {
      compressible: true,
      extensions: ["ovf"]
    },
    "application/x-virtualbox-vbox": {
      compressible: true,
      extensions: ["vbox"]
    },
    "application/x-virtualbox-vbox-extpack": {
      compressible: false,
      extensions: ["vbox-extpack"]
    },
    "application/x-virtualbox-vdi": {
      compressible: true,
      extensions: ["vdi"]
    },
    "application/x-virtualbox-vhd": {
      compressible: true,
      extensions: ["vhd"]
    },
    "application/x-virtualbox-vmdk": {
      compressible: true,
      extensions: ["vmdk"]
    },
    "application/x-wais-source": {
      source: "apache",
      extensions: ["src"]
    },
    "application/x-web-app-manifest+json": {
      compressible: true,
      extensions: ["webapp"]
    },
    "application/x-www-form-urlencoded": {
      source: "iana",
      compressible: true
    },
    "application/x-x509-ca-cert": {
      source: "iana",
      extensions: ["der", "crt", "pem"]
    },
    "application/x-x509-ca-ra-cert": {
      source: "iana"
    },
    "application/x-x509-next-ca-cert": {
      source: "iana"
    },
    "application/x-xfig": {
      source: "apache",
      extensions: ["fig"]
    },
    "application/x-xliff+xml": {
      source: "apache",
      compressible: true,
      extensions: ["xlf"]
    },
    "application/x-xpinstall": {
      source: "apache",
      compressible: false,
      extensions: ["xpi"]
    },
    "application/x-xz": {
      source: "apache",
      extensions: ["xz"]
    },
    "application/x-zmachine": {
      source: "apache",
      extensions: ["z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8"]
    },
    "application/x400-bp": {
      source: "iana"
    },
    "application/xacml+xml": {
      source: "iana",
      compressible: true
    },
    "application/xaml+xml": {
      source: "apache",
      compressible: true,
      extensions: ["xaml"]
    },
    "application/xcap-att+xml": {
      source: "iana",
      compressible: true,
      extensions: ["xav"]
    },
    "application/xcap-caps+xml": {
      source: "iana",
      compressible: true,
      extensions: ["xca"]
    },
    "application/xcap-diff+xml": {
      source: "iana",
      compressible: true,
      extensions: ["xdf"]
    },
    "application/xcap-el+xml": {
      source: "iana",
      compressible: true,
      extensions: ["xel"]
    },
    "application/xcap-error+xml": {
      source: "iana",
      compressible: true
    },
    "application/xcap-ns+xml": {
      source: "iana",
      compressible: true,
      extensions: ["xns"]
    },
    "application/xcon-conference-info+xml": {
      source: "iana",
      compressible: true
    },
    "application/xcon-conference-info-diff+xml": {
      source: "iana",
      compressible: true
    },
    "application/xenc+xml": {
      source: "iana",
      compressible: true,
      extensions: ["xenc"]
    },
    "application/xhtml+xml": {
      source: "iana",
      compressible: true,
      extensions: ["xhtml", "xht"]
    },
    "application/xhtml-voice+xml": {
      source: "apache",
      compressible: true
    },
    "application/xliff+xml": {
      source: "iana",
      compressible: true,
      extensions: ["xlf"]
    },
    "application/xml": {
      source: "iana",
      compressible: true,
      extensions: ["xml", "xsl", "xsd", "rng"]
    },
    "application/xml-dtd": {
      source: "iana",
      compressible: true,
      extensions: ["dtd"]
    },
    "application/xml-external-parsed-entity": {
      source: "iana"
    },
    "application/xml-patch+xml": {
      source: "iana",
      compressible: true
    },
    "application/xmpp+xml": {
      source: "iana",
      compressible: true
    },
    "application/xop+xml": {
      source: "iana",
      compressible: true,
      extensions: ["xop"]
    },
    "application/xproc+xml": {
      source: "apache",
      compressible: true,
      extensions: ["xpl"]
    },
    "application/xslt+xml": {
      source: "iana",
      compressible: true,
      extensions: ["xsl", "xslt"]
    },
    "application/xspf+xml": {
      source: "apache",
      compressible: true,
      extensions: ["xspf"]
    },
    "application/xv+xml": {
      source: "iana",
      compressible: true,
      extensions: ["mxml", "xhvml", "xvml", "xvm"]
    },
    "application/yang": {
      source: "iana",
      extensions: ["yang"]
    },
    "application/yang-data+json": {
      source: "iana",
      compressible: true
    },
    "application/yang-data+xml": {
      source: "iana",
      compressible: true
    },
    "application/yang-patch+json": {
      source: "iana",
      compressible: true
    },
    "application/yang-patch+xml": {
      source: "iana",
      compressible: true
    },
    "application/yin+xml": {
      source: "iana",
      compressible: true,
      extensions: ["yin"]
    },
    "application/zip": {
      source: "iana",
      compressible: false,
      extensions: ["zip"]
    },
    "application/zlib": {
      source: "iana"
    },
    "application/zstd": {
      source: "iana"
    },
    "audio/1d-interleaved-parityfec": {
      source: "iana"
    },
    "audio/32kadpcm": {
      source: "iana"
    },
    "audio/3gpp": {
      source: "iana",
      compressible: false,
      extensions: ["3gpp"]
    },
    "audio/3gpp2": {
      source: "iana"
    },
    "audio/aac": {
      source: "iana"
    },
    "audio/ac3": {
      source: "iana"
    },
    "audio/adpcm": {
      source: "apache",
      extensions: ["adp"]
    },
    "audio/amr": {
      source: "iana",
      extensions: ["amr"]
    },
    "audio/amr-wb": {
      source: "iana"
    },
    "audio/amr-wb+": {
      source: "iana"
    },
    "audio/aptx": {
      source: "iana"
    },
    "audio/asc": {
      source: "iana"
    },
    "audio/atrac-advanced-lossless": {
      source: "iana"
    },
    "audio/atrac-x": {
      source: "iana"
    },
    "audio/atrac3": {
      source: "iana"
    },
    "audio/basic": {
      source: "iana",
      compressible: false,
      extensions: ["au", "snd"]
    },
    "audio/bv16": {
      source: "iana"
    },
    "audio/bv32": {
      source: "iana"
    },
    "audio/clearmode": {
      source: "iana"
    },
    "audio/cn": {
      source: "iana"
    },
    "audio/dat12": {
      source: "iana"
    },
    "audio/dls": {
      source: "iana"
    },
    "audio/dsr-es201108": {
      source: "iana"
    },
    "audio/dsr-es202050": {
      source: "iana"
    },
    "audio/dsr-es202211": {
      source: "iana"
    },
    "audio/dsr-es202212": {
      source: "iana"
    },
    "audio/dv": {
      source: "iana"
    },
    "audio/dvi4": {
      source: "iana"
    },
    "audio/eac3": {
      source: "iana"
    },
    "audio/encaprtp": {
      source: "iana"
    },
    "audio/evrc": {
      source: "iana"
    },
    "audio/evrc-qcp": {
      source: "iana"
    },
    "audio/evrc0": {
      source: "iana"
    },
    "audio/evrc1": {
      source: "iana"
    },
    "audio/evrcb": {
      source: "iana"
    },
    "audio/evrcb0": {
      source: "iana"
    },
    "audio/evrcb1": {
      source: "iana"
    },
    "audio/evrcnw": {
      source: "iana"
    },
    "audio/evrcnw0": {
      source: "iana"
    },
    "audio/evrcnw1": {
      source: "iana"
    },
    "audio/evrcwb": {
      source: "iana"
    },
    "audio/evrcwb0": {
      source: "iana"
    },
    "audio/evrcwb1": {
      source: "iana"
    },
    "audio/evs": {
      source: "iana"
    },
    "audio/flexfec": {
      source: "iana"
    },
    "audio/fwdred": {
      source: "iana"
    },
    "audio/g711-0": {
      source: "iana"
    },
    "audio/g719": {
      source: "iana"
    },
    "audio/g722": {
      source: "iana"
    },
    "audio/g7221": {
      source: "iana"
    },
    "audio/g723": {
      source: "iana"
    },
    "audio/g726-16": {
      source: "iana"
    },
    "audio/g726-24": {
      source: "iana"
    },
    "audio/g726-32": {
      source: "iana"
    },
    "audio/g726-40": {
      source: "iana"
    },
    "audio/g728": {
      source: "iana"
    },
    "audio/g729": {
      source: "iana"
    },
    "audio/g7291": {
      source: "iana"
    },
    "audio/g729d": {
      source: "iana"
    },
    "audio/g729e": {
      source: "iana"
    },
    "audio/gsm": {
      source: "iana"
    },
    "audio/gsm-efr": {
      source: "iana"
    },
    "audio/gsm-hr-08": {
      source: "iana"
    },
    "audio/ilbc": {
      source: "iana"
    },
    "audio/ip-mr_v2.5": {
      source: "iana"
    },
    "audio/isac": {
      source: "apache"
    },
    "audio/l16": {
      source: "iana"
    },
    "audio/l20": {
      source: "iana"
    },
    "audio/l24": {
      source: "iana",
      compressible: false
    },
    "audio/l8": {
      source: "iana"
    },
    "audio/lpc": {
      source: "iana"
    },
    "audio/melp": {
      source: "iana"
    },
    "audio/melp1200": {
      source: "iana"
    },
    "audio/melp2400": {
      source: "iana"
    },
    "audio/melp600": {
      source: "iana"
    },
    "audio/mhas": {
      source: "iana"
    },
    "audio/midi": {
      source: "apache",
      extensions: ["mid", "midi", "kar", "rmi"]
    },
    "audio/mobile-xmf": {
      source: "iana",
      extensions: ["mxmf"]
    },
    "audio/mp3": {
      compressible: false,
      extensions: ["mp3"]
    },
    "audio/mp4": {
      source: "iana",
      compressible: false,
      extensions: ["m4a", "mp4a"]
    },
    "audio/mp4a-latm": {
      source: "iana"
    },
    "audio/mpa": {
      source: "iana"
    },
    "audio/mpa-robust": {
      source: "iana"
    },
    "audio/mpeg": {
      source: "iana",
      compressible: false,
      extensions: ["mpga", "mp2", "mp2a", "mp3", "m2a", "m3a"]
    },
    "audio/mpeg4-generic": {
      source: "iana"
    },
    "audio/musepack": {
      source: "apache"
    },
    "audio/ogg": {
      source: "iana",
      compressible: false,
      extensions: ["oga", "ogg", "spx", "opus"]
    },
    "audio/opus": {
      source: "iana"
    },
    "audio/parityfec": {
      source: "iana"
    },
    "audio/pcma": {
      source: "iana"
    },
    "audio/pcma-wb": {
      source: "iana"
    },
    "audio/pcmu": {
      source: "iana"
    },
    "audio/pcmu-wb": {
      source: "iana"
    },
    "audio/prs.sid": {
      source: "iana"
    },
    "audio/qcelp": {
      source: "iana"
    },
    "audio/raptorfec": {
      source: "iana"
    },
    "audio/red": {
      source: "iana"
    },
    "audio/rtp-enc-aescm128": {
      source: "iana"
    },
    "audio/rtp-midi": {
      source: "iana"
    },
    "audio/rtploopback": {
      source: "iana"
    },
    "audio/rtx": {
      source: "iana"
    },
    "audio/s3m": {
      source: "apache",
      extensions: ["s3m"]
    },
    "audio/scip": {
      source: "iana"
    },
    "audio/silk": {
      source: "apache",
      extensions: ["sil"]
    },
    "audio/smv": {
      source: "iana"
    },
    "audio/smv-qcp": {
      source: "iana"
    },
    "audio/smv0": {
      source: "iana"
    },
    "audio/sofa": {
      source: "iana"
    },
    "audio/sp-midi": {
      source: "iana"
    },
    "audio/speex": {
      source: "iana"
    },
    "audio/t140c": {
      source: "iana"
    },
    "audio/t38": {
      source: "iana"
    },
    "audio/telephone-event": {
      source: "iana"
    },
    "audio/tetra_acelp": {
      source: "iana"
    },
    "audio/tetra_acelp_bb": {
      source: "iana"
    },
    "audio/tone": {
      source: "iana"
    },
    "audio/tsvcis": {
      source: "iana"
    },
    "audio/uemclip": {
      source: "iana"
    },
    "audio/ulpfec": {
      source: "iana"
    },
    "audio/usac": {
      source: "iana"
    },
    "audio/vdvi": {
      source: "iana"
    },
    "audio/vmr-wb": {
      source: "iana"
    },
    "audio/vnd.3gpp.iufp": {
      source: "iana"
    },
    "audio/vnd.4sb": {
      source: "iana"
    },
    "audio/vnd.audiokoz": {
      source: "iana"
    },
    "audio/vnd.celp": {
      source: "iana"
    },
    "audio/vnd.cisco.nse": {
      source: "iana"
    },
    "audio/vnd.cmles.radio-events": {
      source: "iana"
    },
    "audio/vnd.cns.anp1": {
      source: "iana"
    },
    "audio/vnd.cns.inf1": {
      source: "iana"
    },
    "audio/vnd.dece.audio": {
      source: "iana",
      extensions: ["uva", "uvva"]
    },
    "audio/vnd.digital-winds": {
      source: "iana",
      extensions: ["eol"]
    },
    "audio/vnd.dlna.adts": {
      source: "iana"
    },
    "audio/vnd.dolby.heaac.1": {
      source: "iana"
    },
    "audio/vnd.dolby.heaac.2": {
      source: "iana"
    },
    "audio/vnd.dolby.mlp": {
      source: "iana"
    },
    "audio/vnd.dolby.mps": {
      source: "iana"
    },
    "audio/vnd.dolby.pl2": {
      source: "iana"
    },
    "audio/vnd.dolby.pl2x": {
      source: "iana"
    },
    "audio/vnd.dolby.pl2z": {
      source: "iana"
    },
    "audio/vnd.dolby.pulse.1": {
      source: "iana"
    },
    "audio/vnd.dra": {
      source: "iana",
      extensions: ["dra"]
    },
    "audio/vnd.dts": {
      source: "iana",
      extensions: ["dts"]
    },
    "audio/vnd.dts.hd": {
      source: "iana",
      extensions: ["dtshd"]
    },
    "audio/vnd.dts.uhd": {
      source: "iana"
    },
    "audio/vnd.dvb.file": {
      source: "iana"
    },
    "audio/vnd.everad.plj": {
      source: "iana"
    },
    "audio/vnd.hns.audio": {
      source: "iana"
    },
    "audio/vnd.lucent.voice": {
      source: "iana",
      extensions: ["lvp"]
    },
    "audio/vnd.ms-playready.media.pya": {
      source: "iana",
      extensions: ["pya"]
    },
    "audio/vnd.nokia.mobile-xmf": {
      source: "iana"
    },
    "audio/vnd.nortel.vbk": {
      source: "iana"
    },
    "audio/vnd.nuera.ecelp4800": {
      source: "iana",
      extensions: ["ecelp4800"]
    },
    "audio/vnd.nuera.ecelp7470": {
      source: "iana",
      extensions: ["ecelp7470"]
    },
    "audio/vnd.nuera.ecelp9600": {
      source: "iana",
      extensions: ["ecelp9600"]
    },
    "audio/vnd.octel.sbc": {
      source: "iana"
    },
    "audio/vnd.presonus.multitrack": {
      source: "iana"
    },
    "audio/vnd.qcelp": {
      source: "iana"
    },
    "audio/vnd.rhetorex.32kadpcm": {
      source: "iana"
    },
    "audio/vnd.rip": {
      source: "iana",
      extensions: ["rip"]
    },
    "audio/vnd.rn-realaudio": {
      compressible: false
    },
    "audio/vnd.sealedmedia.softseal.mpeg": {
      source: "iana"
    },
    "audio/vnd.vmx.cvsd": {
      source: "iana"
    },
    "audio/vnd.wave": {
      compressible: false
    },
    "audio/vorbis": {
      source: "iana",
      compressible: false
    },
    "audio/vorbis-config": {
      source: "iana"
    },
    "audio/wav": {
      compressible: false,
      extensions: ["wav"]
    },
    "audio/wave": {
      compressible: false,
      extensions: ["wav"]
    },
    "audio/webm": {
      source: "apache",
      compressible: false,
      extensions: ["weba"]
    },
    "audio/x-aac": {
      source: "apache",
      compressible: false,
      extensions: ["aac"]
    },
    "audio/x-aiff": {
      source: "apache",
      extensions: ["aif", "aiff", "aifc"]
    },
    "audio/x-caf": {
      source: "apache",
      compressible: false,
      extensions: ["caf"]
    },
    "audio/x-flac": {
      source: "apache",
      extensions: ["flac"]
    },
    "audio/x-m4a": {
      source: "nginx",
      extensions: ["m4a"]
    },
    "audio/x-matroska": {
      source: "apache",
      extensions: ["mka"]
    },
    "audio/x-mpegurl": {
      source: "apache",
      extensions: ["m3u"]
    },
    "audio/x-ms-wax": {
      source: "apache",
      extensions: ["wax"]
    },
    "audio/x-ms-wma": {
      source: "apache",
      extensions: ["wma"]
    },
    "audio/x-pn-realaudio": {
      source: "apache",
      extensions: ["ram", "ra"]
    },
    "audio/x-pn-realaudio-plugin": {
      source: "apache",
      extensions: ["rmp"]
    },
    "audio/x-realaudio": {
      source: "nginx",
      extensions: ["ra"]
    },
    "audio/x-tta": {
      source: "apache"
    },
    "audio/x-wav": {
      source: "apache",
      extensions: ["wav"]
    },
    "audio/xm": {
      source: "apache",
      extensions: ["xm"]
    },
    "chemical/x-cdx": {
      source: "apache",
      extensions: ["cdx"]
    },
    "chemical/x-cif": {
      source: "apache",
      extensions: ["cif"]
    },
    "chemical/x-cmdf": {
      source: "apache",
      extensions: ["cmdf"]
    },
    "chemical/x-cml": {
      source: "apache",
      extensions: ["cml"]
    },
    "chemical/x-csml": {
      source: "apache",
      extensions: ["csml"]
    },
    "chemical/x-pdb": {
      source: "apache"
    },
    "chemical/x-xyz": {
      source: "apache",
      extensions: ["xyz"]
    },
    "font/collection": {
      source: "iana",
      extensions: ["ttc"]
    },
    "font/otf": {
      source: "iana",
      compressible: true,
      extensions: ["otf"]
    },
    "font/sfnt": {
      source: "iana"
    },
    "font/ttf": {
      source: "iana",
      compressible: true,
      extensions: ["ttf"]
    },
    "font/woff": {
      source: "iana",
      extensions: ["woff"]
    },
    "font/woff2": {
      source: "iana",
      extensions: ["woff2"]
    },
    "image/aces": {
      source: "iana",
      extensions: ["exr"]
    },
    "image/apng": {
      compressible: false,
      extensions: ["apng"]
    },
    "image/avci": {
      source: "iana",
      extensions: ["avci"]
    },
    "image/avcs": {
      source: "iana",
      extensions: ["avcs"]
    },
    "image/avif": {
      source: "iana",
      compressible: false,
      extensions: ["avif"]
    },
    "image/bmp": {
      source: "iana",
      compressible: true,
      extensions: ["bmp"]
    },
    "image/cgm": {
      source: "iana",
      extensions: ["cgm"]
    },
    "image/dicom-rle": {
      source: "iana",
      extensions: ["drle"]
    },
    "image/emf": {
      source: "iana",
      extensions: ["emf"]
    },
    "image/fits": {
      source: "iana",
      extensions: ["fits"]
    },
    "image/g3fax": {
      source: "iana",
      extensions: ["g3"]
    },
    "image/gif": {
      source: "iana",
      compressible: false,
      extensions: ["gif"]
    },
    "image/heic": {
      source: "iana",
      extensions: ["heic"]
    },
    "image/heic-sequence": {
      source: "iana",
      extensions: ["heics"]
    },
    "image/heif": {
      source: "iana",
      extensions: ["heif"]
    },
    "image/heif-sequence": {
      source: "iana",
      extensions: ["heifs"]
    },
    "image/hej2k": {
      source: "iana",
      extensions: ["hej2"]
    },
    "image/hsj2": {
      source: "iana",
      extensions: ["hsj2"]
    },
    "image/ief": {
      source: "iana",
      extensions: ["ief"]
    },
    "image/jls": {
      source: "iana",
      extensions: ["jls"]
    },
    "image/jp2": {
      source: "iana",
      compressible: false,
      extensions: ["jp2", "jpg2"]
    },
    "image/jpeg": {
      source: "iana",
      compressible: false,
      extensions: ["jpeg", "jpg", "jpe"]
    },
    "image/jph": {
      source: "iana",
      extensions: ["jph"]
    },
    "image/jphc": {
      source: "iana",
      extensions: ["jhc"]
    },
    "image/jpm": {
      source: "iana",
      compressible: false,
      extensions: ["jpm"]
    },
    "image/jpx": {
      source: "iana",
      compressible: false,
      extensions: ["jpx", "jpf"]
    },
    "image/jxr": {
      source: "iana",
      extensions: ["jxr"]
    },
    "image/jxra": {
      source: "iana",
      extensions: ["jxra"]
    },
    "image/jxrs": {
      source: "iana",
      extensions: ["jxrs"]
    },
    "image/jxs": {
      source: "iana",
      extensions: ["jxs"]
    },
    "image/jxsc": {
      source: "iana",
      extensions: ["jxsc"]
    },
    "image/jxsi": {
      source: "iana",
      extensions: ["jxsi"]
    },
    "image/jxss": {
      source: "iana",
      extensions: ["jxss"]
    },
    "image/ktx": {
      source: "iana",
      extensions: ["ktx"]
    },
    "image/ktx2": {
      source: "iana",
      extensions: ["ktx2"]
    },
    "image/naplps": {
      source: "iana"
    },
    "image/pjpeg": {
      compressible: false
    },
    "image/png": {
      source: "iana",
      compressible: false,
      extensions: ["png"]
    },
    "image/prs.btif": {
      source: "iana",
      extensions: ["btif"]
    },
    "image/prs.pti": {
      source: "iana",
      extensions: ["pti"]
    },
    "image/pwg-raster": {
      source: "iana"
    },
    "image/sgi": {
      source: "apache",
      extensions: ["sgi"]
    },
    "image/svg+xml": {
      source: "iana",
      compressible: true,
      extensions: ["svg", "svgz"]
    },
    "image/t38": {
      source: "iana",
      extensions: ["t38"]
    },
    "image/tiff": {
      source: "iana",
      compressible: false,
      extensions: ["tif", "tiff"]
    },
    "image/tiff-fx": {
      source: "iana",
      extensions: ["tfx"]
    },
    "image/vnd.adobe.photoshop": {
      source: "iana",
      compressible: true,
      extensions: ["psd"]
    },
    "image/vnd.airzip.accelerator.azv": {
      source: "iana",
      extensions: ["azv"]
    },
    "image/vnd.cns.inf2": {
      source: "iana"
    },
    "image/vnd.dece.graphic": {
      source: "iana",
      extensions: ["uvi", "uvvi", "uvg", "uvvg"]
    },
    "image/vnd.djvu": {
      source: "iana",
      extensions: ["djvu", "djv"]
    },
    "image/vnd.dvb.subtitle": {
      source: "iana",
      extensions: ["sub"]
    },
    "image/vnd.dwg": {
      source: "iana",
      extensions: ["dwg"]
    },
    "image/vnd.dxf": {
      source: "iana",
      extensions: ["dxf"]
    },
    "image/vnd.fastbidsheet": {
      source: "iana",
      extensions: ["fbs"]
    },
    "image/vnd.fpx": {
      source: "iana",
      extensions: ["fpx"]
    },
    "image/vnd.fst": {
      source: "iana",
      extensions: ["fst"]
    },
    "image/vnd.fujixerox.edmics-mmr": {
      source: "iana",
      extensions: ["mmr"]
    },
    "image/vnd.fujixerox.edmics-rlc": {
      source: "iana",
      extensions: ["rlc"]
    },
    "image/vnd.globalgraphics.pgb": {
      source: "iana"
    },
    "image/vnd.microsoft.icon": {
      source: "iana",
      compressible: true,
      extensions: ["ico"]
    },
    "image/vnd.mix": {
      source: "iana"
    },
    "image/vnd.mozilla.apng": {
      source: "iana"
    },
    "image/vnd.ms-dds": {
      compressible: true,
      extensions: ["dds"]
    },
    "image/vnd.ms-modi": {
      source: "iana",
      extensions: ["mdi"]
    },
    "image/vnd.ms-photo": {
      source: "apache",
      extensions: ["wdp"]
    },
    "image/vnd.net-fpx": {
      source: "iana",
      extensions: ["npx"]
    },
    "image/vnd.pco.b16": {
      source: "iana",
      extensions: ["b16"]
    },
    "image/vnd.radiance": {
      source: "iana"
    },
    "image/vnd.sealed.png": {
      source: "iana"
    },
    "image/vnd.sealedmedia.softseal.gif": {
      source: "iana"
    },
    "image/vnd.sealedmedia.softseal.jpg": {
      source: "iana"
    },
    "image/vnd.svf": {
      source: "iana"
    },
    "image/vnd.tencent.tap": {
      source: "iana",
      extensions: ["tap"]
    },
    "image/vnd.valve.source.texture": {
      source: "iana",
      extensions: ["vtf"]
    },
    "image/vnd.wap.wbmp": {
      source: "iana",
      extensions: ["wbmp"]
    },
    "image/vnd.xiff": {
      source: "iana",
      extensions: ["xif"]
    },
    "image/vnd.zbrush.pcx": {
      source: "iana",
      extensions: ["pcx"]
    },
    "image/webp": {
      source: "apache",
      extensions: ["webp"]
    },
    "image/wmf": {
      source: "iana",
      extensions: ["wmf"]
    },
    "image/x-3ds": {
      source: "apache",
      extensions: ["3ds"]
    },
    "image/x-cmu-raster": {
      source: "apache",
      extensions: ["ras"]
    },
    "image/x-cmx": {
      source: "apache",
      extensions: ["cmx"]
    },
    "image/x-freehand": {
      source: "apache",
      extensions: ["fh", "fhc", "fh4", "fh5", "fh7"]
    },
    "image/x-icon": {
      source: "apache",
      compressible: true,
      extensions: ["ico"]
    },
    "image/x-jng": {
      source: "nginx",
      extensions: ["jng"]
    },
    "image/x-mrsid-image": {
      source: "apache",
      extensions: ["sid"]
    },
    "image/x-ms-bmp": {
      source: "nginx",
      compressible: true,
      extensions: ["bmp"]
    },
    "image/x-pcx": {
      source: "apache",
      extensions: ["pcx"]
    },
    "image/x-pict": {
      source: "apache",
      extensions: ["pic", "pct"]
    },
    "image/x-portable-anymap": {
      source: "apache",
      extensions: ["pnm"]
    },
    "image/x-portable-bitmap": {
      source: "apache",
      extensions: ["pbm"]
    },
    "image/x-portable-graymap": {
      source: "apache",
      extensions: ["pgm"]
    },
    "image/x-portable-pixmap": {
      source: "apache",
      extensions: ["ppm"]
    },
    "image/x-rgb": {
      source: "apache",
      extensions: ["rgb"]
    },
    "image/x-tga": {
      source: "apache",
      extensions: ["tga"]
    },
    "image/x-xbitmap": {
      source: "apache",
      extensions: ["xbm"]
    },
    "image/x-xcf": {
      compressible: false
    },
    "image/x-xpixmap": {
      source: "apache",
      extensions: ["xpm"]
    },
    "image/x-xwindowdump": {
      source: "apache",
      extensions: ["xwd"]
    },
    "message/cpim": {
      source: "iana"
    },
    "message/delivery-status": {
      source: "iana"
    },
    "message/disposition-notification": {
      source: "iana",
      extensions: [
        "disposition-notification"
      ]
    },
    "message/external-body": {
      source: "iana"
    },
    "message/feedback-report": {
      source: "iana"
    },
    "message/global": {
      source: "iana",
      extensions: ["u8msg"]
    },
    "message/global-delivery-status": {
      source: "iana",
      extensions: ["u8dsn"]
    },
    "message/global-disposition-notification": {
      source: "iana",
      extensions: ["u8mdn"]
    },
    "message/global-headers": {
      source: "iana",
      extensions: ["u8hdr"]
    },
    "message/http": {
      source: "iana",
      compressible: false
    },
    "message/imdn+xml": {
      source: "iana",
      compressible: true
    },
    "message/news": {
      source: "iana"
    },
    "message/partial": {
      source: "iana",
      compressible: false
    },
    "message/rfc822": {
      source: "iana",
      compressible: true,
      extensions: ["eml", "mime"]
    },
    "message/s-http": {
      source: "iana"
    },
    "message/sip": {
      source: "iana"
    },
    "message/sipfrag": {
      source: "iana"
    },
    "message/tracking-status": {
      source: "iana"
    },
    "message/vnd.si.simp": {
      source: "iana"
    },
    "message/vnd.wfa.wsc": {
      source: "iana",
      extensions: ["wsc"]
    },
    "model/3mf": {
      source: "iana",
      extensions: ["3mf"]
    },
    "model/e57": {
      source: "iana"
    },
    "model/gltf+json": {
      source: "iana",
      compressible: true,
      extensions: ["gltf"]
    },
    "model/gltf-binary": {
      source: "iana",
      compressible: true,
      extensions: ["glb"]
    },
    "model/iges": {
      source: "iana",
      compressible: false,
      extensions: ["igs", "iges"]
    },
    "model/mesh": {
      source: "iana",
      compressible: false,
      extensions: ["msh", "mesh", "silo"]
    },
    "model/mtl": {
      source: "iana",
      extensions: ["mtl"]
    },
    "model/obj": {
      source: "iana",
      extensions: ["obj"]
    },
    "model/step": {
      source: "iana"
    },
    "model/step+xml": {
      source: "iana",
      compressible: true,
      extensions: ["stpx"]
    },
    "model/step+zip": {
      source: "iana",
      compressible: false,
      extensions: ["stpz"]
    },
    "model/step-xml+zip": {
      source: "iana",
      compressible: false,
      extensions: ["stpxz"]
    },
    "model/stl": {
      source: "iana",
      extensions: ["stl"]
    },
    "model/vnd.collada+xml": {
      source: "iana",
      compressible: true,
      extensions: ["dae"]
    },
    "model/vnd.dwf": {
      source: "iana",
      extensions: ["dwf"]
    },
    "model/vnd.flatland.3dml": {
      source: "iana"
    },
    "model/vnd.gdl": {
      source: "iana",
      extensions: ["gdl"]
    },
    "model/vnd.gs-gdl": {
      source: "apache"
    },
    "model/vnd.gs.gdl": {
      source: "iana"
    },
    "model/vnd.gtw": {
      source: "iana",
      extensions: ["gtw"]
    },
    "model/vnd.moml+xml": {
      source: "iana",
      compressible: true
    },
    "model/vnd.mts": {
      source: "iana",
      extensions: ["mts"]
    },
    "model/vnd.opengex": {
      source: "iana",
      extensions: ["ogex"]
    },
    "model/vnd.parasolid.transmit.binary": {
      source: "iana",
      extensions: ["x_b"]
    },
    "model/vnd.parasolid.transmit.text": {
      source: "iana",
      extensions: ["x_t"]
    },
    "model/vnd.pytha.pyox": {
      source: "iana"
    },
    "model/vnd.rosette.annotated-data-model": {
      source: "iana"
    },
    "model/vnd.sap.vds": {
      source: "iana",
      extensions: ["vds"]
    },
    "model/vnd.usdz+zip": {
      source: "iana",
      compressible: false,
      extensions: ["usdz"]
    },
    "model/vnd.valve.source.compiled-map": {
      source: "iana",
      extensions: ["bsp"]
    },
    "model/vnd.vtu": {
      source: "iana",
      extensions: ["vtu"]
    },
    "model/vrml": {
      source: "iana",
      compressible: false,
      extensions: ["wrl", "vrml"]
    },
    "model/x3d+binary": {
      source: "apache",
      compressible: false,
      extensions: ["x3db", "x3dbz"]
    },
    "model/x3d+fastinfoset": {
      source: "iana",
      extensions: ["x3db"]
    },
    "model/x3d+vrml": {
      source: "apache",
      compressible: false,
      extensions: ["x3dv", "x3dvz"]
    },
    "model/x3d+xml": {
      source: "iana",
      compressible: true,
      extensions: ["x3d", "x3dz"]
    },
    "model/x3d-vrml": {
      source: "iana",
      extensions: ["x3dv"]
    },
    "multipart/alternative": {
      source: "iana",
      compressible: false
    },
    "multipart/appledouble": {
      source: "iana"
    },
    "multipart/byteranges": {
      source: "iana"
    },
    "multipart/digest": {
      source: "iana"
    },
    "multipart/encrypted": {
      source: "iana",
      compressible: false
    },
    "multipart/form-data": {
      source: "iana",
      compressible: false
    },
    "multipart/header-set": {
      source: "iana"
    },
    "multipart/mixed": {
      source: "iana"
    },
    "multipart/multilingual": {
      source: "iana"
    },
    "multipart/parallel": {
      source: "iana"
    },
    "multipart/related": {
      source: "iana",
      compressible: false
    },
    "multipart/report": {
      source: "iana"
    },
    "multipart/signed": {
      source: "iana",
      compressible: false
    },
    "multipart/vnd.bint.med-plus": {
      source: "iana"
    },
    "multipart/voice-message": {
      source: "iana"
    },
    "multipart/x-mixed-replace": {
      source: "iana"
    },
    "text/1d-interleaved-parityfec": {
      source: "iana"
    },
    "text/cache-manifest": {
      source: "iana",
      compressible: true,
      extensions: ["appcache", "manifest"]
    },
    "text/calendar": {
      source: "iana",
      extensions: ["ics", "ifb"]
    },
    "text/calender": {
      compressible: true
    },
    "text/cmd": {
      compressible: true
    },
    "text/coffeescript": {
      extensions: ["coffee", "litcoffee"]
    },
    "text/cql": {
      source: "iana"
    },
    "text/cql-expression": {
      source: "iana"
    },
    "text/cql-identifier": {
      source: "iana"
    },
    "text/css": {
      source: "iana",
      charset: "UTF-8",
      compressible: true,
      extensions: ["css"]
    },
    "text/csv": {
      source: "iana",
      compressible: true,
      extensions: ["csv"]
    },
    "text/csv-schema": {
      source: "iana"
    },
    "text/directory": {
      source: "iana"
    },
    "text/dns": {
      source: "iana"
    },
    "text/ecmascript": {
      source: "iana"
    },
    "text/encaprtp": {
      source: "iana"
    },
    "text/enriched": {
      source: "iana"
    },
    "text/fhirpath": {
      source: "iana"
    },
    "text/flexfec": {
      source: "iana"
    },
    "text/fwdred": {
      source: "iana"
    },
    "text/gff3": {
      source: "iana"
    },
    "text/grammar-ref-list": {
      source: "iana"
    },
    "text/html": {
      source: "iana",
      compressible: true,
      extensions: ["html", "htm", "shtml"]
    },
    "text/jade": {
      extensions: ["jade"]
    },
    "text/javascript": {
      source: "iana",
      compressible: true
    },
    "text/jcr-cnd": {
      source: "iana"
    },
    "text/jsx": {
      compressible: true,
      extensions: ["jsx"]
    },
    "text/less": {
      compressible: true,
      extensions: ["less"]
    },
    "text/markdown": {
      source: "iana",
      compressible: true,
      extensions: ["markdown", "md"]
    },
    "text/mathml": {
      source: "nginx",
      extensions: ["mml"]
    },
    "text/mdx": {
      compressible: true,
      extensions: ["mdx"]
    },
    "text/mizar": {
      source: "iana"
    },
    "text/n3": {
      source: "iana",
      charset: "UTF-8",
      compressible: true,
      extensions: ["n3"]
    },
    "text/parameters": {
      source: "iana",
      charset: "UTF-8"
    },
    "text/parityfec": {
      source: "iana"
    },
    "text/plain": {
      source: "iana",
      compressible: true,
      extensions: ["txt", "text", "conf", "def", "list", "log", "in", "ini"]
    },
    "text/provenance-notation": {
      source: "iana",
      charset: "UTF-8"
    },
    "text/prs.fallenstein.rst": {
      source: "iana"
    },
    "text/prs.lines.tag": {
      source: "iana",
      extensions: ["dsc"]
    },
    "text/prs.prop.logic": {
      source: "iana"
    },
    "text/raptorfec": {
      source: "iana"
    },
    "text/red": {
      source: "iana"
    },
    "text/rfc822-headers": {
      source: "iana"
    },
    "text/richtext": {
      source: "iana",
      compressible: true,
      extensions: ["rtx"]
    },
    "text/rtf": {
      source: "iana",
      compressible: true,
      extensions: ["rtf"]
    },
    "text/rtp-enc-aescm128": {
      source: "iana"
    },
    "text/rtploopback": {
      source: "iana"
    },
    "text/rtx": {
      source: "iana"
    },
    "text/sgml": {
      source: "iana",
      extensions: ["sgml", "sgm"]
    },
    "text/shaclc": {
      source: "iana"
    },
    "text/shex": {
      source: "iana",
      extensions: ["shex"]
    },
    "text/slim": {
      extensions: ["slim", "slm"]
    },
    "text/spdx": {
      source: "iana",
      extensions: ["spdx"]
    },
    "text/strings": {
      source: "iana"
    },
    "text/stylus": {
      extensions: ["stylus", "styl"]
    },
    "text/t140": {
      source: "iana"
    },
    "text/tab-separated-values": {
      source: "iana",
      compressible: true,
      extensions: ["tsv"]
    },
    "text/troff": {
      source: "iana",
      extensions: ["t", "tr", "roff", "man", "me", "ms"]
    },
    "text/turtle": {
      source: "iana",
      charset: "UTF-8",
      extensions: ["ttl"]
    },
    "text/ulpfec": {
      source: "iana"
    },
    "text/uri-list": {
      source: "iana",
      compressible: true,
      extensions: ["uri", "uris", "urls"]
    },
    "text/vcard": {
      source: "iana",
      compressible: true,
      extensions: ["vcard"]
    },
    "text/vnd.a": {
      source: "iana"
    },
    "text/vnd.abc": {
      source: "iana"
    },
    "text/vnd.ascii-art": {
      source: "iana"
    },
    "text/vnd.curl": {
      source: "iana",
      extensions: ["curl"]
    },
    "text/vnd.curl.dcurl": {
      source: "apache",
      extensions: ["dcurl"]
    },
    "text/vnd.curl.mcurl": {
      source: "apache",
      extensions: ["mcurl"]
    },
    "text/vnd.curl.scurl": {
      source: "apache",
      extensions: ["scurl"]
    },
    "text/vnd.debian.copyright": {
      source: "iana",
      charset: "UTF-8"
    },
    "text/vnd.dmclientscript": {
      source: "iana"
    },
    "text/vnd.dvb.subtitle": {
      source: "iana",
      extensions: ["sub"]
    },
    "text/vnd.esmertec.theme-descriptor": {
      source: "iana",
      charset: "UTF-8"
    },
    "text/vnd.familysearch.gedcom": {
      source: "iana",
      extensions: ["ged"]
    },
    "text/vnd.ficlab.flt": {
      source: "iana"
    },
    "text/vnd.fly": {
      source: "iana",
      extensions: ["fly"]
    },
    "text/vnd.fmi.flexstor": {
      source: "iana",
      extensions: ["flx"]
    },
    "text/vnd.gml": {
      source: "iana"
    },
    "text/vnd.graphviz": {
      source: "iana",
      extensions: ["gv"]
    },
    "text/vnd.hans": {
      source: "iana"
    },
    "text/vnd.hgl": {
      source: "iana"
    },
    "text/vnd.in3d.3dml": {
      source: "iana",
      extensions: ["3dml"]
    },
    "text/vnd.in3d.spot": {
      source: "iana",
      extensions: ["spot"]
    },
    "text/vnd.iptc.newsml": {
      source: "iana"
    },
    "text/vnd.iptc.nitf": {
      source: "iana"
    },
    "text/vnd.latex-z": {
      source: "iana"
    },
    "text/vnd.motorola.reflex": {
      source: "iana"
    },
    "text/vnd.ms-mediapackage": {
      source: "iana"
    },
    "text/vnd.net2phone.commcenter.command": {
      source: "iana"
    },
    "text/vnd.radisys.msml-basic-layout": {
      source: "iana"
    },
    "text/vnd.senx.warpscript": {
      source: "iana"
    },
    "text/vnd.si.uricatalogue": {
      source: "iana"
    },
    "text/vnd.sosi": {
      source: "iana"
    },
    "text/vnd.sun.j2me.app-descriptor": {
      source: "iana",
      charset: "UTF-8",
      extensions: ["jad"]
    },
    "text/vnd.trolltech.linguist": {
      source: "iana",
      charset: "UTF-8"
    },
    "text/vnd.wap.si": {
      source: "iana"
    },
    "text/vnd.wap.sl": {
      source: "iana"
    },
    "text/vnd.wap.wml": {
      source: "iana",
      extensions: ["wml"]
    },
    "text/vnd.wap.wmlscript": {
      source: "iana",
      extensions: ["wmls"]
    },
    "text/vtt": {
      source: "iana",
      charset: "UTF-8",
      compressible: true,
      extensions: ["vtt"]
    },
    "text/x-asm": {
      source: "apache",
      extensions: ["s", "asm"]
    },
    "text/x-c": {
      source: "apache",
      extensions: ["c", "cc", "cxx", "cpp", "h", "hh", "dic"]
    },
    "text/x-component": {
      source: "nginx",
      extensions: ["htc"]
    },
    "text/x-fortran": {
      source: "apache",
      extensions: ["f", "for", "f77", "f90"]
    },
    "text/x-gwt-rpc": {
      compressible: true
    },
    "text/x-handlebars-template": {
      extensions: ["hbs"]
    },
    "text/x-java-source": {
      source: "apache",
      extensions: ["java"]
    },
    "text/x-jquery-tmpl": {
      compressible: true
    },
    "text/x-lua": {
      extensions: ["lua"]
    },
    "text/x-markdown": {
      compressible: true,
      extensions: ["mkd"]
    },
    "text/x-nfo": {
      source: "apache",
      extensions: ["nfo"]
    },
    "text/x-opml": {
      source: "apache",
      extensions: ["opml"]
    },
    "text/x-org": {
      compressible: true,
      extensions: ["org"]
    },
    "text/x-pascal": {
      source: "apache",
      extensions: ["p", "pas"]
    },
    "text/x-processing": {
      compressible: true,
      extensions: ["pde"]
    },
    "text/x-sass": {
      extensions: ["sass"]
    },
    "text/x-scss": {
      extensions: ["scss"]
    },
    "text/x-setext": {
      source: "apache",
      extensions: ["etx"]
    },
    "text/x-sfv": {
      source: "apache",
      extensions: ["sfv"]
    },
    "text/x-suse-ymp": {
      compressible: true,
      extensions: ["ymp"]
    },
    "text/x-uuencode": {
      source: "apache",
      extensions: ["uu"]
    },
    "text/x-vcalendar": {
      source: "apache",
      extensions: ["vcs"]
    },
    "text/x-vcard": {
      source: "apache",
      extensions: ["vcf"]
    },
    "text/xml": {
      source: "iana",
      compressible: true,
      extensions: ["xml"]
    },
    "text/xml-external-parsed-entity": {
      source: "iana"
    },
    "text/yaml": {
      compressible: true,
      extensions: ["yaml", "yml"]
    },
    "video/1d-interleaved-parityfec": {
      source: "iana"
    },
    "video/3gpp": {
      source: "iana",
      extensions: ["3gp", "3gpp"]
    },
    "video/3gpp-tt": {
      source: "iana"
    },
    "video/3gpp2": {
      source: "iana",
      extensions: ["3g2"]
    },
    "video/av1": {
      source: "iana"
    },
    "video/bmpeg": {
      source: "iana"
    },
    "video/bt656": {
      source: "iana"
    },
    "video/celb": {
      source: "iana"
    },
    "video/dv": {
      source: "iana"
    },
    "video/encaprtp": {
      source: "iana"
    },
    "video/ffv1": {
      source: "iana"
    },
    "video/flexfec": {
      source: "iana"
    },
    "video/h261": {
      source: "iana",
      extensions: ["h261"]
    },
    "video/h263": {
      source: "iana",
      extensions: ["h263"]
    },
    "video/h263-1998": {
      source: "iana"
    },
    "video/h263-2000": {
      source: "iana"
    },
    "video/h264": {
      source: "iana",
      extensions: ["h264"]
    },
    "video/h264-rcdo": {
      source: "iana"
    },
    "video/h264-svc": {
      source: "iana"
    },
    "video/h265": {
      source: "iana"
    },
    "video/iso.segment": {
      source: "iana",
      extensions: ["m4s"]
    },
    "video/jpeg": {
      source: "iana",
      extensions: ["jpgv"]
    },
    "video/jpeg2000": {
      source: "iana"
    },
    "video/jpm": {
      source: "apache",
      extensions: ["jpm", "jpgm"]
    },
    "video/jxsv": {
      source: "iana"
    },
    "video/mj2": {
      source: "iana",
      extensions: ["mj2", "mjp2"]
    },
    "video/mp1s": {
      source: "iana"
    },
    "video/mp2p": {
      source: "iana"
    },
    "video/mp2t": {
      source: "iana",
      extensions: ["ts"]
    },
    "video/mp4": {
      source: "iana",
      compressible: false,
      extensions: ["mp4", "mp4v", "mpg4"]
    },
    "video/mp4v-es": {
      source: "iana"
    },
    "video/mpeg": {
      source: "iana",
      compressible: false,
      extensions: ["mpeg", "mpg", "mpe", "m1v", "m2v"]
    },
    "video/mpeg4-generic": {
      source: "iana"
    },
    "video/mpv": {
      source: "iana"
    },
    "video/nv": {
      source: "iana"
    },
    "video/ogg": {
      source: "iana",
      compressible: false,
      extensions: ["ogv"]
    },
    "video/parityfec": {
      source: "iana"
    },
    "video/pointer": {
      source: "iana"
    },
    "video/quicktime": {
      source: "iana",
      compressible: false,
      extensions: ["qt", "mov"]
    },
    "video/raptorfec": {
      source: "iana"
    },
    "video/raw": {
      source: "iana"
    },
    "video/rtp-enc-aescm128": {
      source: "iana"
    },
    "video/rtploopback": {
      source: "iana"
    },
    "video/rtx": {
      source: "iana"
    },
    "video/scip": {
      source: "iana"
    },
    "video/smpte291": {
      source: "iana"
    },
    "video/smpte292m": {
      source: "iana"
    },
    "video/ulpfec": {
      source: "iana"
    },
    "video/vc1": {
      source: "iana"
    },
    "video/vc2": {
      source: "iana"
    },
    "video/vnd.cctv": {
      source: "iana"
    },
    "video/vnd.dece.hd": {
      source: "iana",
      extensions: ["uvh", "uvvh"]
    },
    "video/vnd.dece.mobile": {
      source: "iana",
      extensions: ["uvm", "uvvm"]
    },
    "video/vnd.dece.mp4": {
      source: "iana"
    },
    "video/vnd.dece.pd": {
      source: "iana",
      extensions: ["uvp", "uvvp"]
    },
    "video/vnd.dece.sd": {
      source: "iana",
      extensions: ["uvs", "uvvs"]
    },
    "video/vnd.dece.video": {
      source: "iana",
      extensions: ["uvv", "uvvv"]
    },
    "video/vnd.directv.mpeg": {
      source: "iana"
    },
    "video/vnd.directv.mpeg-tts": {
      source: "iana"
    },
    "video/vnd.dlna.mpeg-tts": {
      source: "iana"
    },
    "video/vnd.dvb.file": {
      source: "iana",
      extensions: ["dvb"]
    },
    "video/vnd.fvt": {
      source: "iana",
      extensions: ["fvt"]
    },
    "video/vnd.hns.video": {
      source: "iana"
    },
    "video/vnd.iptvforum.1dparityfec-1010": {
      source: "iana"
    },
    "video/vnd.iptvforum.1dparityfec-2005": {
      source: "iana"
    },
    "video/vnd.iptvforum.2dparityfec-1010": {
      source: "iana"
    },
    "video/vnd.iptvforum.2dparityfec-2005": {
      source: "iana"
    },
    "video/vnd.iptvforum.ttsavc": {
      source: "iana"
    },
    "video/vnd.iptvforum.ttsmpeg2": {
      source: "iana"
    },
    "video/vnd.motorola.video": {
      source: "iana"
    },
    "video/vnd.motorola.videop": {
      source: "iana"
    },
    "video/vnd.mpegurl": {
      source: "iana",
      extensions: ["mxu", "m4u"]
    },
    "video/vnd.ms-playready.media.pyv": {
      source: "iana",
      extensions: ["pyv"]
    },
    "video/vnd.nokia.interleaved-multimedia": {
      source: "iana"
    },
    "video/vnd.nokia.mp4vr": {
      source: "iana"
    },
    "video/vnd.nokia.videovoip": {
      source: "iana"
    },
    "video/vnd.objectvideo": {
      source: "iana"
    },
    "video/vnd.radgamettools.bink": {
      source: "iana"
    },
    "video/vnd.radgamettools.smacker": {
      source: "iana"
    },
    "video/vnd.sealed.mpeg1": {
      source: "iana"
    },
    "video/vnd.sealed.mpeg4": {
      source: "iana"
    },
    "video/vnd.sealed.swf": {
      source: "iana"
    },
    "video/vnd.sealedmedia.softseal.mov": {
      source: "iana"
    },
    "video/vnd.uvvu.mp4": {
      source: "iana",
      extensions: ["uvu", "uvvu"]
    },
    "video/vnd.vivo": {
      source: "iana",
      extensions: ["viv"]
    },
    "video/vnd.youtube.yt": {
      source: "iana"
    },
    "video/vp8": {
      source: "iana"
    },
    "video/vp9": {
      source: "iana"
    },
    "video/webm": {
      source: "apache",
      compressible: false,
      extensions: ["webm"]
    },
    "video/x-f4v": {
      source: "apache",
      extensions: ["f4v"]
    },
    "video/x-fli": {
      source: "apache",
      extensions: ["fli"]
    },
    "video/x-flv": {
      source: "apache",
      compressible: false,
      extensions: ["flv"]
    },
    "video/x-m4v": {
      source: "apache",
      extensions: ["m4v"]
    },
    "video/x-matroska": {
      source: "apache",
      compressible: false,
      extensions: ["mkv", "mk3d", "mks"]
    },
    "video/x-mng": {
      source: "apache",
      extensions: ["mng"]
    },
    "video/x-ms-asf": {
      source: "apache",
      extensions: ["asf", "asx"]
    },
    "video/x-ms-vob": {
      source: "apache",
      extensions: ["vob"]
    },
    "video/x-ms-wm": {
      source: "apache",
      extensions: ["wm"]
    },
    "video/x-ms-wmv": {
      source: "apache",
      compressible: false,
      extensions: ["wmv"]
    },
    "video/x-ms-wmx": {
      source: "apache",
      extensions: ["wmx"]
    },
    "video/x-ms-wvx": {
      source: "apache",
      extensions: ["wvx"]
    },
    "video/x-msvideo": {
      source: "apache",
      extensions: ["avi"]
    },
    "video/x-sgi-movie": {
      source: "apache",
      extensions: ["movie"]
    },
    "video/x-smv": {
      source: "apache",
      extensions: ["smv"]
    },
    "x-conference/x-cooltalk": {
      source: "apache",
      extensions: ["ice"]
    },
    "x-shader/x-fragment": {
      compressible: true
    },
    "x-shader/x-vertex": {
      compressible: true
    }
  };
});

// node_modules/mime-db/index.js
var require_mime_db = __commonJS((exports, module) => {
  /*!
   * mime-db
   * Copyright(c) 2014 Jonathan Ong
   * Copyright(c) 2015-2022 Douglas Christopher Wilson
   * MIT Licensed
   */
  module.exports = require_db();
});

// node_modules/mime-types/index.js
var require_mime_types = __commonJS((exports) => {
  /*!
   * mime-types
   * Copyright(c) 2014 Jonathan Ong
   * Copyright(c) 2015 Douglas Christopher Wilson
   * MIT Licensed
   */
  var db = require_mime_db();
  var extname = __require("path").extname;
  var EXTRACT_TYPE_REGEXP = /^\s*([^;\s]*)(?:;|\s|$)/;
  var TEXT_TYPE_REGEXP = /^text\//i;
  exports.charset = charset;
  exports.charsets = { lookup: charset };
  exports.contentType = contentType;
  exports.extension = extension;
  exports.extensions = Object.create(null);
  exports.lookup = lookup;
  exports.types = Object.create(null);
  populateMaps(exports.extensions, exports.types);
  function charset(type) {
    if (!type || typeof type !== "string") {
      return false;
    }
    var match = EXTRACT_TYPE_REGEXP.exec(type);
    var mime = match && db[match[1].toLowerCase()];
    if (mime && mime.charset) {
      return mime.charset;
    }
    if (match && TEXT_TYPE_REGEXP.test(match[1])) {
      return "UTF-8";
    }
    return false;
  }
  function contentType(str) {
    if (!str || typeof str !== "string") {
      return false;
    }
    var mime = str.indexOf("/") === -1 ? exports.lookup(str) : str;
    if (!mime) {
      return false;
    }
    if (mime.indexOf("charset") === -1) {
      var charset2 = exports.charset(mime);
      if (charset2)
        mime += "; charset=" + charset2.toLowerCase();
    }
    return mime;
  }
  function extension(type) {
    if (!type || typeof type !== "string") {
      return false;
    }
    var match = EXTRACT_TYPE_REGEXP.exec(type);
    var exts = match && exports.extensions[match[1].toLowerCase()];
    if (!exts || !exts.length) {
      return false;
    }
    return exts[0];
  }
  function lookup(path) {
    if (!path || typeof path !== "string") {
      return false;
    }
    var extension2 = extname("x." + path).toLowerCase().substr(1);
    if (!extension2) {
      return false;
    }
    return exports.types[extension2] || false;
  }
  function populateMaps(extensions, types) {
    var preference = ["nginx", "apache", undefined, "iana"];
    Object.keys(db).forEach(function forEachMimeType(type) {
      var mime = db[type];
      var exts = mime.extensions;
      if (!exts || !exts.length) {
        return;
      }
      extensions[type] = exts;
      for (var i = 0;i < exts.length; i++) {
        var extension2 = exts[i];
        if (types[extension2]) {
          var from = preference.indexOf(db[types[extension2]].source);
          var to = preference.indexOf(mime.source);
          if (types[extension2] !== "application/octet-stream" && (from > to || from === to && types[extension2].substr(0, 12) === "application/")) {
            continue;
          }
        }
        types[extension2] = type;
      }
    });
  }
});

// node_modules/asynckit/lib/defer.js
var require_defer = __commonJS((exports, module) => {
  module.exports = defer;
  function defer(fn) {
    var nextTick = typeof setImmediate == "function" ? setImmediate : typeof process == "object" && typeof process.nextTick == "function" ? process.nextTick : null;
    if (nextTick) {
      nextTick(fn);
    } else {
      setTimeout(fn, 0);
    }
  }
});

// node_modules/asynckit/lib/async.js
var require_async = __commonJS((exports, module) => {
  var defer = require_defer();
  module.exports = async;
  function async(callback) {
    var isAsync2 = false;
    defer(function() {
      isAsync2 = true;
    });
    return function async_callback(err, result) {
      if (isAsync2) {
        callback(err, result);
      } else {
        defer(function nextTick_callback() {
          callback(err, result);
        });
      }
    };
  }
});

// node_modules/asynckit/lib/abort.js
var require_abort = __commonJS((exports, module) => {
  module.exports = abort;
  function abort(state) {
    Object.keys(state.jobs).forEach(clean.bind(state));
    state.jobs = {};
  }
  function clean(key) {
    if (typeof this.jobs[key] == "function") {
      this.jobs[key]();
    }
  }
});

// node_modules/asynckit/lib/iterate.js
var require_iterate = __commonJS((exports, module) => {
  var async = require_async();
  var abort = require_abort();
  module.exports = iterate;
  function iterate(list, iterator, state, callback) {
    var key = state["keyedList"] ? state["keyedList"][state.index] : state.index;
    state.jobs[key] = runJob(iterator, key, list[key], function(error, output) {
      if (!(key in state.jobs)) {
        return;
      }
      delete state.jobs[key];
      if (error) {
        abort(state);
      } else {
        state.results[key] = output;
      }
      callback(error, state.results);
    });
  }
  function runJob(iterator, key, item, callback) {
    var aborter;
    if (iterator.length == 2) {
      aborter = iterator(item, async(callback));
    } else {
      aborter = iterator(item, key, async(callback));
    }
    return aborter;
  }
});

// node_modules/asynckit/lib/state.js
var require_state = __commonJS((exports, module) => {
  module.exports = state;
  function state(list, sortMethod) {
    var isNamedList = !Array.isArray(list), initState = {
      index: 0,
      keyedList: isNamedList || sortMethod ? Object.keys(list) : null,
      jobs: {},
      results: isNamedList ? {} : [],
      size: isNamedList ? Object.keys(list).length : list.length
    };
    if (sortMethod) {
      initState.keyedList.sort(isNamedList ? sortMethod : function(a, b) {
        return sortMethod(list[a], list[b]);
      });
    }
    return initState;
  }
});

// node_modules/asynckit/lib/terminator.js
var require_terminator = __commonJS((exports, module) => {
  var abort = require_abort();
  var async = require_async();
  module.exports = terminator;
  function terminator(callback) {
    if (!Object.keys(this.jobs).length) {
      return;
    }
    this.index = this.size;
    abort(this);
    async(callback)(null, this.results);
  }
});

// node_modules/asynckit/parallel.js
var require_parallel = __commonJS((exports, module) => {
  var iterate = require_iterate();
  var initState = require_state();
  var terminator = require_terminator();
  module.exports = parallel;
  function parallel(list, iterator, callback) {
    var state = initState(list);
    while (state.index < (state["keyedList"] || list).length) {
      iterate(list, iterator, state, function(error, result) {
        if (error) {
          callback(error, result);
          return;
        }
        if (Object.keys(state.jobs).length === 0) {
          callback(null, state.results);
          return;
        }
      });
      state.index++;
    }
    return terminator.bind(state, callback);
  }
});

// node_modules/asynckit/serialOrdered.js
var require_serialOrdered = __commonJS((exports, module) => {
  var iterate = require_iterate();
  var initState = require_state();
  var terminator = require_terminator();
  module.exports = serialOrdered;
  module.exports.ascending = ascending;
  module.exports.descending = descending;
  function serialOrdered(list, iterator, sortMethod, callback) {
    var state = initState(list, sortMethod);
    iterate(list, iterator, state, function iteratorHandler(error, result) {
      if (error) {
        callback(error, result);
        return;
      }
      state.index++;
      if (state.index < (state["keyedList"] || list).length) {
        iterate(list, iterator, state, iteratorHandler);
        return;
      }
      callback(null, state.results);
    });
    return terminator.bind(state, callback);
  }
  function ascending(a, b) {
    return a < b ? -1 : a > b ? 1 : 0;
  }
  function descending(a, b) {
    return -1 * ascending(a, b);
  }
});

// node_modules/asynckit/serial.js
var require_serial = __commonJS((exports, module) => {
  var serialOrdered = require_serialOrdered();
  module.exports = serial;
  function serial(list, iterator, callback) {
    return serialOrdered(list, iterator, null, callback);
  }
});

// node_modules/asynckit/index.js
var require_asynckit = __commonJS((exports, module) => {
  module.exports = {
    parallel: require_parallel(),
    serial: require_serial(),
    serialOrdered: require_serialOrdered()
  };
});

// node_modules/es-object-atoms/index.js
var require_es_object_atoms = __commonJS((exports, module) => {
  module.exports = Object;
});

// node_modules/es-errors/index.js
var require_es_errors = __commonJS((exports, module) => {
  module.exports = Error;
});

// node_modules/es-errors/eval.js
var require_eval = __commonJS((exports, module) => {
  module.exports = EvalError;
});

// node_modules/es-errors/range.js
var require_range = __commonJS((exports, module) => {
  module.exports = RangeError;
});

// node_modules/es-errors/ref.js
var require_ref = __commonJS((exports, module) => {
  module.exports = ReferenceError;
});

// node_modules/es-errors/syntax.js
var require_syntax = __commonJS((exports, module) => {
  module.exports = SyntaxError;
});

// node_modules/es-errors/type.js
var require_type = __commonJS((exports, module) => {
  module.exports = TypeError;
});

// node_modules/es-errors/uri.js
var require_uri = __commonJS((exports, module) => {
  module.exports = URIError;
});

// node_modules/math-intrinsics/abs.js
var require_abs = __commonJS((exports, module) => {
  module.exports = Math.abs;
});

// node_modules/math-intrinsics/floor.js
var require_floor = __commonJS((exports, module) => {
  module.exports = Math.floor;
});

// node_modules/math-intrinsics/max.js
var require_max = __commonJS((exports, module) => {
  module.exports = Math.max;
});

// node_modules/math-intrinsics/min.js
var require_min = __commonJS((exports, module) => {
  module.exports = Math.min;
});

// node_modules/math-intrinsics/pow.js
var require_pow = __commonJS((exports, module) => {
  module.exports = Math.pow;
});

// node_modules/math-intrinsics/round.js
var require_round = __commonJS((exports, module) => {
  module.exports = Math.round;
});

// node_modules/math-intrinsics/isNaN.js
var require_isNaN = __commonJS((exports, module) => {
  module.exports = Number.isNaN || function isNaN(a) {
    return a !== a;
  };
});

// node_modules/math-intrinsics/sign.js
var require_sign = __commonJS((exports, module) => {
  var $isNaN = require_isNaN();
  module.exports = function sign(number2) {
    if ($isNaN(number2) || number2 === 0) {
      return number2;
    }
    return number2 < 0 ? -1 : 1;
  };
});

// node_modules/gopd/gOPD.js
var require_gOPD = __commonJS((exports, module) => {
  module.exports = Object.getOwnPropertyDescriptor;
});

// node_modules/gopd/index.js
var require_gopd = __commonJS((exports, module) => {
  var $gOPD = require_gOPD();
  if ($gOPD) {
    try {
      $gOPD([], "length");
    } catch (e) {
      $gOPD = null;
    }
  }
  module.exports = $gOPD;
});

// node_modules/es-define-property/index.js
var require_es_define_property = __commonJS((exports, module) => {
  var $defineProperty = Object.defineProperty || false;
  if ($defineProperty) {
    try {
      $defineProperty({}, "a", { value: 1 });
    } catch (e) {
      $defineProperty = false;
    }
  }
  module.exports = $defineProperty;
});

// node_modules/has-symbols/shams.js
var require_shams = __commonJS((exports, module) => {
  module.exports = function hasSymbols() {
    if (typeof Symbol !== "function" || typeof Object.getOwnPropertySymbols !== "function") {
      return false;
    }
    if (typeof Symbol.iterator === "symbol") {
      return true;
    }
    var obj2 = {};
    var sym = Symbol("test");
    var symObj = Object(sym);
    if (typeof sym === "string") {
      return false;
    }
    if (Object.prototype.toString.call(sym) !== "[object Symbol]") {
      return false;
    }
    if (Object.prototype.toString.call(symObj) !== "[object Symbol]") {
      return false;
    }
    var symVal = 42;
    obj2[sym] = symVal;
    for (var _ in obj2) {
      return false;
    }
    if (typeof Object.keys === "function" && Object.keys(obj2).length !== 0) {
      return false;
    }
    if (typeof Object.getOwnPropertyNames === "function" && Object.getOwnPropertyNames(obj2).length !== 0) {
      return false;
    }
    var syms = Object.getOwnPropertySymbols(obj2);
    if (syms.length !== 1 || syms[0] !== sym) {
      return false;
    }
    if (!Object.prototype.propertyIsEnumerable.call(obj2, sym)) {
      return false;
    }
    if (typeof Object.getOwnPropertyDescriptor === "function") {
      var descriptor = Object.getOwnPropertyDescriptor(obj2, sym);
      if (descriptor.value !== symVal || descriptor.enumerable !== true) {
        return false;
      }
    }
    return true;
  };
});

// node_modules/has-symbols/index.js
var require_has_symbols = __commonJS((exports, module) => {
  var origSymbol = typeof Symbol !== "undefined" && Symbol;
  var hasSymbolSham = require_shams();
  module.exports = function hasNativeSymbols() {
    if (typeof origSymbol !== "function") {
      return false;
    }
    if (typeof Symbol !== "function") {
      return false;
    }
    if (typeof origSymbol("foo") !== "symbol") {
      return false;
    }
    if (typeof Symbol("bar") !== "symbol") {
      return false;
    }
    return hasSymbolSham();
  };
});

// node_modules/get-proto/Reflect.getPrototypeOf.js
var require_Reflect_getPrototypeOf = __commonJS((exports, module) => {
  module.exports = typeof Reflect !== "undefined" && Reflect.getPrototypeOf || null;
});

// node_modules/get-proto/Object.getPrototypeOf.js
var require_Object_getPrototypeOf = __commonJS((exports, module) => {
  var $Object = require_es_object_atoms();
  module.exports = $Object.getPrototypeOf || null;
});

// node_modules/function-bind/implementation.js
var require_implementation = __commonJS((exports, module) => {
  var ERROR_MESSAGE = "Function.prototype.bind called on incompatible ";
  var toStr = Object.prototype.toString;
  var max = Math.max;
  var funcType = "[object Function]";
  var concatty = function concatty(a, b) {
    var arr = [];
    for (var i = 0;i < a.length; i += 1) {
      arr[i] = a[i];
    }
    for (var j = 0;j < b.length; j += 1) {
      arr[j + a.length] = b[j];
    }
    return arr;
  };
  var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0;i < arrLike.length; i += 1, j += 1) {
      arr[j] = arrLike[i];
    }
    return arr;
  };
  var joiny = function(arr, joiner) {
    var str = "";
    for (var i = 0;i < arr.length; i += 1) {
      str += arr[i];
      if (i + 1 < arr.length) {
        str += joiner;
      }
    }
    return str;
  };
  module.exports = function bind(that) {
    var target = this;
    if (typeof target !== "function" || toStr.apply(target) !== funcType) {
      throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);
    var bound;
    var binder = function() {
      if (this instanceof bound) {
        var result = target.apply(this, concatty(args, arguments));
        if (Object(result) === result) {
          return result;
        }
        return this;
      }
      return target.apply(that, concatty(args, arguments));
    };
    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0;i < boundLength; i++) {
      boundArgs[i] = "$" + i;
    }
    bound = Function("binder", "return function (" + joiny(boundArgs, ",") + "){ return binder.apply(this,arguments); }")(binder);
    if (target.prototype) {
      var Empty = function Empty() {};
      Empty.prototype = target.prototype;
      bound.prototype = new Empty;
      Empty.prototype = null;
    }
    return bound;
  };
});

// node_modules/function-bind/index.js
var require_function_bind = __commonJS((exports, module) => {
  var implementation = require_implementation();
  module.exports = Function.prototype.bind || implementation;
});

// node_modules/call-bind-apply-helpers/functionCall.js
var require_functionCall = __commonJS((exports, module) => {
  module.exports = Function.prototype.call;
});

// node_modules/call-bind-apply-helpers/functionApply.js
var require_functionApply = __commonJS((exports, module) => {
  module.exports = Function.prototype.apply;
});

// node_modules/call-bind-apply-helpers/reflectApply.js
var require_reflectApply = __commonJS((exports, module) => {
  module.exports = typeof Reflect !== "undefined" && Reflect && Reflect.apply;
});

// node_modules/call-bind-apply-helpers/actualApply.js
var require_actualApply = __commonJS((exports, module) => {
  var bind = require_function_bind();
  var $apply = require_functionApply();
  var $call = require_functionCall();
  var $reflectApply = require_reflectApply();
  module.exports = $reflectApply || bind.call($call, $apply);
});

// node_modules/call-bind-apply-helpers/index.js
var require_call_bind_apply_helpers = __commonJS((exports, module) => {
  var bind = require_function_bind();
  var $TypeError = require_type();
  var $call = require_functionCall();
  var $actualApply = require_actualApply();
  module.exports = function callBindBasic(args) {
    if (args.length < 1 || typeof args[0] !== "function") {
      throw new $TypeError("a function is required");
    }
    return $actualApply(bind, $call, args);
  };
});

// node_modules/dunder-proto/get.js
var require_get = __commonJS((exports, module) => {
  var callBind = require_call_bind_apply_helpers();
  var gOPD = require_gopd();
  var hasProtoAccessor;
  try {
    hasProtoAccessor = [].__proto__ === Array.prototype;
  } catch (e) {
    if (!e || typeof e !== "object" || !("code" in e) || e.code !== "ERR_PROTO_ACCESS") {
      throw e;
    }
  }
  var desc = !!hasProtoAccessor && gOPD && gOPD(Object.prototype, "__proto__");
  var $Object = Object;
  var $getPrototypeOf = $Object.getPrototypeOf;
  module.exports = desc && typeof desc.get === "function" ? callBind([desc.get]) : typeof $getPrototypeOf === "function" ? function getDunder(value) {
    return $getPrototypeOf(value == null ? value : $Object(value));
  } : false;
});

// node_modules/get-proto/index.js
var require_get_proto = __commonJS((exports, module) => {
  var reflectGetProto = require_Reflect_getPrototypeOf();
  var originalGetProto = require_Object_getPrototypeOf();
  var getDunderProto = require_get();
  module.exports = reflectGetProto ? function getProto(O) {
    return reflectGetProto(O);
  } : originalGetProto ? function getProto(O) {
    if (!O || typeof O !== "object" && typeof O !== "function") {
      throw new TypeError("getProto: not an object");
    }
    return originalGetProto(O);
  } : getDunderProto ? function getProto(O) {
    return getDunderProto(O);
  } : null;
});

// node_modules/hasown/index.js
var require_hasown = __commonJS((exports, module) => {
  var call = Function.prototype.call;
  var $hasOwn = Object.prototype.hasOwnProperty;
  var bind = require_function_bind();
  module.exports = bind.call(call, $hasOwn);
});

// node_modules/get-intrinsic/index.js
var require_get_intrinsic = __commonJS((exports, module) => {
  var undefined3;
  var $Object = require_es_object_atoms();
  var $Error = require_es_errors();
  var $EvalError = require_eval();
  var $RangeError = require_range();
  var $ReferenceError = require_ref();
  var $SyntaxError = require_syntax();
  var $TypeError = require_type();
  var $URIError = require_uri();
  var abs = require_abs();
  var floor = require_floor();
  var max = require_max();
  var min = require_min();
  var pow = require_pow();
  var round = require_round();
  var sign = require_sign();
  var $Function = Function;
  var getEvalledConstructor = function(expressionSyntax) {
    try {
      return $Function('"use strict"; return (' + expressionSyntax + ").constructor;")();
    } catch (e) {}
  };
  var $gOPD = require_gopd();
  var $defineProperty = require_es_define_property();
  var throwTypeError = function() {
    throw new $TypeError;
  };
  var ThrowTypeError = $gOPD ? function() {
    try {
      arguments.callee;
      return throwTypeError;
    } catch (calleeThrows) {
      try {
        return $gOPD(arguments, "callee").get;
      } catch (gOPDthrows) {
        return throwTypeError;
      }
    }
  }() : throwTypeError;
  var hasSymbols = require_has_symbols()();
  var getProto = require_get_proto();
  var $ObjectGPO = require_Object_getPrototypeOf();
  var $ReflectGPO = require_Reflect_getPrototypeOf();
  var $apply = require_functionApply();
  var $call = require_functionCall();
  var needsEval = {};
  var TypedArray = typeof Uint8Array === "undefined" || !getProto ? undefined3 : getProto(Uint8Array);
  var INTRINSICS = {
    __proto__: null,
    "%AggregateError%": typeof AggregateError === "undefined" ? undefined3 : AggregateError,
    "%Array%": Array,
    "%ArrayBuffer%": typeof ArrayBuffer === "undefined" ? undefined3 : ArrayBuffer,
    "%ArrayIteratorPrototype%": hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined3,
    "%AsyncFromSyncIteratorPrototype%": undefined3,
    "%AsyncFunction%": needsEval,
    "%AsyncGenerator%": needsEval,
    "%AsyncGeneratorFunction%": needsEval,
    "%AsyncIteratorPrototype%": needsEval,
    "%Atomics%": typeof Atomics === "undefined" ? undefined3 : Atomics,
    "%BigInt%": typeof BigInt === "undefined" ? undefined3 : BigInt,
    "%BigInt64Array%": typeof BigInt64Array === "undefined" ? undefined3 : BigInt64Array,
    "%BigUint64Array%": typeof BigUint64Array === "undefined" ? undefined3 : BigUint64Array,
    "%Boolean%": Boolean,
    "%DataView%": typeof DataView === "undefined" ? undefined3 : DataView,
    "%Date%": Date,
    "%decodeURI%": decodeURI,
    "%decodeURIComponent%": decodeURIComponent,
    "%encodeURI%": encodeURI,
    "%encodeURIComponent%": encodeURIComponent,
    "%Error%": $Error,
    "%eval%": eval,
    "%EvalError%": $EvalError,
    "%Float16Array%": typeof Float16Array === "undefined" ? undefined3 : Float16Array,
    "%Float32Array%": typeof Float32Array === "undefined" ? undefined3 : Float32Array,
    "%Float64Array%": typeof Float64Array === "undefined" ? undefined3 : Float64Array,
    "%FinalizationRegistry%": typeof FinalizationRegistry === "undefined" ? undefined3 : FinalizationRegistry,
    "%Function%": $Function,
    "%GeneratorFunction%": needsEval,
    "%Int8Array%": typeof Int8Array === "undefined" ? undefined3 : Int8Array,
    "%Int16Array%": typeof Int16Array === "undefined" ? undefined3 : Int16Array,
    "%Int32Array%": typeof Int32Array === "undefined" ? undefined3 : Int32Array,
    "%isFinite%": isFinite,
    "%isNaN%": isNaN,
    "%IteratorPrototype%": hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined3,
    "%JSON%": typeof JSON === "object" ? JSON : undefined3,
    "%Map%": typeof Map === "undefined" ? undefined3 : Map,
    "%MapIteratorPrototype%": typeof Map === "undefined" || !hasSymbols || !getProto ? undefined3 : getProto(new Map()[Symbol.iterator]()),
    "%Math%": Math,
    "%Number%": Number,
    "%Object%": $Object,
    "%Object.getOwnPropertyDescriptor%": $gOPD,
    "%parseFloat%": parseFloat,
    "%parseInt%": parseInt,
    "%Promise%": typeof Promise === "undefined" ? undefined3 : Promise,
    "%Proxy%": typeof Proxy === "undefined" ? undefined3 : Proxy,
    "%RangeError%": $RangeError,
    "%ReferenceError%": $ReferenceError,
    "%Reflect%": typeof Reflect === "undefined" ? undefined3 : Reflect,
    "%RegExp%": RegExp,
    "%Set%": typeof Set === "undefined" ? undefined3 : Set,
    "%SetIteratorPrototype%": typeof Set === "undefined" || !hasSymbols || !getProto ? undefined3 : getProto(new Set()[Symbol.iterator]()),
    "%SharedArrayBuffer%": typeof SharedArrayBuffer === "undefined" ? undefined3 : SharedArrayBuffer,
    "%String%": String,
    "%StringIteratorPrototype%": hasSymbols && getProto ? getProto(""[Symbol.iterator]()) : undefined3,
    "%Symbol%": hasSymbols ? Symbol : undefined3,
    "%SyntaxError%": $SyntaxError,
    "%ThrowTypeError%": ThrowTypeError,
    "%TypedArray%": TypedArray,
    "%TypeError%": $TypeError,
    "%Uint8Array%": typeof Uint8Array === "undefined" ? undefined3 : Uint8Array,
    "%Uint8ClampedArray%": typeof Uint8ClampedArray === "undefined" ? undefined3 : Uint8ClampedArray,
    "%Uint16Array%": typeof Uint16Array === "undefined" ? undefined3 : Uint16Array,
    "%Uint32Array%": typeof Uint32Array === "undefined" ? undefined3 : Uint32Array,
    "%URIError%": $URIError,
    "%WeakMap%": typeof WeakMap === "undefined" ? undefined3 : WeakMap,
    "%WeakRef%": typeof WeakRef === "undefined" ? undefined3 : WeakRef,
    "%WeakSet%": typeof WeakSet === "undefined" ? undefined3 : WeakSet,
    "%Function.prototype.call%": $call,
    "%Function.prototype.apply%": $apply,
    "%Object.defineProperty%": $defineProperty,
    "%Object.getPrototypeOf%": $ObjectGPO,
    "%Math.abs%": abs,
    "%Math.floor%": floor,
    "%Math.max%": max,
    "%Math.min%": min,
    "%Math.pow%": pow,
    "%Math.round%": round,
    "%Math.sign%": sign,
    "%Reflect.getPrototypeOf%": $ReflectGPO
  };
  if (getProto) {
    try {
      null.error;
    } catch (e) {
      errorProto = getProto(getProto(e));
      INTRINSICS["%Error.prototype%"] = errorProto;
    }
  }
  var errorProto;
  var doEval = function doEval(name) {
    var value;
    if (name === "%AsyncFunction%") {
      value = getEvalledConstructor("async function () {}");
    } else if (name === "%GeneratorFunction%") {
      value = getEvalledConstructor("function* () {}");
    } else if (name === "%AsyncGeneratorFunction%") {
      value = getEvalledConstructor("async function* () {}");
    } else if (name === "%AsyncGenerator%") {
      var fn = doEval("%AsyncGeneratorFunction%");
      if (fn) {
        value = fn.prototype;
      }
    } else if (name === "%AsyncIteratorPrototype%") {
      var gen = doEval("%AsyncGenerator%");
      if (gen && getProto) {
        value = getProto(gen.prototype);
      }
    }
    INTRINSICS[name] = value;
    return value;
  };
  var LEGACY_ALIASES = {
    __proto__: null,
    "%ArrayBufferPrototype%": ["ArrayBuffer", "prototype"],
    "%ArrayPrototype%": ["Array", "prototype"],
    "%ArrayProto_entries%": ["Array", "prototype", "entries"],
    "%ArrayProto_forEach%": ["Array", "prototype", "forEach"],
    "%ArrayProto_keys%": ["Array", "prototype", "keys"],
    "%ArrayProto_values%": ["Array", "prototype", "values"],
    "%AsyncFunctionPrototype%": ["AsyncFunction", "prototype"],
    "%AsyncGenerator%": ["AsyncGeneratorFunction", "prototype"],
    "%AsyncGeneratorPrototype%": ["AsyncGeneratorFunction", "prototype", "prototype"],
    "%BooleanPrototype%": ["Boolean", "prototype"],
    "%DataViewPrototype%": ["DataView", "prototype"],
    "%DatePrototype%": ["Date", "prototype"],
    "%ErrorPrototype%": ["Error", "prototype"],
    "%EvalErrorPrototype%": ["EvalError", "prototype"],
    "%Float32ArrayPrototype%": ["Float32Array", "prototype"],
    "%Float64ArrayPrototype%": ["Float64Array", "prototype"],
    "%FunctionPrototype%": ["Function", "prototype"],
    "%Generator%": ["GeneratorFunction", "prototype"],
    "%GeneratorPrototype%": ["GeneratorFunction", "prototype", "prototype"],
    "%Int8ArrayPrototype%": ["Int8Array", "prototype"],
    "%Int16ArrayPrototype%": ["Int16Array", "prototype"],
    "%Int32ArrayPrototype%": ["Int32Array", "prototype"],
    "%JSONParse%": ["JSON", "parse"],
    "%JSONStringify%": ["JSON", "stringify"],
    "%MapPrototype%": ["Map", "prototype"],
    "%NumberPrototype%": ["Number", "prototype"],
    "%ObjectPrototype%": ["Object", "prototype"],
    "%ObjProto_toString%": ["Object", "prototype", "toString"],
    "%ObjProto_valueOf%": ["Object", "prototype", "valueOf"],
    "%PromisePrototype%": ["Promise", "prototype"],
    "%PromiseProto_then%": ["Promise", "prototype", "then"],
    "%Promise_all%": ["Promise", "all"],
    "%Promise_reject%": ["Promise", "reject"],
    "%Promise_resolve%": ["Promise", "resolve"],
    "%RangeErrorPrototype%": ["RangeError", "prototype"],
    "%ReferenceErrorPrototype%": ["ReferenceError", "prototype"],
    "%RegExpPrototype%": ["RegExp", "prototype"],
    "%SetPrototype%": ["Set", "prototype"],
    "%SharedArrayBufferPrototype%": ["SharedArrayBuffer", "prototype"],
    "%StringPrototype%": ["String", "prototype"],
    "%SymbolPrototype%": ["Symbol", "prototype"],
    "%SyntaxErrorPrototype%": ["SyntaxError", "prototype"],
    "%TypedArrayPrototype%": ["TypedArray", "prototype"],
    "%TypeErrorPrototype%": ["TypeError", "prototype"],
    "%Uint8ArrayPrototype%": ["Uint8Array", "prototype"],
    "%Uint8ClampedArrayPrototype%": ["Uint8ClampedArray", "prototype"],
    "%Uint16ArrayPrototype%": ["Uint16Array", "prototype"],
    "%Uint32ArrayPrototype%": ["Uint32Array", "prototype"],
    "%URIErrorPrototype%": ["URIError", "prototype"],
    "%WeakMapPrototype%": ["WeakMap", "prototype"],
    "%WeakSetPrototype%": ["WeakSet", "prototype"]
  };
  var bind = require_function_bind();
  var hasOwn = require_hasown();
  var $concat = bind.call($call, Array.prototype.concat);
  var $spliceApply = bind.call($apply, Array.prototype.splice);
  var $replace = bind.call($call, String.prototype.replace);
  var $strSlice = bind.call($call, String.prototype.slice);
  var $exec = bind.call($call, RegExp.prototype.exec);
  var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
  var reEscapeChar = /\\(\\)?/g;
  var stringToPath = function stringToPath(string2) {
    var first = $strSlice(string2, 0, 1);
    var last = $strSlice(string2, -1);
    if (first === "%" && last !== "%") {
      throw new $SyntaxError("invalid intrinsic syntax, expected closing `%`");
    } else if (last === "%" && first !== "%") {
      throw new $SyntaxError("invalid intrinsic syntax, expected opening `%`");
    }
    var result = [];
    $replace(string2, rePropName, function(match, number2, quote, subString) {
      result[result.length] = quote ? $replace(subString, reEscapeChar, "$1") : number2 || match;
    });
    return result;
  };
  var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
    var intrinsicName = name;
    var alias;
    if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
      alias = LEGACY_ALIASES[intrinsicName];
      intrinsicName = "%" + alias[0] + "%";
    }
    if (hasOwn(INTRINSICS, intrinsicName)) {
      var value = INTRINSICS[intrinsicName];
      if (value === needsEval) {
        value = doEval(intrinsicName);
      }
      if (typeof value === "undefined" && !allowMissing) {
        throw new $TypeError("intrinsic " + name + " exists, but is not available. Please file an issue!");
      }
      return {
        alias,
        name: intrinsicName,
        value
      };
    }
    throw new $SyntaxError("intrinsic " + name + " does not exist!");
  };
  module.exports = function GetIntrinsic(name, allowMissing) {
    if (typeof name !== "string" || name.length === 0) {
      throw new $TypeError("intrinsic name must be a non-empty string");
    }
    if (arguments.length > 1 && typeof allowMissing !== "boolean") {
      throw new $TypeError('"allowMissing" argument must be a boolean');
    }
    if ($exec(/^%?[^%]*%?$/, name) === null) {
      throw new $SyntaxError("`%` may not be present anywhere but at the beginning and end of the intrinsic name");
    }
    var parts = stringToPath(name);
    var intrinsicBaseName = parts.length > 0 ? parts[0] : "";
    var intrinsic = getBaseIntrinsic("%" + intrinsicBaseName + "%", allowMissing);
    var intrinsicRealName = intrinsic.name;
    var value = intrinsic.value;
    var skipFurtherCaching = false;
    var alias = intrinsic.alias;
    if (alias) {
      intrinsicBaseName = alias[0];
      $spliceApply(parts, $concat([0, 1], alias));
    }
    for (var i = 1, isOwn = true;i < parts.length; i += 1) {
      var part = parts[i];
      var first = $strSlice(part, 0, 1);
      var last = $strSlice(part, -1);
      if ((first === '"' || first === "'" || first === "`" || (last === '"' || last === "'" || last === "`")) && first !== last) {
        throw new $SyntaxError("property names with quotes must have matching quotes");
      }
      if (part === "constructor" || !isOwn) {
        skipFurtherCaching = true;
      }
      intrinsicBaseName += "." + part;
      intrinsicRealName = "%" + intrinsicBaseName + "%";
      if (hasOwn(INTRINSICS, intrinsicRealName)) {
        value = INTRINSICS[intrinsicRealName];
      } else if (value != null) {
        if (!(part in value)) {
          if (!allowMissing) {
            throw new $TypeError("base intrinsic for " + name + " exists, but the property is not available.");
          }
          return;
        }
        if ($gOPD && i + 1 >= parts.length) {
          var desc = $gOPD(value, part);
          isOwn = !!desc;
          if (isOwn && "get" in desc && !("originalValue" in desc.get)) {
            value = desc.get;
          } else {
            value = value[part];
          }
        } else {
          isOwn = hasOwn(value, part);
          value = value[part];
        }
        if (isOwn && !skipFurtherCaching) {
          INTRINSICS[intrinsicRealName] = value;
        }
      }
    }
    return value;
  };
});

// node_modules/has-tostringtag/shams.js
var require_shams2 = __commonJS((exports, module) => {
  var hasSymbols = require_shams();
  module.exports = function hasToStringTagShams() {
    return hasSymbols() && !!Symbol.toStringTag;
  };
});

// node_modules/es-set-tostringtag/index.js
var require_es_set_tostringtag = __commonJS((exports, module) => {
  var GetIntrinsic = require_get_intrinsic();
  var $defineProperty = GetIntrinsic("%Object.defineProperty%", true);
  var hasToStringTag = require_shams2()();
  var hasOwn = require_hasown();
  var $TypeError = require_type();
  var toStringTag = hasToStringTag ? Symbol.toStringTag : null;
  module.exports = function setToStringTag(object2, value) {
    var overrideIfSet = arguments.length > 2 && !!arguments[2] && arguments[2].force;
    var nonConfigurable = arguments.length > 2 && !!arguments[2] && arguments[2].nonConfigurable;
    if (typeof overrideIfSet !== "undefined" && typeof overrideIfSet !== "boolean" || typeof nonConfigurable !== "undefined" && typeof nonConfigurable !== "boolean") {
      throw new $TypeError("if provided, the `overrideIfSet` and `nonConfigurable` options must be booleans");
    }
    if (toStringTag && (overrideIfSet || !hasOwn(object2, toStringTag))) {
      if ($defineProperty) {
        $defineProperty(object2, toStringTag, {
          configurable: !nonConfigurable,
          enumerable: false,
          value,
          writable: false
        });
      } else {
        object2[toStringTag] = value;
      }
    }
  };
});

// node_modules/form-data/lib/populate.js
var require_populate = __commonJS((exports, module) => {
  module.exports = function(dst, src) {
    Object.keys(src).forEach(function(prop) {
      dst[prop] = dst[prop] || src[prop];
    });
    return dst;
  };
});

// node_modules/form-data/lib/form_data.js
var require_form_data = __commonJS((exports, module) => {
  var CombinedStream = require_combined_stream();
  var util2 = __require("util");
  var path = __require("path");
  var http = __require("http");
  var https = __require("https");
  var parseUrl = __require("url").parse;
  var fs = __require("fs");
  var Stream = __require("stream").Stream;
  var mime = require_mime_types();
  var asynckit = require_asynckit();
  var setToStringTag = require_es_set_tostringtag();
  var populate = require_populate();
  module.exports = FormData2;
  util2.inherits(FormData2, CombinedStream);
  function FormData2(options) {
    if (!(this instanceof FormData2)) {
      return new FormData2(options);
    }
    this._overheadLength = 0;
    this._valueLength = 0;
    this._valuesToMeasure = [];
    CombinedStream.call(this);
    options = options || {};
    for (var option in options) {
      this[option] = options[option];
    }
  }
  FormData2.LINE_BREAK = `\r
`;
  FormData2.DEFAULT_CONTENT_TYPE = "application/octet-stream";
  FormData2.prototype.append = function(field, value, options) {
    options = options || {};
    if (typeof options == "string") {
      options = { filename: options };
    }
    var append = CombinedStream.prototype.append.bind(this);
    if (typeof value == "number") {
      value = "" + value;
    }
    if (Array.isArray(value)) {
      this._error(new Error("Arrays are not supported."));
      return;
    }
    var header = this._multiPartHeader(field, value, options);
    var footer = this._multiPartFooter();
    append(header);
    append(value);
    append(footer);
    this._trackLength(header, value, options);
  };
  FormData2.prototype._trackLength = function(header, value, options) {
    var valueLength = 0;
    if (options.knownLength != null) {
      valueLength += +options.knownLength;
    } else if (Buffer.isBuffer(value)) {
      valueLength = value.length;
    } else if (typeof value === "string") {
      valueLength = Buffer.byteLength(value);
    }
    this._valueLength += valueLength;
    this._overheadLength += Buffer.byteLength(header) + FormData2.LINE_BREAK.length;
    if (!value || !value.path && !(value.readable && Object.prototype.hasOwnProperty.call(value, "httpVersion")) && !(value instanceof Stream)) {
      return;
    }
    if (!options.knownLength) {
      this._valuesToMeasure.push(value);
    }
  };
  FormData2.prototype._lengthRetriever = function(value, callback) {
    if (Object.prototype.hasOwnProperty.call(value, "fd")) {
      if (value.end != null && value.end != Infinity && value.start != null) {
        callback(null, value.end + 1 - (value.start ? value.start : 0));
      } else {
        fs.stat(value.path, function(err, stat) {
          var fileSize;
          if (err) {
            callback(err);
            return;
          }
          fileSize = stat.size - (value.start ? value.start : 0);
          callback(null, fileSize);
        });
      }
    } else if (Object.prototype.hasOwnProperty.call(value, "httpVersion")) {
      callback(null, +value.headers["content-length"]);
    } else if (Object.prototype.hasOwnProperty.call(value, "httpModule")) {
      value.on("response", function(response) {
        value.pause();
        callback(null, +response.headers["content-length"]);
      });
      value.resume();
    } else {
      callback("Unknown stream");
    }
  };
  FormData2.prototype._multiPartHeader = function(field, value, options) {
    if (typeof options.header == "string") {
      return options.header;
    }
    var contentDisposition = this._getContentDisposition(value, options);
    var contentType = this._getContentType(value, options);
    var contents = "";
    var headers = {
      "Content-Disposition": ["form-data", 'name="' + field + '"'].concat(contentDisposition || []),
      "Content-Type": [].concat(contentType || [])
    };
    if (typeof options.header == "object") {
      populate(headers, options.header);
    }
    var header;
    for (var prop in headers) {
      if (Object.prototype.hasOwnProperty.call(headers, prop)) {
        header = headers[prop];
        if (header == null) {
          continue;
        }
        if (!Array.isArray(header)) {
          header = [header];
        }
        if (header.length) {
          contents += prop + ": " + header.join("; ") + FormData2.LINE_BREAK;
        }
      }
    }
    return "--" + this.getBoundary() + FormData2.LINE_BREAK + contents + FormData2.LINE_BREAK;
  };
  FormData2.prototype._getContentDisposition = function(value, options) {
    var filename, contentDisposition;
    if (typeof options.filepath === "string") {
      filename = path.normalize(options.filepath).replace(/\\/g, "/");
    } else if (options.filename || value.name || value.path) {
      filename = path.basename(options.filename || value.name || value.path);
    } else if (value.readable && Object.prototype.hasOwnProperty.call(value, "httpVersion")) {
      filename = path.basename(value.client._httpMessage.path || "");
    }
    if (filename) {
      contentDisposition = 'filename="' + filename + '"';
    }
    return contentDisposition;
  };
  FormData2.prototype._getContentType = function(value, options) {
    var contentType = options.contentType;
    if (!contentType && value.name) {
      contentType = mime.lookup(value.name);
    }
    if (!contentType && value.path) {
      contentType = mime.lookup(value.path);
    }
    if (!contentType && value.readable && Object.prototype.hasOwnProperty.call(value, "httpVersion")) {
      contentType = value.headers["content-type"];
    }
    if (!contentType && (options.filepath || options.filename)) {
      contentType = mime.lookup(options.filepath || options.filename);
    }
    if (!contentType && typeof value == "object") {
      contentType = FormData2.DEFAULT_CONTENT_TYPE;
    }
    return contentType;
  };
  FormData2.prototype._multiPartFooter = function() {
    return function(next) {
      var footer = FormData2.LINE_BREAK;
      var lastPart = this._streams.length === 0;
      if (lastPart) {
        footer += this._lastBoundary();
      }
      next(footer);
    }.bind(this);
  };
  FormData2.prototype._lastBoundary = function() {
    return "--" + this.getBoundary() + "--" + FormData2.LINE_BREAK;
  };
  FormData2.prototype.getHeaders = function(userHeaders) {
    var header;
    var formHeaders = {
      "content-type": "multipart/form-data; boundary=" + this.getBoundary()
    };
    for (header in userHeaders) {
      if (Object.prototype.hasOwnProperty.call(userHeaders, header)) {
        formHeaders[header.toLowerCase()] = userHeaders[header];
      }
    }
    return formHeaders;
  };
  FormData2.prototype.setBoundary = function(boundary) {
    this._boundary = boundary;
  };
  FormData2.prototype.getBoundary = function() {
    if (!this._boundary) {
      this._generateBoundary();
    }
    return this._boundary;
  };
  FormData2.prototype.getBuffer = function() {
    var dataBuffer = new Buffer.alloc(0);
    var boundary = this.getBoundary();
    for (var i = 0, len = this._streams.length;i < len; i++) {
      if (typeof this._streams[i] !== "function") {
        if (Buffer.isBuffer(this._streams[i])) {
          dataBuffer = Buffer.concat([dataBuffer, this._streams[i]]);
        } else {
          dataBuffer = Buffer.concat([dataBuffer, Buffer.from(this._streams[i])]);
        }
        if (typeof this._streams[i] !== "string" || this._streams[i].substring(2, boundary.length + 2) !== boundary) {
          dataBuffer = Buffer.concat([dataBuffer, Buffer.from(FormData2.LINE_BREAK)]);
        }
      }
    }
    return Buffer.concat([dataBuffer, Buffer.from(this._lastBoundary())]);
  };
  FormData2.prototype._generateBoundary = function() {
    var boundary = "--------------------------";
    for (var i = 0;i < 24; i++) {
      boundary += Math.floor(Math.random() * 10).toString(16);
    }
    this._boundary = boundary;
  };
  FormData2.prototype.getLengthSync = function() {
    var knownLength = this._overheadLength + this._valueLength;
    if (this._streams.length) {
      knownLength += this._lastBoundary().length;
    }
    if (!this.hasKnownLength()) {
      this._error(new Error("Cannot calculate proper length in synchronous way."));
    }
    return knownLength;
  };
  FormData2.prototype.hasKnownLength = function() {
    var hasKnownLength = true;
    if (this._valuesToMeasure.length) {
      hasKnownLength = false;
    }
    return hasKnownLength;
  };
  FormData2.prototype.getLength = function(cb) {
    var knownLength = this._overheadLength + this._valueLength;
    if (this._streams.length) {
      knownLength += this._lastBoundary().length;
    }
    if (!this._valuesToMeasure.length) {
      process.nextTick(cb.bind(this, null, knownLength));
      return;
    }
    asynckit.parallel(this._valuesToMeasure, this._lengthRetriever, function(err, values) {
      if (err) {
        cb(err);
        return;
      }
      values.forEach(function(length) {
        knownLength += length;
      });
      cb(null, knownLength);
    });
  };
  FormData2.prototype.submit = function(params, cb) {
    var request, options, defaults = { method: "post" };
    if (typeof params == "string") {
      params = parseUrl(params);
      options = populate({
        port: params.port,
        path: params.pathname,
        host: params.hostname,
        protocol: params.protocol
      }, defaults);
    } else {
      options = populate(params, defaults);
      if (!options.port) {
        options.port = options.protocol == "https:" ? 443 : 80;
      }
    }
    options.headers = this.getHeaders(params.headers);
    if (options.protocol == "https:") {
      request = https.request(options);
    } else {
      request = http.request(options);
    }
    this.getLength(function(err, length) {
      if (err && err !== "Unknown stream") {
        this._error(err);
        return;
      }
      if (length) {
        request.setHeader("Content-Length", length);
      }
      this.pipe(request);
      if (cb) {
        var onResponse;
        var callback = function(error, responce) {
          request.removeListener("error", callback);
          request.removeListener("response", onResponse);
          return cb.call(this, error, responce);
        };
        onResponse = callback.bind(this, null);
        request.on("error", callback);
        request.on("response", onResponse);
      }
    }.bind(this));
    return request;
  };
  FormData2.prototype._error = function(err) {
    if (!this.error) {
      this.error = err;
      this.pause();
      this.emit("error", err);
    }
  };
  FormData2.prototype.toString = function() {
    return "[object FormData]";
  };
  setToStringTag(FormData2, "FormData");
});

// node_modules/proxy-from-env/index.js
var require_proxy_from_env = __commonJS((exports) => {
  var parseUrl = __require("url").parse;
  var DEFAULT_PORTS = {
    ftp: 21,
    gopher: 70,
    http: 80,
    https: 443,
    ws: 80,
    wss: 443
  };
  var stringEndsWith = String.prototype.endsWith || function(s) {
    return s.length <= this.length && this.indexOf(s, this.length - s.length) !== -1;
  };
  function getProxyForUrl(url) {
    var parsedUrl = typeof url === "string" ? parseUrl(url) : url || {};
    var proto = parsedUrl.protocol;
    var hostname = parsedUrl.host;
    var port = parsedUrl.port;
    if (typeof hostname !== "string" || !hostname || typeof proto !== "string") {
      return "";
    }
    proto = proto.split(":", 1)[0];
    hostname = hostname.replace(/:\d*$/, "");
    port = parseInt(port) || DEFAULT_PORTS[proto] || 0;
    if (!shouldProxy(hostname, port)) {
      return "";
    }
    var proxy = getEnv("npm_config_" + proto + "_proxy") || getEnv(proto + "_proxy") || getEnv("npm_config_proxy") || getEnv("all_proxy");
    if (proxy && proxy.indexOf("://") === -1) {
      proxy = proto + "://" + proxy;
    }
    return proxy;
  }
  function shouldProxy(hostname, port) {
    var NO_PROXY = (getEnv("npm_config_no_proxy") || getEnv("no_proxy")).toLowerCase();
    if (!NO_PROXY) {
      return true;
    }
    if (NO_PROXY === "*") {
      return false;
    }
    return NO_PROXY.split(/[,\s]/).every(function(proxy) {
      if (!proxy) {
        return true;
      }
      var parsedProxy = proxy.match(/^(.+):(\d+)$/);
      var parsedProxyHostname = parsedProxy ? parsedProxy[1] : proxy;
      var parsedProxyPort = parsedProxy ? parseInt(parsedProxy[2]) : 0;
      if (parsedProxyPort && parsedProxyPort !== port) {
        return true;
      }
      if (!/^[.*]/.test(parsedProxyHostname)) {
        return hostname !== parsedProxyHostname;
      }
      if (parsedProxyHostname.charAt(0) === "*") {
        parsedProxyHostname = parsedProxyHostname.slice(1);
      }
      return !stringEndsWith.call(hostname, parsedProxyHostname);
    });
  }
  function getEnv(key) {
    return process.env[key.toLowerCase()] || process.env[key.toUpperCase()] || "";
  }
  exports.getProxyForUrl = getProxyForUrl;
});

// node_modules/ms/index.js
var require_ms = __commonJS((exports, module) => {
  var s = 1000;
  var m = s * 60;
  var h = m * 60;
  var d = h * 24;
  var w = d * 7;
  var y = d * 365.25;
  module.exports = function(val, options) {
    options = options || {};
    var type = typeof val;
    if (type === "string" && val.length > 0) {
      return parse(val);
    } else if (type === "number" && isFinite(val)) {
      return options.long ? fmtLong(val) : fmtShort(val);
    }
    throw new Error("val is not a non-empty string or a valid number. val=" + JSON.stringify(val));
  };
  function parse(str) {
    str = String(str);
    if (str.length > 100) {
      return;
    }
    var match = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(str);
    if (!match) {
      return;
    }
    var n = parseFloat(match[1]);
    var type = (match[2] || "ms").toLowerCase();
    switch (type) {
      case "years":
      case "year":
      case "yrs":
      case "yr":
      case "y":
        return n * y;
      case "weeks":
      case "week":
      case "w":
        return n * w;
      case "days":
      case "day":
      case "d":
        return n * d;
      case "hours":
      case "hour":
      case "hrs":
      case "hr":
      case "h":
        return n * h;
      case "minutes":
      case "minute":
      case "mins":
      case "min":
      case "m":
        return n * m;
      case "seconds":
      case "second":
      case "secs":
      case "sec":
      case "s":
        return n * s;
      case "milliseconds":
      case "millisecond":
      case "msecs":
      case "msec":
      case "ms":
        return n;
      default:
        return;
    }
  }
  function fmtShort(ms) {
    var msAbs = Math.abs(ms);
    if (msAbs >= d) {
      return Math.round(ms / d) + "d";
    }
    if (msAbs >= h) {
      return Math.round(ms / h) + "h";
    }
    if (msAbs >= m) {
      return Math.round(ms / m) + "m";
    }
    if (msAbs >= s) {
      return Math.round(ms / s) + "s";
    }
    return ms + "ms";
  }
  function fmtLong(ms) {
    var msAbs = Math.abs(ms);
    if (msAbs >= d) {
      return plural(ms, msAbs, d, "day");
    }
    if (msAbs >= h) {
      return plural(ms, msAbs, h, "hour");
    }
    if (msAbs >= m) {
      return plural(ms, msAbs, m, "minute");
    }
    if (msAbs >= s) {
      return plural(ms, msAbs, s, "second");
    }
    return ms + " ms";
  }
  function plural(ms, msAbs, n, name) {
    var isPlural = msAbs >= n * 1.5;
    return Math.round(ms / n) + " " + name + (isPlural ? "s" : "");
  }
});

// node_modules/debug/src/common.js
var require_common = __commonJS((exports, module) => {
  function setup(env) {
    createDebug.debug = createDebug;
    createDebug.default = createDebug;
    createDebug.coerce = coerce2;
    createDebug.disable = disable;
    createDebug.enable = enable;
    createDebug.enabled = enabled;
    createDebug.humanize = require_ms();
    createDebug.destroy = destroy;
    Object.keys(env).forEach((key) => {
      createDebug[key] = env[key];
    });
    createDebug.names = [];
    createDebug.skips = [];
    createDebug.formatters = {};
    function selectColor(namespace) {
      let hash = 0;
      for (let i = 0;i < namespace.length; i++) {
        hash = (hash << 5) - hash + namespace.charCodeAt(i);
        hash |= 0;
      }
      return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
    }
    createDebug.selectColor = selectColor;
    function createDebug(namespace) {
      let prevTime;
      let enableOverride = null;
      let namespacesCache;
      let enabledCache;
      function debug(...args) {
        if (!debug.enabled) {
          return;
        }
        const self2 = debug;
        const curr = Number(new Date);
        const ms = curr - (prevTime || curr);
        self2.diff = ms;
        self2.prev = prevTime;
        self2.curr = curr;
        prevTime = curr;
        args[0] = createDebug.coerce(args[0]);
        if (typeof args[0] !== "string") {
          args.unshift("%O");
        }
        let index = 0;
        args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
          if (match === "%%") {
            return "%";
          }
          index++;
          const formatter = createDebug.formatters[format];
          if (typeof formatter === "function") {
            const val = args[index];
            match = formatter.call(self2, val);
            args.splice(index, 1);
            index--;
          }
          return match;
        });
        createDebug.formatArgs.call(self2, args);
        const logFn = self2.log || createDebug.log;
        logFn.apply(self2, args);
      }
      debug.namespace = namespace;
      debug.useColors = createDebug.useColors();
      debug.color = createDebug.selectColor(namespace);
      debug.extend = extend;
      debug.destroy = createDebug.destroy;
      Object.defineProperty(debug, "enabled", {
        enumerable: true,
        configurable: false,
        get: () => {
          if (enableOverride !== null) {
            return enableOverride;
          }
          if (namespacesCache !== createDebug.namespaces) {
            namespacesCache = createDebug.namespaces;
            enabledCache = createDebug.enabled(namespace);
          }
          return enabledCache;
        },
        set: (v) => {
          enableOverride = v;
        }
      });
      if (typeof createDebug.init === "function") {
        createDebug.init(debug);
      }
      return debug;
    }
    function extend(namespace, delimiter) {
      const newDebug = createDebug(this.namespace + (typeof delimiter === "undefined" ? ":" : delimiter) + namespace);
      newDebug.log = this.log;
      return newDebug;
    }
    function enable(namespaces) {
      createDebug.save(namespaces);
      createDebug.namespaces = namespaces;
      createDebug.names = [];
      createDebug.skips = [];
      const split = (typeof namespaces === "string" ? namespaces : "").trim().replace(" ", ",").split(",").filter(Boolean);
      for (const ns of split) {
        if (ns[0] === "-") {
          createDebug.skips.push(ns.slice(1));
        } else {
          createDebug.names.push(ns);
        }
      }
    }
    function matchesTemplate(search, template) {
      let searchIndex = 0;
      let templateIndex = 0;
      let starIndex = -1;
      let matchIndex = 0;
      while (searchIndex < search.length) {
        if (templateIndex < template.length && (template[templateIndex] === search[searchIndex] || template[templateIndex] === "*")) {
          if (template[templateIndex] === "*") {
            starIndex = templateIndex;
            matchIndex = searchIndex;
            templateIndex++;
          } else {
            searchIndex++;
            templateIndex++;
          }
        } else if (starIndex !== -1) {
          templateIndex = starIndex + 1;
          matchIndex++;
          searchIndex = matchIndex;
        } else {
          return false;
        }
      }
      while (templateIndex < template.length && template[templateIndex] === "*") {
        templateIndex++;
      }
      return templateIndex === template.length;
    }
    function disable() {
      const namespaces = [
        ...createDebug.names,
        ...createDebug.skips.map((namespace) => "-" + namespace)
      ].join(",");
      createDebug.enable("");
      return namespaces;
    }
    function enabled(name) {
      for (const skip of createDebug.skips) {
        if (matchesTemplate(name, skip)) {
          return false;
        }
      }
      for (const ns of createDebug.names) {
        if (matchesTemplate(name, ns)) {
          return true;
        }
      }
      return false;
    }
    function coerce2(val) {
      if (val instanceof Error) {
        return val.stack || val.message;
      }
      return val;
    }
    function destroy() {
      console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
    }
    createDebug.enable(createDebug.load());
    return createDebug;
  }
  module.exports = setup;
});

// node_modules/debug/src/browser.js
var require_browser = __commonJS((exports, module) => {
  exports.formatArgs = formatArgs;
  exports.save = save;
  exports.load = load;
  exports.useColors = useColors;
  exports.storage = localstorage();
  exports.destroy = (() => {
    let warned = false;
    return () => {
      if (!warned) {
        warned = true;
        console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
      }
    };
  })();
  exports.colors = [
    "#0000CC",
    "#0000FF",
    "#0033CC",
    "#0033FF",
    "#0066CC",
    "#0066FF",
    "#0099CC",
    "#0099FF",
    "#00CC00",
    "#00CC33",
    "#00CC66",
    "#00CC99",
    "#00CCCC",
    "#00CCFF",
    "#3300CC",
    "#3300FF",
    "#3333CC",
    "#3333FF",
    "#3366CC",
    "#3366FF",
    "#3399CC",
    "#3399FF",
    "#33CC00",
    "#33CC33",
    "#33CC66",
    "#33CC99",
    "#33CCCC",
    "#33CCFF",
    "#6600CC",
    "#6600FF",
    "#6633CC",
    "#6633FF",
    "#66CC00",
    "#66CC33",
    "#9900CC",
    "#9900FF",
    "#9933CC",
    "#9933FF",
    "#99CC00",
    "#99CC33",
    "#CC0000",
    "#CC0033",
    "#CC0066",
    "#CC0099",
    "#CC00CC",
    "#CC00FF",
    "#CC3300",
    "#CC3333",
    "#CC3366",
    "#CC3399",
    "#CC33CC",
    "#CC33FF",
    "#CC6600",
    "#CC6633",
    "#CC9900",
    "#CC9933",
    "#CCCC00",
    "#CCCC33",
    "#FF0000",
    "#FF0033",
    "#FF0066",
    "#FF0099",
    "#FF00CC",
    "#FF00FF",
    "#FF3300",
    "#FF3333",
    "#FF3366",
    "#FF3399",
    "#FF33CC",
    "#FF33FF",
    "#FF6600",
    "#FF6633",
    "#FF9900",
    "#FF9933",
    "#FFCC00",
    "#FFCC33"
  ];
  function useColors() {
    if (typeof window !== "undefined" && window.process && (window.process.type === "renderer" || window.process.__nwjs)) {
      return true;
    }
    if (typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
      return false;
    }
    let m;
    return typeof document !== "undefined" && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance || typeof window !== "undefined" && window.console && (window.console.firebug || window.console.exception && window.console.table) || typeof navigator !== "undefined" && navigator.userAgent && (m = navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)) && parseInt(m[1], 10) >= 31 || typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/);
  }
  function formatArgs(args) {
    args[0] = (this.useColors ? "%c" : "") + this.namespace + (this.useColors ? " %c" : " ") + args[0] + (this.useColors ? "%c " : " ") + "+" + module.exports.humanize(this.diff);
    if (!this.useColors) {
      return;
    }
    const c = "color: " + this.color;
    args.splice(1, 0, c, "color: inherit");
    let index = 0;
    let lastC = 0;
    args[0].replace(/%[a-zA-Z%]/g, (match) => {
      if (match === "%%") {
        return;
      }
      index++;
      if (match === "%c") {
        lastC = index;
      }
    });
    args.splice(lastC, 0, c);
  }
  exports.log = console.debug || console.log || (() => {});
  function save(namespaces) {
    try {
      if (namespaces) {
        exports.storage.setItem("debug", namespaces);
      } else {
        exports.storage.removeItem("debug");
      }
    } catch (error) {}
  }
  function load() {
    let r;
    try {
      r = exports.storage.getItem("debug");
    } catch (error) {}
    if (!r && typeof process !== "undefined" && "env" in process) {
      r = process.env.DEBUG;
    }
    return r;
  }
  function localstorage() {
    try {
      return localStorage;
    } catch (error) {}
  }
  module.exports = require_common()(exports);
  var { formatters } = module.exports;
  formatters.j = function(v) {
    try {
      return JSON.stringify(v);
    } catch (error) {
      return "[UnexpectedJSONParseError]: " + error.message;
    }
  };
});

// node_modules/has-flag/index.js
var require_has_flag = __commonJS((exports, module) => {
  module.exports = (flag, argv = process.argv) => {
    const prefix = flag.startsWith("-") ? "" : flag.length === 1 ? "-" : "--";
    const position = argv.indexOf(prefix + flag);
    const terminatorPosition = argv.indexOf("--");
    return position !== -1 && (terminatorPosition === -1 || position < terminatorPosition);
  };
});

// node_modules/supports-color/index.js
var require_supports_color = __commonJS((exports, module) => {
  var os = __require("os");
  var tty = __require("tty");
  var hasFlag = require_has_flag();
  var { env } = process;
  var forceColor;
  if (hasFlag("no-color") || hasFlag("no-colors") || hasFlag("color=false") || hasFlag("color=never")) {
    forceColor = 0;
  } else if (hasFlag("color") || hasFlag("colors") || hasFlag("color=true") || hasFlag("color=always")) {
    forceColor = 1;
  }
  if ("FORCE_COLOR" in env) {
    if (env.FORCE_COLOR === "true") {
      forceColor = 1;
    } else if (env.FORCE_COLOR === "false") {
      forceColor = 0;
    } else {
      forceColor = env.FORCE_COLOR.length === 0 ? 1 : Math.min(parseInt(env.FORCE_COLOR, 10), 3);
    }
  }
  function translateLevel(level) {
    if (level === 0) {
      return false;
    }
    return {
      level,
      hasBasic: true,
      has256: level >= 2,
      has16m: level >= 3
    };
  }
  function supportsColor(haveStream, streamIsTTY) {
    if (forceColor === 0) {
      return 0;
    }
    if (hasFlag("color=16m") || hasFlag("color=full") || hasFlag("color=truecolor")) {
      return 3;
    }
    if (hasFlag("color=256")) {
      return 2;
    }
    if (haveStream && !streamIsTTY && forceColor === undefined) {
      return 0;
    }
    const min = forceColor || 0;
    if (env.TERM === "dumb") {
      return min;
    }
    if (process.platform === "win32") {
      const osRelease = os.release().split(".");
      if (Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
        return Number(osRelease[2]) >= 14931 ? 3 : 2;
      }
      return 1;
    }
    if ("CI" in env) {
      if (["TRAVIS", "CIRCLECI", "APPVEYOR", "GITLAB_CI", "GITHUB_ACTIONS", "BUILDKITE"].some((sign) => (sign in env)) || env.CI_NAME === "codeship") {
        return 1;
      }
      return min;
    }
    if ("TEAMCITY_VERSION" in env) {
      return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION) ? 1 : 0;
    }
    if (env.COLORTERM === "truecolor") {
      return 3;
    }
    if ("TERM_PROGRAM" in env) {
      const version = parseInt((env.TERM_PROGRAM_VERSION || "").split(".")[0], 10);
      switch (env.TERM_PROGRAM) {
        case "iTerm.app":
          return version >= 3 ? 3 : 2;
        case "Apple_Terminal":
          return 2;
      }
    }
    if (/-256(color)?$/i.test(env.TERM)) {
      return 2;
    }
    if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)) {
      return 1;
    }
    if ("COLORTERM" in env) {
      return 1;
    }
    return min;
  }
  function getSupportLevel(stream) {
    const level = supportsColor(stream, stream && stream.isTTY);
    return translateLevel(level);
  }
  module.exports = {
    supportsColor: getSupportLevel,
    stdout: translateLevel(supportsColor(true, tty.isatty(1))),
    stderr: translateLevel(supportsColor(true, tty.isatty(2)))
  };
});

// node_modules/debug/src/node.js
var require_node = __commonJS((exports, module) => {
  var tty = __require("tty");
  var util2 = __require("util");
  exports.init = init;
  exports.log = log;
  exports.formatArgs = formatArgs;
  exports.save = save;
  exports.load = load;
  exports.useColors = useColors;
  exports.destroy = util2.deprecate(() => {}, "Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
  exports.colors = [6, 2, 3, 4, 5, 1];
  try {
    const supportsColor = require_supports_color();
    if (supportsColor && (supportsColor.stderr || supportsColor).level >= 2) {
      exports.colors = [
        20,
        21,
        26,
        27,
        32,
        33,
        38,
        39,
        40,
        41,
        42,
        43,
        44,
        45,
        56,
        57,
        62,
        63,
        68,
        69,
        74,
        75,
        76,
        77,
        78,
        79,
        80,
        81,
        92,
        93,
        98,
        99,
        112,
        113,
        128,
        129,
        134,
        135,
        148,
        149,
        160,
        161,
        162,
        163,
        164,
        165,
        166,
        167,
        168,
        169,
        170,
        171,
        172,
        173,
        178,
        179,
        184,
        185,
        196,
        197,
        198,
        199,
        200,
        201,
        202,
        203,
        204,
        205,
        206,
        207,
        208,
        209,
        214,
        215,
        220,
        221
      ];
    }
  } catch (error) {}
  exports.inspectOpts = Object.keys(process.env).filter((key) => {
    return /^debug_/i.test(key);
  }).reduce((obj2, key) => {
    const prop = key.substring(6).toLowerCase().replace(/_([a-z])/g, (_, k) => {
      return k.toUpperCase();
    });
    let val = process.env[key];
    if (/^(yes|on|true|enabled)$/i.test(val)) {
      val = true;
    } else if (/^(no|off|false|disabled)$/i.test(val)) {
      val = false;
    } else if (val === "null") {
      val = null;
    } else {
      val = Number(val);
    }
    obj2[prop] = val;
    return obj2;
  }, {});
  function useColors() {
    return "colors" in exports.inspectOpts ? Boolean(exports.inspectOpts.colors) : tty.isatty(process.stderr.fd);
  }
  function formatArgs(args) {
    const { namespace: name, useColors: useColors2 } = this;
    if (useColors2) {
      const c = this.color;
      const colorCode = "\x1B[3" + (c < 8 ? c : "8;5;" + c);
      const prefix = `  ${colorCode};1m${name} \x1B[0m`;
      args[0] = prefix + args[0].split(`
`).join(`
` + prefix);
      args.push(colorCode + "m+" + module.exports.humanize(this.diff) + "\x1B[0m");
    } else {
      args[0] = getDate() + name + " " + args[0];
    }
  }
  function getDate() {
    if (exports.inspectOpts.hideDate) {
      return "";
    }
    return new Date().toISOString() + " ";
  }
  function log(...args) {
    return process.stderr.write(util2.formatWithOptions(exports.inspectOpts, ...args) + `
`);
  }
  function save(namespaces) {
    if (namespaces) {
      process.env.DEBUG = namespaces;
    } else {
      delete process.env.DEBUG;
    }
  }
  function load() {
    return process.env.DEBUG;
  }
  function init(debug) {
    debug.inspectOpts = {};
    const keys = Object.keys(exports.inspectOpts);
    for (let i = 0;i < keys.length; i++) {
      debug.inspectOpts[keys[i]] = exports.inspectOpts[keys[i]];
    }
  }
  module.exports = require_common()(exports);
  var { formatters } = module.exports;
  formatters.o = function(v) {
    this.inspectOpts.colors = this.useColors;
    return util2.inspect(v, this.inspectOpts).split(`
`).map((str) => str.trim()).join(" ");
  };
  formatters.O = function(v) {
    this.inspectOpts.colors = this.useColors;
    return util2.inspect(v, this.inspectOpts);
  };
});

// node_modules/debug/src/index.js
var require_src = __commonJS((exports, module) => {
  if (typeof process === "undefined" || process.type === "renderer" || false || process.__nwjs) {
    module.exports = require_browser();
  } else {
    module.exports = require_node();
  }
});

// node_modules/follow-redirects/debug.js
var require_debug = __commonJS((exports, module) => {
  var debug;
  module.exports = function() {
    if (!debug) {
      try {
        debug = require_src()("follow-redirects");
      } catch (error) {}
      if (typeof debug !== "function") {
        debug = function() {};
      }
    }
    debug.apply(null, arguments);
  };
});

// node_modules/follow-redirects/index.js
var require_follow_redirects = __commonJS((exports, module) => {
  var url = __require("url");
  var URL2 = url.URL;
  var http = __require("http");
  var https = __require("https");
  var Writable = __require("stream").Writable;
  var assert = __require("assert");
  var debug = require_debug();
  (function detectUnsupportedEnvironment() {
    var looksLikeNode = typeof process !== "undefined";
    var looksLikeBrowser = typeof window !== "undefined" && typeof document !== "undefined";
    var looksLikeV8 = isFunction(Error.captureStackTrace);
    if (!looksLikeNode && (looksLikeBrowser || !looksLikeV8)) {
      console.warn("The follow-redirects package should be excluded from browser builds.");
    }
  })();
  var useNativeURL = false;
  try {
    assert(new URL2(""));
  } catch (error) {
    useNativeURL = error.code === "ERR_INVALID_URL";
  }
  var preservedUrlFields = [
    "auth",
    "host",
    "hostname",
    "href",
    "path",
    "pathname",
    "port",
    "protocol",
    "query",
    "search",
    "hash"
  ];
  var events = ["abort", "aborted", "connect", "error", "socket", "timeout"];
  var eventHandlers = Object.create(null);
  events.forEach(function(event) {
    eventHandlers[event] = function(arg1, arg2, arg3) {
      this._redirectable.emit(event, arg1, arg2, arg3);
    };
  });
  var InvalidUrlError = createErrorType("ERR_INVALID_URL", "Invalid URL", TypeError);
  var RedirectionError = createErrorType("ERR_FR_REDIRECTION_FAILURE", "Redirected request failed");
  var TooManyRedirectsError = createErrorType("ERR_FR_TOO_MANY_REDIRECTS", "Maximum number of redirects exceeded", RedirectionError);
  var MaxBodyLengthExceededError = createErrorType("ERR_FR_MAX_BODY_LENGTH_EXCEEDED", "Request body larger than maxBodyLength limit");
  var WriteAfterEndError = createErrorType("ERR_STREAM_WRITE_AFTER_END", "write after end");
  var destroy = Writable.prototype.destroy || noop;
  function RedirectableRequest(options, responseCallback) {
    Writable.call(this);
    this._sanitizeOptions(options);
    this._options = options;
    this._ended = false;
    this._ending = false;
    this._redirectCount = 0;
    this._redirects = [];
    this._requestBodyLength = 0;
    this._requestBodyBuffers = [];
    if (responseCallback) {
      this.on("response", responseCallback);
    }
    var self2 = this;
    this._onNativeResponse = function(response) {
      try {
        self2._processResponse(response);
      } catch (cause) {
        self2.emit("error", cause instanceof RedirectionError ? cause : new RedirectionError({ cause }));
      }
    };
    this._performRequest();
  }
  RedirectableRequest.prototype = Object.create(Writable.prototype);
  RedirectableRequest.prototype.abort = function() {
    destroyRequest(this._currentRequest);
    this._currentRequest.abort();
    this.emit("abort");
  };
  RedirectableRequest.prototype.destroy = function(error) {
    destroyRequest(this._currentRequest, error);
    destroy.call(this, error);
    return this;
  };
  RedirectableRequest.prototype.write = function(data, encoding, callback) {
    if (this._ending) {
      throw new WriteAfterEndError;
    }
    if (!isString(data) && !isBuffer(data)) {
      throw new TypeError("data should be a string, Buffer or Uint8Array");
    }
    if (isFunction(encoding)) {
      callback = encoding;
      encoding = null;
    }
    if (data.length === 0) {
      if (callback) {
        callback();
      }
      return;
    }
    if (this._requestBodyLength + data.length <= this._options.maxBodyLength) {
      this._requestBodyLength += data.length;
      this._requestBodyBuffers.push({ data, encoding });
      this._currentRequest.write(data, encoding, callback);
    } else {
      this.emit("error", new MaxBodyLengthExceededError);
      this.abort();
    }
  };
  RedirectableRequest.prototype.end = function(data, encoding, callback) {
    if (isFunction(data)) {
      callback = data;
      data = encoding = null;
    } else if (isFunction(encoding)) {
      callback = encoding;
      encoding = null;
    }
    if (!data) {
      this._ended = this._ending = true;
      this._currentRequest.end(null, null, callback);
    } else {
      var self2 = this;
      var currentRequest = this._currentRequest;
      this.write(data, encoding, function() {
        self2._ended = true;
        currentRequest.end(null, null, callback);
      });
      this._ending = true;
    }
  };
  RedirectableRequest.prototype.setHeader = function(name, value) {
    this._options.headers[name] = value;
    this._currentRequest.setHeader(name, value);
  };
  RedirectableRequest.prototype.removeHeader = function(name) {
    delete this._options.headers[name];
    this._currentRequest.removeHeader(name);
  };
  RedirectableRequest.prototype.setTimeout = function(msecs, callback) {
    var self2 = this;
    function destroyOnTimeout(socket) {
      socket.setTimeout(msecs);
      socket.removeListener("timeout", socket.destroy);
      socket.addListener("timeout", socket.destroy);
    }
    function startTimer(socket) {
      if (self2._timeout) {
        clearTimeout(self2._timeout);
      }
      self2._timeout = setTimeout(function() {
        self2.emit("timeout");
        clearTimer();
      }, msecs);
      destroyOnTimeout(socket);
    }
    function clearTimer() {
      if (self2._timeout) {
        clearTimeout(self2._timeout);
        self2._timeout = null;
      }
      self2.removeListener("abort", clearTimer);
      self2.removeListener("error", clearTimer);
      self2.removeListener("response", clearTimer);
      self2.removeListener("close", clearTimer);
      if (callback) {
        self2.removeListener("timeout", callback);
      }
      if (!self2.socket) {
        self2._currentRequest.removeListener("socket", startTimer);
      }
    }
    if (callback) {
      this.on("timeout", callback);
    }
    if (this.socket) {
      startTimer(this.socket);
    } else {
      this._currentRequest.once("socket", startTimer);
    }
    this.on("socket", destroyOnTimeout);
    this.on("abort", clearTimer);
    this.on("error", clearTimer);
    this.on("response", clearTimer);
    this.on("close", clearTimer);
    return this;
  };
  [
    "flushHeaders",
    "getHeader",
    "setNoDelay",
    "setSocketKeepAlive"
  ].forEach(function(method) {
    RedirectableRequest.prototype[method] = function(a, b) {
      return this._currentRequest[method](a, b);
    };
  });
  ["aborted", "connection", "socket"].forEach(function(property) {
    Object.defineProperty(RedirectableRequest.prototype, property, {
      get: function() {
        return this._currentRequest[property];
      }
    });
  });
  RedirectableRequest.prototype._sanitizeOptions = function(options) {
    if (!options.headers) {
      options.headers = {};
    }
    if (options.host) {
      if (!options.hostname) {
        options.hostname = options.host;
      }
      delete options.host;
    }
    if (!options.pathname && options.path) {
      var searchPos = options.path.indexOf("?");
      if (searchPos < 0) {
        options.pathname = options.path;
      } else {
        options.pathname = options.path.substring(0, searchPos);
        options.search = options.path.substring(searchPos);
      }
    }
  };
  RedirectableRequest.prototype._performRequest = function() {
    var protocol = this._options.protocol;
    var nativeProtocol = this._options.nativeProtocols[protocol];
    if (!nativeProtocol) {
      throw new TypeError("Unsupported protocol " + protocol);
    }
    if (this._options.agents) {
      var scheme = protocol.slice(0, -1);
      this._options.agent = this._options.agents[scheme];
    }
    var request = this._currentRequest = nativeProtocol.request(this._options, this._onNativeResponse);
    request._redirectable = this;
    for (var event of events) {
      request.on(event, eventHandlers[event]);
    }
    this._currentUrl = /^\//.test(this._options.path) ? url.format(this._options) : this._options.path;
    if (this._isRedirect) {
      var i = 0;
      var self2 = this;
      var buffers = this._requestBodyBuffers;
      (function writeNext(error) {
        if (request === self2._currentRequest) {
          if (error) {
            self2.emit("error", error);
          } else if (i < buffers.length) {
            var buffer = buffers[i++];
            if (!request.finished) {
              request.write(buffer.data, buffer.encoding, writeNext);
            }
          } else if (self2._ended) {
            request.end();
          }
        }
      })();
    }
  };
  RedirectableRequest.prototype._processResponse = function(response) {
    var statusCode = response.statusCode;
    if (this._options.trackRedirects) {
      this._redirects.push({
        url: this._currentUrl,
        headers: response.headers,
        statusCode
      });
    }
    var location = response.headers.location;
    if (!location || this._options.followRedirects === false || statusCode < 300 || statusCode >= 400) {
      response.responseUrl = this._currentUrl;
      response.redirects = this._redirects;
      this.emit("response", response);
      this._requestBodyBuffers = [];
      return;
    }
    destroyRequest(this._currentRequest);
    response.destroy();
    if (++this._redirectCount > this._options.maxRedirects) {
      throw new TooManyRedirectsError;
    }
    var requestHeaders;
    var beforeRedirect = this._options.beforeRedirect;
    if (beforeRedirect) {
      requestHeaders = Object.assign({
        Host: response.req.getHeader("host")
      }, this._options.headers);
    }
    var method = this._options.method;
    if ((statusCode === 301 || statusCode === 302) && this._options.method === "POST" || statusCode === 303 && !/^(?:GET|HEAD)$/.test(this._options.method)) {
      this._options.method = "GET";
      this._requestBodyBuffers = [];
      removeMatchingHeaders(/^content-/i, this._options.headers);
    }
    var currentHostHeader = removeMatchingHeaders(/^host$/i, this._options.headers);
    var currentUrlParts = parseUrl(this._currentUrl);
    var currentHost = currentHostHeader || currentUrlParts.host;
    var currentUrl = /^\w+:/.test(location) ? this._currentUrl : url.format(Object.assign(currentUrlParts, { host: currentHost }));
    var redirectUrl = resolveUrl(location, currentUrl);
    debug("redirecting to", redirectUrl.href);
    this._isRedirect = true;
    spreadUrlObject(redirectUrl, this._options);
    if (redirectUrl.protocol !== currentUrlParts.protocol && redirectUrl.protocol !== "https:" || redirectUrl.host !== currentHost && !isSubdomain(redirectUrl.host, currentHost)) {
      removeMatchingHeaders(/^(?:(?:proxy-)?authorization|cookie)$/i, this._options.headers);
    }
    if (isFunction(beforeRedirect)) {
      var responseDetails = {
        headers: response.headers,
        statusCode
      };
      var requestDetails = {
        url: currentUrl,
        method,
        headers: requestHeaders
      };
      beforeRedirect(this._options, responseDetails, requestDetails);
      this._sanitizeOptions(this._options);
    }
    this._performRequest();
  };
  function wrap(protocols) {
    var exports2 = {
      maxRedirects: 21,
      maxBodyLength: 10 * 1024 * 1024
    };
    var nativeProtocols = {};
    Object.keys(protocols).forEach(function(scheme) {
      var protocol = scheme + ":";
      var nativeProtocol = nativeProtocols[protocol] = protocols[scheme];
      var wrappedProtocol = exports2[scheme] = Object.create(nativeProtocol);
      function request(input, options, callback) {
        if (isURL(input)) {
          input = spreadUrlObject(input);
        } else if (isString(input)) {
          input = spreadUrlObject(parseUrl(input));
        } else {
          callback = options;
          options = validateUrl(input);
          input = { protocol };
        }
        if (isFunction(options)) {
          callback = options;
          options = null;
        }
        options = Object.assign({
          maxRedirects: exports2.maxRedirects,
          maxBodyLength: exports2.maxBodyLength
        }, input, options);
        options.nativeProtocols = nativeProtocols;
        if (!isString(options.host) && !isString(options.hostname)) {
          options.hostname = "::1";
        }
        assert.equal(options.protocol, protocol, "protocol mismatch");
        debug("options", options);
        return new RedirectableRequest(options, callback);
      }
      function get(input, options, callback) {
        var wrappedRequest = wrappedProtocol.request(input, options, callback);
        wrappedRequest.end();
        return wrappedRequest;
      }
      Object.defineProperties(wrappedProtocol, {
        request: { value: request, configurable: true, enumerable: true, writable: true },
        get: { value: get, configurable: true, enumerable: true, writable: true }
      });
    });
    return exports2;
  }
  function noop() {}
  function parseUrl(input) {
    var parsed;
    if (useNativeURL) {
      parsed = new URL2(input);
    } else {
      parsed = validateUrl(url.parse(input));
      if (!isString(parsed.protocol)) {
        throw new InvalidUrlError({ input });
      }
    }
    return parsed;
  }
  function resolveUrl(relative, base) {
    return useNativeURL ? new URL2(relative, base) : parseUrl(url.resolve(base, relative));
  }
  function validateUrl(input) {
    if (/^\[/.test(input.hostname) && !/^\[[:0-9a-f]+\]$/i.test(input.hostname)) {
      throw new InvalidUrlError({ input: input.href || input });
    }
    if (/^\[/.test(input.host) && !/^\[[:0-9a-f]+\](:\d+)?$/i.test(input.host)) {
      throw new InvalidUrlError({ input: input.href || input });
    }
    return input;
  }
  function spreadUrlObject(urlObject, target) {
    var spread = target || {};
    for (var key of preservedUrlFields) {
      spread[key] = urlObject[key];
    }
    if (spread.hostname.startsWith("[")) {
      spread.hostname = spread.hostname.slice(1, -1);
    }
    if (spread.port !== "") {
      spread.port = Number(spread.port);
    }
    spread.path = spread.search ? spread.pathname + spread.search : spread.pathname;
    return spread;
  }
  function removeMatchingHeaders(regex, headers) {
    var lastValue;
    for (var header in headers) {
      if (regex.test(header)) {
        lastValue = headers[header];
        delete headers[header];
      }
    }
    return lastValue === null || typeof lastValue === "undefined" ? undefined : String(lastValue).trim();
  }
  function createErrorType(code, message, baseClass) {
    function CustomError(properties) {
      if (isFunction(Error.captureStackTrace)) {
        Error.captureStackTrace(this, this.constructor);
      }
      Object.assign(this, properties || {});
      this.code = code;
      this.message = this.cause ? message + ": " + this.cause.message : message;
    }
    CustomError.prototype = new (baseClass || Error);
    Object.defineProperties(CustomError.prototype, {
      constructor: {
        value: CustomError,
        enumerable: false
      },
      name: {
        value: "Error [" + code + "]",
        enumerable: false
      }
    });
    return CustomError;
  }
  function destroyRequest(request, error) {
    for (var event of events) {
      request.removeListener(event, eventHandlers[event]);
    }
    request.on("error", noop);
    request.destroy(error);
  }
  function isSubdomain(subdomain, domain) {
    assert(isString(subdomain) && isString(domain));
    var dot = subdomain.length - domain.length - 1;
    return dot > 0 && subdomain[dot] === "." && subdomain.endsWith(domain);
  }
  function isString(value) {
    return typeof value === "string" || value instanceof String;
  }
  function isFunction(value) {
    return typeof value === "function";
  }
  function isBuffer(value) {
    return typeof value === "object" && "length" in value;
  }
  function isURL(value) {
    return URL2 && value instanceof URL2;
  }
  module.exports = wrap({ http, https });
  module.exports.wrap = wrap;
});

// node_modules/axios/dist/node/axios.cjs
var require_axios = __commonJS((exports, module) => {
  /*! Axios v1.9.0 Copyright (c) 2025 Matt Zabriskie and contributors */
  var FormData$1 = require_form_data();
  var crypto2 = __require("crypto");
  var url = __require("url");
  var proxyFromEnv = require_proxy_from_env();
  var http = __require("http");
  var https = __require("https");
  var util2 = __require("util");
  var followRedirects = require_follow_redirects();
  var zlib = __require("zlib");
  var stream = __require("stream");
  var events = __require("events");
  function _interopDefaultLegacy(e) {
    return e && typeof e === "object" && "default" in e ? e : { default: e };
  }
  var FormData__default = /* @__PURE__ */ _interopDefaultLegacy(FormData$1);
  var crypto__default = /* @__PURE__ */ _interopDefaultLegacy(crypto2);
  var url__default = /* @__PURE__ */ _interopDefaultLegacy(url);
  var proxyFromEnv__default = /* @__PURE__ */ _interopDefaultLegacy(proxyFromEnv);
  var http__default = /* @__PURE__ */ _interopDefaultLegacy(http);
  var https__default = /* @__PURE__ */ _interopDefaultLegacy(https);
  var util__default = /* @__PURE__ */ _interopDefaultLegacy(util2);
  var followRedirects__default = /* @__PURE__ */ _interopDefaultLegacy(followRedirects);
  var zlib__default = /* @__PURE__ */ _interopDefaultLegacy(zlib);
  var stream__default = /* @__PURE__ */ _interopDefaultLegacy(stream);
  function bind(fn, thisArg) {
    return function wrap() {
      return fn.apply(thisArg, arguments);
    };
  }
  var { toString } = Object.prototype;
  var { getPrototypeOf } = Object;
  var { iterator, toStringTag } = Symbol;
  var kindOf = ((cache) => (thing) => {
    const str = toString.call(thing);
    return cache[str] || (cache[str] = str.slice(8, -1).toLowerCase());
  })(Object.create(null));
  var kindOfTest = (type) => {
    type = type.toLowerCase();
    return (thing) => kindOf(thing) === type;
  };
  var typeOfTest = (type) => (thing) => typeof thing === type;
  var { isArray } = Array;
  var isUndefined = typeOfTest("undefined");
  function isBuffer(val) {
    return val !== null && !isUndefined(val) && val.constructor !== null && !isUndefined(val.constructor) && isFunction(val.constructor.isBuffer) && val.constructor.isBuffer(val);
  }
  var isArrayBuffer = kindOfTest("ArrayBuffer");
  function isArrayBufferView(val) {
    let result;
    if (typeof ArrayBuffer !== "undefined" && ArrayBuffer.isView) {
      result = ArrayBuffer.isView(val);
    } else {
      result = val && val.buffer && isArrayBuffer(val.buffer);
    }
    return result;
  }
  var isString = typeOfTest("string");
  var isFunction = typeOfTest("function");
  var isNumber = typeOfTest("number");
  var isObject = (thing) => thing !== null && typeof thing === "object";
  var isBoolean = (thing) => thing === true || thing === false;
  var isPlainObject = (val) => {
    if (kindOf(val) !== "object") {
      return false;
    }
    const prototype2 = getPrototypeOf(val);
    return (prototype2 === null || prototype2 === Object.prototype || Object.getPrototypeOf(prototype2) === null) && !(toStringTag in val) && !(iterator in val);
  };
  var isDate = kindOfTest("Date");
  var isFile = kindOfTest("File");
  var isBlob = kindOfTest("Blob");
  var isFileList = kindOfTest("FileList");
  var isStream = (val) => isObject(val) && isFunction(val.pipe);
  var isFormData = (thing) => {
    let kind;
    return thing && (typeof FormData === "function" && thing instanceof FormData || isFunction(thing.append) && ((kind = kindOf(thing)) === "formdata" || kind === "object" && isFunction(thing.toString) && thing.toString() === "[object FormData]"));
  };
  var isURLSearchParams = kindOfTest("URLSearchParams");
  var [isReadableStream, isRequest, isResponse, isHeaders] = ["ReadableStream", "Request", "Response", "Headers"].map(kindOfTest);
  var trim = (str) => str.trim ? str.trim() : str.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, "");
  function forEach(obj2, fn, { allOwnKeys = false } = {}) {
    if (obj2 === null || typeof obj2 === "undefined") {
      return;
    }
    let i;
    let l2;
    if (typeof obj2 !== "object") {
      obj2 = [obj2];
    }
    if (isArray(obj2)) {
      for (i = 0, l2 = obj2.length;i < l2; i++) {
        fn.call(null, obj2[i], i, obj2);
      }
    } else {
      const keys = allOwnKeys ? Object.getOwnPropertyNames(obj2) : Object.keys(obj2);
      const len = keys.length;
      let key;
      for (i = 0;i < len; i++) {
        key = keys[i];
        fn.call(null, obj2[key], key, obj2);
      }
    }
  }
  function findKey(obj2, key) {
    key = key.toLowerCase();
    const keys = Object.keys(obj2);
    let i = keys.length;
    let _key;
    while (i-- > 0) {
      _key = keys[i];
      if (key === _key.toLowerCase()) {
        return _key;
      }
    }
    return null;
  }
  var _global = (() => {
    if (typeof globalThis !== "undefined")
      return globalThis;
    return typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : global;
  })();
  var isContextDefined = (context) => !isUndefined(context) && context !== _global;
  function merge() {
    const { caseless } = isContextDefined(this) && this || {};
    const result = {};
    const assignValue = (val, key) => {
      const targetKey = caseless && findKey(result, key) || key;
      if (isPlainObject(result[targetKey]) && isPlainObject(val)) {
        result[targetKey] = merge(result[targetKey], val);
      } else if (isPlainObject(val)) {
        result[targetKey] = merge({}, val);
      } else if (isArray(val)) {
        result[targetKey] = val.slice();
      } else {
        result[targetKey] = val;
      }
    };
    for (let i = 0, l2 = arguments.length;i < l2; i++) {
      arguments[i] && forEach(arguments[i], assignValue);
    }
    return result;
  }
  var extend = (a, b, thisArg, { allOwnKeys } = {}) => {
    forEach(b, (val, key) => {
      if (thisArg && isFunction(val)) {
        a[key] = bind(val, thisArg);
      } else {
        a[key] = val;
      }
    }, { allOwnKeys });
    return a;
  };
  var stripBOM = (content) => {
    if (content.charCodeAt(0) === 65279) {
      content = content.slice(1);
    }
    return content;
  };
  var inherits = (constructor, superConstructor, props, descriptors2) => {
    constructor.prototype = Object.create(superConstructor.prototype, descriptors2);
    constructor.prototype.constructor = constructor;
    Object.defineProperty(constructor, "super", {
      value: superConstructor.prototype
    });
    props && Object.assign(constructor.prototype, props);
  };
  var toFlatObject = (sourceObj, destObj, filter, propFilter) => {
    let props;
    let i;
    let prop;
    const merged = {};
    destObj = destObj || {};
    if (sourceObj == null)
      return destObj;
    do {
      props = Object.getOwnPropertyNames(sourceObj);
      i = props.length;
      while (i-- > 0) {
        prop = props[i];
        if ((!propFilter || propFilter(prop, sourceObj, destObj)) && !merged[prop]) {
          destObj[prop] = sourceObj[prop];
          merged[prop] = true;
        }
      }
      sourceObj = filter !== false && getPrototypeOf(sourceObj);
    } while (sourceObj && (!filter || filter(sourceObj, destObj)) && sourceObj !== Object.prototype);
    return destObj;
  };
  var endsWith = (str, searchString, position) => {
    str = String(str);
    if (position === undefined || position > str.length) {
      position = str.length;
    }
    position -= searchString.length;
    const lastIndex = str.indexOf(searchString, position);
    return lastIndex !== -1 && lastIndex === position;
  };
  var toArray = (thing) => {
    if (!thing)
      return null;
    if (isArray(thing))
      return thing;
    let i = thing.length;
    if (!isNumber(i))
      return null;
    const arr = new Array(i);
    while (i-- > 0) {
      arr[i] = thing[i];
    }
    return arr;
  };
  var isTypedArray = ((TypedArray) => {
    return (thing) => {
      return TypedArray && thing instanceof TypedArray;
    };
  })(typeof Uint8Array !== "undefined" && getPrototypeOf(Uint8Array));
  var forEachEntry = (obj2, fn) => {
    const generator = obj2 && obj2[iterator];
    const _iterator = generator.call(obj2);
    let result;
    while ((result = _iterator.next()) && !result.done) {
      const pair = result.value;
      fn.call(obj2, pair[0], pair[1]);
    }
  };
  var matchAll = (regExp, str) => {
    let matches;
    const arr = [];
    while ((matches = regExp.exec(str)) !== null) {
      arr.push(matches);
    }
    return arr;
  };
  var isHTMLForm = kindOfTest("HTMLFormElement");
  var toCamelCase = (str) => {
    return str.toLowerCase().replace(/[-_\s]([a-z\d])(\w*)/g, function replacer(m, p1, p2) {
      return p1.toUpperCase() + p2;
    });
  };
  var hasOwnProperty = (({ hasOwnProperty: hasOwnProperty2 }) => (obj2, prop) => hasOwnProperty2.call(obj2, prop))(Object.prototype);
  var isRegExp = kindOfTest("RegExp");
  var reduceDescriptors = (obj2, reducer) => {
    const descriptors2 = Object.getOwnPropertyDescriptors(obj2);
    const reducedDescriptors = {};
    forEach(descriptors2, (descriptor, name) => {
      let ret;
      if ((ret = reducer(descriptor, name, obj2)) !== false) {
        reducedDescriptors[name] = ret || descriptor;
      }
    });
    Object.defineProperties(obj2, reducedDescriptors);
  };
  var freezeMethods = (obj2) => {
    reduceDescriptors(obj2, (descriptor, name) => {
      if (isFunction(obj2) && ["arguments", "caller", "callee"].indexOf(name) !== -1) {
        return false;
      }
      const value = obj2[name];
      if (!isFunction(value))
        return;
      descriptor.enumerable = false;
      if ("writable" in descriptor) {
        descriptor.writable = false;
        return;
      }
      if (!descriptor.set) {
        descriptor.set = () => {
          throw Error("Can not rewrite read-only method '" + name + "'");
        };
      }
    });
  };
  var toObjectSet = (arrayOrString, delimiter) => {
    const obj2 = {};
    const define2 = (arr) => {
      arr.forEach((value) => {
        obj2[value] = true;
      });
    };
    isArray(arrayOrString) ? define2(arrayOrString) : define2(String(arrayOrString).split(delimiter));
    return obj2;
  };
  var noop = () => {};
  var toFiniteNumber = (value, defaultValue) => {
    return value != null && Number.isFinite(value = +value) ? value : defaultValue;
  };
  function isSpecCompliantForm(thing) {
    return !!(thing && isFunction(thing.append) && thing[toStringTag] === "FormData" && thing[iterator]);
  }
  var toJSONObject = (obj2) => {
    const stack = new Array(10);
    const visit = (source, i) => {
      if (isObject(source)) {
        if (stack.indexOf(source) >= 0) {
          return;
        }
        if (!("toJSON" in source)) {
          stack[i] = source;
          const target = isArray(source) ? [] : {};
          forEach(source, (value, key) => {
            const reducedValue = visit(value, i + 1);
            !isUndefined(reducedValue) && (target[key] = reducedValue);
          });
          stack[i] = undefined;
          return target;
        }
      }
      return source;
    };
    return visit(obj2, 0);
  };
  var isAsyncFn = kindOfTest("AsyncFunction");
  var isThenable = (thing) => thing && (isObject(thing) || isFunction(thing)) && isFunction(thing.then) && isFunction(thing.catch);
  var _setImmediate = ((setImmediateSupported, postMessageSupported) => {
    if (setImmediateSupported) {
      return setImmediate;
    }
    return postMessageSupported ? ((token, callbacks) => {
      _global.addEventListener("message", ({ source, data }) => {
        if (source === _global && data === token) {
          callbacks.length && callbacks.shift()();
        }
      }, false);
      return (cb) => {
        callbacks.push(cb);
        _global.postMessage(token, "*");
      };
    })(`axios@${Math.random()}`, []) : (cb) => setTimeout(cb);
  })(typeof setImmediate === "function", isFunction(_global.postMessage));
  var asap = typeof queueMicrotask !== "undefined" ? queueMicrotask.bind(_global) : typeof process !== "undefined" && process.nextTick || _setImmediate;
  var isIterable = (thing) => thing != null && isFunction(thing[iterator]);
  var utils$1 = {
    isArray,
    isArrayBuffer,
    isBuffer,
    isFormData,
    isArrayBufferView,
    isString,
    isNumber,
    isBoolean,
    isObject,
    isPlainObject,
    isReadableStream,
    isRequest,
    isResponse,
    isHeaders,
    isUndefined,
    isDate,
    isFile,
    isBlob,
    isRegExp,
    isFunction,
    isStream,
    isURLSearchParams,
    isTypedArray,
    isFileList,
    forEach,
    merge,
    extend,
    trim,
    stripBOM,
    inherits,
    toFlatObject,
    kindOf,
    kindOfTest,
    endsWith,
    toArray,
    forEachEntry,
    matchAll,
    isHTMLForm,
    hasOwnProperty,
    hasOwnProp: hasOwnProperty,
    reduceDescriptors,
    freezeMethods,
    toObjectSet,
    toCamelCase,
    noop,
    toFiniteNumber,
    findKey,
    global: _global,
    isContextDefined,
    isSpecCompliantForm,
    toJSONObject,
    isAsyncFn,
    isThenable,
    setImmediate: _setImmediate,
    asap,
    isIterable
  };
  function AxiosError(message, code, config, request, response) {
    Error.call(this);
    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, this.constructor);
    } else {
      this.stack = new Error().stack;
    }
    this.message = message;
    this.name = "AxiosError";
    code && (this.code = code);
    config && (this.config = config);
    request && (this.request = request);
    if (response) {
      this.response = response;
      this.status = response.status ? response.status : null;
    }
  }
  utils$1.inherits(AxiosError, Error, {
    toJSON: function toJSON() {
      return {
        message: this.message,
        name: this.name,
        description: this.description,
        number: this.number,
        fileName: this.fileName,
        lineNumber: this.lineNumber,
        columnNumber: this.columnNumber,
        stack: this.stack,
        config: utils$1.toJSONObject(this.config),
        code: this.code,
        status: this.status
      };
    }
  });
  var prototype$1 = AxiosError.prototype;
  var descriptors = {};
  [
    "ERR_BAD_OPTION_VALUE",
    "ERR_BAD_OPTION",
    "ECONNABORTED",
    "ETIMEDOUT",
    "ERR_NETWORK",
    "ERR_FR_TOO_MANY_REDIRECTS",
    "ERR_DEPRECATED",
    "ERR_BAD_RESPONSE",
    "ERR_BAD_REQUEST",
    "ERR_CANCELED",
    "ERR_NOT_SUPPORT",
    "ERR_INVALID_URL"
  ].forEach((code) => {
    descriptors[code] = { value: code };
  });
  Object.defineProperties(AxiosError, descriptors);
  Object.defineProperty(prototype$1, "isAxiosError", { value: true });
  AxiosError.from = (error, code, config, request, response, customProps) => {
    const axiosError = Object.create(prototype$1);
    utils$1.toFlatObject(error, axiosError, function filter(obj2) {
      return obj2 !== Error.prototype;
    }, (prop) => {
      return prop !== "isAxiosError";
    });
    AxiosError.call(axiosError, error.message, code, config, request, response);
    axiosError.cause = error;
    axiosError.name = error.name;
    customProps && Object.assign(axiosError, customProps);
    return axiosError;
  };
  function isVisitable(thing) {
    return utils$1.isPlainObject(thing) || utils$1.isArray(thing);
  }
  function removeBrackets(key) {
    return utils$1.endsWith(key, "[]") ? key.slice(0, -2) : key;
  }
  function renderKey(path, key, dots) {
    if (!path)
      return key;
    return path.concat(key).map(function each(token, i) {
      token = removeBrackets(token);
      return !dots && i ? "[" + token + "]" : token;
    }).join(dots ? "." : "");
  }
  function isFlatArray(arr) {
    return utils$1.isArray(arr) && !arr.some(isVisitable);
  }
  var predicates = utils$1.toFlatObject(utils$1, {}, null, function filter(prop) {
    return /^is[A-Z]/.test(prop);
  });
  function toFormData(obj2, formData, options) {
    if (!utils$1.isObject(obj2)) {
      throw new TypeError("target must be an object");
    }
    formData = formData || new (FormData__default["default"] || FormData);
    options = utils$1.toFlatObject(options, {
      metaTokens: true,
      dots: false,
      indexes: false
    }, false, function defined(option, source) {
      return !utils$1.isUndefined(source[option]);
    });
    const metaTokens = options.metaTokens;
    const visitor = options.visitor || defaultVisitor;
    const dots = options.dots;
    const indexes = options.indexes;
    const _Blob = options.Blob || typeof Blob !== "undefined" && Blob;
    const useBlob = _Blob && utils$1.isSpecCompliantForm(formData);
    if (!utils$1.isFunction(visitor)) {
      throw new TypeError("visitor must be a function");
    }
    function convertValue(value) {
      if (value === null)
        return "";
      if (utils$1.isDate(value)) {
        return value.toISOString();
      }
      if (!useBlob && utils$1.isBlob(value)) {
        throw new AxiosError("Blob is not supported. Use a Buffer instead.");
      }
      if (utils$1.isArrayBuffer(value) || utils$1.isTypedArray(value)) {
        return useBlob && typeof Blob === "function" ? new Blob([value]) : Buffer.from(value);
      }
      return value;
    }
    function defaultVisitor(value, key, path) {
      let arr = value;
      if (value && !path && typeof value === "object") {
        if (utils$1.endsWith(key, "{}")) {
          key = metaTokens ? key : key.slice(0, -2);
          value = JSON.stringify(value);
        } else if (utils$1.isArray(value) && isFlatArray(value) || (utils$1.isFileList(value) || utils$1.endsWith(key, "[]")) && (arr = utils$1.toArray(value))) {
          key = removeBrackets(key);
          arr.forEach(function each(el, index) {
            !(utils$1.isUndefined(el) || el === null) && formData.append(indexes === true ? renderKey([key], index, dots) : indexes === null ? key : key + "[]", convertValue(el));
          });
          return false;
        }
      }
      if (isVisitable(value)) {
        return true;
      }
      formData.append(renderKey(path, key, dots), convertValue(value));
      return false;
    }
    const stack = [];
    const exposedHelpers = Object.assign(predicates, {
      defaultVisitor,
      convertValue,
      isVisitable
    });
    function build(value, path) {
      if (utils$1.isUndefined(value))
        return;
      if (stack.indexOf(value) !== -1) {
        throw Error("Circular reference detected in " + path.join("."));
      }
      stack.push(value);
      utils$1.forEach(value, function each(el, key) {
        const result = !(utils$1.isUndefined(el) || el === null) && visitor.call(formData, el, utils$1.isString(key) ? key.trim() : key, path, exposedHelpers);
        if (result === true) {
          build(el, path ? path.concat(key) : [key]);
        }
      });
      stack.pop();
    }
    if (!utils$1.isObject(obj2)) {
      throw new TypeError("data must be an object");
    }
    build(obj2);
    return formData;
  }
  function encode$1(str) {
    const charMap = {
      "!": "%21",
      "'": "%27",
      "(": "%28",
      ")": "%29",
      "~": "%7E",
      "%20": "+",
      "%00": "\x00"
    };
    return encodeURIComponent(str).replace(/[!'()~]|%20|%00/g, function replacer(match) {
      return charMap[match];
    });
  }
  function AxiosURLSearchParams(params, options) {
    this._pairs = [];
    params && toFormData(params, this, options);
  }
  var prototype = AxiosURLSearchParams.prototype;
  prototype.append = function append(name, value) {
    this._pairs.push([name, value]);
  };
  prototype.toString = function toString(encoder) {
    const _encode = encoder ? function(value) {
      return encoder.call(this, value, encode$1);
    } : encode$1;
    return this._pairs.map(function each(pair) {
      return _encode(pair[0]) + "=" + _encode(pair[1]);
    }, "").join("&");
  };
  function encode(val) {
    return encodeURIComponent(val).replace(/%3A/gi, ":").replace(/%24/g, "$").replace(/%2C/gi, ",").replace(/%20/g, "+").replace(/%5B/gi, "[").replace(/%5D/gi, "]");
  }
  function buildURL(url2, params, options) {
    if (!params) {
      return url2;
    }
    const _encode = options && options.encode || encode;
    if (utils$1.isFunction(options)) {
      options = {
        serialize: options
      };
    }
    const serializeFn = options && options.serialize;
    let serializedParams;
    if (serializeFn) {
      serializedParams = serializeFn(params, options);
    } else {
      serializedParams = utils$1.isURLSearchParams(params) ? params.toString() : new AxiosURLSearchParams(params, options).toString(_encode);
    }
    if (serializedParams) {
      const hashmarkIndex = url2.indexOf("#");
      if (hashmarkIndex !== -1) {
        url2 = url2.slice(0, hashmarkIndex);
      }
      url2 += (url2.indexOf("?") === -1 ? "?" : "&") + serializedParams;
    }
    return url2;
  }

  class InterceptorManager {
    constructor() {
      this.handlers = [];
    }
    use(fulfilled, rejected, options) {
      this.handlers.push({
        fulfilled,
        rejected,
        synchronous: options ? options.synchronous : false,
        runWhen: options ? options.runWhen : null
      });
      return this.handlers.length - 1;
    }
    eject(id) {
      if (this.handlers[id]) {
        this.handlers[id] = null;
      }
    }
    clear() {
      if (this.handlers) {
        this.handlers = [];
      }
    }
    forEach(fn) {
      utils$1.forEach(this.handlers, function forEachHandler(h) {
        if (h !== null) {
          fn(h);
        }
      });
    }
  }
  var InterceptorManager$1 = InterceptorManager;
  var transitionalDefaults = {
    silentJSONParsing: true,
    forcedJSONParsing: true,
    clarifyTimeoutError: false
  };
  var URLSearchParams2 = url__default["default"].URLSearchParams;
  var ALPHA = "abcdefghijklmnopqrstuvwxyz";
  var DIGIT = "0123456789";
  var ALPHABET = {
    DIGIT,
    ALPHA,
    ALPHA_DIGIT: ALPHA + ALPHA.toUpperCase() + DIGIT
  };
  var generateString = (size = 16, alphabet = ALPHABET.ALPHA_DIGIT) => {
    let str = "";
    const { length } = alphabet;
    const randomValues = new Uint32Array(size);
    crypto__default["default"].randomFillSync(randomValues);
    for (let i = 0;i < size; i++) {
      str += alphabet[randomValues[i] % length];
    }
    return str;
  };
  var platform$1 = {
    isNode: true,
    classes: {
      URLSearchParams: URLSearchParams2,
      FormData: FormData__default["default"],
      Blob: typeof Blob !== "undefined" && Blob || null
    },
    ALPHABET,
    generateString,
    protocols: ["http", "https", "file", "data"]
  };
  var hasBrowserEnv = typeof window !== "undefined" && typeof document !== "undefined";
  var _navigator = typeof navigator === "object" && navigator || undefined;
  var hasStandardBrowserEnv = hasBrowserEnv && (!_navigator || ["ReactNative", "NativeScript", "NS"].indexOf(_navigator.product) < 0);
  var hasStandardBrowserWebWorkerEnv = (() => {
    return typeof WorkerGlobalScope !== "undefined" && self instanceof WorkerGlobalScope && typeof self.importScripts === "function";
  })();
  var origin = hasBrowserEnv && window.location.href || "http://localhost";
  var utils = /* @__PURE__ */ Object.freeze({
    __proto__: null,
    hasBrowserEnv,
    hasStandardBrowserWebWorkerEnv,
    hasStandardBrowserEnv,
    navigator: _navigator,
    origin
  });
  var platform = {
    ...utils,
    ...platform$1
  };
  function toURLEncodedForm(data, options) {
    return toFormData(data, new platform.classes.URLSearchParams, Object.assign({
      visitor: function(value, key, path, helpers) {
        if (platform.isNode && utils$1.isBuffer(value)) {
          this.append(key, value.toString("base64"));
          return false;
        }
        return helpers.defaultVisitor.apply(this, arguments);
      }
    }, options));
  }
  function parsePropPath(name) {
    return utils$1.matchAll(/\w+|\[(\w*)]/g, name).map((match) => {
      return match[0] === "[]" ? "" : match[1] || match[0];
    });
  }
  function arrayToObject(arr) {
    const obj2 = {};
    const keys = Object.keys(arr);
    let i;
    const len = keys.length;
    let key;
    for (i = 0;i < len; i++) {
      key = keys[i];
      obj2[key] = arr[key];
    }
    return obj2;
  }
  function formDataToJSON(formData) {
    function buildPath(path, value, target, index) {
      let name = path[index++];
      if (name === "__proto__")
        return true;
      const isNumericKey = Number.isFinite(+name);
      const isLast = index >= path.length;
      name = !name && utils$1.isArray(target) ? target.length : name;
      if (isLast) {
        if (utils$1.hasOwnProp(target, name)) {
          target[name] = [target[name], value];
        } else {
          target[name] = value;
        }
        return !isNumericKey;
      }
      if (!target[name] || !utils$1.isObject(target[name])) {
        target[name] = [];
      }
      const result = buildPath(path, value, target[name], index);
      if (result && utils$1.isArray(target[name])) {
        target[name] = arrayToObject(target[name]);
      }
      return !isNumericKey;
    }
    if (utils$1.isFormData(formData) && utils$1.isFunction(formData.entries)) {
      const obj2 = {};
      utils$1.forEachEntry(formData, (name, value) => {
        buildPath(parsePropPath(name), value, obj2, 0);
      });
      return obj2;
    }
    return null;
  }
  function stringifySafely(rawValue, parser, encoder) {
    if (utils$1.isString(rawValue)) {
      try {
        (parser || JSON.parse)(rawValue);
        return utils$1.trim(rawValue);
      } catch (e) {
        if (e.name !== "SyntaxError") {
          throw e;
        }
      }
    }
    return (encoder || JSON.stringify)(rawValue);
  }
  var defaults = {
    transitional: transitionalDefaults,
    adapter: ["xhr", "http", "fetch"],
    transformRequest: [function transformRequest(data, headers) {
      const contentType = headers.getContentType() || "";
      const hasJSONContentType = contentType.indexOf("application/json") > -1;
      const isObjectPayload = utils$1.isObject(data);
      if (isObjectPayload && utils$1.isHTMLForm(data)) {
        data = new FormData(data);
      }
      const isFormData2 = utils$1.isFormData(data);
      if (isFormData2) {
        return hasJSONContentType ? JSON.stringify(formDataToJSON(data)) : data;
      }
      if (utils$1.isArrayBuffer(data) || utils$1.isBuffer(data) || utils$1.isStream(data) || utils$1.isFile(data) || utils$1.isBlob(data) || utils$1.isReadableStream(data)) {
        return data;
      }
      if (utils$1.isArrayBufferView(data)) {
        return data.buffer;
      }
      if (utils$1.isURLSearchParams(data)) {
        headers.setContentType("application/x-www-form-urlencoded;charset=utf-8", false);
        return data.toString();
      }
      let isFileList2;
      if (isObjectPayload) {
        if (contentType.indexOf("application/x-www-form-urlencoded") > -1) {
          return toURLEncodedForm(data, this.formSerializer).toString();
        }
        if ((isFileList2 = utils$1.isFileList(data)) || contentType.indexOf("multipart/form-data") > -1) {
          const _FormData = this.env && this.env.FormData;
          return toFormData(isFileList2 ? { "files[]": data } : data, _FormData && new _FormData, this.formSerializer);
        }
      }
      if (isObjectPayload || hasJSONContentType) {
        headers.setContentType("application/json", false);
        return stringifySafely(data);
      }
      return data;
    }],
    transformResponse: [function transformResponse(data) {
      const transitional = this.transitional || defaults.transitional;
      const forcedJSONParsing = transitional && transitional.forcedJSONParsing;
      const JSONRequested = this.responseType === "json";
      if (utils$1.isResponse(data) || utils$1.isReadableStream(data)) {
        return data;
      }
      if (data && utils$1.isString(data) && (forcedJSONParsing && !this.responseType || JSONRequested)) {
        const silentJSONParsing = transitional && transitional.silentJSONParsing;
        const strictJSONParsing = !silentJSONParsing && JSONRequested;
        try {
          return JSON.parse(data);
        } catch (e) {
          if (strictJSONParsing) {
            if (e.name === "SyntaxError") {
              throw AxiosError.from(e, AxiosError.ERR_BAD_RESPONSE, this, null, this.response);
            }
            throw e;
          }
        }
      }
      return data;
    }],
    timeout: 0,
    xsrfCookieName: "XSRF-TOKEN",
    xsrfHeaderName: "X-XSRF-TOKEN",
    maxContentLength: -1,
    maxBodyLength: -1,
    env: {
      FormData: platform.classes.FormData,
      Blob: platform.classes.Blob
    },
    validateStatus: function validateStatus(status) {
      return status >= 200 && status < 300;
    },
    headers: {
      common: {
        Accept: "application/json, text/plain, */*",
        "Content-Type": undefined
      }
    }
  };
  utils$1.forEach(["delete", "get", "head", "post", "put", "patch"], (method) => {
    defaults.headers[method] = {};
  });
  var defaults$1 = defaults;
  var ignoreDuplicateOf = utils$1.toObjectSet([
    "age",
    "authorization",
    "content-length",
    "content-type",
    "etag",
    "expires",
    "from",
    "host",
    "if-modified-since",
    "if-unmodified-since",
    "last-modified",
    "location",
    "max-forwards",
    "proxy-authorization",
    "referer",
    "retry-after",
    "user-agent"
  ]);
  var parseHeaders = (rawHeaders) => {
    const parsed = {};
    let key;
    let val;
    let i;
    rawHeaders && rawHeaders.split(`
`).forEach(function parser(line) {
      i = line.indexOf(":");
      key = line.substring(0, i).trim().toLowerCase();
      val = line.substring(i + 1).trim();
      if (!key || parsed[key] && ignoreDuplicateOf[key]) {
        return;
      }
      if (key === "set-cookie") {
        if (parsed[key]) {
          parsed[key].push(val);
        } else {
          parsed[key] = [val];
        }
      } else {
        parsed[key] = parsed[key] ? parsed[key] + ", " + val : val;
      }
    });
    return parsed;
  };
  var $internals = Symbol("internals");
  function normalizeHeader(header) {
    return header && String(header).trim().toLowerCase();
  }
  function normalizeValue(value) {
    if (value === false || value == null) {
      return value;
    }
    return utils$1.isArray(value) ? value.map(normalizeValue) : String(value);
  }
  function parseTokens(str) {
    const tokens = Object.create(null);
    const tokensRE = /([^\s,;=]+)\s*(?:=\s*([^,;]+))?/g;
    let match;
    while (match = tokensRE.exec(str)) {
      tokens[match[1]] = match[2];
    }
    return tokens;
  }
  var isValidHeaderName = (str) => /^[-_a-zA-Z0-9^`|~,!#$%&'*+.]+$/.test(str.trim());
  function matchHeaderValue(context, value, header, filter, isHeaderNameFilter) {
    if (utils$1.isFunction(filter)) {
      return filter.call(this, value, header);
    }
    if (isHeaderNameFilter) {
      value = header;
    }
    if (!utils$1.isString(value))
      return;
    if (utils$1.isString(filter)) {
      return value.indexOf(filter) !== -1;
    }
    if (utils$1.isRegExp(filter)) {
      return filter.test(value);
    }
  }
  function formatHeader(header) {
    return header.trim().toLowerCase().replace(/([a-z\d])(\w*)/g, (w, char, str) => {
      return char.toUpperCase() + str;
    });
  }
  function buildAccessors(obj2, header) {
    const accessorName = utils$1.toCamelCase(" " + header);
    ["get", "set", "has"].forEach((methodName) => {
      Object.defineProperty(obj2, methodName + accessorName, {
        value: function(arg1, arg2, arg3) {
          return this[methodName].call(this, header, arg1, arg2, arg3);
        },
        configurable: true
      });
    });
  }

  class AxiosHeaders {
    constructor(headers) {
      headers && this.set(headers);
    }
    set(header, valueOrRewrite, rewrite) {
      const self2 = this;
      function setHeader(_value, _header, _rewrite) {
        const lHeader = normalizeHeader(_header);
        if (!lHeader) {
          throw new Error("header name must be a non-empty string");
        }
        const key = utils$1.findKey(self2, lHeader);
        if (!key || self2[key] === undefined || _rewrite === true || _rewrite === undefined && self2[key] !== false) {
          self2[key || _header] = normalizeValue(_value);
        }
      }
      const setHeaders = (headers, _rewrite) => utils$1.forEach(headers, (_value, _header) => setHeader(_value, _header, _rewrite));
      if (utils$1.isPlainObject(header) || header instanceof this.constructor) {
        setHeaders(header, valueOrRewrite);
      } else if (utils$1.isString(header) && (header = header.trim()) && !isValidHeaderName(header)) {
        setHeaders(parseHeaders(header), valueOrRewrite);
      } else if (utils$1.isObject(header) && utils$1.isIterable(header)) {
        let obj2 = {}, dest, key;
        for (const entry of header) {
          if (!utils$1.isArray(entry)) {
            throw TypeError("Object iterator must return a key-value pair");
          }
          obj2[key = entry[0]] = (dest = obj2[key]) ? utils$1.isArray(dest) ? [...dest, entry[1]] : [dest, entry[1]] : entry[1];
        }
        setHeaders(obj2, valueOrRewrite);
      } else {
        header != null && setHeader(valueOrRewrite, header, rewrite);
      }
      return this;
    }
    get(header, parser) {
      header = normalizeHeader(header);
      if (header) {
        const key = utils$1.findKey(this, header);
        if (key) {
          const value = this[key];
          if (!parser) {
            return value;
          }
          if (parser === true) {
            return parseTokens(value);
          }
          if (utils$1.isFunction(parser)) {
            return parser.call(this, value, key);
          }
          if (utils$1.isRegExp(parser)) {
            return parser.exec(value);
          }
          throw new TypeError("parser must be boolean|regexp|function");
        }
      }
    }
    has(header, matcher) {
      header = normalizeHeader(header);
      if (header) {
        const key = utils$1.findKey(this, header);
        return !!(key && this[key] !== undefined && (!matcher || matchHeaderValue(this, this[key], key, matcher)));
      }
      return false;
    }
    delete(header, matcher) {
      const self2 = this;
      let deleted = false;
      function deleteHeader(_header) {
        _header = normalizeHeader(_header);
        if (_header) {
          const key = utils$1.findKey(self2, _header);
          if (key && (!matcher || matchHeaderValue(self2, self2[key], key, matcher))) {
            delete self2[key];
            deleted = true;
          }
        }
      }
      if (utils$1.isArray(header)) {
        header.forEach(deleteHeader);
      } else {
        deleteHeader(header);
      }
      return deleted;
    }
    clear(matcher) {
      const keys = Object.keys(this);
      let i = keys.length;
      let deleted = false;
      while (i--) {
        const key = keys[i];
        if (!matcher || matchHeaderValue(this, this[key], key, matcher, true)) {
          delete this[key];
          deleted = true;
        }
      }
      return deleted;
    }
    normalize(format) {
      const self2 = this;
      const headers = {};
      utils$1.forEach(this, (value, header) => {
        const key = utils$1.findKey(headers, header);
        if (key) {
          self2[key] = normalizeValue(value);
          delete self2[header];
          return;
        }
        const normalized = format ? formatHeader(header) : String(header).trim();
        if (normalized !== header) {
          delete self2[header];
        }
        self2[normalized] = normalizeValue(value);
        headers[normalized] = true;
      });
      return this;
    }
    concat(...targets) {
      return this.constructor.concat(this, ...targets);
    }
    toJSON(asStrings) {
      const obj2 = Object.create(null);
      utils$1.forEach(this, (value, header) => {
        value != null && value !== false && (obj2[header] = asStrings && utils$1.isArray(value) ? value.join(", ") : value);
      });
      return obj2;
    }
    [Symbol.iterator]() {
      return Object.entries(this.toJSON())[Symbol.iterator]();
    }
    toString() {
      return Object.entries(this.toJSON()).map(([header, value]) => header + ": " + value).join(`
`);
    }
    getSetCookie() {
      return this.get("set-cookie") || [];
    }
    get [Symbol.toStringTag]() {
      return "AxiosHeaders";
    }
    static from(thing) {
      return thing instanceof this ? thing : new this(thing);
    }
    static concat(first, ...targets) {
      const computed = new this(first);
      targets.forEach((target) => computed.set(target));
      return computed;
    }
    static accessor(header) {
      const internals = this[$internals] = this[$internals] = {
        accessors: {}
      };
      const accessors = internals.accessors;
      const prototype2 = this.prototype;
      function defineAccessor(_header) {
        const lHeader = normalizeHeader(_header);
        if (!accessors[lHeader]) {
          buildAccessors(prototype2, _header);
          accessors[lHeader] = true;
        }
      }
      utils$1.isArray(header) ? header.forEach(defineAccessor) : defineAccessor(header);
      return this;
    }
  }
  AxiosHeaders.accessor(["Content-Type", "Content-Length", "Accept", "Accept-Encoding", "User-Agent", "Authorization"]);
  utils$1.reduceDescriptors(AxiosHeaders.prototype, ({ value }, key) => {
    let mapped = key[0].toUpperCase() + key.slice(1);
    return {
      get: () => value,
      set(headerValue) {
        this[mapped] = headerValue;
      }
    };
  });
  utils$1.freezeMethods(AxiosHeaders);
  var AxiosHeaders$1 = AxiosHeaders;
  function transformData(fns, response) {
    const config = this || defaults$1;
    const context = response || config;
    const headers = AxiosHeaders$1.from(context.headers);
    let data = context.data;
    utils$1.forEach(fns, function transform(fn) {
      data = fn.call(config, data, headers.normalize(), response ? response.status : undefined);
    });
    headers.normalize();
    return data;
  }
  function isCancel(value) {
    return !!(value && value.__CANCEL__);
  }
  function CanceledError(message, config, request) {
    AxiosError.call(this, message == null ? "canceled" : message, AxiosError.ERR_CANCELED, config, request);
    this.name = "CanceledError";
  }
  utils$1.inherits(CanceledError, AxiosError, {
    __CANCEL__: true
  });
  function settle(resolve, reject, response) {
    const validateStatus = response.config.validateStatus;
    if (!response.status || !validateStatus || validateStatus(response.status)) {
      resolve(response);
    } else {
      reject(new AxiosError("Request failed with status code " + response.status, [AxiosError.ERR_BAD_REQUEST, AxiosError.ERR_BAD_RESPONSE][Math.floor(response.status / 100) - 4], response.config, response.request, response));
    }
  }
  function isAbsoluteURL(url2) {
    return /^([a-z][a-z\d+\-.]*:)?\/\//i.test(url2);
  }
  function combineURLs(baseURL, relativeURL) {
    return relativeURL ? baseURL.replace(/\/?\/$/, "") + "/" + relativeURL.replace(/^\/+/, "") : baseURL;
  }
  function buildFullPath(baseURL, requestedURL, allowAbsoluteUrls) {
    let isRelativeUrl = !isAbsoluteURL(requestedURL);
    if (baseURL && (isRelativeUrl || allowAbsoluteUrls == false)) {
      return combineURLs(baseURL, requestedURL);
    }
    return requestedURL;
  }
  var VERSION = "1.9.0";
  function parseProtocol(url2) {
    const match = /^([-+\w]{1,25})(:?\/\/|:)/.exec(url2);
    return match && match[1] || "";
  }
  var DATA_URL_PATTERN = /^(?:([^;]+);)?(?:[^;]+;)?(base64|),([\s\S]*)$/;
  function fromDataURI(uri, asBlob, options) {
    const _Blob = options && options.Blob || platform.classes.Blob;
    const protocol = parseProtocol(uri);
    if (asBlob === undefined && _Blob) {
      asBlob = true;
    }
    if (protocol === "data") {
      uri = protocol.length ? uri.slice(protocol.length + 1) : uri;
      const match = DATA_URL_PATTERN.exec(uri);
      if (!match) {
        throw new AxiosError("Invalid URL", AxiosError.ERR_INVALID_URL);
      }
      const mime = match[1];
      const isBase64 = match[2];
      const body = match[3];
      const buffer = Buffer.from(decodeURIComponent(body), isBase64 ? "base64" : "utf8");
      if (asBlob) {
        if (!_Blob) {
          throw new AxiosError("Blob is not supported", AxiosError.ERR_NOT_SUPPORT);
        }
        return new _Blob([buffer], { type: mime });
      }
      return buffer;
    }
    throw new AxiosError("Unsupported protocol " + protocol, AxiosError.ERR_NOT_SUPPORT);
  }
  var kInternals = Symbol("internals");

  class AxiosTransformStream extends stream__default["default"].Transform {
    constructor(options) {
      options = utils$1.toFlatObject(options, {
        maxRate: 0,
        chunkSize: 64 * 1024,
        minChunkSize: 100,
        timeWindow: 500,
        ticksRate: 2,
        samplesCount: 15
      }, null, (prop, source) => {
        return !utils$1.isUndefined(source[prop]);
      });
      super({
        readableHighWaterMark: options.chunkSize
      });
      const internals = this[kInternals] = {
        timeWindow: options.timeWindow,
        chunkSize: options.chunkSize,
        maxRate: options.maxRate,
        minChunkSize: options.minChunkSize,
        bytesSeen: 0,
        isCaptured: false,
        notifiedBytesLoaded: 0,
        ts: Date.now(),
        bytes: 0,
        onReadCallback: null
      };
      this.on("newListener", (event) => {
        if (event === "progress") {
          if (!internals.isCaptured) {
            internals.isCaptured = true;
          }
        }
      });
    }
    _read(size) {
      const internals = this[kInternals];
      if (internals.onReadCallback) {
        internals.onReadCallback();
      }
      return super._read(size);
    }
    _transform(chunk, encoding, callback) {
      const internals = this[kInternals];
      const maxRate = internals.maxRate;
      const readableHighWaterMark = this.readableHighWaterMark;
      const timeWindow = internals.timeWindow;
      const divider = 1000 / timeWindow;
      const bytesThreshold = maxRate / divider;
      const minChunkSize = internals.minChunkSize !== false ? Math.max(internals.minChunkSize, bytesThreshold * 0.01) : 0;
      const pushChunk = (_chunk, _callback) => {
        const bytes = Buffer.byteLength(_chunk);
        internals.bytesSeen += bytes;
        internals.bytes += bytes;
        internals.isCaptured && this.emit("progress", internals.bytesSeen);
        if (this.push(_chunk)) {
          process.nextTick(_callback);
        } else {
          internals.onReadCallback = () => {
            internals.onReadCallback = null;
            process.nextTick(_callback);
          };
        }
      };
      const transformChunk = (_chunk, _callback) => {
        const chunkSize = Buffer.byteLength(_chunk);
        let chunkRemainder = null;
        let maxChunkSize = readableHighWaterMark;
        let bytesLeft;
        let passed = 0;
        if (maxRate) {
          const now = Date.now();
          if (!internals.ts || (passed = now - internals.ts) >= timeWindow) {
            internals.ts = now;
            bytesLeft = bytesThreshold - internals.bytes;
            internals.bytes = bytesLeft < 0 ? -bytesLeft : 0;
            passed = 0;
          }
          bytesLeft = bytesThreshold - internals.bytes;
        }
        if (maxRate) {
          if (bytesLeft <= 0) {
            return setTimeout(() => {
              _callback(null, _chunk);
            }, timeWindow - passed);
          }
          if (bytesLeft < maxChunkSize) {
            maxChunkSize = bytesLeft;
          }
        }
        if (maxChunkSize && chunkSize > maxChunkSize && chunkSize - maxChunkSize > minChunkSize) {
          chunkRemainder = _chunk.subarray(maxChunkSize);
          _chunk = _chunk.subarray(0, maxChunkSize);
        }
        pushChunk(_chunk, chunkRemainder ? () => {
          process.nextTick(_callback, null, chunkRemainder);
        } : _callback);
      };
      transformChunk(chunk, function transformNextChunk(err, _chunk) {
        if (err) {
          return callback(err);
        }
        if (_chunk) {
          transformChunk(_chunk, transformNextChunk);
        } else {
          callback(null);
        }
      });
    }
  }
  var AxiosTransformStream$1 = AxiosTransformStream;
  var { asyncIterator } = Symbol;
  var readBlob = async function* (blob) {
    if (blob.stream) {
      yield* blob.stream();
    } else if (blob.arrayBuffer) {
      yield await blob.arrayBuffer();
    } else if (blob[asyncIterator]) {
      yield* blob[asyncIterator]();
    } else {
      yield blob;
    }
  };
  var readBlob$1 = readBlob;
  var BOUNDARY_ALPHABET = platform.ALPHABET.ALPHA_DIGIT + "-_";
  var textEncoder = typeof TextEncoder === "function" ? new TextEncoder : new util__default["default"].TextEncoder;
  var CRLF = `\r
`;
  var CRLF_BYTES = textEncoder.encode(CRLF);
  var CRLF_BYTES_COUNT = 2;

  class FormDataPart {
    constructor(name, value) {
      const { escapeName } = this.constructor;
      const isStringValue = utils$1.isString(value);
      let headers = `Content-Disposition: form-data; name="${escapeName(name)}"${!isStringValue && value.name ? `; filename="${escapeName(value.name)}"` : ""}${CRLF}`;
      if (isStringValue) {
        value = textEncoder.encode(String(value).replace(/\r?\n|\r\n?/g, CRLF));
      } else {
        headers += `Content-Type: ${value.type || "application/octet-stream"}${CRLF}`;
      }
      this.headers = textEncoder.encode(headers + CRLF);
      this.contentLength = isStringValue ? value.byteLength : value.size;
      this.size = this.headers.byteLength + this.contentLength + CRLF_BYTES_COUNT;
      this.name = name;
      this.value = value;
    }
    async* encode() {
      yield this.headers;
      const { value } = this;
      if (utils$1.isTypedArray(value)) {
        yield value;
      } else {
        yield* readBlob$1(value);
      }
      yield CRLF_BYTES;
    }
    static escapeName(name) {
      return String(name).replace(/[\r\n"]/g, (match) => ({
        "\r": "%0D",
        "\n": "%0A",
        '"': "%22"
      })[match]);
    }
  }
  var formDataToStream = (form, headersHandler, options) => {
    const {
      tag = "form-data-boundary",
      size = 25,
      boundary = tag + "-" + platform.generateString(size, BOUNDARY_ALPHABET)
    } = options || {};
    if (!utils$1.isFormData(form)) {
      throw TypeError("FormData instance required");
    }
    if (boundary.length < 1 || boundary.length > 70) {
      throw Error("boundary must be 10-70 characters long");
    }
    const boundaryBytes = textEncoder.encode("--" + boundary + CRLF);
    const footerBytes = textEncoder.encode("--" + boundary + "--" + CRLF);
    let contentLength = footerBytes.byteLength;
    const parts = Array.from(form.entries()).map(([name, value]) => {
      const part = new FormDataPart(name, value);
      contentLength += part.size;
      return part;
    });
    contentLength += boundaryBytes.byteLength * parts.length;
    contentLength = utils$1.toFiniteNumber(contentLength);
    const computedHeaders = {
      "Content-Type": `multipart/form-data; boundary=${boundary}`
    };
    if (Number.isFinite(contentLength)) {
      computedHeaders["Content-Length"] = contentLength;
    }
    headersHandler && headersHandler(computedHeaders);
    return stream.Readable.from(async function* () {
      for (const part of parts) {
        yield boundaryBytes;
        yield* part.encode();
      }
      yield footerBytes;
    }());
  };
  var formDataToStream$1 = formDataToStream;

  class ZlibHeaderTransformStream extends stream__default["default"].Transform {
    __transform(chunk, encoding, callback) {
      this.push(chunk);
      callback();
    }
    _transform(chunk, encoding, callback) {
      if (chunk.length !== 0) {
        this._transform = this.__transform;
        if (chunk[0] !== 120) {
          const header = Buffer.alloc(2);
          header[0] = 120;
          header[1] = 156;
          this.push(header, encoding);
        }
      }
      this.__transform(chunk, encoding, callback);
    }
  }
  var ZlibHeaderTransformStream$1 = ZlibHeaderTransformStream;
  var callbackify = (fn, reducer) => {
    return utils$1.isAsyncFn(fn) ? function(...args) {
      const cb = args.pop();
      fn.apply(this, args).then((value) => {
        try {
          reducer ? cb(null, ...reducer(value)) : cb(null, value);
        } catch (err) {
          cb(err);
        }
      }, cb);
    } : fn;
  };
  var callbackify$1 = callbackify;
  function speedometer(samplesCount, min) {
    samplesCount = samplesCount || 10;
    const bytes = new Array(samplesCount);
    const timestamps = new Array(samplesCount);
    let head = 0;
    let tail = 0;
    let firstSampleTS;
    min = min !== undefined ? min : 1000;
    return function push(chunkLength) {
      const now = Date.now();
      const startedAt = timestamps[tail];
      if (!firstSampleTS) {
        firstSampleTS = now;
      }
      bytes[head] = chunkLength;
      timestamps[head] = now;
      let i = tail;
      let bytesCount = 0;
      while (i !== head) {
        bytesCount += bytes[i++];
        i = i % samplesCount;
      }
      head = (head + 1) % samplesCount;
      if (head === tail) {
        tail = (tail + 1) % samplesCount;
      }
      if (now - firstSampleTS < min) {
        return;
      }
      const passed = startedAt && now - startedAt;
      return passed ? Math.round(bytesCount * 1000 / passed) : undefined;
    };
  }
  function throttle(fn, freq) {
    let timestamp = 0;
    let threshold = 1000 / freq;
    let lastArgs;
    let timer;
    const invoke = (args, now = Date.now()) => {
      timestamp = now;
      lastArgs = null;
      if (timer) {
        clearTimeout(timer);
        timer = null;
      }
      fn.apply(null, args);
    };
    const throttled = (...args) => {
      const now = Date.now();
      const passed = now - timestamp;
      if (passed >= threshold) {
        invoke(args, now);
      } else {
        lastArgs = args;
        if (!timer) {
          timer = setTimeout(() => {
            timer = null;
            invoke(lastArgs);
          }, threshold - passed);
        }
      }
    };
    const flush = () => lastArgs && invoke(lastArgs);
    return [throttled, flush];
  }
  var progressEventReducer = (listener, isDownloadStream, freq = 3) => {
    let bytesNotified = 0;
    const _speedometer = speedometer(50, 250);
    return throttle((e) => {
      const loaded = e.loaded;
      const total = e.lengthComputable ? e.total : undefined;
      const progressBytes = loaded - bytesNotified;
      const rate = _speedometer(progressBytes);
      const inRange = loaded <= total;
      bytesNotified = loaded;
      const data = {
        loaded,
        total,
        progress: total ? loaded / total : undefined,
        bytes: progressBytes,
        rate: rate ? rate : undefined,
        estimated: rate && total && inRange ? (total - loaded) / rate : undefined,
        event: e,
        lengthComputable: total != null,
        [isDownloadStream ? "download" : "upload"]: true
      };
      listener(data);
    }, freq);
  };
  var progressEventDecorator = (total, throttled) => {
    const lengthComputable = total != null;
    return [(loaded) => throttled[0]({
      lengthComputable,
      total,
      loaded
    }), throttled[1]];
  };
  var asyncDecorator = (fn) => (...args) => utils$1.asap(() => fn(...args));
  var zlibOptions = {
    flush: zlib__default["default"].constants.Z_SYNC_FLUSH,
    finishFlush: zlib__default["default"].constants.Z_SYNC_FLUSH
  };
  var brotliOptions = {
    flush: zlib__default["default"].constants.BROTLI_OPERATION_FLUSH,
    finishFlush: zlib__default["default"].constants.BROTLI_OPERATION_FLUSH
  };
  var isBrotliSupported = utils$1.isFunction(zlib__default["default"].createBrotliDecompress);
  var { http: httpFollow, https: httpsFollow } = followRedirects__default["default"];
  var isHttps = /https:?/;
  var supportedProtocols = platform.protocols.map((protocol) => {
    return protocol + ":";
  });
  var flushOnFinish = (stream2, [throttled, flush]) => {
    stream2.on("end", flush).on("error", flush);
    return throttled;
  };
  function dispatchBeforeRedirect(options, responseDetails) {
    if (options.beforeRedirects.proxy) {
      options.beforeRedirects.proxy(options);
    }
    if (options.beforeRedirects.config) {
      options.beforeRedirects.config(options, responseDetails);
    }
  }
  function setProxy(options, configProxy, location) {
    let proxy = configProxy;
    if (!proxy && proxy !== false) {
      const proxyUrl = proxyFromEnv__default["default"].getProxyForUrl(location);
      if (proxyUrl) {
        proxy = new URL(proxyUrl);
      }
    }
    if (proxy) {
      if (proxy.username) {
        proxy.auth = (proxy.username || "") + ":" + (proxy.password || "");
      }
      if (proxy.auth) {
        if (proxy.auth.username || proxy.auth.password) {
          proxy.auth = (proxy.auth.username || "") + ":" + (proxy.auth.password || "");
        }
        const base64 = Buffer.from(proxy.auth, "utf8").toString("base64");
        options.headers["Proxy-Authorization"] = "Basic " + base64;
      }
      options.headers.host = options.hostname + (options.port ? ":" + options.port : "");
      const proxyHost = proxy.hostname || proxy.host;
      options.hostname = proxyHost;
      options.host = proxyHost;
      options.port = proxy.port;
      options.path = location;
      if (proxy.protocol) {
        options.protocol = proxy.protocol.includes(":") ? proxy.protocol : `${proxy.protocol}:`;
      }
    }
    options.beforeRedirects.proxy = function beforeRedirect(redirectOptions) {
      setProxy(redirectOptions, configProxy, redirectOptions.href);
    };
  }
  var isHttpAdapterSupported = typeof process !== "undefined" && utils$1.kindOf(process) === "process";
  var wrapAsync = (asyncExecutor) => {
    return new Promise((resolve, reject) => {
      let onDone;
      let isDone;
      const done = (value, isRejected) => {
        if (isDone)
          return;
        isDone = true;
        onDone && onDone(value, isRejected);
      };
      const _resolve = (value) => {
        done(value);
        resolve(value);
      };
      const _reject = (reason) => {
        done(reason, true);
        reject(reason);
      };
      asyncExecutor(_resolve, _reject, (onDoneHandler) => onDone = onDoneHandler).catch(_reject);
    });
  };
  var resolveFamily = ({ address, family }) => {
    if (!utils$1.isString(address)) {
      throw TypeError("address must be a string");
    }
    return {
      address,
      family: family || (address.indexOf(".") < 0 ? 6 : 4)
    };
  };
  var buildAddressEntry = (address, family) => resolveFamily(utils$1.isObject(address) ? address : { address, family });
  var httpAdapter = isHttpAdapterSupported && function httpAdapter(config) {
    return wrapAsync(async function dispatchHttpRequest(resolve, reject, onDone) {
      let { data, lookup, family } = config;
      const { responseType, responseEncoding } = config;
      const method = config.method.toUpperCase();
      let isDone;
      let rejected = false;
      let req;
      if (lookup) {
        const _lookup = callbackify$1(lookup, (value) => utils$1.isArray(value) ? value : [value]);
        lookup = (hostname, opt, cb) => {
          _lookup(hostname, opt, (err, arg0, arg1) => {
            if (err) {
              return cb(err);
            }
            const addresses = utils$1.isArray(arg0) ? arg0.map((addr) => buildAddressEntry(addr)) : [buildAddressEntry(arg0, arg1)];
            opt.all ? cb(err, addresses) : cb(err, addresses[0].address, addresses[0].family);
          });
        };
      }
      const emitter = new events.EventEmitter;
      const onFinished = () => {
        if (config.cancelToken) {
          config.cancelToken.unsubscribe(abort);
        }
        if (config.signal) {
          config.signal.removeEventListener("abort", abort);
        }
        emitter.removeAllListeners();
      };
      onDone((value, isRejected) => {
        isDone = true;
        if (isRejected) {
          rejected = true;
          onFinished();
        }
      });
      function abort(reason) {
        emitter.emit("abort", !reason || reason.type ? new CanceledError(null, config, req) : reason);
      }
      emitter.once("abort", reject);
      if (config.cancelToken || config.signal) {
        config.cancelToken && config.cancelToken.subscribe(abort);
        if (config.signal) {
          config.signal.aborted ? abort() : config.signal.addEventListener("abort", abort);
        }
      }
      const fullPath = buildFullPath(config.baseURL, config.url, config.allowAbsoluteUrls);
      const parsed = new URL(fullPath, platform.hasBrowserEnv ? platform.origin : undefined);
      const protocol = parsed.protocol || supportedProtocols[0];
      if (protocol === "data:") {
        let convertedData;
        if (method !== "GET") {
          return settle(resolve, reject, {
            status: 405,
            statusText: "method not allowed",
            headers: {},
            config
          });
        }
        try {
          convertedData = fromDataURI(config.url, responseType === "blob", {
            Blob: config.env && config.env.Blob
          });
        } catch (err) {
          throw AxiosError.from(err, AxiosError.ERR_BAD_REQUEST, config);
        }
        if (responseType === "text") {
          convertedData = convertedData.toString(responseEncoding);
          if (!responseEncoding || responseEncoding === "utf8") {
            convertedData = utils$1.stripBOM(convertedData);
          }
        } else if (responseType === "stream") {
          convertedData = stream__default["default"].Readable.from(convertedData);
        }
        return settle(resolve, reject, {
          data: convertedData,
          status: 200,
          statusText: "OK",
          headers: new AxiosHeaders$1,
          config
        });
      }
      if (supportedProtocols.indexOf(protocol) === -1) {
        return reject(new AxiosError("Unsupported protocol " + protocol, AxiosError.ERR_BAD_REQUEST, config));
      }
      const headers = AxiosHeaders$1.from(config.headers).normalize();
      headers.set("User-Agent", "axios/" + VERSION, false);
      const { onUploadProgress, onDownloadProgress } = config;
      const maxRate = config.maxRate;
      let maxUploadRate = undefined;
      let maxDownloadRate = undefined;
      if (utils$1.isSpecCompliantForm(data)) {
        const userBoundary = headers.getContentType(/boundary=([-_\w\d]{10,70})/i);
        data = formDataToStream$1(data, (formHeaders) => {
          headers.set(formHeaders);
        }, {
          tag: `axios-${VERSION}-boundary`,
          boundary: userBoundary && userBoundary[1] || undefined
        });
      } else if (utils$1.isFormData(data) && utils$1.isFunction(data.getHeaders)) {
        headers.set(data.getHeaders());
        if (!headers.hasContentLength()) {
          try {
            const knownLength = await util__default["default"].promisify(data.getLength).call(data);
            Number.isFinite(knownLength) && knownLength >= 0 && headers.setContentLength(knownLength);
          } catch (e) {}
        }
      } else if (utils$1.isBlob(data) || utils$1.isFile(data)) {
        data.size && headers.setContentType(data.type || "application/octet-stream");
        headers.setContentLength(data.size || 0);
        data = stream__default["default"].Readable.from(readBlob$1(data));
      } else if (data && !utils$1.isStream(data)) {
        if (Buffer.isBuffer(data))
          ;
        else if (utils$1.isArrayBuffer(data)) {
          data = Buffer.from(new Uint8Array(data));
        } else if (utils$1.isString(data)) {
          data = Buffer.from(data, "utf-8");
        } else {
          return reject(new AxiosError("Data after transformation must be a string, an ArrayBuffer, a Buffer, or a Stream", AxiosError.ERR_BAD_REQUEST, config));
        }
        headers.setContentLength(data.length, false);
        if (config.maxBodyLength > -1 && data.length > config.maxBodyLength) {
          return reject(new AxiosError("Request body larger than maxBodyLength limit", AxiosError.ERR_BAD_REQUEST, config));
        }
      }
      const contentLength = utils$1.toFiniteNumber(headers.getContentLength());
      if (utils$1.isArray(maxRate)) {
        maxUploadRate = maxRate[0];
        maxDownloadRate = maxRate[1];
      } else {
        maxUploadRate = maxDownloadRate = maxRate;
      }
      if (data && (onUploadProgress || maxUploadRate)) {
        if (!utils$1.isStream(data)) {
          data = stream__default["default"].Readable.from(data, { objectMode: false });
        }
        data = stream__default["default"].pipeline([data, new AxiosTransformStream$1({
          maxRate: utils$1.toFiniteNumber(maxUploadRate)
        })], utils$1.noop);
        onUploadProgress && data.on("progress", flushOnFinish(data, progressEventDecorator(contentLength, progressEventReducer(asyncDecorator(onUploadProgress), false, 3))));
      }
      let auth = undefined;
      if (config.auth) {
        const username = config.auth.username || "";
        const password = config.auth.password || "";
        auth = username + ":" + password;
      }
      if (!auth && parsed.username) {
        const urlUsername = parsed.username;
        const urlPassword = parsed.password;
        auth = urlUsername + ":" + urlPassword;
      }
      auth && headers.delete("authorization");
      let path;
      try {
        path = buildURL(parsed.pathname + parsed.search, config.params, config.paramsSerializer).replace(/^\?/, "");
      } catch (err) {
        const customErr = new Error(err.message);
        customErr.config = config;
        customErr.url = config.url;
        customErr.exists = true;
        return reject(customErr);
      }
      headers.set("Accept-Encoding", "gzip, compress, deflate" + (isBrotliSupported ? ", br" : ""), false);
      const options = {
        path,
        method,
        headers: headers.toJSON(),
        agents: { http: config.httpAgent, https: config.httpsAgent },
        auth,
        protocol,
        family,
        beforeRedirect: dispatchBeforeRedirect,
        beforeRedirects: {}
      };
      !utils$1.isUndefined(lookup) && (options.lookup = lookup);
      if (config.socketPath) {
        options.socketPath = config.socketPath;
      } else {
        options.hostname = parsed.hostname.startsWith("[") ? parsed.hostname.slice(1, -1) : parsed.hostname;
        options.port = parsed.port;
        setProxy(options, config.proxy, protocol + "//" + parsed.hostname + (parsed.port ? ":" + parsed.port : "") + options.path);
      }
      let transport;
      const isHttpsRequest = isHttps.test(options.protocol);
      options.agent = isHttpsRequest ? config.httpsAgent : config.httpAgent;
      if (config.transport) {
        transport = config.transport;
      } else if (config.maxRedirects === 0) {
        transport = isHttpsRequest ? https__default["default"] : http__default["default"];
      } else {
        if (config.maxRedirects) {
          options.maxRedirects = config.maxRedirects;
        }
        if (config.beforeRedirect) {
          options.beforeRedirects.config = config.beforeRedirect;
        }
        transport = isHttpsRequest ? httpsFollow : httpFollow;
      }
      if (config.maxBodyLength > -1) {
        options.maxBodyLength = config.maxBodyLength;
      } else {
        options.maxBodyLength = Infinity;
      }
      if (config.insecureHTTPParser) {
        options.insecureHTTPParser = config.insecureHTTPParser;
      }
      req = transport.request(options, function handleResponse(res) {
        if (req.destroyed)
          return;
        const streams = [res];
        const responseLength = +res.headers["content-length"];
        if (onDownloadProgress || maxDownloadRate) {
          const transformStream = new AxiosTransformStream$1({
            maxRate: utils$1.toFiniteNumber(maxDownloadRate)
          });
          onDownloadProgress && transformStream.on("progress", flushOnFinish(transformStream, progressEventDecorator(responseLength, progressEventReducer(asyncDecorator(onDownloadProgress), true, 3))));
          streams.push(transformStream);
        }
        let responseStream = res;
        const lastRequest = res.req || req;
        if (config.decompress !== false && res.headers["content-encoding"]) {
          if (method === "HEAD" || res.statusCode === 204) {
            delete res.headers["content-encoding"];
          }
          switch ((res.headers["content-encoding"] || "").toLowerCase()) {
            case "gzip":
            case "x-gzip":
            case "compress":
            case "x-compress":
              streams.push(zlib__default["default"].createUnzip(zlibOptions));
              delete res.headers["content-encoding"];
              break;
            case "deflate":
              streams.push(new ZlibHeaderTransformStream$1);
              streams.push(zlib__default["default"].createUnzip(zlibOptions));
              delete res.headers["content-encoding"];
              break;
            case "br":
              if (isBrotliSupported) {
                streams.push(zlib__default["default"].createBrotliDecompress(brotliOptions));
                delete res.headers["content-encoding"];
              }
          }
        }
        responseStream = streams.length > 1 ? stream__default["default"].pipeline(streams, utils$1.noop) : streams[0];
        const offListeners = stream__default["default"].finished(responseStream, () => {
          offListeners();
          onFinished();
        });
        const response = {
          status: res.statusCode,
          statusText: res.statusMessage,
          headers: new AxiosHeaders$1(res.headers),
          config,
          request: lastRequest
        };
        if (responseType === "stream") {
          response.data = responseStream;
          settle(resolve, reject, response);
        } else {
          const responseBuffer = [];
          let totalResponseBytes = 0;
          responseStream.on("data", function handleStreamData(chunk) {
            responseBuffer.push(chunk);
            totalResponseBytes += chunk.length;
            if (config.maxContentLength > -1 && totalResponseBytes > config.maxContentLength) {
              rejected = true;
              responseStream.destroy();
              reject(new AxiosError("maxContentLength size of " + config.maxContentLength + " exceeded", AxiosError.ERR_BAD_RESPONSE, config, lastRequest));
            }
          });
          responseStream.on("aborted", function handlerStreamAborted() {
            if (rejected) {
              return;
            }
            const err = new AxiosError("stream has been aborted", AxiosError.ERR_BAD_RESPONSE, config, lastRequest);
            responseStream.destroy(err);
            reject(err);
          });
          responseStream.on("error", function handleStreamError(err) {
            if (req.destroyed)
              return;
            reject(AxiosError.from(err, null, config, lastRequest));
          });
          responseStream.on("end", function handleStreamEnd() {
            try {
              let responseData = responseBuffer.length === 1 ? responseBuffer[0] : Buffer.concat(responseBuffer);
              if (responseType !== "arraybuffer") {
                responseData = responseData.toString(responseEncoding);
                if (!responseEncoding || responseEncoding === "utf8") {
                  responseData = utils$1.stripBOM(responseData);
                }
              }
              response.data = responseData;
            } catch (err) {
              return reject(AxiosError.from(err, null, config, response.request, response));
            }
            settle(resolve, reject, response);
          });
        }
        emitter.once("abort", (err) => {
          if (!responseStream.destroyed) {
            responseStream.emit("error", err);
            responseStream.destroy();
          }
        });
      });
      emitter.once("abort", (err) => {
        reject(err);
        req.destroy(err);
      });
      req.on("error", function handleRequestError(err) {
        reject(AxiosError.from(err, null, config, req));
      });
      req.on("socket", function handleRequestSocket(socket) {
        socket.setKeepAlive(true, 1000 * 60);
      });
      if (config.timeout) {
        const timeout = parseInt(config.timeout, 10);
        if (Number.isNaN(timeout)) {
          reject(new AxiosError("error trying to parse `config.timeout` to int", AxiosError.ERR_BAD_OPTION_VALUE, config, req));
          return;
        }
        req.setTimeout(timeout, function handleRequestTimeout() {
          if (isDone)
            return;
          let timeoutErrorMessage = config.timeout ? "timeout of " + config.timeout + "ms exceeded" : "timeout exceeded";
          const transitional = config.transitional || transitionalDefaults;
          if (config.timeoutErrorMessage) {
            timeoutErrorMessage = config.timeoutErrorMessage;
          }
          reject(new AxiosError(timeoutErrorMessage, transitional.clarifyTimeoutError ? AxiosError.ETIMEDOUT : AxiosError.ECONNABORTED, config, req));
          abort();
        });
      }
      if (utils$1.isStream(data)) {
        let ended = false;
        let errored = false;
        data.on("end", () => {
          ended = true;
        });
        data.once("error", (err) => {
          errored = true;
          req.destroy(err);
        });
        data.on("close", () => {
          if (!ended && !errored) {
            abort(new CanceledError("Request stream has been aborted", config, req));
          }
        });
        data.pipe(req);
      } else {
        req.end(data);
      }
    });
  };
  var isURLSameOrigin = platform.hasStandardBrowserEnv ? ((origin2, isMSIE) => (url2) => {
    url2 = new URL(url2, platform.origin);
    return origin2.protocol === url2.protocol && origin2.host === url2.host && (isMSIE || origin2.port === url2.port);
  })(new URL(platform.origin), platform.navigator && /(msie|trident)/i.test(platform.navigator.userAgent)) : () => true;
  var cookies = platform.hasStandardBrowserEnv ? {
    write(name, value, expires, path, domain, secure) {
      const cookie = [name + "=" + encodeURIComponent(value)];
      utils$1.isNumber(expires) && cookie.push("expires=" + new Date(expires).toGMTString());
      utils$1.isString(path) && cookie.push("path=" + path);
      utils$1.isString(domain) && cookie.push("domain=" + domain);
      secure === true && cookie.push("secure");
      document.cookie = cookie.join("; ");
    },
    read(name) {
      const match = document.cookie.match(new RegExp("(^|;\\s*)(" + name + ")=([^;]*)"));
      return match ? decodeURIComponent(match[3]) : null;
    },
    remove(name) {
      this.write(name, "", Date.now() - 86400000);
    }
  } : {
    write() {},
    read() {
      return null;
    },
    remove() {}
  };
  var headersToObject = (thing) => thing instanceof AxiosHeaders$1 ? { ...thing } : thing;
  function mergeConfig(config1, config2) {
    config2 = config2 || {};
    const config = {};
    function getMergedValue(target, source, prop, caseless) {
      if (utils$1.isPlainObject(target) && utils$1.isPlainObject(source)) {
        return utils$1.merge.call({ caseless }, target, source);
      } else if (utils$1.isPlainObject(source)) {
        return utils$1.merge({}, source);
      } else if (utils$1.isArray(source)) {
        return source.slice();
      }
      return source;
    }
    function mergeDeepProperties(a, b, prop, caseless) {
      if (!utils$1.isUndefined(b)) {
        return getMergedValue(a, b, prop, caseless);
      } else if (!utils$1.isUndefined(a)) {
        return getMergedValue(undefined, a, prop, caseless);
      }
    }
    function valueFromConfig2(a, b) {
      if (!utils$1.isUndefined(b)) {
        return getMergedValue(undefined, b);
      }
    }
    function defaultToConfig2(a, b) {
      if (!utils$1.isUndefined(b)) {
        return getMergedValue(undefined, b);
      } else if (!utils$1.isUndefined(a)) {
        return getMergedValue(undefined, a);
      }
    }
    function mergeDirectKeys(a, b, prop) {
      if (prop in config2) {
        return getMergedValue(a, b);
      } else if (prop in config1) {
        return getMergedValue(undefined, a);
      }
    }
    const mergeMap = {
      url: valueFromConfig2,
      method: valueFromConfig2,
      data: valueFromConfig2,
      baseURL: defaultToConfig2,
      transformRequest: defaultToConfig2,
      transformResponse: defaultToConfig2,
      paramsSerializer: defaultToConfig2,
      timeout: defaultToConfig2,
      timeoutMessage: defaultToConfig2,
      withCredentials: defaultToConfig2,
      withXSRFToken: defaultToConfig2,
      adapter: defaultToConfig2,
      responseType: defaultToConfig2,
      xsrfCookieName: defaultToConfig2,
      xsrfHeaderName: defaultToConfig2,
      onUploadProgress: defaultToConfig2,
      onDownloadProgress: defaultToConfig2,
      decompress: defaultToConfig2,
      maxContentLength: defaultToConfig2,
      maxBodyLength: defaultToConfig2,
      beforeRedirect: defaultToConfig2,
      transport: defaultToConfig2,
      httpAgent: defaultToConfig2,
      httpsAgent: defaultToConfig2,
      cancelToken: defaultToConfig2,
      socketPath: defaultToConfig2,
      responseEncoding: defaultToConfig2,
      validateStatus: mergeDirectKeys,
      headers: (a, b, prop) => mergeDeepProperties(headersToObject(a), headersToObject(b), prop, true)
    };
    utils$1.forEach(Object.keys(Object.assign({}, config1, config2)), function computeConfigValue(prop) {
      const merge2 = mergeMap[prop] || mergeDeepProperties;
      const configValue = merge2(config1[prop], config2[prop], prop);
      utils$1.isUndefined(configValue) && merge2 !== mergeDirectKeys || (config[prop] = configValue);
    });
    return config;
  }
  var resolveConfig = (config) => {
    const newConfig = mergeConfig({}, config);
    let { data, withXSRFToken, xsrfHeaderName, xsrfCookieName, headers, auth } = newConfig;
    newConfig.headers = headers = AxiosHeaders$1.from(headers);
    newConfig.url = buildURL(buildFullPath(newConfig.baseURL, newConfig.url, newConfig.allowAbsoluteUrls), config.params, config.paramsSerializer);
    if (auth) {
      headers.set("Authorization", "Basic " + btoa((auth.username || "") + ":" + (auth.password ? unescape(encodeURIComponent(auth.password)) : "")));
    }
    let contentType;
    if (utils$1.isFormData(data)) {
      if (platform.hasStandardBrowserEnv || platform.hasStandardBrowserWebWorkerEnv) {
        headers.setContentType(undefined);
      } else if ((contentType = headers.getContentType()) !== false) {
        const [type, ...tokens] = contentType ? contentType.split(";").map((token) => token.trim()).filter(Boolean) : [];
        headers.setContentType([type || "multipart/form-data", ...tokens].join("; "));
      }
    }
    if (platform.hasStandardBrowserEnv) {
      withXSRFToken && utils$1.isFunction(withXSRFToken) && (withXSRFToken = withXSRFToken(newConfig));
      if (withXSRFToken || withXSRFToken !== false && isURLSameOrigin(newConfig.url)) {
        const xsrfValue = xsrfHeaderName && xsrfCookieName && cookies.read(xsrfCookieName);
        if (xsrfValue) {
          headers.set(xsrfHeaderName, xsrfValue);
        }
      }
    }
    return newConfig;
  };
  var isXHRAdapterSupported = typeof XMLHttpRequest !== "undefined";
  var xhrAdapter = isXHRAdapterSupported && function(config) {
    return new Promise(function dispatchXhrRequest(resolve, reject) {
      const _config = resolveConfig(config);
      let requestData = _config.data;
      const requestHeaders = AxiosHeaders$1.from(_config.headers).normalize();
      let { responseType, onUploadProgress, onDownloadProgress } = _config;
      let onCanceled;
      let uploadThrottled, downloadThrottled;
      let flushUpload, flushDownload;
      function done() {
        flushUpload && flushUpload();
        flushDownload && flushDownload();
        _config.cancelToken && _config.cancelToken.unsubscribe(onCanceled);
        _config.signal && _config.signal.removeEventListener("abort", onCanceled);
      }
      let request = new XMLHttpRequest;
      request.open(_config.method.toUpperCase(), _config.url, true);
      request.timeout = _config.timeout;
      function onloadend() {
        if (!request) {
          return;
        }
        const responseHeaders = AxiosHeaders$1.from("getAllResponseHeaders" in request && request.getAllResponseHeaders());
        const responseData = !responseType || responseType === "text" || responseType === "json" ? request.responseText : request.response;
        const response = {
          data: responseData,
          status: request.status,
          statusText: request.statusText,
          headers: responseHeaders,
          config,
          request
        };
        settle(function _resolve(value) {
          resolve(value);
          done();
        }, function _reject(err) {
          reject(err);
          done();
        }, response);
        request = null;
      }
      if ("onloadend" in request) {
        request.onloadend = onloadend;
      } else {
        request.onreadystatechange = function handleLoad() {
          if (!request || request.readyState !== 4) {
            return;
          }
          if (request.status === 0 && !(request.responseURL && request.responseURL.indexOf("file:") === 0)) {
            return;
          }
          setTimeout(onloadend);
        };
      }
      request.onabort = function handleAbort() {
        if (!request) {
          return;
        }
        reject(new AxiosError("Request aborted", AxiosError.ECONNABORTED, config, request));
        request = null;
      };
      request.onerror = function handleError() {
        reject(new AxiosError("Network Error", AxiosError.ERR_NETWORK, config, request));
        request = null;
      };
      request.ontimeout = function handleTimeout() {
        let timeoutErrorMessage = _config.timeout ? "timeout of " + _config.timeout + "ms exceeded" : "timeout exceeded";
        const transitional = _config.transitional || transitionalDefaults;
        if (_config.timeoutErrorMessage) {
          timeoutErrorMessage = _config.timeoutErrorMessage;
        }
        reject(new AxiosError(timeoutErrorMessage, transitional.clarifyTimeoutError ? AxiosError.ETIMEDOUT : AxiosError.ECONNABORTED, config, request));
        request = null;
      };
      requestData === undefined && requestHeaders.setContentType(null);
      if ("setRequestHeader" in request) {
        utils$1.forEach(requestHeaders.toJSON(), function setRequestHeader(val, key) {
          request.setRequestHeader(key, val);
        });
      }
      if (!utils$1.isUndefined(_config.withCredentials)) {
        request.withCredentials = !!_config.withCredentials;
      }
      if (responseType && responseType !== "json") {
        request.responseType = _config.responseType;
      }
      if (onDownloadProgress) {
        [downloadThrottled, flushDownload] = progressEventReducer(onDownloadProgress, true);
        request.addEventListener("progress", downloadThrottled);
      }
      if (onUploadProgress && request.upload) {
        [uploadThrottled, flushUpload] = progressEventReducer(onUploadProgress);
        request.upload.addEventListener("progress", uploadThrottled);
        request.upload.addEventListener("loadend", flushUpload);
      }
      if (_config.cancelToken || _config.signal) {
        onCanceled = (cancel) => {
          if (!request) {
            return;
          }
          reject(!cancel || cancel.type ? new CanceledError(null, config, request) : cancel);
          request.abort();
          request = null;
        };
        _config.cancelToken && _config.cancelToken.subscribe(onCanceled);
        if (_config.signal) {
          _config.signal.aborted ? onCanceled() : _config.signal.addEventListener("abort", onCanceled);
        }
      }
      const protocol = parseProtocol(_config.url);
      if (protocol && platform.protocols.indexOf(protocol) === -1) {
        reject(new AxiosError("Unsupported protocol " + protocol + ":", AxiosError.ERR_BAD_REQUEST, config));
        return;
      }
      request.send(requestData || null);
    });
  };
  var composeSignals = (signals, timeout) => {
    const { length } = signals = signals ? signals.filter(Boolean) : [];
    if (timeout || length) {
      let controller = new AbortController;
      let aborted;
      const onabort = function(reason) {
        if (!aborted) {
          aborted = true;
          unsubscribe();
          const err = reason instanceof Error ? reason : this.reason;
          controller.abort(err instanceof AxiosError ? err : new CanceledError(err instanceof Error ? err.message : err));
        }
      };
      let timer = timeout && setTimeout(() => {
        timer = null;
        onabort(new AxiosError(`timeout ${timeout} of ms exceeded`, AxiosError.ETIMEDOUT));
      }, timeout);
      const unsubscribe = () => {
        if (signals) {
          timer && clearTimeout(timer);
          timer = null;
          signals.forEach((signal2) => {
            signal2.unsubscribe ? signal2.unsubscribe(onabort) : signal2.removeEventListener("abort", onabort);
          });
          signals = null;
        }
      };
      signals.forEach((signal2) => signal2.addEventListener("abort", onabort));
      const { signal } = controller;
      signal.unsubscribe = () => utils$1.asap(unsubscribe);
      return signal;
    }
  };
  var composeSignals$1 = composeSignals;
  var streamChunk = function* (chunk, chunkSize) {
    let len = chunk.byteLength;
    if (!chunkSize || len < chunkSize) {
      yield chunk;
      return;
    }
    let pos = 0;
    let end;
    while (pos < len) {
      end = pos + chunkSize;
      yield chunk.slice(pos, end);
      pos = end;
    }
  };
  var readBytes = async function* (iterable, chunkSize) {
    for await (const chunk of readStream(iterable)) {
      yield* streamChunk(chunk, chunkSize);
    }
  };
  var readStream = async function* (stream2) {
    if (stream2[Symbol.asyncIterator]) {
      yield* stream2;
      return;
    }
    const reader = stream2.getReader();
    try {
      for (;; ) {
        const { done, value } = await reader.read();
        if (done) {
          break;
        }
        yield value;
      }
    } finally {
      await reader.cancel();
    }
  };
  var trackStream = (stream2, chunkSize, onProgress, onFinish) => {
    const iterator2 = readBytes(stream2, chunkSize);
    let bytes = 0;
    let done;
    let _onFinish = (e) => {
      if (!done) {
        done = true;
        onFinish && onFinish(e);
      }
    };
    return new ReadableStream({
      async pull(controller) {
        try {
          const { done: done2, value } = await iterator2.next();
          if (done2) {
            _onFinish();
            controller.close();
            return;
          }
          let len = value.byteLength;
          if (onProgress) {
            let loadedBytes = bytes += len;
            onProgress(loadedBytes);
          }
          controller.enqueue(new Uint8Array(value));
        } catch (err) {
          _onFinish(err);
          throw err;
        }
      },
      cancel(reason) {
        _onFinish(reason);
        return iterator2.return();
      }
    }, {
      highWaterMark: 2
    });
  };
  var isFetchSupported = typeof fetch === "function" && typeof Request === "function" && typeof Response === "function";
  var isReadableStreamSupported = isFetchSupported && typeof ReadableStream === "function";
  var encodeText = isFetchSupported && (typeof TextEncoder === "function" ? ((encoder) => (str) => encoder.encode(str))(new TextEncoder) : async (str) => new Uint8Array(await new Response(str).arrayBuffer()));
  var test = (fn, ...args) => {
    try {
      return !!fn(...args);
    } catch (e) {
      return false;
    }
  };
  var supportsRequestStream = isReadableStreamSupported && test(() => {
    let duplexAccessed = false;
    const hasContentType = new Request(platform.origin, {
      body: new ReadableStream,
      method: "POST",
      get duplex() {
        duplexAccessed = true;
        return "half";
      }
    }).headers.has("Content-Type");
    return duplexAccessed && !hasContentType;
  });
  var DEFAULT_CHUNK_SIZE = 64 * 1024;
  var supportsResponseStream = isReadableStreamSupported && test(() => utils$1.isReadableStream(new Response("").body));
  var resolvers = {
    stream: supportsResponseStream && ((res) => res.body)
  };
  isFetchSupported && ((res) => {
    ["text", "arrayBuffer", "blob", "formData", "stream"].forEach((type) => {
      !resolvers[type] && (resolvers[type] = utils$1.isFunction(res[type]) ? (res2) => res2[type]() : (_, config) => {
        throw new AxiosError(`Response type '${type}' is not supported`, AxiosError.ERR_NOT_SUPPORT, config);
      });
    });
  })(new Response);
  var getBodyLength = async (body) => {
    if (body == null) {
      return 0;
    }
    if (utils$1.isBlob(body)) {
      return body.size;
    }
    if (utils$1.isSpecCompliantForm(body)) {
      const _request = new Request(platform.origin, {
        method: "POST",
        body
      });
      return (await _request.arrayBuffer()).byteLength;
    }
    if (utils$1.isArrayBufferView(body) || utils$1.isArrayBuffer(body)) {
      return body.byteLength;
    }
    if (utils$1.isURLSearchParams(body)) {
      body = body + "";
    }
    if (utils$1.isString(body)) {
      return (await encodeText(body)).byteLength;
    }
  };
  var resolveBodyLength = async (headers, body) => {
    const length = utils$1.toFiniteNumber(headers.getContentLength());
    return length == null ? getBodyLength(body) : length;
  };
  var fetchAdapter = isFetchSupported && (async (config) => {
    let {
      url: url2,
      method,
      data,
      signal,
      cancelToken,
      timeout,
      onDownloadProgress,
      onUploadProgress,
      responseType,
      headers,
      withCredentials = "same-origin",
      fetchOptions
    } = resolveConfig(config);
    responseType = responseType ? (responseType + "").toLowerCase() : "text";
    let composedSignal = composeSignals$1([signal, cancelToken && cancelToken.toAbortSignal()], timeout);
    let request;
    const unsubscribe = composedSignal && composedSignal.unsubscribe && (() => {
      composedSignal.unsubscribe();
    });
    let requestContentLength;
    try {
      if (onUploadProgress && supportsRequestStream && method !== "get" && method !== "head" && (requestContentLength = await resolveBodyLength(headers, data)) !== 0) {
        let _request = new Request(url2, {
          method: "POST",
          body: data,
          duplex: "half"
        });
        let contentTypeHeader;
        if (utils$1.isFormData(data) && (contentTypeHeader = _request.headers.get("content-type"))) {
          headers.setContentType(contentTypeHeader);
        }
        if (_request.body) {
          const [onProgress, flush] = progressEventDecorator(requestContentLength, progressEventReducer(asyncDecorator(onUploadProgress)));
          data = trackStream(_request.body, DEFAULT_CHUNK_SIZE, onProgress, flush);
        }
      }
      if (!utils$1.isString(withCredentials)) {
        withCredentials = withCredentials ? "include" : "omit";
      }
      const isCredentialsSupported = "credentials" in Request.prototype;
      request = new Request(url2, {
        ...fetchOptions,
        signal: composedSignal,
        method: method.toUpperCase(),
        headers: headers.normalize().toJSON(),
        body: data,
        duplex: "half",
        credentials: isCredentialsSupported ? withCredentials : undefined
      });
      let response = await fetch(request);
      const isStreamResponse = supportsResponseStream && (responseType === "stream" || responseType === "response");
      if (supportsResponseStream && (onDownloadProgress || isStreamResponse && unsubscribe)) {
        const options = {};
        ["status", "statusText", "headers"].forEach((prop) => {
          options[prop] = response[prop];
        });
        const responseContentLength = utils$1.toFiniteNumber(response.headers.get("content-length"));
        const [onProgress, flush] = onDownloadProgress && progressEventDecorator(responseContentLength, progressEventReducer(asyncDecorator(onDownloadProgress), true)) || [];
        response = new Response(trackStream(response.body, DEFAULT_CHUNK_SIZE, onProgress, () => {
          flush && flush();
          unsubscribe && unsubscribe();
        }), options);
      }
      responseType = responseType || "text";
      let responseData = await resolvers[utils$1.findKey(resolvers, responseType) || "text"](response, config);
      !isStreamResponse && unsubscribe && unsubscribe();
      return await new Promise((resolve, reject) => {
        settle(resolve, reject, {
          data: responseData,
          headers: AxiosHeaders$1.from(response.headers),
          status: response.status,
          statusText: response.statusText,
          config,
          request
        });
      });
    } catch (err) {
      unsubscribe && unsubscribe();
      if (err && err.name === "TypeError" && /Load failed|fetch/i.test(err.message)) {
        throw Object.assign(new AxiosError("Network Error", AxiosError.ERR_NETWORK, config, request), {
          cause: err.cause || err
        });
      }
      throw AxiosError.from(err, err && err.code, config, request);
    }
  });
  var knownAdapters = {
    http: httpAdapter,
    xhr: xhrAdapter,
    fetch: fetchAdapter
  };
  utils$1.forEach(knownAdapters, (fn, value) => {
    if (fn) {
      try {
        Object.defineProperty(fn, "name", { value });
      } catch (e) {}
      Object.defineProperty(fn, "adapterName", { value });
    }
  });
  var renderReason = (reason) => `- ${reason}`;
  var isResolvedHandle = (adapter) => utils$1.isFunction(adapter) || adapter === null || adapter === false;
  var adapters = {
    getAdapter: (adapters2) => {
      adapters2 = utils$1.isArray(adapters2) ? adapters2 : [adapters2];
      const { length } = adapters2;
      let nameOrAdapter;
      let adapter;
      const rejectedReasons = {};
      for (let i = 0;i < length; i++) {
        nameOrAdapter = adapters2[i];
        let id;
        adapter = nameOrAdapter;
        if (!isResolvedHandle(nameOrAdapter)) {
          adapter = knownAdapters[(id = String(nameOrAdapter)).toLowerCase()];
          if (adapter === undefined) {
            throw new AxiosError(`Unknown adapter '${id}'`);
          }
        }
        if (adapter) {
          break;
        }
        rejectedReasons[id || "#" + i] = adapter;
      }
      if (!adapter) {
        const reasons = Object.entries(rejectedReasons).map(([id, state]) => `adapter ${id} ` + (state === false ? "is not supported by the environment" : "is not available in the build"));
        let s = length ? reasons.length > 1 ? `since :
` + reasons.map(renderReason).join(`
`) : " " + renderReason(reasons[0]) : "as no adapter specified";
        throw new AxiosError(`There is no suitable adapter to dispatch the request ` + s, "ERR_NOT_SUPPORT");
      }
      return adapter;
    },
    adapters: knownAdapters
  };
  function throwIfCancellationRequested(config) {
    if (config.cancelToken) {
      config.cancelToken.throwIfRequested();
    }
    if (config.signal && config.signal.aborted) {
      throw new CanceledError(null, config);
    }
  }
  function dispatchRequest(config) {
    throwIfCancellationRequested(config);
    config.headers = AxiosHeaders$1.from(config.headers);
    config.data = transformData.call(config, config.transformRequest);
    if (["post", "put", "patch"].indexOf(config.method) !== -1) {
      config.headers.setContentType("application/x-www-form-urlencoded", false);
    }
    const adapter = adapters.getAdapter(config.adapter || defaults$1.adapter);
    return adapter(config).then(function onAdapterResolution(response) {
      throwIfCancellationRequested(config);
      response.data = transformData.call(config, config.transformResponse, response);
      response.headers = AxiosHeaders$1.from(response.headers);
      return response;
    }, function onAdapterRejection(reason) {
      if (!isCancel(reason)) {
        throwIfCancellationRequested(config);
        if (reason && reason.response) {
          reason.response.data = transformData.call(config, config.transformResponse, reason.response);
          reason.response.headers = AxiosHeaders$1.from(reason.response.headers);
        }
      }
      return Promise.reject(reason);
    });
  }
  var validators$1 = {};
  ["object", "boolean", "number", "function", "string", "symbol"].forEach((type, i) => {
    validators$1[type] = function validator(thing) {
      return typeof thing === type || "a" + (i < 1 ? "n " : " ") + type;
    };
  });
  var deprecatedWarnings = {};
  validators$1.transitional = function transitional(validator2, version, message) {
    function formatMessage(opt, desc) {
      return "[Axios v" + VERSION + "] Transitional option '" + opt + "'" + desc + (message ? ". " + message : "");
    }
    return (value, opt, opts) => {
      if (validator2 === false) {
        throw new AxiosError(formatMessage(opt, " has been removed" + (version ? " in " + version : "")), AxiosError.ERR_DEPRECATED);
      }
      if (version && !deprecatedWarnings[opt]) {
        deprecatedWarnings[opt] = true;
        console.warn(formatMessage(opt, " has been deprecated since v" + version + " and will be removed in the near future"));
      }
      return validator2 ? validator2(value, opt, opts) : true;
    };
  };
  validators$1.spelling = function spelling(correctSpelling) {
    return (value, opt) => {
      console.warn(`${opt} is likely a misspelling of ${correctSpelling}`);
      return true;
    };
  };
  function assertOptions(options, schema, allowUnknown) {
    if (typeof options !== "object") {
      throw new AxiosError("options must be an object", AxiosError.ERR_BAD_OPTION_VALUE);
    }
    const keys = Object.keys(options);
    let i = keys.length;
    while (i-- > 0) {
      const opt = keys[i];
      const validator2 = schema[opt];
      if (validator2) {
        const value = options[opt];
        const result = value === undefined || validator2(value, opt, options);
        if (result !== true) {
          throw new AxiosError("option " + opt + " must be " + result, AxiosError.ERR_BAD_OPTION_VALUE);
        }
        continue;
      }
      if (allowUnknown !== true) {
        throw new AxiosError("Unknown option " + opt, AxiosError.ERR_BAD_OPTION);
      }
    }
  }
  var validator = {
    assertOptions,
    validators: validators$1
  };
  var validators = validator.validators;

  class Axios {
    constructor(instanceConfig) {
      this.defaults = instanceConfig || {};
      this.interceptors = {
        request: new InterceptorManager$1,
        response: new InterceptorManager$1
      };
    }
    async request(configOrUrl, config) {
      try {
        return await this._request(configOrUrl, config);
      } catch (err) {
        if (err instanceof Error) {
          let dummy = {};
          Error.captureStackTrace ? Error.captureStackTrace(dummy) : dummy = new Error;
          const stack = dummy.stack ? dummy.stack.replace(/^.+\n/, "") : "";
          try {
            if (!err.stack) {
              err.stack = stack;
            } else if (stack && !String(err.stack).endsWith(stack.replace(/^.+\n.+\n/, ""))) {
              err.stack += `
` + stack;
            }
          } catch (e) {}
        }
        throw err;
      }
    }
    _request(configOrUrl, config) {
      if (typeof configOrUrl === "string") {
        config = config || {};
        config.url = configOrUrl;
      } else {
        config = configOrUrl || {};
      }
      config = mergeConfig(this.defaults, config);
      const { transitional, paramsSerializer, headers } = config;
      if (transitional !== undefined) {
        validator.assertOptions(transitional, {
          silentJSONParsing: validators.transitional(validators.boolean),
          forcedJSONParsing: validators.transitional(validators.boolean),
          clarifyTimeoutError: validators.transitional(validators.boolean)
        }, false);
      }
      if (paramsSerializer != null) {
        if (utils$1.isFunction(paramsSerializer)) {
          config.paramsSerializer = {
            serialize: paramsSerializer
          };
        } else {
          validator.assertOptions(paramsSerializer, {
            encode: validators.function,
            serialize: validators.function
          }, true);
        }
      }
      if (config.allowAbsoluteUrls !== undefined)
        ;
      else if (this.defaults.allowAbsoluteUrls !== undefined) {
        config.allowAbsoluteUrls = this.defaults.allowAbsoluteUrls;
      } else {
        config.allowAbsoluteUrls = true;
      }
      validator.assertOptions(config, {
        baseUrl: validators.spelling("baseURL"),
        withXsrfToken: validators.spelling("withXSRFToken")
      }, true);
      config.method = (config.method || this.defaults.method || "get").toLowerCase();
      let contextHeaders = headers && utils$1.merge(headers.common, headers[config.method]);
      headers && utils$1.forEach(["delete", "get", "head", "post", "put", "patch", "common"], (method) => {
        delete headers[method];
      });
      config.headers = AxiosHeaders$1.concat(contextHeaders, headers);
      const requestInterceptorChain = [];
      let synchronousRequestInterceptors = true;
      this.interceptors.request.forEach(function unshiftRequestInterceptors(interceptor) {
        if (typeof interceptor.runWhen === "function" && interceptor.runWhen(config) === false) {
          return;
        }
        synchronousRequestInterceptors = synchronousRequestInterceptors && interceptor.synchronous;
        requestInterceptorChain.unshift(interceptor.fulfilled, interceptor.rejected);
      });
      const responseInterceptorChain = [];
      this.interceptors.response.forEach(function pushResponseInterceptors(interceptor) {
        responseInterceptorChain.push(interceptor.fulfilled, interceptor.rejected);
      });
      let promise2;
      let i = 0;
      let len;
      if (!synchronousRequestInterceptors) {
        const chain = [dispatchRequest.bind(this), undefined];
        chain.unshift.apply(chain, requestInterceptorChain);
        chain.push.apply(chain, responseInterceptorChain);
        len = chain.length;
        promise2 = Promise.resolve(config);
        while (i < len) {
          promise2 = promise2.then(chain[i++], chain[i++]);
        }
        return promise2;
      }
      len = requestInterceptorChain.length;
      let newConfig = config;
      i = 0;
      while (i < len) {
        const onFulfilled = requestInterceptorChain[i++];
        const onRejected = requestInterceptorChain[i++];
        try {
          newConfig = onFulfilled(newConfig);
        } catch (error) {
          onRejected.call(this, error);
          break;
        }
      }
      try {
        promise2 = dispatchRequest.call(this, newConfig);
      } catch (error) {
        return Promise.reject(error);
      }
      i = 0;
      len = responseInterceptorChain.length;
      while (i < len) {
        promise2 = promise2.then(responseInterceptorChain[i++], responseInterceptorChain[i++]);
      }
      return promise2;
    }
    getUri(config) {
      config = mergeConfig(this.defaults, config);
      const fullPath = buildFullPath(config.baseURL, config.url, config.allowAbsoluteUrls);
      return buildURL(fullPath, config.params, config.paramsSerializer);
    }
  }
  utils$1.forEach(["delete", "get", "head", "options"], function forEachMethodNoData(method) {
    Axios.prototype[method] = function(url2, config) {
      return this.request(mergeConfig(config || {}, {
        method,
        url: url2,
        data: (config || {}).data
      }));
    };
  });
  utils$1.forEach(["post", "put", "patch"], function forEachMethodWithData(method) {
    function generateHTTPMethod(isForm) {
      return function httpMethod(url2, data, config) {
        return this.request(mergeConfig(config || {}, {
          method,
          headers: isForm ? {
            "Content-Type": "multipart/form-data"
          } : {},
          url: url2,
          data
        }));
      };
    }
    Axios.prototype[method] = generateHTTPMethod();
    Axios.prototype[method + "Form"] = generateHTTPMethod(true);
  });
  var Axios$1 = Axios;

  class CancelToken {
    constructor(executor) {
      if (typeof executor !== "function") {
        throw new TypeError("executor must be a function.");
      }
      let resolvePromise;
      this.promise = new Promise(function promiseExecutor(resolve) {
        resolvePromise = resolve;
      });
      const token = this;
      this.promise.then((cancel) => {
        if (!token._listeners)
          return;
        let i = token._listeners.length;
        while (i-- > 0) {
          token._listeners[i](cancel);
        }
        token._listeners = null;
      });
      this.promise.then = (onfulfilled) => {
        let _resolve;
        const promise2 = new Promise((resolve) => {
          token.subscribe(resolve);
          _resolve = resolve;
        }).then(onfulfilled);
        promise2.cancel = function reject() {
          token.unsubscribe(_resolve);
        };
        return promise2;
      };
      executor(function cancel(message, config, request) {
        if (token.reason) {
          return;
        }
        token.reason = new CanceledError(message, config, request);
        resolvePromise(token.reason);
      });
    }
    throwIfRequested() {
      if (this.reason) {
        throw this.reason;
      }
    }
    subscribe(listener) {
      if (this.reason) {
        listener(this.reason);
        return;
      }
      if (this._listeners) {
        this._listeners.push(listener);
      } else {
        this._listeners = [listener];
      }
    }
    unsubscribe(listener) {
      if (!this._listeners) {
        return;
      }
      const index = this._listeners.indexOf(listener);
      if (index !== -1) {
        this._listeners.splice(index, 1);
      }
    }
    toAbortSignal() {
      const controller = new AbortController;
      const abort = (err) => {
        controller.abort(err);
      };
      this.subscribe(abort);
      controller.signal.unsubscribe = () => this.unsubscribe(abort);
      return controller.signal;
    }
    static source() {
      let cancel;
      const token = new CancelToken(function executor(c) {
        cancel = c;
      });
      return {
        token,
        cancel
      };
    }
  }
  var CancelToken$1 = CancelToken;
  function spread(callback) {
    return function wrap(arr) {
      return callback.apply(null, arr);
    };
  }
  function isAxiosError(payload) {
    return utils$1.isObject(payload) && payload.isAxiosError === true;
  }
  var HttpStatusCode = {
    Continue: 100,
    SwitchingProtocols: 101,
    Processing: 102,
    EarlyHints: 103,
    Ok: 200,
    Created: 201,
    Accepted: 202,
    NonAuthoritativeInformation: 203,
    NoContent: 204,
    ResetContent: 205,
    PartialContent: 206,
    MultiStatus: 207,
    AlreadyReported: 208,
    ImUsed: 226,
    MultipleChoices: 300,
    MovedPermanently: 301,
    Found: 302,
    SeeOther: 303,
    NotModified: 304,
    UseProxy: 305,
    Unused: 306,
    TemporaryRedirect: 307,
    PermanentRedirect: 308,
    BadRequest: 400,
    Unauthorized: 401,
    PaymentRequired: 402,
    Forbidden: 403,
    NotFound: 404,
    MethodNotAllowed: 405,
    NotAcceptable: 406,
    ProxyAuthenticationRequired: 407,
    RequestTimeout: 408,
    Conflict: 409,
    Gone: 410,
    LengthRequired: 411,
    PreconditionFailed: 412,
    PayloadTooLarge: 413,
    UriTooLong: 414,
    UnsupportedMediaType: 415,
    RangeNotSatisfiable: 416,
    ExpectationFailed: 417,
    ImATeapot: 418,
    MisdirectedRequest: 421,
    UnprocessableEntity: 422,
    Locked: 423,
    FailedDependency: 424,
    TooEarly: 425,
    UpgradeRequired: 426,
    PreconditionRequired: 428,
    TooManyRequests: 429,
    RequestHeaderFieldsTooLarge: 431,
    UnavailableForLegalReasons: 451,
    InternalServerError: 500,
    NotImplemented: 501,
    BadGateway: 502,
    ServiceUnavailable: 503,
    GatewayTimeout: 504,
    HttpVersionNotSupported: 505,
    VariantAlsoNegotiates: 506,
    InsufficientStorage: 507,
    LoopDetected: 508,
    NotExtended: 510,
    NetworkAuthenticationRequired: 511
  };
  Object.entries(HttpStatusCode).forEach(([key, value]) => {
    HttpStatusCode[value] = key;
  });
  var HttpStatusCode$1 = HttpStatusCode;
  function createInstance(defaultConfig) {
    const context = new Axios$1(defaultConfig);
    const instance = bind(Axios$1.prototype.request, context);
    utils$1.extend(instance, Axios$1.prototype, context, { allOwnKeys: true });
    utils$1.extend(instance, context, null, { allOwnKeys: true });
    instance.create = function create(instanceConfig) {
      return createInstance(mergeConfig(defaultConfig, instanceConfig));
    };
    return instance;
  }
  var axios = createInstance(defaults$1);
  axios.Axios = Axios$1;
  axios.CanceledError = CanceledError;
  axios.CancelToken = CancelToken$1;
  axios.isCancel = isCancel;
  axios.VERSION = VERSION;
  axios.toFormData = toFormData;
  axios.AxiosError = AxiosError;
  axios.Cancel = axios.CanceledError;
  axios.all = function all(promises) {
    return Promise.all(promises);
  };
  axios.spread = spread;
  axios.isAxiosError = isAxiosError;
  axios.mergeConfig = mergeConfig;
  axios.AxiosHeaders = AxiosHeaders$1;
  axios.formToJSON = (thing) => formDataToJSON(utils$1.isHTMLForm(thing) ? new FormData(thing) : thing);
  axios.getAdapter = adapters.getAdapter;
  axios.HttpStatusCode = HttpStatusCode$1;
  axios.default = axios;
  module.exports = axios;
});

// node_modules/jira.js/out/services/authenticationService/base64Encoder.js
var require_base64Encoder = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Base64Encoder = undefined;
  var Base64Encoder;
  (function(Base64Encoder2) {
    const base64Sequence = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    const utf8Encode = (value) => {
      value = value.replace(/\r\n/g, `
`);
      let utftext = "";
      for (let n = 0;n < value.length; n++) {
        const c = value.charCodeAt(n);
        if (c < 128) {
          utftext += String.fromCharCode(c);
        } else if (c > 127 && c < 2048) {
          utftext += String.fromCharCode(c >> 6 | 192);
          utftext += String.fromCharCode(c & 63 | 128);
        } else {
          utftext += String.fromCharCode(c >> 12 | 224);
          utftext += String.fromCharCode(c >> 6 & 63 | 128);
          utftext += String.fromCharCode(c & 63 | 128);
        }
      }
      return utftext;
    };
    Base64Encoder2.encode = (input) => {
      let output = "";
      let chr1;
      let chr2;
      let chr3;
      let enc1;
      let enc2;
      let enc3;
      let enc4;
      let i = 0;
      input = utf8Encode(input);
      while (i < input.length) {
        chr1 = input.charCodeAt(i++);
        chr2 = input.charCodeAt(i++);
        chr3 = input.charCodeAt(i++);
        enc1 = chr1 >> 2;
        enc2 = (chr1 & 3) << 4 | chr2 >> 4;
        enc3 = (chr2 & 15) << 2 | chr3 >> 6;
        enc4 = chr3 & 63;
        if (isNaN(chr2)) {
          enc3 = enc4 = 64;
        } else if (isNaN(chr3)) {
          enc4 = 64;
        }
        output += `${base64Sequence.charAt(enc1)}${base64Sequence.charAt(enc2)}${base64Sequence.charAt(enc3)}${base64Sequence.charAt(enc4)}`;
      }
      return output;
    };
  })(Base64Encoder || (exports.Base64Encoder = Base64Encoder = {}));
});

// node_modules/jira.js/out/services/authenticationService/authentications/createBasicAuthenticationToken.js
var require_createBasicAuthenticationToken = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.createBasicAuthenticationToken = undefined;
  var base64Encoder_1 = require_base64Encoder();
  function createBasicAuthenticationToken(authenticationData) {
    let login;
    let secret;
    if ("username" in authenticationData) {
      login = authenticationData.username;
      secret = authenticationData.password;
    } else {
      login = authenticationData.email;
      secret = authenticationData.apiToken;
    }
    const token = base64Encoder_1.Base64Encoder.encode(`${login}:${secret}`);
    return `Basic ${token}`;
  }
  exports.createBasicAuthenticationToken = createBasicAuthenticationToken;
});

// node_modules/jira.js/out/services/authenticationService/authentications/createOAuth2AuthenticationToken.js
var require_createOAuth2AuthenticationToken = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.createOAuth2AuthenticationToken = undefined;
  function createOAuth2AuthenticationToken(authenticationData) {
    return `Bearer ${authenticationData.accessToken}`;
  }
  exports.createOAuth2AuthenticationToken = createOAuth2AuthenticationToken;
});

// node_modules/jira.js/out/services/authenticationService/authentications/createPATAuthentication.js
var require_createPATAuthentication = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.createPATAuthentication = undefined;
  function createPATAuthentication(pat) {
    return `Bearer ${pat}`;
  }
  exports.createPATAuthentication = createPATAuthentication;
});

// node_modules/jira.js/out/services/authenticationService/authentications/index.js
var require_authentications = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  var tslib_1 = require_tslib();
  tslib_1.__exportStar(require_createBasicAuthenticationToken(), exports);
  tslib_1.__exportStar(require_createOAuth2AuthenticationToken(), exports);
  tslib_1.__exportStar(require_createPATAuthentication(), exports);
});

// node_modules/jira.js/out/services/authenticationService/getAuthenticationToken.js
var require_getAuthenticationToken = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.getAuthenticationToken = undefined;
  var tslib_1 = require_tslib();
  var authentications_1 = require_authentications();
  function getAuthenticationToken(authentication) {
    return tslib_1.__awaiter(this, undefined, undefined, function* () {
      if (!authentication) {
        return;
      }
      if (authentication.basic) {
        return (0, authentications_1.createBasicAuthenticationToken)(authentication.basic);
      }
      if (authentication.oauth2) {
        return (0, authentications_1.createOAuth2AuthenticationToken)(authentication.oauth2);
      }
      if (authentication.personalAccessToken) {
        return (0, authentications_1.createPATAuthentication)(authentication.personalAccessToken);
      }
      return;
    });
  }
  exports.getAuthenticationToken = getAuthenticationToken;
});

// node_modules/jira.js/out/services/authenticationService/index.js
var require_authenticationService = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  var tslib_1 = require_tslib();
  tslib_1.__exportStar(require_getAuthenticationToken(), exports);
});

// node_modules/jira.js/out/clients/baseClient.js
var require_baseClient = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.BaseClient = undefined;
  var tslib_1 = require_tslib();
  var axios_1 = require_axios();
  var authenticationService_1 = require_authenticationService();
  var STRICT_GDPR_FLAG = "x-atlassian-force-account-id";
  var ATLASSIAN_TOKEN_CHECK_FLAG = "X-Atlassian-Token";
  var ATLASSIAN_TOKEN_CHECK_NOCHECK_VALUE = "no-check";

  class BaseClient {
    constructor(config) {
      var _a;
      this.config = config;
      try {
        new URL(config.host);
      } catch (e) {
        throw new Error("Couldn't parse the host URL. Perhaps you forgot to add 'http://' or 'https://' at the beginning of the URL?");
      }
      this.instance = axios_1.default.create(Object.assign(Object.assign({ paramsSerializer: this.paramSerializer.bind(this) }, config.baseRequestConfig), { baseURL: config.host, headers: this.removeUndefinedProperties(Object.assign({ [STRICT_GDPR_FLAG]: config.strictGDPR, [ATLASSIAN_TOKEN_CHECK_FLAG]: config.noCheckAtlassianToken ? ATLASSIAN_TOKEN_CHECK_NOCHECK_VALUE : undefined }, (_a = config.baseRequestConfig) === null || _a === undefined ? undefined : _a.headers)) }));
    }
    paramSerializer(parameters) {
      const parts = [];
      Object.entries(parameters).forEach(([key, value]) => {
        if (value === null || typeof value === "undefined") {
          return;
        }
        if (Array.isArray(value)) {
          value = value.join(",");
        }
        if (value instanceof Date) {
          value = value.toISOString();
        } else if (value !== null && typeof value === "object") {
          value = JSON.stringify(value);
        } else if (value instanceof Function) {
          const part = value();
          return part && parts.push(part);
        }
        parts.push(`${this.encode(key)}=${this.encode(value)}`);
      });
      return parts.join("&");
    }
    encode(value) {
      return encodeURIComponent(value).replace(/%3A/gi, ":").replace(/%24/g, "$").replace(/%2C/gi, ",").replace(/%20/g, "+").replace(/%5B/gi, "[").replace(/%5D/gi, "]");
    }
    removeUndefinedProperties(obj2) {
      return Object.entries(obj2).filter(([, value]) => typeof value !== "undefined").reduce((accumulator, [key, value]) => Object.assign(Object.assign({}, accumulator), { [key]: value }), {});
    }
    sendRequest(requestConfig, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        try {
          const response = yield this.sendRequestFullResponse(requestConfig);
          return this.handleSuccessResponse(response.data, callback);
        } catch (e) {
          return this.handleFailedResponse(e, callback);
        }
      });
    }
    sendRequestFullResponse(requestConfig) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const modifiedRequestConfig = Object.assign(Object.assign({}, requestConfig), { headers: this.removeUndefinedProperties(Object.assign({ Authorization: yield (0, authenticationService_1.getAuthenticationToken)(this.config.authentication) }, requestConfig.headers)) });
        return this.instance.request(modifiedRequestConfig);
      });
    }
    handleSuccessResponse(response, callback) {
      var _a, _b;
      const callbackResponseHandler = callback && ((data) => callback(null, data));
      const defaultResponseHandler = (data) => data;
      const responseHandler = callbackResponseHandler !== null && callbackResponseHandler !== undefined ? callbackResponseHandler : defaultResponseHandler;
      (_b = (_a = this.config.middlewares) === null || _a === undefined ? undefined : _a.onResponse) === null || _b === undefined || _b.call(_a, response.data);
      return responseHandler(response);
    }
    handleFailedResponse(e, callback) {
      var _a, _b;
      const err = axios_1.default.isAxiosError(e) && e.response ? this.buildErrorHandlingResponse(e) : e;
      const callbackErrorHandler = callback && ((error) => callback(error));
      const defaultErrorHandler = (error) => {
        throw error;
      };
      const errorHandler = callbackErrorHandler !== null && callbackErrorHandler !== undefined ? callbackErrorHandler : defaultErrorHandler;
      (_b = (_a = this.config.middlewares) === null || _a === undefined ? undefined : _a.onError) === null || _b === undefined || _b.call(_a, err);
      return errorHandler(err);
    }
    buildErrorHandlingResponse(error) {
      var _a, _b, _c, _d;
      return Object.assign({ code: error.code, status: (_a = error.response) === null || _a === undefined ? undefined : _a.status, statusText: (_b = error.response) === null || _b === undefined ? undefined : _b.statusText }, (_d = (_c = error.response) === null || _c === undefined ? undefined : _c.data) !== null && _d !== undefined ? _d : {});
    }
  }
  exports.BaseClient = BaseClient;
});

// node_modules/jira.js/out/clients/client.js
var require_client = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/announcementBanner.js
var require_announcementBanner = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.AnnouncementBanner = undefined;
  var tslib_1 = require_tslib();

  class AnnouncementBanner {
    constructor(client) {
      this.client = client;
    }
    getBanner(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/announcementBanner",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setBanner(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/announcementBanner",
          method: "PUT",
          data: {
            isDismissible: parameters.isDismissible,
            isEnabled: parameters.isEnabled,
            message: parameters.message,
            visibility: parameters.visibility
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.AnnouncementBanner = AnnouncementBanner;
});

// node_modules/jira.js/out/version2/applicationRoles.js
var require_applicationRoles = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ApplicationRoles = undefined;
  var tslib_1 = require_tslib();

  class ApplicationRoles {
    constructor(client) {
      this.client = client;
    }
    getAllApplicationRoles(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/applicationrole",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getApplicationRole(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const key = typeof parameters === "string" ? parameters : parameters.key;
        const config = {
          url: `/rest/api/2/applicationrole/${key}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.ApplicationRoles = ApplicationRoles;
});

// node_modules/jira.js/out/version2/appMigration.js
var require_appMigration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.AppMigration = undefined;
  var tslib_1 = require_tslib();

  class AppMigration {
    constructor(client) {
      this.client = client;
    }
    updateIssueFields(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/atlassian-connect/1/migration/field",
          method: "PUT",
          headers: {
            "Atlassian-Account-Id": parameters.accountId,
            "Atlassian-Transfer-Id": parameters.transferId
          },
          data: {
            updateValueList: parameters.updateValueList
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateEntityPropertiesValue(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/atlassian-connect/1/migration/properties/${parameters.entityType}`,
          method: "PUT",
          headers: {
            "Atlassian-Account-Id": parameters.accountId,
            "Atlassian-Transfer-Id": parameters.transferId,
            "Content-Type": "application/json"
          },
          data: parameters.entities
        };
        return this.client.sendRequest(config, callback);
      });
    }
    workflowRuleSearch(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/atlassian-connect/1/migration/workflow/rule/search",
          method: "POST",
          headers: {
            "Atlassian-Transfer-Id": parameters.transferId
          },
          data: {
            expand: parameters.expand,
            ruleIds: parameters.ruleIds,
            workflowEntityId: parameters.workflowEntityId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.AppMigration = AppMigration;
});

// node_modules/jira.js/out/version2/appProperties.js
var require_appProperties = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.AppProperties = undefined;
  var tslib_1 = require_tslib();

  class AppProperties {
    constructor(client) {
      this.client = client;
    }
    getAddonProperties(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const addonKey = typeof parameters === "string" ? parameters : parameters.addonKey;
        const config = {
          url: `/rest/atlassian-connect/1/addons/${addonKey}/properties`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAddonProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/atlassian-connect/1/addons/${parameters.addonKey}/properties/${parameters.propertyKey}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    putAddonProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/atlassian-connect/1/addons/${parameters.addonKey}/properties/${parameters.propertyKey}`,
          method: "PUT",
          data: parameters.propertyValue
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteAddonProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/atlassian-connect/1/addons/${parameters.addonKey}/properties/${parameters.propertyKey}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    putAppProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/forge/1/app/properties/${parameters.propertyKey}`,
          method: "PUT",
          data: parameters.propertyValue
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteAppProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/forge/1/app/properties/${parameters.propertyKey}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.AppProperties = AppProperties;
});

// node_modules/jira.js/out/version2/auditRecords.js
var require_auditRecords = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.AuditRecords = undefined;
  var tslib_1 = require_tslib();

  class AuditRecords {
    constructor(client) {
      this.client = client;
    }
    getAuditRecords(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/auditing/record",
          method: "GET",
          params: {
            offset: parameters === null || parameters === undefined ? undefined : parameters.offset,
            limit: parameters === null || parameters === undefined ? undefined : parameters.limit,
            filter: parameters === null || parameters === undefined ? undefined : parameters.filter,
            from: parameters === null || parameters === undefined ? undefined : parameters.from,
            to: parameters === null || parameters === undefined ? undefined : parameters.to
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.AuditRecords = AuditRecords;
});

// node_modules/jira.js/out/version2/avatars.js
var require_avatars = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Avatars = undefined;
  var tslib_1 = require_tslib();

  class Avatars {
    constructor(client) {
      this.client = client;
    }
    getAllSystemAvatars(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const type = typeof parameters === "string" ? parameters : parameters.type;
        const config = {
          url: `/rest/api/2/avatar/${type}/system`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAvatars(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/universal_avatar/type/${parameters.type}/owner/${parameters.entityId}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    storeAvatar(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/universal_avatar/type/${parameters.type}/owner/${parameters.entityId}`,
          method: "POST",
          params: {
            x: parameters.x,
            y: parameters.y,
            size: parameters.size
          },
          data: parameters.avatar
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteAvatar(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/universal_avatar/type/${parameters.type}/owner/${parameters.owningObjectId}/avatar/${parameters.id}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAvatarImageByType(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const type = typeof parameters === "string" ? parameters : parameters.type;
        const config = {
          url: `/rest/api/2/universal_avatar/view/type/${type}`,
          method: "GET",
          responseType: "arraybuffer",
          params: {
            size: typeof parameters !== "string" && parameters.size,
            format: typeof parameters !== "string" && parameters.format
          }
        };
        const { data: avatar, headers: { "content-type": contentTypeWithEncoding } } = yield this.client.sendRequestFullResponse(config);
        const contentType = contentTypeWithEncoding.split(";")[0].trim();
        return this.client.handleSuccessResponse({ contentType, avatar }, callback);
      });
    }
    getAvatarImageByID(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/universal_avatar/view/type/${parameters.type}/avatar/${parameters.id}`,
          method: "GET",
          responseType: "arraybuffer",
          params: {
            size: parameters.size,
            format: parameters.format
          }
        };
        const { data: avatar, headers: { "content-type": contentTypeWithEncoding } } = yield this.client.sendRequestFullResponse(config);
        const contentType = contentTypeWithEncoding.split(";")[0].trim();
        return this.client.handleSuccessResponse({ contentType, avatar }, callback);
      });
    }
    getAvatarImageByOwner(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/universal_avatar/view/type/${parameters.type}/owner/${parameters.entityId}`,
          method: "GET",
          responseType: "arraybuffer",
          params: {
            size: parameters.size,
            format: parameters.format
          }
        };
        const { data: avatar, headers: { "content-type": contentTypeWithEncoding } } = yield this.client.sendRequestFullResponse(config);
        const contentType = contentTypeWithEncoding.split(";")[0].trim();
        return this.client.handleSuccessResponse({ contentType, avatar }, callback);
      });
    }
  }
  exports.Avatars = Avatars;
});

// node_modules/jira.js/out/paramSerializer.js
var require_paramSerializer = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.paramSerializer = undefined;
  function paramSerializer(key, values) {
    if (typeof values === "string" || typeof values === "number") {
      return `${key}=${values}`;
    }
    if (!values || !values.length) {
      return;
    }
    return () => values.map((value) => `${key}=${value}`).join("&");
  }
  exports.paramSerializer = paramSerializer;
});

// node_modules/jira.js/out/version2/dashboards.js
var require_dashboards = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Dashboards = undefined;
  var tslib_1 = require_tslib();
  var paramSerializer_1 = require_paramSerializer();

  class Dashboards {
    constructor(client) {
      this.client = client;
    }
    getAllDashboards(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/dashboard",
          method: "GET",
          params: {
            filter: parameters === null || parameters === undefined ? undefined : parameters.filter,
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createDashboard(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/dashboard",
          method: "POST",
          data: {
            description: parameters.description,
            editPermissions: parameters.editPermissions,
            name: parameters.name,
            sharePermissions: parameters.sharePermissions
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    bulkEditDashboards(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/dashboard/bulk/edit",
          method: "PUT",
          data: {
            action: parameters.action,
            changeOwnerDetails: parameters.changeOwnerDetails,
            entityIds: parameters.entityIds,
            extendAdminPermissions: parameters.extendAdminPermissions,
            permissionDetails: parameters.permissionDetails
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAllAvailableDashboardGadgets(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/dashboard/gadgets",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getDashboardsPaginated(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/dashboard/search",
          method: "GET",
          params: {
            dashboardName: parameters === null || parameters === undefined ? undefined : parameters.dashboardName,
            accountId: parameters === null || parameters === undefined ? undefined : parameters.accountId,
            groupname: parameters === null || parameters === undefined ? undefined : parameters.groupname,
            groupId: parameters === null || parameters === undefined ? undefined : parameters.groupId,
            projectId: parameters === null || parameters === undefined ? undefined : parameters.projectId,
            orderBy: parameters === null || parameters === undefined ? undefined : parameters.orderBy,
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            status: parameters === null || parameters === undefined ? undefined : parameters.status,
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAllGadgets(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/dashboard/${parameters.dashboardId}/gadget`,
          method: "GET",
          params: {
            moduleKey: (0, paramSerializer_1.paramSerializer)("moduleKey", parameters.moduleKey),
            uri: parameters.uri,
            gadgetId: (0, paramSerializer_1.paramSerializer)("gadgetId", parameters.gadgetId)
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    addGadget(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/dashboard/${parameters.dashboardId}/gadget`,
          method: "POST",
          data: {
            color: parameters.color,
            ignoreUriAndModuleKeyValidation: parameters.ignoreUriAndModuleKeyValidation,
            moduleKey: parameters.moduleKey,
            position: parameters.position,
            title: parameters.title,
            uri: parameters.uri
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateGadget(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/dashboard/${parameters.dashboardId}/gadget/${parameters.gadgetId}`,
          method: "PUT",
          data: {
            color: parameters.color,
            position: parameters.position,
            title: parameters.title
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeGadget(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/dashboard/${parameters.dashboardId}/gadget/${parameters.gadgetId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getDashboardItemPropertyKeys(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/dashboard/${parameters.dashboardId}/items/${parameters.itemId}/properties`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getDashboardItemProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/dashboard/${parameters.dashboardId}/items/${parameters.itemId}/properties/${parameters.propertyKey}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setDashboardItemProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/dashboard/${parameters.dashboardId}/items/${parameters.itemId}/properties/${parameters.propertyKey}`,
          method: "PUT",
          headers: {
            "Content-Type": "application/json"
          },
          data: parameters.propertyValue
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteDashboardItemProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/dashboard/${parameters.dashboardId}/items/${parameters.itemId}/properties/${parameters.propertyKey}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getDashboard(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/dashboard/${id}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateDashboard(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/dashboard/${parameters.id}`,
          method: "PUT",
          data: {
            description: parameters.description,
            editPermissions: parameters.editPermissions,
            name: parameters.name,
            sharePermissions: parameters.sharePermissions
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteDashboard(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/dashboard/${id}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    copyDashboard(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/dashboard/${parameters.id}/copy`,
          method: "POST",
          data: {
            description: parameters.description,
            editPermissions: parameters.editPermissions,
            name: parameters.name,
            sharePermissions: parameters.sharePermissions
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Dashboards = Dashboards;
});

// node_modules/jira.js/out/version2/dynamicModules.js
var require_dynamicModules = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.DynamicModules = undefined;
  var tslib_1 = require_tslib();

  class DynamicModules {
    constructor(client) {
      this.client = client;
    }
    getModules(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/atlassian-connect/1/app/module/dynamic",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    registerModules(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/atlassian-connect/1/app/module/dynamic",
          method: "POST",
          data: {
            modules: parameters === null || parameters === undefined ? undefined : parameters.modules
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeModules(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/atlassian-connect/1/app/module/dynamic",
          method: "DELETE",
          params: {
            moduleKey: parameters === null || parameters === undefined ? undefined : parameters.moduleKey
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.DynamicModules = DynamicModules;
});

// node_modules/jira.js/out/version2/filters.js
var require_filters = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Filters = undefined;
  var tslib_1 = require_tslib();

  class Filters {
    constructor(client) {
      this.client = client;
    }
    createFilter(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/filter",
          method: "POST",
          params: {
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand,
            overrideSharePermissions: parameters === null || parameters === undefined ? undefined : parameters.overrideSharePermissions
          },
          data: {
            description: parameters.description,
            editPermissions: parameters.editPermissions,
            favourite: parameters.favourite,
            favouritedCount: parameters.favouritedCount,
            id: parameters.id,
            jql: parameters.jql,
            name: parameters.name,
            owner: parameters.owner,
            searchUrl: parameters.searchUrl,
            self: parameters.self,
            sharePermissions: parameters.sharePermissions,
            sharedUsers: parameters.sharedUsers,
            subscriptions: parameters.subscriptions,
            viewUrl: parameters.viewUrl
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getFavouriteFilters(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/filter/favourite",
          method: "GET",
          params: {
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getMyFilters(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/filter/my",
          method: "GET",
          params: {
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand,
            includeFavourites: parameters === null || parameters === undefined ? undefined : parameters.includeFavourites
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getFiltersPaginated(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/filter/search",
          method: "GET",
          params: {
            filterName: parameters === null || parameters === undefined ? undefined : parameters.filterName,
            accountId: parameters === null || parameters === undefined ? undefined : parameters.accountId,
            groupname: parameters === null || parameters === undefined ? undefined : parameters.groupname,
            groupId: parameters === null || parameters === undefined ? undefined : parameters.groupId,
            projectId: parameters === null || parameters === undefined ? undefined : parameters.projectId,
            id: parameters === null || parameters === undefined ? undefined : parameters.id,
            orderBy: parameters === null || parameters === undefined ? undefined : parameters.orderBy,
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand,
            overrideSharePermissions: parameters === null || parameters === undefined ? undefined : parameters.overrideSharePermissions
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getFilter(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/filter/${id}`,
          method: "GET",
          params: {
            expand: typeof parameters !== "string" && parameters.expand,
            overrideSharePermissions: typeof parameters !== "string" && parameters.overrideSharePermissions
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateFilter(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/filter/${parameters.id}`,
          method: "PUT",
          params: {
            expand: parameters.expand,
            overrideSharePermissions: parameters.overrideSharePermissions
          },
          data: {
            name: parameters.name,
            description: parameters.description,
            jql: parameters.jql,
            favourite: parameters.favourite,
            sharePermissions: parameters.sharePermissions
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteFilter(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/filter/${id}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getColumns(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/filter/${id}/columns`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setColumns(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/filter/${parameters.id}/columns`,
          method: "PUT",
          data: parameters.columns
        };
        return this.client.sendRequest(config, callback);
      });
    }
    resetColumns(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/filter/${parameters.id}/columns`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setFavouriteForFilter(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/filter/${id}/favourite`,
          method: "PUT",
          params: {
            expand: typeof parameters !== "string" && parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteFavouriteForFilter(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/filter/${id}/favourite`,
          method: "DELETE",
          params: {
            expand: typeof parameters !== "string" && parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    changeFilterOwner(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/filter/${parameters.id}/owner`,
          method: "PUT",
          data: {
            accountId: parameters.accountId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Filters = Filters;
});

// node_modules/jira.js/out/version2/filterSharing.js
var require_filterSharing = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.FilterSharing = undefined;
  var tslib_1 = require_tslib();

  class FilterSharing {
    constructor(client) {
      this.client = client;
    }
    getDefaultShareScope(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/filter/defaultShareScope",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setDefaultShareScope(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const scope = typeof parameters === "string" ? parameters : parameters.scope;
        const config = {
          url: "/rest/api/2/filter/defaultShareScope",
          method: "PUT",
          data: {
            scope
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getSharePermissions(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/filter/${id}/permission`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    addSharePermission(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/filter/${parameters.id}/permission`,
          method: "POST",
          data: {
            type: parameters.type,
            projectId: parameters.projectId,
            groupname: parameters.groupname,
            projectRoleId: parameters.projectRoleId,
            accountId: parameters.accountId,
            rights: parameters.rights,
            groupId: parameters.groupId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getSharePermission(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/filter/${parameters.id}/permission/${parameters.permissionId}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteSharePermission(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/filter/${parameters.id}/permission/${parameters.permissionId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.FilterSharing = FilterSharing;
});

// node_modules/jira.js/out/version2/groupAndUserPicker.js
var require_groupAndUserPicker = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.GroupAndUserPicker = undefined;
  var tslib_1 = require_tslib();

  class GroupAndUserPicker {
    constructor(client) {
      this.client = client;
    }
    findUsersAndGroups(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/groupuserpicker",
          method: "GET",
          params: {
            query: parameters.query,
            maxResults: parameters.maxResults,
            showAvatar: parameters.showAvatar,
            fieldId: parameters.fieldId,
            projectId: parameters.projectId,
            issueTypeId: parameters.issueTypeId,
            avatarSize: parameters.avatarSize,
            caseInsensitive: parameters.caseInsensitive,
            excludeConnectAddons: parameters.excludeConnectAddons
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.GroupAndUserPicker = GroupAndUserPicker;
});

// node_modules/jira.js/out/version2/groups.js
var require_groups = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Groups = undefined;
  var tslib_1 = require_tslib();

  class Groups {
    constructor(client) {
      this.client = client;
    }
    createGroup(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/group",
          method: "POST",
          data: parameters
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeGroup(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/group",
          method: "DELETE",
          params: {
            groupname: parameters === null || parameters === undefined ? undefined : parameters.groupname,
            groupId: parameters === null || parameters === undefined ? undefined : parameters.groupId,
            swapGroup: parameters === null || parameters === undefined ? undefined : parameters.swapGroup,
            swapGroupId: parameters === null || parameters === undefined ? undefined : parameters.swapGroupId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    bulkGetGroups(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/group/bulk",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            groupId: parameters === null || parameters === undefined ? undefined : parameters.groupId,
            groupName: parameters === null || parameters === undefined ? undefined : parameters.groupName,
            accessType: parameters === null || parameters === undefined ? undefined : parameters.accessType,
            applicationKey: parameters === null || parameters === undefined ? undefined : parameters.applicationKey
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getUsersFromGroup(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/group/member",
          method: "GET",
          params: {
            groupname: parameters.groupname,
            groupId: parameters.groupId,
            includeInactiveUsers: parameters.includeInactiveUsers,
            startAt: parameters.startAt,
            maxResults: parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    addUserToGroup(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/group/user",
          method: "POST",
          params: {
            groupname: parameters.groupName,
            groupId: parameters.groupId
          },
          data: {
            name: parameters.name,
            accountId: parameters.accountId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeUserFromGroup(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/group/user",
          method: "DELETE",
          params: {
            groupname: parameters.groupname,
            groupId: parameters.groupId,
            username: parameters.username,
            accountId: parameters.accountId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    findGroups(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/groups/picker",
          method: "GET",
          params: {
            query: parameters === null || parameters === undefined ? undefined : parameters.query,
            exclude: parameters === null || parameters === undefined ? undefined : parameters.exclude,
            excludeId: parameters === null || parameters === undefined ? undefined : parameters.excludeId,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            caseInsensitive: parameters === null || parameters === undefined ? undefined : parameters.caseInsensitive
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Groups = Groups;
});

// node_modules/jira.js/out/version2/issueAttachments.js
var require_issueAttachments = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueAttachments = undefined;
  var tslib_1 = require_tslib();
  var FormData2 = require_form_data();

  class IssueAttachments {
    constructor(client) {
      this.client = client;
    }
    getAttachmentContent(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/attachment/content/${id}`,
          method: "GET",
          params: {
            redirect: typeof parameters !== "string" && parameters.redirect
          },
          responseType: "arraybuffer"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAttachmentMeta(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/attachment/meta",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAttachmentThumbnail(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/attachment/thumbnail/${id}`,
          method: "GET",
          params: {
            redirect: typeof parameters !== "string" && parameters.redirect,
            fallbackToDefault: typeof parameters !== "string" && parameters.fallbackToDefault,
            width: typeof parameters !== "string" && parameters.width,
            height: typeof parameters !== "string" && parameters.height
          },
          responseType: "arraybuffer"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAttachment(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/attachment/${id}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeAttachment(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/attachment/${id}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    expandAttachmentForHumans(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/attachment/${id}/expand/human`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    expandAttachmentForMachines(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/attachment/${id}/expand/raw`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    addAttachment(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        var _a;
        const formData = new FormData2;
        const attachments = Array.isArray(parameters.attachment) ? parameters.attachment : [parameters.attachment];
        attachments.forEach((attachment) => formData.append("file", attachment.file, attachment.filename));
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/attachments`,
          method: "POST",
          headers: Object.assign({ "X-Atlassian-Token": "no-check", "Content-Type": "multipart/form-data" }, (_a = formData.getHeaders) === null || _a === undefined ? undefined : _a.call(formData)),
          data: formData,
          maxBodyLength: Infinity,
          maxContentLength: Infinity
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueAttachments = IssueAttachments;
});

// node_modules/jira.js/out/version2/issueCommentProperties.js
var require_issueCommentProperties = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueCommentProperties = undefined;
  var tslib_1 = require_tslib();

  class IssueCommentProperties {
    constructor(client) {
      this.client = client;
    }
    getCommentPropertyKeys(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const commentId = typeof parameters === "string" ? parameters : parameters.commentId;
        const config = {
          url: `/rest/api/2/comment/${commentId}/properties`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getCommentProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/comment/${parameters.commentId}/properties/${parameters.propertyKey}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setCommentProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/comment/${parameters.commentId}/properties/${parameters.propertyKey}`,
          method: "PUT",
          data: parameters.property
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteCommentProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/comment/${parameters.commentId}/properties/${parameters.propertyKey}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueCommentProperties = IssueCommentProperties;
});

// node_modules/jira.js/out/version2/issueComments.js
var require_issueComments = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueComments = undefined;
  var tslib_1 = require_tslib();

  class IssueComments {
    constructor(client) {
      this.client = client;
    }
    getCommentsByIds(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/comment/list",
          method: "POST",
          params: {
            expand: parameters.expand
          },
          data: {
            ids: parameters.ids
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getComments(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueIdOrKey = typeof parameters === "string" ? parameters : parameters.issueIdOrKey;
        const config = {
          url: `/rest/api/2/issue/${issueIdOrKey}/comment`,
          method: "GET",
          params: {
            startAt: typeof parameters !== "string" && parameters.startAt,
            maxResults: typeof parameters !== "string" && parameters.maxResults,
            orderBy: typeof parameters !== "string" && parameters.orderBy,
            expand: typeof parameters !== "string" && parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    addComment(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/comment`,
          method: "POST",
          params: {
            expand: parameters.expand
          },
          data: {
            self: parameters.self,
            id: parameters.id,
            author: parameters.author,
            body: parameters.comment,
            renderedBody: parameters.renderedBody,
            updateAuthor: parameters.updateAuthor,
            created: parameters.created,
            updated: parameters.updated,
            visibility: parameters.visibility,
            jsdPublic: parameters.jsdPublic,
            jsdAuthorCanSeeRequest: parameters.jsdAuthorCanSeeRequest,
            properties: parameters.properties
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getComment(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/comment/${parameters.id}`,
          method: "GET",
          params: {
            expand: parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateComment(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/comment/${parameters.id}`,
          method: "PUT",
          params: {
            notifyUsers: parameters.notifyUsers,
            overrideEditableFlag: parameters.overrideEditableFlag,
            expand: parameters.expand
          },
          data: {
            body: parameters.comment,
            visibility: parameters.visibility,
            properties: parameters.properties
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteComment(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/comment/${parameters.id}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueComments = IssueComments;
});

// node_modules/jira.js/out/version2/issueCustomFieldConfigurationApps.js
var require_issueCustomFieldConfigurationApps = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueCustomFieldConfigurationApps = undefined;
  var tslib_1 = require_tslib();

  class IssueCustomFieldConfigurationApps {
    constructor(client) {
      this.client = client;
    }
    getCustomFieldConfiguration(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/app/field/${parameters.fieldIdOrKey}/context/configuration`,
          method: "GET",
          params: {
            id: parameters.id,
            fieldContextId: parameters.fieldContextId,
            issueId: parameters.issueId,
            projectKeyOrId: parameters.projectKeyOrId,
            issueTypeId: parameters.issueTypeId,
            startAt: parameters.startAt,
            maxResults: parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateCustomFieldConfiguration(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/app/field/${parameters.fieldIdOrKey}/context/configuration`,
          method: "PUT",
          data: {
            configurations: parameters.configurations
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueCustomFieldConfigurationApps = IssueCustomFieldConfigurationApps;
});

// node_modules/jira.js/out/version2/issueCustomFieldContexts.js
var require_issueCustomFieldContexts = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueCustomFieldContexts = undefined;
  var tslib_1 = require_tslib();

  class IssueCustomFieldContexts {
    constructor(client) {
      this.client = client;
    }
    getContextsForField(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const fieldId = typeof parameters === "string" ? parameters : parameters.fieldId;
        const config = {
          url: `/rest/api/2/field/${fieldId}/context`,
          method: "GET",
          params: {
            isAnyIssueType: typeof parameters !== "string" && parameters.isAnyIssueType,
            isGlobalContext: typeof parameters !== "string" && parameters.isGlobalContext,
            contextId: typeof parameters !== "string" && parameters.contextId,
            startAt: typeof parameters !== "string" && parameters.startAt,
            maxResults: typeof parameters !== "string" && parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createCustomFieldContext(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldId}/context`,
          method: "POST",
          data: {
            id: parameters.id,
            name: parameters.name,
            description: parameters.description,
            projectIds: parameters.projectIds,
            issueTypeIds: parameters.issueTypeIds
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getDefaultValues(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const fieldId = typeof parameters === "string" ? parameters : parameters.fieldId;
        const config = {
          url: `/rest/api/2/field/${fieldId}/context/defaultValue`,
          method: "GET",
          params: {
            contextId: typeof parameters !== "string" && parameters.contextId,
            startAt: typeof parameters !== "string" && parameters.startAt,
            maxResults: typeof parameters !== "string" && parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setDefaultValues(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldId}/context/defaultValue`,
          method: "PUT",
          data: {
            defaultValues: parameters.defaultValues
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssueTypeMappingsForContexts(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const fieldId = typeof parameters === "string" ? parameters : parameters.fieldId;
        const config = {
          url: `/rest/api/2/field/${fieldId}/context/issuetypemapping`,
          method: "GET",
          params: {
            contextId: typeof parameters !== "string" && parameters.contextId,
            startAt: typeof parameters !== "string" && parameters.startAt,
            maxResults: typeof parameters !== "string" && parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getCustomFieldContextsForProjectsAndIssueTypes(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldId}/context/mapping`,
          method: "POST",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults
          },
          data: {
            mappings: parameters.mappings
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getProjectContextMapping(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const fieldId = typeof parameters === "string" ? parameters : parameters.fieldId;
        const config = {
          url: `/rest/api/2/field/${fieldId}/context/projectmapping`,
          method: "GET",
          params: {
            contextId: typeof parameters !== "string" && parameters.contextId,
            startAt: typeof parameters !== "string" && parameters.startAt,
            maxResults: typeof parameters !== "string" && parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateCustomFieldContext(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldId}/context/${parameters.contextId}`,
          method: "PUT",
          data: {
            name: parameters.name,
            description: parameters.description
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteCustomFieldContext(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldId}/context/${parameters.contextId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    addIssueTypesToContext(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldId}/context/${parameters.contextId}/issuetype`,
          method: "PUT",
          data: {
            issueTypeIds: parameters.issueTypeIds
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeIssueTypesFromContext(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldId}/context/${parameters.contextId}/issuetype/remove`,
          method: "POST",
          data: {
            issueTypeIds: parameters.issueTypeIds
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    assignProjectsToCustomFieldContext(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldId}/context/${parameters.contextId}/project`,
          method: "PUT",
          data: {
            projectIds: parameters.projectIds
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeCustomFieldContextFromProjects(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldId}/context/${parameters.contextId}/project/remove`,
          method: "POST",
          data: {
            projectIds: parameters.projectIds
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueCustomFieldContexts = IssueCustomFieldContexts;
});

// node_modules/jira.js/out/version2/issueCustomFieldOptions.js
var require_issueCustomFieldOptions = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueCustomFieldOptions = undefined;
  var tslib_1 = require_tslib();

  class IssueCustomFieldOptions {
    constructor(client) {
      this.client = client;
    }
    getCustomFieldOption(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/customFieldOption/${id}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getOptionsForContext(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldId}/context/${parameters.contextId}/option`,
          method: "GET",
          params: {
            optionId: parameters.optionId,
            onlyOptions: parameters.onlyOptions,
            startAt: parameters.startAt,
            maxResults: parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createCustomFieldOption(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldId}/context/${parameters.contextId}/option`,
          method: "POST",
          data: {
            options: parameters.options
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateCustomFieldOption(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldId}/context/${parameters.contextId}/option`,
          method: "PUT",
          data: {
            options: parameters.options
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    reorderCustomFieldOptions(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldId}/context/${parameters.contextId}/option/move`,
          method: "PUT",
          data: {
            customFieldOptionIds: parameters.customFieldOptionIds,
            after: parameters.after,
            position: parameters.position
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteCustomFieldOption(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldId}/context/${parameters.contextId}/option/${parameters.optionId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueCustomFieldOptions = IssueCustomFieldOptions;
});

// node_modules/jira.js/out/version2/issueCustomFieldOptionsApps.js
var require_issueCustomFieldOptionsApps = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueCustomFieldOptionsApps = undefined;
  var tslib_1 = require_tslib();

  class IssueCustomFieldOptionsApps {
    constructor(client) {
      this.client = client;
    }
    getAllIssueFieldOptions(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const fieldKey = typeof parameters === "string" ? parameters : parameters.fieldKey;
        const config = {
          url: `/rest/api/2/field/${fieldKey}/option`,
          method: "GET",
          params: {
            startAt: typeof parameters !== "string" && parameters.startAt,
            maxResults: typeof parameters !== "string" && parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createIssueFieldOption(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldKey}/option`,
          method: "POST",
          data: {
            value: parameters.value,
            properties: parameters.properties,
            config: parameters.config
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getSelectableIssueFieldOptions(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const fieldKey = typeof parameters === "string" ? parameters : parameters.fieldKey;
        const config = {
          url: `/rest/api/2/field/${fieldKey}/option/suggestions/edit`,
          method: "GET",
          params: {
            startAt: typeof parameters !== "string" && parameters.startAt,
            maxResults: typeof parameters !== "string" && parameters.maxResults,
            projectId: typeof parameters !== "string" && parameters.projectId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getVisibleIssueFieldOptions(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const fieldKey = typeof parameters === "string" ? parameters : parameters.fieldKey;
        const config = {
          url: `/rest/api/2/field/${fieldKey}/option/suggestions/search`,
          method: "GET",
          params: {
            startAt: typeof parameters !== "string" && parameters.startAt,
            maxResults: typeof parameters !== "string" && parameters.maxResults,
            projectId: typeof parameters !== "string" && parameters.projectId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssueFieldOption(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldKey}/option/${parameters.optionId}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateIssueFieldOption(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldKey}/option/${parameters.optionId}`,
          method: "PUT",
          data: {
            id: parameters.id,
            value: parameters.value,
            properties: parameters.properties,
            config: parameters.config
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteIssueFieldOption(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldKey}/option/${parameters.optionId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    replaceIssueFieldOption(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldKey}/option/${parameters.optionId}/issue`,
          method: "DELETE",
          params: {
            replaceWith: parameters.replaceWith,
            jql: parameters.jql,
            overrideScreenSecurity: parameters.overrideScreenSecurity,
            overrideEditableFlag: parameters.overrideEditableFlag
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueCustomFieldOptionsApps = IssueCustomFieldOptionsApps;
});

// node_modules/jira.js/out/version2/issueCustomFieldValuesApps.js
var require_issueCustomFieldValuesApps = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueCustomFieldValuesApps = undefined;
  var tslib_1 = require_tslib();

  class IssueCustomFieldValuesApps {
    constructor(client) {
      this.client = client;
    }
    updateMultipleCustomFieldValues(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/app/field/value",
          method: "POST",
          params: {
            generateChangelog: parameters.generateChangelog
          },
          data: {
            updates: parameters.updates
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateCustomFieldValue(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/app/field/${parameters.fieldIdOrKey}/value`,
          method: "PUT",
          params: {
            generateChangelog: parameters.generateChangelog
          },
          data: {
            updates: parameters.updates
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueCustomFieldValuesApps = IssueCustomFieldValuesApps;
});

// node_modules/jira.js/out/version2/issueFieldConfigurations.js
var require_issueFieldConfigurations = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueFieldConfigurations = undefined;
  var tslib_1 = require_tslib();

  class IssueFieldConfigurations {
    constructor(client) {
      this.client = client;
    }
    getAllFieldConfigurations(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/fieldconfiguration",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            id: parameters === null || parameters === undefined ? undefined : parameters.id,
            isDefault: parameters === null || parameters === undefined ? undefined : parameters.isDefault,
            query: parameters === null || parameters === undefined ? undefined : parameters.query
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createFieldConfiguration(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/fieldconfiguration",
          method: "POST",
          data: {
            name: parameters === null || parameters === undefined ? undefined : parameters.name,
            description: parameters === null || parameters === undefined ? undefined : parameters.description
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateFieldConfiguration(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/fieldconfiguration/${parameters.id}`,
          method: "PUT",
          data: {
            name: parameters.name,
            description: parameters.description
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteFieldConfiguration(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/fieldconfiguration/${id}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getFieldConfigurationItems(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/fieldconfiguration/${id}/fields`,
          method: "GET",
          params: {
            startAt: typeof parameters !== "string" && parameters.startAt,
            maxResults: typeof parameters !== "string" && parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateFieldConfigurationItems(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/fieldconfiguration/${parameters.id}/fields`,
          method: "PUT",
          data: {
            fieldConfigurationItems: parameters.fieldConfigurationItems
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAllFieldConfigurationSchemes(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/fieldconfigurationscheme",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            id: parameters === null || parameters === undefined ? undefined : parameters.id
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createFieldConfigurationScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/fieldconfigurationscheme",
          method: "POST",
          data: {
            name: parameters === null || parameters === undefined ? undefined : parameters.name,
            description: parameters === null || parameters === undefined ? undefined : parameters.description
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getFieldConfigurationSchemeMappings(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/fieldconfigurationscheme/mapping",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            fieldConfigurationSchemeId: parameters === null || parameters === undefined ? undefined : parameters.fieldConfigurationSchemeId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getFieldConfigurationSchemeProjectMapping(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/fieldconfigurationscheme/project",
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults,
            projectId: parameters.projectId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    assignFieldConfigurationSchemeToProject(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/fieldconfigurationscheme/project",
          method: "PUT",
          data: {
            fieldConfigurationSchemeId: parameters.fieldConfigurationSchemeId,
            projectId: parameters.projectId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateFieldConfigurationScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/fieldconfigurationscheme/${parameters.id}`,
          method: "PUT",
          data: {
            name: parameters.name,
            description: parameters.description
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteFieldConfigurationScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/fieldconfigurationscheme/${id}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setFieldConfigurationSchemeMapping(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/fieldconfigurationscheme/${parameters.id}/mapping`,
          method: "PUT",
          data: {
            mappings: parameters.mappings
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeIssueTypesFromGlobalFieldConfigurationScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/fieldconfigurationscheme/${parameters.id}/mapping/delete`,
          method: "POST",
          data: {
            issueTypeIds: parameters.issueTypeIds
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueFieldConfigurations = IssueFieldConfigurations;
});

// node_modules/jira.js/out/version2/issueFields.js
var require_issueFields = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueFields = undefined;
  var tslib_1 = require_tslib();

  class IssueFields {
    constructor(client) {
      this.client = client;
    }
    getFields(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/field",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createCustomField(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/field",
          method: "POST",
          data: {
            name: parameters === null || parameters === undefined ? undefined : parameters.name,
            description: parameters === null || parameters === undefined ? undefined : parameters.description,
            type: parameters === null || parameters === undefined ? undefined : parameters.type,
            searcherKey: parameters === null || parameters === undefined ? undefined : parameters.searcherKey
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getFieldsPaginated(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/field/search",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            type: parameters === null || parameters === undefined ? undefined : parameters.type,
            id: parameters === null || parameters === undefined ? undefined : parameters.id,
            query: parameters === null || parameters === undefined ? undefined : parameters.query,
            orderBy: parameters === null || parameters === undefined ? undefined : parameters.orderBy,
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getTrashedFieldsPaginated(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/field/search/trashed",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            id: parameters === null || parameters === undefined ? undefined : parameters.id,
            query: parameters === null || parameters === undefined ? undefined : parameters.query,
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand,
            orderBy: parameters === null || parameters === undefined ? undefined : parameters.orderBy
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateCustomField(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.fieldId}`,
          method: "PUT",
          data: {
            name: parameters.name,
            description: parameters.description,
            searcherKey: parameters.searcherKey
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteCustomField(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.id}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    restoreCustomField(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.id}/restore`,
          method: "POST"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    trashCustomField(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/field/${parameters.id}/trash`,
          method: "POST"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueFields = IssueFields;
});

// node_modules/jira.js/out/version2/issueLinks.js
var require_issueLinks = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueLinks = undefined;
  var tslib_1 = require_tslib();

  class IssueLinks {
    constructor(client) {
      this.client = client;
    }
    linkIssues(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issueLink",
          method: "POST",
          data: {
            type: parameters.type,
            inwardIssue: parameters.inwardIssue,
            outwardIssue: parameters.outwardIssue,
            comment: parameters.comment
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssueLink(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const linkId = typeof parameters === "string" ? parameters : parameters.linkId;
        const config = {
          url: `/rest/api/2/issueLink/${linkId}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteIssueLink(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const linkId = typeof parameters === "string" ? parameters : parameters.linkId;
        const config = {
          url: `/rest/api/2/issueLink/${linkId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueLinks = IssueLinks;
});

// node_modules/jira.js/out/version2/issueLinkTypes.js
var require_issueLinkTypes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueLinkTypes = undefined;
  var tslib_1 = require_tslib();

  class IssueLinkTypes {
    constructor(client) {
      this.client = client;
    }
    getIssueLinkTypes(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issueLinkType",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createIssueLinkType(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issueLinkType",
          method: "POST",
          data: {
            id: parameters.id,
            inward: parameters.inward,
            name: parameters.name,
            outward: parameters.outward,
            self: parameters.self
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssueLinkType(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueLinkTypeId = typeof parameters === "string" ? parameters : parameters.issueLinkTypeId;
        const config = {
          url: `/rest/api/2/issueLinkType/${issueLinkTypeId}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateIssueLinkType(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issueLinkType/${parameters.issueLinkTypeId}`,
          method: "PUT",
          data: {
            id: parameters.id,
            inward: parameters.inward,
            name: parameters.name,
            outward: parameters.outward,
            self: parameters.self
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteIssueLinkType(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueLinkTypeId = typeof parameters === "string" ? parameters : parameters.issueLinkTypeId;
        const config = {
          url: `/rest/api/2/issueLinkType/${issueLinkTypeId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueLinkTypes = IssueLinkTypes;
});

// node_modules/jira.js/out/version2/issueNavigatorSettings.js
var require_issueNavigatorSettings = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueNavigatorSettings = undefined;
  var tslib_1 = require_tslib();

  class IssueNavigatorSettings {
    constructor(client) {
      this.client = client;
    }
    getIssueNavigatorDefaultColumns(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/settings/columns",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setIssueNavigatorDefaultColumns(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/settings/columns",
          method: "PUT"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueNavigatorSettings = IssueNavigatorSettings;
});

// node_modules/jira.js/out/version2/issueNotificationSchemes.js
var require_issueNotificationSchemes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueNotificationSchemes = undefined;
  var tslib_1 = require_tslib();

  class IssueNotificationSchemes {
    constructor(client) {
      this.client = client;
    }
    getNotificationSchemes(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/notificationscheme",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            id: parameters === null || parameters === undefined ? undefined : parameters.id,
            projectId: parameters === null || parameters === undefined ? undefined : parameters.projectId,
            onlyDefault: parameters === null || parameters === undefined ? undefined : parameters.onlyDefault,
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createNotificationScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/notificationscheme",
          method: "POST",
          data: {
            description: parameters.description,
            name: parameters.name,
            notificationSchemeEvents: parameters.notificationSchemeEvents
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getNotificationSchemeToProjectMappings(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/notificationscheme/project",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            notificationSchemeId: parameters === null || parameters === undefined ? undefined : parameters.notificationSchemeId,
            projectId: parameters === null || parameters === undefined ? undefined : parameters.projectId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getNotificationScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/notificationscheme/${id}`,
          method: "GET",
          params: {
            expand: typeof parameters !== "string" && parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateNotificationScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/notificationscheme/${parameters.id}`,
          method: "PUT",
          data: {
            description: parameters.description,
            name: parameters.name
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteNotificationScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/notificationscheme/${parameters.notificationSchemeId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeNotificationFromNotificationScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/notificationscheme/${parameters.notificationSchemeId}/notification/${parameters.notificationId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueNotificationSchemes = IssueNotificationSchemes;
});

// node_modules/jira.js/out/version2/issuePriorities.js
var require_issuePriorities = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssuePriorities = undefined;
  var tslib_1 = require_tslib();
  var paramSerializer_1 = require_paramSerializer();

  class IssuePriorities {
    constructor(client) {
      this.client = client;
    }
    getPriorities(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/priority",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createPriority(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/priority",
          method: "POST",
          data: {
            description: parameters.description,
            iconUrl: parameters.iconUrl,
            name: parameters.name,
            statusColor: parameters.statusColor
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setDefaultPriority(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/priority/default",
          method: "PUT",
          data: {
            id: parameters === null || parameters === undefined ? undefined : parameters.id
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    movePriorities(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/priority/move",
          method: "PUT",
          data: {
            ids: parameters.ids,
            after: parameters.after,
            position: parameters.position
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    searchPriorities(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/priority/search",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            id: parameters === null || parameters === undefined ? undefined : parameters.id,
            projectId: (0, paramSerializer_1.paramSerializer)("projectId", parameters === null || parameters === undefined ? undefined : parameters.projectId),
            onlyDefault: parameters === null || parameters === undefined ? undefined : parameters.onlyDefault
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getPriority(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/priority/${id}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updatePriority(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/priority/${parameters.id}`,
          method: "PUT",
          data: {
            description: parameters.description,
            iconUrl: parameters.iconUrl,
            name: parameters.name,
            statusColor: parameters.statusColor
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssuePriorities = IssuePriorities;
});

// node_modules/jira.js/out/version2/issueProperties.js
var require_issueProperties = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueProperties = undefined;
  var tslib_1 = require_tslib();

  class IssueProperties {
    constructor(client) {
      this.client = client;
    }
    bulkSetIssuesProperties(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issue/properties",
          method: "POST",
          data: {
            entitiesIds: parameters === null || parameters === undefined ? undefined : parameters.entitiesIds,
            properties: parameters === null || parameters === undefined ? undefined : parameters.properties
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    bulkSetIssuePropertiesByIssue(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issue/properties/multi",
          method: "POST",
          data: {
            issues: parameters === null || parameters === undefined ? undefined : parameters.issues
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    bulkSetIssueProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/properties/${parameters.propertyKey}`,
          method: "PUT",
          data: {
            value: parameters.value,
            expression: parameters.expression,
            filter: parameters.filter
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    bulkDeleteIssueProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/properties/${parameters.propertyKey}`,
          method: "DELETE",
          data: {
            entityIds: parameters.entityIds,
            currentValue: parameters.currentValue
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssuePropertyKeys(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueIdOrKey = typeof parameters === "string" ? parameters : parameters.issueIdOrKey;
        const config = {
          url: `/rest/api/2/issue/${issueIdOrKey}/properties`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssueProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/properties/${parameters.propertyKey}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setIssueProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/properties/${parameters.propertyKey}`,
          method: "PUT",
          data: parameters.propertyValue
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteIssueProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/properties/${parameters.propertyKey}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueProperties = IssueProperties;
});

// node_modules/jira.js/out/version2/issueRemoteLinks.js
var require_issueRemoteLinks = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueRemoteLinks = undefined;
  var tslib_1 = require_tslib();

  class IssueRemoteLinks {
    constructor(client) {
      this.client = client;
    }
    getRemoteIssueLinks(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueIdOrKey = typeof parameters === "string" ? parameters : parameters.issueIdOrKey;
        const config = {
          url: `/rest/api/2/issue/${issueIdOrKey}/remotelink`,
          method: "GET",
          params: {
            globalId: typeof parameters !== "string" && parameters.globalId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createOrUpdateRemoteIssueLink(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/remotelink`,
          method: "POST",
          data: {
            globalId: parameters.globalId,
            application: parameters.application,
            relationship: parameters.relationship,
            object: parameters.object
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteRemoteIssueLinkByGlobalId(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueIdOrKey = typeof parameters === "string" ? parameters : parameters.issueIdOrKey;
        const config = {
          url: `/rest/api/2/issue/${issueIdOrKey}/remotelink`,
          method: "DELETE",
          params: {
            globalId: typeof parameters !== "string" && parameters.globalId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getRemoteIssueLinkById(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/remotelink/${parameters.linkId}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateRemoteIssueLink(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/remotelink/${parameters.linkId}`,
          method: "PUT",
          data: {
            globalId: parameters.globalId,
            application: parameters.application,
            relationship: parameters.relationship,
            object: parameters.object
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteRemoteIssueLinkById(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/remotelink/${parameters.linkId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueRemoteLinks = IssueRemoteLinks;
});

// node_modules/jira.js/out/version2/issueResolutions.js
var require_issueResolutions = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueResolutions = undefined;
  var tslib_1 = require_tslib();

  class IssueResolutions {
    constructor(client) {
      this.client = client;
    }
    createResolution(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/resolution",
          method: "POST",
          data: parameters
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setDefaultResolution(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/resolution/default",
          method: "PUT",
          data: {
            id: parameters.id
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    moveResolutions(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/resolution/move",
          method: "PUT",
          data: {
            ids: parameters.ids,
            after: parameters.after,
            position: parameters.position
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    searchResolutions(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/resolution/search",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            id: parameters === null || parameters === undefined ? undefined : parameters.id,
            onlyDefault: parameters === null || parameters === undefined ? undefined : parameters.onlyDefault
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateResolution(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/resolution/${parameters.id}`,
          method: "PUT",
          data: Object.assign(Object.assign({}, parameters), { name: parameters.name, description: parameters.description, id: undefined })
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteResolution(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/resolution/${parameters.id}`,
          method: "DELETE",
          params: {
            replaceWith: parameters.replaceWith
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueResolutions = IssueResolutions;
});

// node_modules/jira.js/out/version2/issues.js
var require_issues = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Issues = undefined;
  var tslib_1 = require_tslib();

  class Issues {
    constructor(client) {
      this.client = client;
    }
    getEvents(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/events",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createIssue(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issue",
          method: "POST",
          params: {
            updateHistory: parameters.updateHistory
          },
          data: {
            fields: parameters.fields,
            historyMetadata: parameters.historyMetadata,
            properties: parameters.properties,
            transition: parameters.transition,
            update: parameters.update
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    archiveIssuesAsync(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issue/archive",
          method: "POST",
          data: {
            jql: parameters.jql
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    archiveIssues(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issue/archive",
          method: "PUT",
          data: {
            issueIdsOrKeys: parameters.issueIdsOrKeys
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createIssues(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issue/bulk",
          method: "POST",
          data: {
            issueUpdates: parameters === null || parameters === undefined ? undefined : parameters.issueUpdates
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getCreateIssueMeta(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issue/createmeta",
          method: "GET",
          params: {
            projectIds: parameters === null || parameters === undefined ? undefined : parameters.projectIds,
            projectKeys: parameters === null || parameters === undefined ? undefined : parameters.projectKeys,
            issuetypeIds: parameters === null || parameters === undefined ? undefined : parameters.issuetypeIds,
            issuetypeNames: parameters === null || parameters === undefined ? undefined : parameters.issuetypeNames,
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    unarchiveIssues(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issue/unarchive",
          method: "PUT",
          data: {
            issueIdsOrKeys: parameters.issueIdsOrKeys
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssue(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueIdOrKey = typeof parameters === "string" ? parameters : parameters.issueIdOrKey;
        const config = {
          url: `/rest/api/2/issue/${issueIdOrKey}`,
          method: "GET",
          params: {
            fields: typeof parameters !== "string" && parameters.fields,
            fieldsByKeys: typeof parameters !== "string" && parameters.fieldsByKeys,
            expand: typeof parameters !== "string" && parameters.expand,
            properties: typeof parameters !== "string" && parameters.properties,
            updateHistory: typeof parameters !== "string" && parameters.updateHistory
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    editIssue(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}`,
          method: "PUT",
          params: {
            notifyUsers: parameters.notifyUsers,
            overrideScreenSecurity: parameters.overrideScreenSecurity,
            overrideEditableFlag: parameters.overrideEditableFlag,
            returnIssue: parameters.returnIssue,
            expand: parameters.expand
          },
          data: {
            fields: parameters.fields,
            historyMetadata: parameters.historyMetadata,
            properties: parameters.properties,
            transition: parameters.transition,
            update: parameters.update
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteIssue(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueIdOrKey = typeof parameters === "string" ? parameters : parameters.issueIdOrKey;
        const config = {
          url: `/rest/api/2/issue/${issueIdOrKey}`,
          method: "DELETE",
          params: {
            deleteSubtasks: typeof parameters !== "string" && parameters.deleteSubtasks
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    assignIssue(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/assignee`,
          method: "PUT",
          data: {
            accountId: parameters.accountId,
            accountType: parameters.accountType,
            active: parameters.active,
            applicationRoles: parameters.applicationRoles,
            avatarUrls: parameters.avatarUrls,
            displayName: parameters.displayName,
            emailAddress: parameters.emailAddress,
            expand: parameters.expand,
            groups: parameters.groups,
            key: parameters.key,
            locale: parameters.locale,
            name: parameters.name,
            self: parameters.self,
            timeZone: parameters.timeZone
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getChangeLogs(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueIdOrKey = typeof parameters === "string" ? parameters : parameters.issueIdOrKey;
        const config = {
          url: `/rest/api/2/issue/${issueIdOrKey}/changelog`,
          method: "GET",
          params: {
            startAt: typeof parameters !== "string" && parameters.startAt,
            maxResults: typeof parameters !== "string" && parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getChangeLogsByIds(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/changelog/list`,
          method: "POST",
          data: {
            changelogIds: parameters.changelogIds
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getEditIssueMeta(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueIdOrKey = typeof parameters === "string" ? parameters : parameters.issueIdOrKey;
        const config = {
          url: `/rest/api/2/issue/${issueIdOrKey}/editmeta`,
          method: "GET",
          params: {
            overrideScreenSecurity: typeof parameters !== "string" && parameters.overrideScreenSecurity,
            overrideEditableFlag: typeof parameters !== "string" && parameters.overrideEditableFlag
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    notify(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/notify`,
          method: "POST",
          data: {
            htmlBody: parameters.htmlBody,
            restrict: parameters.restrict,
            subject: parameters.subject,
            textBody: parameters.textBody,
            to: parameters.to
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getTransitions(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueIdOrKey = typeof parameters === "string" ? parameters : parameters.issueIdOrKey;
        const config = {
          url: `/rest/api/2/issue/${issueIdOrKey}/transitions`,
          method: "GET",
          params: {
            expand: typeof parameters !== "string" && parameters.expand,
            transitionId: typeof parameters !== "string" && parameters.transitionId,
            skipRemoteOnlyCondition: typeof parameters !== "string" && parameters.skipRemoteOnlyCondition,
            includeUnavailableTransitions: typeof parameters !== "string" && parameters.includeUnavailableTransitions,
            sortByOpsBarAndStatus: typeof parameters !== "string" && parameters.sortByOpsBarAndStatus
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    doTransition(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/transitions`,
          method: "POST",
          data: {
            fields: parameters.fields,
            historyMetadata: parameters.historyMetadata,
            properties: parameters.properties,
            transition: parameters.transition,
            update: parameters.update
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    exportArchivedIssues(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issues/archive/export",
          method: "PUT",
          data: {
            archivedBy: parameters.archivedBy,
            archivedDateRange: parameters.archivedDateRange,
            issueTypes: parameters.issueTypes,
            projects: parameters.projects,
            reporters: parameters.reporters
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Issues = Issues;
});

// node_modules/jira.js/out/version2/issueSearch.js
var require_issueSearch = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueSearch = undefined;
  var tslib_1 = require_tslib();

  class IssueSearch {
    constructor(client) {
      this.client = client;
    }
    getIssuePickerResource(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issue/picker",
          method: "GET",
          params: {
            query: parameters === null || parameters === undefined ? undefined : parameters.query,
            currentJQL: parameters === null || parameters === undefined ? undefined : parameters.currentJQL,
            currentIssueKey: parameters === null || parameters === undefined ? undefined : parameters.currentIssueKey,
            currentProjectId: parameters === null || parameters === undefined ? undefined : parameters.currentProjectId,
            showSubTasks: parameters === null || parameters === undefined ? undefined : parameters.showSubTasks,
            showSubTaskParent: parameters === null || parameters === undefined ? undefined : parameters.showSubTaskParent
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    matchIssues(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/jql/match",
          method: "POST",
          data: {
            jqls: parameters === null || parameters === undefined ? undefined : parameters.jqls,
            issueIds: parameters === null || parameters === undefined ? undefined : parameters.issueIds
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    searchForIssuesUsingJql(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/search",
          method: "GET",
          params: {
            jql: parameters === null || parameters === undefined ? undefined : parameters.jql,
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            validateQuery: parameters === null || parameters === undefined ? undefined : parameters.validateQuery,
            fields: parameters === null || parameters === undefined ? undefined : parameters.fields,
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand,
            properties: parameters === null || parameters === undefined ? undefined : parameters.properties,
            fieldsByKeys: parameters === null || parameters === undefined ? undefined : parameters.fieldsByKeys
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    searchForIssuesUsingJqlPost(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/search",
          method: "POST",
          data: {
            jql: parameters === null || parameters === undefined ? undefined : parameters.jql,
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            fields: parameters === null || parameters === undefined ? undefined : parameters.fields,
            validateQuery: parameters === null || parameters === undefined ? undefined : parameters.validateQuery,
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand,
            properties: parameters === null || parameters === undefined ? undefined : parameters.properties,
            fieldsByKeys: parameters === null || parameters === undefined ? undefined : parameters.fieldsByKeys
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueSearch = IssueSearch;
});

// node_modules/jira.js/out/version2/issueSecurityLevel.js
var require_issueSecurityLevel = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueSecurityLevel = undefined;
  var tslib_1 = require_tslib();

  class IssueSecurityLevel {
    constructor(client) {
      this.client = client;
    }
    getIssueSecurityLevelMembers(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueSecuritySchemeId = typeof parameters === "string" ? parameters : parameters.issueSecuritySchemeId;
        const config = {
          url: `/rest/api/2/issuesecurityschemes/${issueSecuritySchemeId}/members`,
          method: "GET",
          params: {
            startAt: typeof parameters !== "string" && parameters.startAt,
            maxResults: typeof parameters !== "string" && parameters.maxResults,
            issueSecurityLevelId: typeof parameters !== "string" && parameters.issueSecurityLevelId,
            expand: typeof parameters !== "string" && parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssueSecurityLevel(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/securitylevel/${id}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueSecurityLevel = IssueSecurityLevel;
});

// node_modules/jira.js/out/version2/issueSecuritySchemes.js
var require_issueSecuritySchemes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueSecuritySchemes = undefined;
  var tslib_1 = require_tslib();
  var paramSerializer_1 = require_paramSerializer();

  class IssueSecuritySchemes {
    constructor(client) {
      this.client = client;
    }
    getIssueSecuritySchemes(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuesecurityschemes",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createIssueSecurityScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuesecurityschemes",
          method: "POST",
          data: {
            description: parameters.description,
            levels: parameters.levels,
            name: parameters.name
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getSecurityLevels(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuesecurityschemes/level",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            id: (0, paramSerializer_1.paramSerializer)("id", parameters === null || parameters === undefined ? undefined : parameters.id),
            schemeId: (0, paramSerializer_1.paramSerializer)("schemeId", parameters === null || parameters === undefined ? undefined : parameters.schemeId),
            onlyDefault: parameters === null || parameters === undefined ? undefined : parameters.onlyDefault
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setDefaultLevels(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuesecurityschemes/level/default",
          method: "PUT",
          data: {
            defaultValues: parameters === null || parameters === undefined ? undefined : parameters.defaultValues
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getSecurityLevelMembers(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuesecurityschemes/level/member",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            id: (0, paramSerializer_1.paramSerializer)("id", parameters === null || parameters === undefined ? undefined : parameters.id),
            schemeId: (0, paramSerializer_1.paramSerializer)("schemeId", parameters === null || parameters === undefined ? undefined : parameters.schemeId),
            levelId: (0, paramSerializer_1.paramSerializer)("levelId", parameters === null || parameters === undefined ? undefined : parameters.levelId),
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    searchProjectsUsingSecuritySchemes(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuesecurityschemes/project",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            issueSecuritySchemeId: parameters === null || parameters === undefined ? undefined : parameters.issueSecuritySchemeId,
            projectId: parameters === null || parameters === undefined ? undefined : parameters.projectId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    associateSchemesToProjects(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuesecurityschemes/project",
          method: "PUT",
          data: {
            oldToNewSecurityLevelMappings: parameters.oldToNewSecurityLevelMappings,
            projectId: parameters.projectId,
            schemeId: parameters.schemeId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    searchSecuritySchemes(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuesecurityschemes/search",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            id: (0, paramSerializer_1.paramSerializer)("id", parameters === null || parameters === undefined ? undefined : parameters.id),
            projectId: (0, paramSerializer_1.paramSerializer)("projectId", parameters === null || parameters === undefined ? undefined : parameters.projectId)
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssueSecurityScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/issuesecurityschemes/${id}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateIssueSecurityScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuesecurityschemes/${parameters.id}`,
          method: "PUT",
          data: {
            description: parameters.description,
            name: parameters.name
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteSecurityScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuesecurityschemes/${parameters.schemeId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    addSecurityLevel(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuesecurityschemes/${parameters.schemeId}/level`,
          method: "PUT",
          data: {
            levels: parameters.levels
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateSecurityLevel(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuesecurityschemes/${parameters.schemeId}/level/${parameters.levelId}`,
          method: "PUT",
          data: {
            description: parameters.description,
            name: parameters.name
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeLevel(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuesecurityschemes/${parameters.schemeId}/level/${parameters.levelId}`,
          method: "DELETE",
          params: {
            replaceWith: parameters.replaceWith
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    addSecurityLevelMembers(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuesecurityschemes/${parameters.schemeId}/level/${parameters.levelId}/member`,
          method: "PUT",
          data: {
            members: parameters.members
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeMemberFromSecurityLevel(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuesecurityschemes/${parameters.schemeId}/level/${parameters.levelId}/member/${parameters.memberId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueSecuritySchemes = IssueSecuritySchemes;
});

// node_modules/jira.js/out/version2/issueTypeProperties.js
var require_issueTypeProperties = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueTypeProperties = undefined;
  var tslib_1 = require_tslib();

  class IssueTypeProperties {
    constructor(client) {
      this.client = client;
    }
    getIssueTypePropertyKeys(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueTypeId = typeof parameters === "string" ? parameters : parameters.issueTypeId;
        const config = {
          url: `/rest/api/2/issuetype/${issueTypeId}/properties`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssueTypeProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuetype/${parameters.issueTypeId}/properties/${parameters.propertyKey}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setIssueTypeProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuetype/${parameters.issueTypeId}/properties/${parameters.propertyKey}`,
          method: "PUT",
          data: parameters.propertyValue
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteIssueTypeProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuetype/${parameters.issueTypeId}/properties/${parameters.propertyKey}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueTypeProperties = IssueTypeProperties;
});

// node_modules/jira.js/out/version2/issueTypes.js
var require_issueTypes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueTypes = undefined;
  var tslib_1 = require_tslib();

  class IssueTypes {
    constructor(client) {
      this.client = client;
    }
    getIssueAllTypes(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuetype",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createIssueType(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuetype",
          method: "POST",
          data: {
            name: parameters === null || parameters === undefined ? undefined : parameters.name,
            description: parameters === null || parameters === undefined ? undefined : parameters.description,
            hierarchyLevel: parameters === null || parameters === undefined ? undefined : parameters.hierarchyLevel
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssueTypesForProject(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuetype/project",
          method: "GET",
          params: {
            projectId: parameters.projectId,
            level: parameters.level
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssueType(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/issuetype/${id}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateIssueType(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuetype/${parameters.id}`,
          method: "PUT",
          data: {
            name: parameters.name,
            description: parameters.description,
            avatarId: parameters.avatarId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteIssueType(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/issuetype/${id}`,
          method: "DELETE",
          params: {
            alternativeIssueTypeId: typeof parameters !== "string" && parameters.alternativeIssueTypeId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAlternativeIssueTypes(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/issuetype/${id}/alternatives`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createIssueTypeAvatar(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuetype/${parameters.id}/avatar2`,
          method: "POST",
          params: {
            x: parameters.x,
            y: parameters.y,
            size: parameters.size
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueTypes = IssueTypes;
});

// node_modules/jira.js/out/version2/issueTypeSchemes.js
var require_issueTypeSchemes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueTypeSchemes = undefined;
  var tslib_1 = require_tslib();

  class IssueTypeSchemes {
    constructor(client) {
      this.client = client;
    }
    getAllIssueTypeSchemes(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuetypescheme",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            id: parameters === null || parameters === undefined ? undefined : parameters.id,
            orderBy: parameters === null || parameters === undefined ? undefined : parameters.orderBy,
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand,
            queryString: parameters === null || parameters === undefined ? undefined : parameters.queryString
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createIssueTypeScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuetypescheme",
          method: "POST",
          data: {
            name: parameters === null || parameters === undefined ? undefined : parameters.name,
            description: parameters === null || parameters === undefined ? undefined : parameters.description,
            defaultIssueTypeId: parameters === null || parameters === undefined ? undefined : parameters.defaultIssueTypeId,
            issueTypeIds: parameters === null || parameters === undefined ? undefined : parameters.issueTypeIds
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssueTypeSchemesMapping(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuetypescheme/mapping",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            issueTypeSchemeId: parameters === null || parameters === undefined ? undefined : parameters.issueTypeSchemeId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssueTypeSchemeForProjects(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuetypescheme/project",
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults,
            projectId: parameters.projectId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    assignIssueTypeSchemeToProject(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuetypescheme/project",
          method: "PUT",
          data: {
            issueTypeSchemeId: parameters === null || parameters === undefined ? undefined : parameters.issueTypeSchemeId,
            projectId: parameters === null || parameters === undefined ? undefined : parameters.projectId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateIssueTypeScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuetypescheme/${parameters.issueTypeSchemeId}`,
          method: "PUT",
          data: {
            name: parameters.name,
            description: parameters.description,
            defaultIssueTypeId: parameters.defaultIssueTypeId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteIssueTypeScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueTypeSchemeId = typeof parameters === "string" ? parameters : parameters.issueTypeSchemeId;
        const config = {
          url: `/rest/api/2/issuetypescheme/${issueTypeSchemeId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    addIssueTypesToIssueTypeScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuetypescheme/${parameters.issueTypeSchemeId}/issuetype`,
          method: "PUT",
          data: {
            issueTypeIds: parameters.issueTypeIds
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    reorderIssueTypesInIssueTypeScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuetypescheme/${parameters.issueTypeSchemeId}/issuetype/move`,
          method: "PUT",
          data: {
            issueTypeIds: parameters.issueTypeIds,
            after: parameters.after,
            position: parameters.position
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeIssueTypeFromIssueTypeScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuetypescheme/${parameters.issueTypeSchemeId}/issuetype/${parameters.issueTypeId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueTypeSchemes = IssueTypeSchemes;
});

// node_modules/jira.js/out/version2/issueTypeScreenSchemes.js
var require_issueTypeScreenSchemes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueTypeScreenSchemes = undefined;
  var tslib_1 = require_tslib();

  class IssueTypeScreenSchemes {
    constructor(client) {
      this.client = client;
    }
    getIssueTypeScreenSchemes(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuetypescreenscheme",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            id: parameters === null || parameters === undefined ? undefined : parameters.id,
            queryString: parameters === null || parameters === undefined ? undefined : parameters.queryString,
            orderBy: parameters === null || parameters === undefined ? undefined : parameters.orderBy,
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createIssueTypeScreenScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuetypescreenscheme",
          method: "POST",
          data: {
            name: parameters === null || parameters === undefined ? undefined : parameters.name,
            description: parameters === null || parameters === undefined ? undefined : parameters.description,
            issueTypeMappings: parameters === null || parameters === undefined ? undefined : parameters.issueTypeMappings
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssueTypeScreenSchemeMappings(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuetypescreenscheme/mapping",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            issueTypeScreenSchemeId: parameters === null || parameters === undefined ? undefined : parameters.issueTypeScreenSchemeId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssueTypeScreenSchemeProjectAssociations(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuetypescreenscheme/project",
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults,
            projectId: parameters.projectId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    assignIssueTypeScreenSchemeToProject(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issuetypescreenscheme/project",
          method: "PUT",
          data: {
            issueTypeScreenSchemeId: parameters === null || parameters === undefined ? undefined : parameters.issueTypeScreenSchemeId,
            projectId: parameters === null || parameters === undefined ? undefined : parameters.projectId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateIssueTypeScreenScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuetypescreenscheme/${parameters.issueTypeScreenSchemeId}`,
          method: "PUT",
          data: {
            name: parameters.name,
            description: parameters.description
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteIssueTypeScreenScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueTypeScreenSchemeId = typeof parameters === "string" ? parameters : parameters.issueTypeScreenSchemeId;
        const config = {
          url: `/rest/api/2/issuetypescreenscheme/${issueTypeScreenSchemeId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    appendMappingsForIssueTypeScreenScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuetypescreenscheme/${parameters.issueTypeScreenSchemeId}/mapping`,
          method: "PUT",
          data: {
            issueTypeMappings: parameters.issueTypeMappings
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateDefaultScreenScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuetypescreenscheme/${parameters.issueTypeScreenSchemeId}/mapping/default`,
          method: "PUT",
          data: {
            screenSchemeId: parameters.screenSchemeId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeMappingsFromIssueTypeScreenScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issuetypescreenscheme/${parameters.issueTypeScreenSchemeId}/mapping/remove`,
          method: "POST",
          data: {
            issueTypeIds: parameters.issueTypeIds
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getProjectsForIssueTypeScreenScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueTypeScreenSchemeId = typeof parameters === "string" ? parameters : parameters.issueTypeScreenSchemeId;
        const config = {
          url: `/rest/api/2/issuetypescreenscheme/${issueTypeScreenSchemeId}/project`,
          method: "GET",
          params: {
            startAt: typeof parameters !== "string" && parameters.startAt,
            maxResults: typeof parameters !== "string" && parameters.maxResults,
            query: typeof parameters !== "string" && parameters.query
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueTypeScreenSchemes = IssueTypeScreenSchemes;
});

// node_modules/jira.js/out/version2/issueVotes.js
var require_issueVotes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueVotes = undefined;
  var tslib_1 = require_tslib();

  class IssueVotes {
    constructor(client) {
      this.client = client;
    }
    getVotes(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueIdOrKey = typeof parameters === "string" ? parameters : parameters.issueIdOrKey;
        const config = {
          url: `/rest/api/2/issue/${issueIdOrKey}/votes`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    addVote(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueIdOrKey = typeof parameters === "string" ? parameters : parameters.issueIdOrKey;
        const config = {
          url: `/rest/api/2/issue/${issueIdOrKey}/votes`,
          method: "POST",
          headers: {
            "Content-Type": "application/json"
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeVote(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueIdOrKey = typeof parameters === "string" ? parameters : parameters.issueIdOrKey;
        const config = {
          url: `/rest/api/2/issue/${issueIdOrKey}/votes`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueVotes = IssueVotes;
});

// node_modules/jira.js/out/version2/issueWatchers.js
var require_issueWatchers = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueWatchers = undefined;
  var tslib_1 = require_tslib();

  class IssueWatchers {
    constructor(client) {
      this.client = client;
    }
    getIsWatchingIssueBulk(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/issue/watching",
          method: "POST",
          data: {
            issueIds: parameters === null || parameters === undefined ? undefined : parameters.issueIds
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIssueWatchers(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueIdOrKey = typeof parameters === "string" ? parameters : parameters.issueIdOrKey;
        const config = {
          url: `/rest/api/2/issue/${issueIdOrKey}/watchers`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    addWatcher(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/watchers`,
          method: "POST",
          headers: {
            "Content-Type": "application/json"
          },
          data: parameters.accountId
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeWatcher(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/watchers`,
          method: "DELETE",
          params: {
            accountId: parameters.accountId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueWatchers = IssueWatchers;
});

// node_modules/jira.js/out/version2/issueWorklogProperties.js
var require_issueWorklogProperties = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueWorklogProperties = undefined;
  var tslib_1 = require_tslib();

  class IssueWorklogProperties {
    constructor(client) {
      this.client = client;
    }
    getWorklogPropertyKeys(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/worklog/${parameters.worklogId}/properties`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getWorklogProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/worklog/${parameters.worklogId}/properties/${parameters.propertyKey}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setWorklogProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/worklog/${parameters.worklogId}/properties/${parameters.propertyKey}`,
          method: "PUT"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteWorklogProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/worklog/${parameters.worklogId}/properties/${parameters.propertyKey}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueWorklogProperties = IssueWorklogProperties;
});

// node_modules/jira.js/out/version2/issueWorklogs.js
var require_issueWorklogs = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IssueWorklogs = undefined;
  var tslib_1 = require_tslib();

  class IssueWorklogs {
    constructor(client) {
      this.client = client;
    }
    getIssueWorklog(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const issueIdOrKey = typeof parameters === "string" ? parameters : parameters.issueIdOrKey;
        const config = {
          url: `/rest/api/2/issue/${issueIdOrKey}/worklog`,
          method: "GET",
          params: {
            startAt: typeof parameters !== "string" && parameters.startAt,
            maxResults: typeof parameters !== "string" && parameters.maxResults,
            startedAfter: typeof parameters !== "string" && parameters.startedAfter,
            startedBefore: typeof parameters !== "string" && parameters.startedBefore,
            expand: typeof parameters !== "string" && parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    addWorklog(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/worklog`,
          method: "POST",
          params: {
            notifyUsers: parameters.notifyUsers,
            adjustEstimate: parameters.adjustEstimate,
            newEstimate: parameters.newEstimate,
            reduceBy: parameters.reduceBy,
            expand: parameters.expand,
            overrideEditableFlag: parameters.overrideEditableFlag
          },
          data: {
            self: parameters.self,
            author: parameters.author,
            updateAuthor: parameters.updateAuthor,
            comment: parameters.comment,
            created: parameters.created,
            updated: parameters.updated,
            visibility: parameters.visibility,
            started: parameters.started,
            timeSpent: parameters.timeSpent,
            timeSpentSeconds: parameters.timeSpentSeconds,
            id: parameters.id,
            issueId: parameters.issueId,
            properties: parameters.properties
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getWorklog(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/worklog/${parameters.id}`,
          method: "GET",
          params: {
            expand: parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateWorklog(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/worklog/${parameters.id}`,
          method: "PUT",
          params: {
            notifyUsers: parameters.notifyUsers,
            adjustEstimate: parameters.adjustEstimate,
            newEstimate: parameters.newEstimate,
            expand: parameters.expand,
            overrideEditableFlag: parameters.overrideEditableFlag
          },
          data: {
            comment: parameters.comment,
            visibility: parameters.visibility,
            started: parameters.started,
            timeSpent: parameters.timeSpent,
            timeSpentSeconds: parameters.timeSpentSeconds,
            properties: parameters.properties
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteWorklog(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/issue/${parameters.issueIdOrKey}/worklog/${parameters.id}`,
          method: "DELETE",
          params: {
            notifyUsers: parameters.notifyUsers,
            adjustEstimate: parameters.adjustEstimate,
            newEstimate: parameters.newEstimate,
            increaseBy: parameters.increaseBy,
            overrideEditableFlag: parameters.overrideEditableFlag
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIdsOfWorklogsDeletedSince(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/worklog/deleted",
          method: "GET",
          params: {
            since: parameters === null || parameters === undefined ? undefined : parameters.since
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getWorklogsForIds(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/worklog/list",
          method: "POST",
          params: {
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand
          },
          data: {
            ids: parameters === null || parameters === undefined ? undefined : parameters.ids
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getIdsOfWorklogsModifiedSince(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/worklog/updated",
          method: "GET",
          params: {
            since: parameters === null || parameters === undefined ? undefined : parameters.since,
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.IssueWorklogs = IssueWorklogs;
});

// node_modules/jira.js/out/version2/jiraExpressions.js
var require_jiraExpressions = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.JiraExpressions = undefined;
  var tslib_1 = require_tslib();

  class JiraExpressions {
    constructor(client) {
      this.client = client;
    }
    analyseExpression(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/expression/analyse",
          method: "POST",
          params: {
            check: parameters === null || parameters === undefined ? undefined : parameters.check
          },
          data: {
            expressions: parameters === null || parameters === undefined ? undefined : parameters.expressions,
            contextVariables: parameters === null || parameters === undefined ? undefined : parameters.contextVariables
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    evaluateJiraExpression(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/expression/eval",
          method: "POST",
          params: {
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand
          },
          data: {
            expression: parameters === null || parameters === undefined ? undefined : parameters.expression,
            context: parameters === null || parameters === undefined ? undefined : parameters.context
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.JiraExpressions = JiraExpressions;
});

// node_modules/jira.js/out/version2/jiraSettings.js
var require_jiraSettings = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.JiraSettings = undefined;
  var tslib_1 = require_tslib();

  class JiraSettings {
    constructor(client) {
      this.client = client;
    }
    getApplicationProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/application-properties",
          method: "GET",
          params: {
            key: parameters === null || parameters === undefined ? undefined : parameters.key,
            permissionLevel: parameters === null || parameters === undefined ? undefined : parameters.permissionLevel,
            keyFilter: parameters === null || parameters === undefined ? undefined : parameters.keyFilter
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAdvancedSettings(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/application-properties/advanced-settings",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setApplicationProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/application-properties/${parameters.id}`,
          method: "PUT",
          data: parameters.body
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getConfiguration(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/configuration",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.JiraSettings = JiraSettings;
});

// node_modules/jira.js/out/version2/jQL.js
var require_jQL = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.JQL = undefined;
  var tslib_1 = require_tslib();

  class JQL {
    constructor(client) {
      this.client = client;
    }
    getAutoComplete(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/jql/autocompletedata",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAutoCompletePost(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/jql/autocompletedata",
          method: "POST",
          data: {
            includeCollapsedFields: parameters === null || parameters === undefined ? undefined : parameters.includeCollapsedFields,
            projectIds: parameters === null || parameters === undefined ? undefined : parameters.projectIds
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getFieldAutoCompleteForQueryString(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/jql/autocompletedata/suggestions",
          method: "GET",
          params: {
            fieldName: parameters === null || parameters === undefined ? undefined : parameters.fieldName,
            fieldValue: parameters === null || parameters === undefined ? undefined : parameters.fieldValue,
            predicateName: parameters === null || parameters === undefined ? undefined : parameters.predicateName,
            predicateValue: parameters === null || parameters === undefined ? undefined : parameters.predicateValue
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    parseJqlQueries(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/jql/parse",
          method: "POST",
          params: {
            validation: parameters === null || parameters === undefined ? undefined : parameters.validation
          },
          data: {
            queries: parameters === null || parameters === undefined ? undefined : parameters.queries
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    migrateQueries(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/jql/pdcleaner",
          method: "POST",
          data: {
            queryStrings: parameters === null || parameters === undefined ? undefined : parameters.queryStrings
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    sanitiseJqlQueries(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/jql/sanitize",
          method: "POST",
          data: {
            queries: parameters === null || parameters === undefined ? undefined : parameters.queries
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.JQL = JQL;
});

// node_modules/jira.js/out/version2/jqlFunctionsApps.js
var require_jqlFunctionsApps = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.JqlFunctionsApps = undefined;
  var tslib_1 = require_tslib();

  class JqlFunctionsApps {
    constructor(client) {
      this.client = client;
    }
    getPrecomputations(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/jql/function/computation",
          method: "GET",
          params: {
            functionKey: parameters === null || parameters === undefined ? undefined : parameters.functionKey,
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            orderBy: parameters === null || parameters === undefined ? undefined : parameters.orderBy,
            filter: parameters === null || parameters === undefined ? undefined : parameters.filter
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updatePrecomputations(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/jql/function/computation",
          method: "POST",
          data: {
            values: parameters === null || parameters === undefined ? undefined : parameters.values
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.JqlFunctionsApps = JqlFunctionsApps;
});

// node_modules/jira.js/out/version2/labels.js
var require_labels = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Labels = undefined;
  var tslib_1 = require_tslib();

  class Labels {
    constructor(client) {
      this.client = client;
    }
    getAllLabels(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/label",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Labels = Labels;
});

// node_modules/jira.js/out/version2/licenseMetrics.js
var require_licenseMetrics = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.LicenseMetrics = undefined;
  var tslib_1 = require_tslib();

  class LicenseMetrics {
    constructor(client) {
      this.client = client;
    }
    getLicense(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/instance/license",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getApproximateLicenseCount(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/license/approximateLicenseCount",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getApproximateApplicationLicenseCount(applicationKey, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/license/approximateLicenseCount/product/${applicationKey}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.LicenseMetrics = LicenseMetrics;
});

// node_modules/jira.js/out/version2/myself.js
var require_myself = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Myself = undefined;
  var tslib_1 = require_tslib();

  class Myself {
    constructor(client) {
      this.client = client;
    }
    getPreference(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/mypreferences",
          method: "GET",
          params: {
            key: parameters.key
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setPreference(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/mypreferences",
          method: "PUT",
          headers: {
            "Content-Type": typeof parameters.value === "string" ? "text/plain" : "application/json"
          },
          params: {
            key: parameters.key
          },
          data: parameters.value
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removePreference(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/mypreferences",
          method: "DELETE",
          params: {
            key: parameters.key
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getLocale(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/mypreferences/locale",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getCurrentUser(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/myself",
          method: "GET",
          params: {
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Myself = Myself;
});

// node_modules/jira.js/out/version2/permissions.js
var require_permissions = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Permissions = undefined;
  var tslib_1 = require_tslib();

  class Permissions {
    constructor(client) {
      this.client = client;
    }
    getMyPermissions(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/mypermissions",
          method: "GET",
          params: {
            projectKey: parameters === null || parameters === undefined ? undefined : parameters.projectKey,
            projectId: parameters === null || parameters === undefined ? undefined : parameters.projectId,
            issueKey: parameters === null || parameters === undefined ? undefined : parameters.issueKey,
            issueId: parameters === null || parameters === undefined ? undefined : parameters.issueId,
            permissions: parameters === null || parameters === undefined ? undefined : parameters.permissions,
            projectUuid: parameters === null || parameters === undefined ? undefined : parameters.projectUuid,
            projectConfigurationUuid: parameters === null || parameters === undefined ? undefined : parameters.projectConfigurationUuid,
            commentId: parameters === null || parameters === undefined ? undefined : parameters.commentId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAllPermissions(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/permissions",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getBulkPermissions(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/permissions/check",
          method: "POST",
          data: {
            projectPermissions: parameters === null || parameters === undefined ? undefined : parameters.projectPermissions,
            globalPermissions: parameters === null || parameters === undefined ? undefined : parameters.globalPermissions,
            accountId: parameters === null || parameters === undefined ? undefined : parameters.accountId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getPermittedProjects(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/permissions/project",
          method: "POST",
          data: {
            permissions: parameters === null || parameters === undefined ? undefined : parameters.permissions
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Permissions = Permissions;
});

// node_modules/jira.js/out/version2/permissionSchemes.js
var require_permissionSchemes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.PermissionSchemes = undefined;
  var tslib_1 = require_tslib();

  class PermissionSchemes {
    constructor(client) {
      this.client = client;
    }
    getAllPermissionSchemes(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/permissionscheme",
          method: "GET",
          params: {
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createPermissionScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/permissionscheme",
          method: "POST",
          params: {
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand
          },
          data: Object.assign(Object.assign({}, parameters), { expand: undefined })
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getPermissionScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const schemeId = typeof parameters === "string" ? parameters : parameters.schemeId;
        const config = {
          url: `/rest/api/2/permissionscheme/${schemeId}`,
          method: "GET",
          params: {
            expand: typeof parameters !== "string" && parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updatePermissionScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/permissionscheme/${parameters.schemeId}`,
          method: "PUT",
          params: {
            expand: parameters.expand
          },
          data: Object.assign(Object.assign({}, parameters), { schemeId: undefined, expand: undefined })
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deletePermissionScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/permissionscheme/${parameters.schemeId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getPermissionSchemeGrants(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/permissionscheme/${parameters.schemeId}/permission`,
          method: "GET",
          params: {
            expand: parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createPermissionGrant(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/permissionscheme/${parameters.schemeId}/permission`,
          method: "POST",
          params: {
            expand: parameters.expand
          },
          data: {
            id: parameters.id,
            self: parameters.self,
            holder: parameters.holder,
            permission: parameters.permission
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getPermissionSchemeGrant(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/permissionscheme/${parameters.schemeId}/permission/${parameters.permissionId}`,
          method: "GET",
          params: {
            expand: parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deletePermissionSchemeEntity(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/permissionscheme/${parameters.schemeId}/permission/${parameters.permissionId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.PermissionSchemes = PermissionSchemes;
});

// node_modules/jira.js/out/version2/projectAvatars.js
var require_projectAvatars = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ProjectAvatars = undefined;
  var tslib_1 = require_tslib();

  class ProjectAvatars {
    constructor(client) {
      this.client = client;
    }
    updateProjectAvatar(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/project/${parameters.projectIdOrKey}/avatar`,
          method: "PUT",
          data: {
            fileName: parameters.fileName,
            id: parameters.id,
            isDeletable: parameters.isDeletable,
            isSelected: parameters.isSelected,
            isSystemAvatar: parameters.isSystemAvatar,
            owner: parameters.owner,
            urls: parameters.urls
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteProjectAvatar(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/project/${parameters.projectIdOrKey}/avatar/${parameters.id}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createProjectAvatar(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/project/${parameters.projectIdOrKey}/avatar2`,
          method: "POST",
          params: {
            x: parameters.x,
            y: parameters.y,
            size: parameters.size
          },
          data: parameters.avatar
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAllProjectAvatars(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectIdOrKey = typeof parameters === "string" ? parameters : parameters.projectIdOrKey;
        const config = {
          url: `/rest/api/2/project/${projectIdOrKey}/avatars`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.ProjectAvatars = ProjectAvatars;
});

// node_modules/jira.js/out/version2/projectCategories.js
var require_projectCategories = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ProjectCategories = undefined;
  var tslib_1 = require_tslib();

  class ProjectCategories {
    constructor(client) {
      this.client = client;
    }
    getAllProjectCategories(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/projectCategory",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createProjectCategory(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/projectCategory",
          method: "POST",
          data: {
            description: parameters.description,
            id: parameters.id,
            name: parameters.name,
            self: parameters.self
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getProjectCategoryById(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/projectCategory/${id}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateProjectCategory(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/projectCategory/${parameters.id}`,
          method: "PUT",
          data: {
            name: parameters.name,
            description: parameters.description
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeProjectCategory(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/projectCategory/${id}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.ProjectCategories = ProjectCategories;
});

// node_modules/jira.js/out/version2/projectComponents.js
var require_projectComponents = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ProjectComponents = undefined;
  var tslib_1 = require_tslib();

  class ProjectComponents {
    constructor(client) {
      this.client = client;
    }
    createComponent(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/component",
          method: "POST",
          data: {
            assignee: parameters.assignee,
            assigneeType: parameters.assigneeType,
            description: parameters.description,
            id: parameters.id,
            isAssigneeTypeValid: parameters.isAssigneeTypeValid,
            lead: parameters.lead,
            leadAccountId: parameters.leadAccountId,
            leadUserName: parameters.leadUserName,
            name: parameters.name,
            project: parameters.project,
            projectId: parameters.projectId,
            realAssignee: parameters.realAssignee,
            realAssigneeType: parameters.realAssigneeType,
            self: parameters.self
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getComponent(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/component/${id}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateComponent(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/component/${parameters.id}`,
          method: "PUT",
          data: {
            name: parameters.name,
            description: parameters.description,
            leadUserName: parameters.leadUserName,
            leadAccountId: parameters.leadAccountId,
            assigneeType: parameters.assigneeType,
            project: parameters.project
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteComponent(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/component/${id}`,
          method: "DELETE",
          params: {
            moveIssuesTo: typeof parameters !== "string" && parameters.moveIssuesTo
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getComponentRelatedIssues(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/component/${id}/relatedIssueCounts`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getProjectComponentsPaginated(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/project/${parameters.projectIdOrKey}/component`,
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults,
            orderBy: parameters.orderBy,
            query: parameters.query
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getProjectComponents(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectIdOrKey = typeof parameters === "string" ? parameters : parameters.projectIdOrKey;
        const config = {
          url: `/rest/api/2/project/${projectIdOrKey}/components`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.ProjectComponents = ProjectComponents;
});

// node_modules/jira.js/out/version2/projectEmail.js
var require_projectEmail = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ProjectEmail = undefined;
  var tslib_1 = require_tslib();

  class ProjectEmail {
    constructor(client) {
      this.client = client;
    }
    getProjectEmail(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectId = typeof parameters === "string" ? parameters : parameters.projectId;
        const config = {
          url: `/rest/api/2/project/${projectId}/email`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateProjectEmail(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/project/${parameters.projectId}/email`,
          method: "PUT",
          data: {
            emailAddress: parameters.emailAddress,
            emailAddressStatus: parameters.emailAddressStatus
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.ProjectEmail = ProjectEmail;
});

// node_modules/jira.js/out/version2/projectFeatures.js
var require_projectFeatures = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ProjectFeatures = undefined;
  var tslib_1 = require_tslib();

  class ProjectFeatures {
    constructor(client) {
      this.client = client;
    }
    getFeaturesForProject(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectIdOrKey = typeof parameters === "string" ? parameters : parameters.projectIdOrKey;
        const config = {
          url: `/rest/api/2/project/${projectIdOrKey}/features`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    toggleFeatureForProject(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/project/${parameters.projectIdOrKey}/features/${parameters.featureKey}`,
          method: "PUT",
          data: {
            state: parameters.state
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.ProjectFeatures = ProjectFeatures;
});

// node_modules/jira.js/out/version2/projectKeyAndNameValidation.js
var require_projectKeyAndNameValidation = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ProjectKeyAndNameValidation = undefined;
  var tslib_1 = require_tslib();

  class ProjectKeyAndNameValidation {
    constructor(client) {
      this.client = client;
    }
    validateProjectKey(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const key = typeof parameters === "string" ? parameters : parameters === null || parameters === undefined ? undefined : parameters.key;
        const config = {
          url: "/rest/api/2/projectvalidate/key",
          method: "GET",
          params: {
            key
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getValidProjectKey(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const key = typeof parameters === "string" ? parameters : parameters === null || parameters === undefined ? undefined : parameters.key;
        const config = {
          url: "/rest/api/2/projectvalidate/validProjectKey",
          method: "GET",
          params: {
            key
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getValidProjectName(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const name = typeof parameters === "string" ? parameters : parameters.name;
        const config = {
          url: "/rest/api/2/projectvalidate/validProjectName",
          method: "GET",
          params: {
            name
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.ProjectKeyAndNameValidation = ProjectKeyAndNameValidation;
});

// node_modules/jira.js/out/version2/projectPermissionSchemes.js
var require_projectPermissionSchemes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ProjectPermissionSchemes = undefined;
  var tslib_1 = require_tslib();

  class ProjectPermissionSchemes {
    constructor(client) {
      this.client = client;
    }
    getProjectIssueSecurityScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectKeyOrId = typeof parameters === "string" ? parameters : parameters.projectKeyOrId;
        const config = {
          url: `/rest/api/2/project/${projectKeyOrId}/issuesecuritylevelscheme`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAssignedPermissionScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectKeyOrId = typeof parameters === "string" ? parameters : parameters.projectKeyOrId;
        const config = {
          url: `/rest/api/2/project/${projectKeyOrId}/permissionscheme`,
          method: "GET",
          params: {
            expand: typeof parameters !== "string" && parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    assignPermissionScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/project/${parameters.projectKeyOrId}/permissionscheme`,
          method: "PUT",
          params: {
            expand: parameters.expand
          },
          data: {
            id: parameters.id
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getSecurityLevelsForProject(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectKeyOrId = typeof parameters === "string" ? parameters : parameters.projectKeyOrId;
        const config = {
          url: `/rest/api/2/project/${projectKeyOrId}/securitylevel`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.ProjectPermissionSchemes = ProjectPermissionSchemes;
});

// node_modules/jira.js/out/version2/projectProperties.js
var require_projectProperties = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ProjectProperties = undefined;
  var tslib_1 = require_tslib();

  class ProjectProperties {
    constructor(client) {
      this.client = client;
    }
    getProjectPropertyKeys(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectIdOrKey = typeof parameters === "string" ? parameters : parameters.projectIdOrKey;
        const config = {
          url: `/rest/api/2/project/${projectIdOrKey}/properties`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getProjectProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/project/${parameters.projectIdOrKey}/properties/${parameters.propertyKey}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setProjectProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/project/${parameters.projectIdOrKey}/properties/${parameters.propertyKey}`,
          method: "PUT",
          data: parameters.propertyValue
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteProjectProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/project/${parameters.projectIdOrKey}/properties/${parameters.propertyKey}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.ProjectProperties = ProjectProperties;
});

// node_modules/jira.js/out/version2/projectRoleActors.js
var require_projectRoleActors = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ProjectRoleActors = undefined;
  var tslib_1 = require_tslib();

  class ProjectRoleActors {
    constructor(client) {
      this.client = client;
    }
    addActorUsers(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/project/${parameters.projectIdOrKey}/role/${parameters.id}`,
          method: "POST",
          data: {
            user: parameters.user,
            group: parameters.group,
            groupId: parameters.groupId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setActors(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/project/${parameters.projectIdOrKey}/role/${parameters.id}`,
          method: "PUT",
          data: {
            categorisedActors: parameters.categorisedActors
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteActor(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/project/${parameters.projectIdOrKey}/role/${parameters.id}`,
          method: "DELETE",
          params: {
            user: parameters.user,
            group: parameters.group,
            groupId: parameters.groupId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getProjectRoleActorsForRole(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/role/${id}/actors`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    addProjectRoleActorsToRole(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/role/${parameters.id}/actors`,
          method: "POST",
          data: {
            user: parameters.user,
            groupId: parameters.groupId,
            group: parameters.group
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteProjectRoleActorsFromRole(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/role/${parameters.id}/actors`,
          method: "DELETE",
          params: {
            user: parameters.user,
            groupId: parameters.groupId,
            group: parameters.group
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.ProjectRoleActors = ProjectRoleActors;
});

// node_modules/jira.js/out/version2/projectRoles.js
var require_projectRoles = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ProjectRoles = undefined;
  var tslib_1 = require_tslib();

  class ProjectRoles {
    constructor(client) {
      this.client = client;
    }
    getProjectRoles(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectIdOrKey = typeof parameters === "string" ? parameters : parameters.projectIdOrKey;
        const config = {
          url: `/rest/api/2/project/${projectIdOrKey}/role`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getProjectRole(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/project/${parameters.projectIdOrKey}/role/${parameters.id}`,
          method: "GET",
          params: {
            excludeInactiveUsers: parameters.excludeInactiveUsers
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getProjectRoleDetails(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectIdOrKey = typeof parameters === "string" ? parameters : parameters.projectIdOrKey;
        const config = {
          url: `/rest/api/2/project/${projectIdOrKey}/roledetails`,
          method: "GET",
          params: {
            currentMember: typeof parameters !== "string" && parameters.currentMember,
            excludeConnectAddons: typeof parameters !== "string" && parameters.excludeConnectAddons
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAllProjectRoles(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/role",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createProjectRole(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/role",
          method: "POST",
          data: {
            name: parameters.name,
            description: parameters.description
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getProjectRoleById(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/role/${id}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    partialUpdateProjectRole(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/role/${parameters.id}`,
          method: "POST",
          data: {
            name: parameters.name,
            description: parameters.description
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    fullyUpdateProjectRole(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/role/${parameters.id}`,
          method: "PUT",
          data: {
            name: parameters.name,
            description: parameters.description
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteProjectRole(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/role/${id}`,
          method: "DELETE",
          params: {
            swap: typeof parameters !== "string" && parameters.swap
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.ProjectRoles = ProjectRoles;
});

// node_modules/jira.js/out/version2/projects.js
var require_projects2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Projects = undefined;
  var tslib_1 = require_tslib();

  class Projects {
    constructor(client) {
      this.client = client;
    }
    createProject(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/project",
          method: "POST",
          data: {
            assigneeType: parameters.assigneeType,
            avatarId: parameters.avatarId,
            categoryId: parameters.categoryId,
            description: parameters.description,
            fieldConfigurationScheme: parameters.fieldConfigurationScheme,
            issueSecurityScheme: parameters.issueSecurityScheme,
            issueTypeScheme: parameters.issueTypeScheme,
            issueTypeScreenScheme: parameters.issueTypeScreenScheme,
            key: parameters.key,
            leadAccountId: parameters.leadAccountId,
            name: parameters.name,
            notificationScheme: parameters.notificationScheme,
            permissionScheme: parameters.permissionScheme,
            projectTemplateKey: parameters.projectTemplateKey,
            projectTypeKey: parameters.projectTypeKey,
            url: parameters.url,
            workflowScheme: parameters.workflowScheme
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getRecent(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/project/recent",
          method: "GET",
          params: {
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand,
            properties: parameters === null || parameters === undefined ? undefined : parameters.properties
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    searchProjects(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/project/search",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            orderBy: parameters === null || parameters === undefined ? undefined : parameters.orderBy,
            id: parameters === null || parameters === undefined ? undefined : parameters.id,
            keys: parameters === null || parameters === undefined ? undefined : parameters.keys,
            query: parameters === null || parameters === undefined ? undefined : parameters.query,
            typeKey: parameters === null || parameters === undefined ? undefined : parameters.typeKey,
            categoryId: parameters === null || parameters === undefined ? undefined : parameters.categoryId,
            action: parameters === null || parameters === undefined ? undefined : parameters.action,
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand,
            status: parameters === null || parameters === undefined ? undefined : parameters.status,
            properties: parameters === null || parameters === undefined ? undefined : parameters.properties,
            propertyQuery: parameters === null || parameters === undefined ? undefined : parameters.propertyQuery
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getProject(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectIdOrKey = typeof parameters === "string" ? parameters : parameters.projectIdOrKey;
        const config = {
          url: `/rest/api/2/project/${projectIdOrKey}`,
          method: "GET",
          params: {
            expand: typeof parameters !== "string" && parameters.expand,
            properties: typeof parameters !== "string" && parameters.properties
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateProject(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/project/${parameters.projectIdOrKey}`,
          method: "PUT",
          params: {
            expand: parameters.expand
          },
          data: {
            assigneeType: parameters.assigneeType,
            avatarId: parameters.avatarId,
            categoryId: parameters.categoryId,
            description: parameters.description,
            issueSecurityScheme: parameters.issueSecurityScheme,
            key: parameters.key,
            leadAccountId: parameters.leadAccountId,
            name: parameters.name,
            notificationScheme: parameters.notificationScheme,
            permissionScheme: parameters.permissionScheme,
            projectTemplateKey: parameters.projectTemplateKey,
            projectTypeKey: parameters.projectTypeKey,
            url: parameters.url
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteProject(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectIdOrKey = typeof parameters === "string" ? parameters : parameters.projectIdOrKey;
        const config = {
          url: `/rest/api/2/project/${projectIdOrKey}`,
          method: "DELETE",
          params: {
            enableUndo: typeof parameters !== "string" && parameters.enableUndo
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    archiveProject(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectIdOrKey = typeof parameters === "string" ? parameters : parameters.projectIdOrKey;
        const config = {
          url: `/rest/api/2/project/${projectIdOrKey}/archive`,
          method: "POST"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteProjectAsynchronously(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectIdOrKey = typeof parameters === "string" ? parameters : parameters.projectIdOrKey;
        const config = {
          url: `/rest/api/2/project/${projectIdOrKey}/delete`,
          method: "POST"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    restore(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectIdOrKey = typeof parameters === "string" ? parameters : parameters.projectIdOrKey;
        const config = {
          url: `/rest/api/2/project/${projectIdOrKey}/restore`,
          method: "POST"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAllStatuses(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectIdOrKey = typeof parameters === "string" ? parameters : parameters.projectIdOrKey;
        const config = {
          url: `/rest/api/2/project/${projectIdOrKey}/statuses`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getHierarchy(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectId = typeof parameters === "string" ? parameters : parameters.projectId;
        const config = {
          url: `/rest/api/2/project/${projectId}/hierarchy`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getNotificationSchemeForProject(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectKeyOrId = typeof parameters === "string" ? parameters : parameters.projectKeyOrId;
        const config = {
          url: `/rest/api/2/project/${projectKeyOrId}/notificationscheme`,
          method: "GET",
          params: {
            expand: typeof parameters !== "string" && parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Projects = Projects;
});

// node_modules/jira.js/out/version2/projectTypes.js
var require_projectTypes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ProjectTypes = undefined;
  var tslib_1 = require_tslib();

  class ProjectTypes {
    constructor(client) {
      this.client = client;
    }
    getAllProjectTypes(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/project/type",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAllAccessibleProjectTypes(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/project/type/accessible",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getProjectTypeByKey(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectTypeKey = typeof parameters === "string" ? parameters : parameters.projectTypeKey;
        const config = {
          url: `/rest/api/2/project/type/${projectTypeKey}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAccessibleProjectTypeByKey(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectTypeKey = typeof parameters === "string" ? parameters : parameters.projectTypeKey;
        const config = {
          url: `/rest/api/2/project/type/${projectTypeKey}/accessible`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.ProjectTypes = ProjectTypes;
});

// node_modules/jira.js/out/version2/projectVersions.js
var require_projectVersions = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ProjectVersions = undefined;
  var tslib_1 = require_tslib();

  class ProjectVersions {
    constructor(client) {
      this.client = client;
    }
    getProjectVersionsPaginated(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectIdOrKey = typeof parameters === "string" ? parameters : parameters.projectIdOrKey;
        const config = {
          url: `/rest/api/2/project/${projectIdOrKey}/version`,
          method: "GET",
          params: {
            startAt: typeof parameters !== "string" && parameters.startAt,
            maxResults: typeof parameters !== "string" && parameters.maxResults,
            orderBy: typeof parameters !== "string" && parameters.orderBy,
            query: typeof parameters !== "string" && parameters.query,
            status: typeof parameters !== "string" && parameters.status,
            expand: typeof parameters !== "string" && parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getProjectVersions(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const projectIdOrKey = typeof parameters === "string" ? parameters : parameters.projectIdOrKey;
        const config = {
          url: `/rest/api/2/project/${projectIdOrKey}/versions`,
          method: "GET",
          params: {
            expand: typeof parameters !== "string" && parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createVersion(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/version",
          method: "POST",
          data: {
            expand: parameters.expand,
            self: parameters.self,
            id: parameters.id,
            description: parameters.description,
            name: parameters.name,
            archived: parameters.archived,
            released: parameters.released,
            startDate: parameters.startDate,
            releaseDate: parameters.releaseDate,
            overdue: parameters.overdue,
            userStartDate: parameters.userStartDate,
            userReleaseDate: parameters.userReleaseDate,
            projectId: parameters.projectId,
            moveUnfixedIssuesTo: parameters.moveUnfixedIssuesTo,
            operations: parameters.operations,
            issuesStatusForFixVersion: parameters.issuesStatusForFixVersion
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getVersion(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/version/${id}`,
          method: "GET",
          params: {
            expand: typeof parameters !== "string" && parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateVersion(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/version/${parameters.id}`,
          method: "PUT",
          data: {
            expand: parameters.expand,
            description: parameters.description,
            name: parameters.name,
            archived: parameters.archived,
            released: parameters.released,
            startDate: parameters.startDate,
            releaseDate: parameters.releaseDate,
            projectId: parameters.projectId,
            moveUnfixedIssuesTo: parameters.moveUnfixedIssuesTo
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    mergeVersions(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/version/${parameters.id}/mergeto/${parameters.moveIssuesTo}`,
          method: "PUT"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    moveVersion(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/version/${parameters.id}/move`,
          method: "POST",
          data: {
            after: parameters.after,
            position: parameters.position
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getVersionRelatedIssues(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/version/${id}/relatedIssueCounts`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteAndReplaceVersion(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/version/${parameters.id}/removeAndSwap`,
          method: "POST",
          data: {
            moveFixIssuesTo: parameters.moveFixIssuesTo,
            moveAffectedIssuesTo: parameters.moveAffectedIssuesTo,
            customFieldReplacementList: parameters.customFieldReplacementList
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getVersionUnresolvedIssues(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/version/${id}/unresolvedIssueCount`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.ProjectVersions = ProjectVersions;
});

// node_modules/jira.js/out/version2/screens.js
var require_screens = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Screens = undefined;
  var tslib_1 = require_tslib();

  class Screens {
    constructor(client) {
      this.client = client;
    }
    getScreensForField(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const fieldId = typeof parameters === "string" ? parameters : parameters.fieldId;
        const config = {
          url: `/rest/api/2/field/${fieldId}/screens`,
          method: "GET",
          params: {
            startAt: typeof parameters !== "string" && parameters.startAt,
            maxResults: typeof parameters !== "string" && parameters.maxResults,
            expand: typeof parameters !== "string" && parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getScreens(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/screens",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            id: parameters === null || parameters === undefined ? undefined : parameters.id,
            queryString: parameters === null || parameters === undefined ? undefined : parameters.queryString,
            scope: parameters === null || parameters === undefined ? undefined : parameters.scope,
            orderBy: parameters === null || parameters === undefined ? undefined : parameters.orderBy
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createScreen(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/screens",
          method: "POST",
          data: {
            name: parameters.name,
            description: parameters.description
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    addFieldToDefaultScreen(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const fieldId = typeof parameters === "string" ? parameters : parameters.fieldId;
        const config = {
          url: `/rest/api/2/screens/addToDefault/${fieldId}`,
          method: "POST"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateScreen(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/screens/${parameters.screenId}`,
          method: "PUT",
          data: {
            name: parameters.name,
            description: parameters.description
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteScreen(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const screenId = typeof parameters === "string" ? parameters : parameters.screenId;
        const config = {
          url: `/rest/api/2/screens/${screenId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAvailableScreenFields(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const screenId = typeof parameters === "string" ? parameters : parameters.screenId;
        const config = {
          url: `/rest/api/2/screens/${screenId}/availableFields`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Screens = Screens;
});

// node_modules/jira.js/out/version2/screenSchemes.js
var require_screenSchemes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ScreenSchemes = undefined;
  var tslib_1 = require_tslib();

  class ScreenSchemes {
    constructor(client) {
      this.client = client;
    }
    getScreenSchemes(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/screenscheme",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            id: parameters === null || parameters === undefined ? undefined : parameters.id,
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand,
            queryString: parameters === null || parameters === undefined ? undefined : parameters.queryString,
            orderBy: parameters === null || parameters === undefined ? undefined : parameters.orderBy
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createScreenScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const name = typeof parameters === "string" ? parameters : parameters.name;
        const config = {
          url: "/rest/api/2/screenscheme",
          method: "POST",
          data: {
            name,
            description: typeof parameters !== "string" && parameters.description,
            screens: typeof parameters !== "string" && parameters.screens
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateScreenScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/screenscheme/${parameters.screenSchemeId}`,
          method: "PUT",
          data: {
            name: parameters.name,
            description: parameters.description,
            screens: parameters.screens
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteScreenScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const screenSchemeId = typeof parameters === "string" ? parameters : parameters.screenSchemeId;
        const config = {
          url: `/rest/api/2/screenscheme/${screenSchemeId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.ScreenSchemes = ScreenSchemes;
});

// node_modules/jira.js/out/version2/screenTabFields.js
var require_screenTabFields = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ScreenTabFields = undefined;
  var tslib_1 = require_tslib();

  class ScreenTabFields {
    constructor(client) {
      this.client = client;
    }
    getAllScreenTabFields(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/screens/${parameters.screenId}/tabs/${parameters.tabId}/fields`,
          method: "GET",
          params: {
            projectKey: parameters.projectKey
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    addScreenTabField(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/screens/${parameters.screenId}/tabs/${parameters.tabId}/fields`,
          method: "POST",
          data: {
            fieldId: parameters.fieldId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeScreenTabField(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/screens/${parameters.screenId}/tabs/${parameters.tabId}/fields/${parameters.id}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    moveScreenTabField(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/screens/${parameters.screenId}/tabs/${parameters.tabId}/fields/${parameters.id}/move`,
          method: "POST",
          data: {
            after: parameters.after,
            position: parameters.position
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.ScreenTabFields = ScreenTabFields;
});

// node_modules/jira.js/out/version2/screenTabs.js
var require_screenTabs = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ScreenTabs = undefined;
  var tslib_1 = require_tslib();

  class ScreenTabs {
    constructor(client) {
      this.client = client;
    }
    getAllScreenTabs(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const screenId = typeof parameters === "string" ? parameters : parameters.screenId;
        const config = {
          url: `/rest/api/2/screens/${screenId}/tabs`,
          method: "GET",
          params: {
            projectKey: typeof parameters !== "string" && parameters.projectKey
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    addScreenTab(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/screens/${parameters.screenId}/tabs`,
          method: "POST",
          data: {
            id: parameters.id,
            name: parameters.name
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    renameScreenTab(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/screens/${parameters.screenId}/tabs/${parameters.tabId}`,
          method: "PUT",
          data: {
            id: parameters.id,
            name: parameters.name
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteScreenTab(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/screens/${parameters.screenId}/tabs/${parameters.tabId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    moveScreenTab(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/screens/${parameters.screenId}/tabs/${parameters.tabId}/move/${parameters.pos}`,
          method: "POST"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.ScreenTabs = ScreenTabs;
});

// node_modules/jira.js/out/version2/serverInfo.js
var require_serverInfo = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ServerInfo = undefined;
  var tslib_1 = require_tslib();

  class ServerInfo {
    constructor(client) {
      this.client = client;
    }
    getServerInfo(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/serverInfo",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.ServerInfo = ServerInfo;
});

// node_modules/jira.js/out/version2/status.js
var require_status2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Status = undefined;
  var tslib_1 = require_tslib();

  class Status {
    constructor(client) {
      this.client = client;
    }
    getStatusesById(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: "/rest/api/2/statuses",
          method: "GET",
          params: {
            id,
            expand: typeof parameters !== "string" && parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createStatuses(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/statuses",
          method: "POST",
          data: {
            statuses: parameters.statuses,
            scope: parameters.scope
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateStatuses(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/statuses",
          method: "PUT",
          data: {
            statuses: parameters.statuses
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteStatusesById(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: "/rest/api/2/statuses",
          method: "DELETE",
          params: {
            id
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    search(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/statuses/search",
          method: "GET",
          params: {
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand,
            projectId: parameters === null || parameters === undefined ? undefined : parameters.projectId,
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            searchString: parameters === null || parameters === undefined ? undefined : parameters.searchString,
            statusCategory: parameters === null || parameters === undefined ? undefined : parameters.statusCategory
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Status = Status;
});

// node_modules/jira.js/out/version2/tasks.js
var require_tasks = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Tasks = undefined;
  var tslib_1 = require_tslib();

  class Tasks {
    constructor(client) {
      this.client = client;
    }
    getTask(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const taskId = typeof parameters === "string" ? parameters : parameters.taskId;
        const config = {
          url: `/rest/api/2/task/${taskId}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    cancelTask(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const taskId = typeof parameters === "string" ? parameters : parameters.taskId;
        const config = {
          url: `/rest/api/2/task/${taskId}/cancel`,
          method: "POST"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Tasks = Tasks;
});

// node_modules/jira.js/out/version2/timeTracking.js
var require_timeTracking = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.TimeTracking = undefined;
  var tslib_1 = require_tslib();

  class TimeTracking {
    constructor(client) {
      this.client = client;
    }
    getSelectedTimeTrackingImplementation(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/configuration/timetracking",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    selectTimeTrackingImplementation(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/configuration/timetracking",
          method: "PUT",
          data: {
            key: parameters === null || parameters === undefined ? undefined : parameters.key,
            name: parameters === null || parameters === undefined ? undefined : parameters.name,
            url: parameters === null || parameters === undefined ? undefined : parameters.url
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAvailableTimeTrackingImplementations(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/configuration/timetracking/list",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getSharedTimeTrackingConfiguration(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/configuration/timetracking/options",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setSharedTimeTrackingConfiguration(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/configuration/timetracking/options",
          method: "PUT",
          data: {
            workingHoursPerDay: parameters === null || parameters === undefined ? undefined : parameters.workingHoursPerDay,
            workingDaysPerWeek: parameters === null || parameters === undefined ? undefined : parameters.workingDaysPerWeek,
            timeFormat: parameters === null || parameters === undefined ? undefined : parameters.timeFormat,
            defaultUnit: parameters === null || parameters === undefined ? undefined : parameters.defaultUnit
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.TimeTracking = TimeTracking;
});

// node_modules/jira.js/out/version2/uIModificationsApps.js
var require_uIModificationsApps = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.UIModificationsApps = undefined;
  var tslib_1 = require_tslib();

  class UIModificationsApps {
    constructor(client) {
      this.client = client;
    }
    getUiModifications(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/uiModifications",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createUiModification(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/uiModifications",
          method: "POST",
          data: {
            name: parameters.name,
            description: parameters.description,
            data: parameters.data,
            contexts: parameters.contexts
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateUiModification(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/uiModifications/${parameters.uiModificationId}`,
          method: "PUT",
          data: {
            name: parameters.name,
            description: parameters.description,
            data: parameters.data,
            contexts: parameters.contexts
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteUiModification(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const uiModificationId = typeof parameters === "string" ? parameters : parameters.uiModificationId;
        const config = {
          url: `/rest/api/2/uiModifications/${uiModificationId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.UIModificationsApps = UIModificationsApps;
});

// node_modules/jira.js/out/version2/userProperties.js
var require_userProperties = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.UserProperties = undefined;
  var tslib_1 = require_tslib();

  class UserProperties {
    constructor(client) {
      this.client = client;
    }
    getUserPropertyKeys(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user/properties",
          method: "GET",
          params: {
            accountId: parameters === null || parameters === undefined ? undefined : parameters.accountId,
            userKey: parameters === null || parameters === undefined ? undefined : parameters.userKey,
            username: parameters === null || parameters === undefined ? undefined : parameters.username
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getUserProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/user/properties/${parameters.propertyKey}`,
          method: "GET",
          params: {
            accountId: parameters.accountId,
            userKey: parameters.userKey,
            username: parameters.username
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setUserProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/user/properties/${parameters.propertyKey}`,
          method: "PUT",
          params: {
            accountId: parameters.accountId
          },
          data: parameters.propertyValue
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteUserProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/user/properties/${parameters.propertyKey}`,
          method: "DELETE",
          params: {
            accountId: parameters.accountId,
            userKey: parameters.userKey,
            username: parameters.username
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.UserProperties = UserProperties;
});

// node_modules/jira.js/out/version2/users.js
var require_users = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Users = undefined;
  var tslib_1 = require_tslib();
  var paramSerializer_1 = require_paramSerializer();

  class Users {
    constructor(client) {
      this.client = client;
    }
    getUser(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user",
          method: "GET",
          params: {
            accountId: parameters === null || parameters === undefined ? undefined : parameters.accountId,
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createUser(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user",
          method: "POST",
          data: {
            emailAddress: parameters.emailAddress,
            key: parameters.key,
            name: parameters.name,
            password: parameters.password,
            products: parameters.products,
            self: parameters.self
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    removeUser(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user",
          method: "DELETE",
          params: {
            accountId: parameters.accountId,
            username: parameters.username,
            key: parameters.key
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    bulkGetUsers(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user/bulk",
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults,
            accountId: (0, paramSerializer_1.paramSerializer)("accountId", parameters.accountId)
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    bulkGetUsersMigration(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user/bulk/migration",
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults,
            username: (0, paramSerializer_1.paramSerializer)("username", parameters.username),
            key: (0, paramSerializer_1.paramSerializer)("key", parameters.key)
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getUserDefaultColumns(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user/columns",
          method: "GET",
          params: {
            accountId: parameters === null || parameters === undefined ? undefined : parameters.accountId,
            username: parameters === null || parameters === undefined ? undefined : parameters.username
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setUserColumns(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user/columns",
          method: "PUT",
          params: {
            accountId: parameters === null || parameters === undefined ? undefined : parameters.accountId
          },
          data: parameters === null || parameters === undefined ? undefined : parameters.columns
        };
        return this.client.sendRequest(config, callback);
      });
    }
    resetUserColumns(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user/columns",
          method: "DELETE",
          params: {
            accountId: parameters.accountId,
            username: parameters.username
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getUserEmail(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const accountId = typeof parameters === "string" ? parameters : parameters.accountId;
        const config = {
          url: "/rest/api/2/user/email",
          method: "GET",
          params: {
            accountId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getUserEmailBulk(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const accountId = typeof parameters === "string" ? parameters : parameters.accountId;
        const config = {
          url: "/rest/api/2/user/email/bulk",
          method: "GET",
          params: {
            accountId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getUserGroups(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user/groups",
          method: "GET",
          params: {
            accountId: parameters.accountId,
            username: parameters.username,
            key: parameters.key
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAllUsersDefault(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/users",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getAllUsers(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/users/search",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Users = Users;
});

// node_modules/jira.js/out/version2/userSearch.js
var require_userSearch = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.UserSearch = undefined;
  var tslib_1 = require_tslib();
  var paramSerializer_1 = require_paramSerializer();

  class UserSearch {
    constructor(client) {
      this.client = client;
    }
    findBulkAssignableUsers(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user/assignable/multiProjectSearch",
          method: "GET",
          params: {
            query: parameters.query,
            username: parameters.username,
            accountId: parameters.accountId,
            projectKeys: parameters.projectKeys,
            startAt: parameters.startAt,
            maxResults: parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    findAssignableUsers(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user/assignable/search",
          method: "GET",
          params: {
            query: parameters === null || parameters === undefined ? undefined : parameters.query,
            sessionId: parameters === null || parameters === undefined ? undefined : parameters.sessionId,
            username: parameters === null || parameters === undefined ? undefined : parameters.username,
            accountId: parameters === null || parameters === undefined ? undefined : parameters.accountId,
            project: parameters === null || parameters === undefined ? undefined : parameters.project,
            issueKey: parameters === null || parameters === undefined ? undefined : parameters.issueKey,
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            actionDescriptorId: parameters === null || parameters === undefined ? undefined : parameters.actionDescriptorId,
            recommend: parameters === null || parameters === undefined ? undefined : parameters.recommend
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    findUsersWithAllPermissions(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user/permission/search",
          method: "GET",
          params: {
            query: parameters.query,
            username: parameters.username,
            accountId: parameters.accountId,
            permissions: parameters.permissions,
            issueKey: parameters.issueKey,
            projectKey: parameters.projectKey,
            startAt: parameters.startAt,
            maxResults: parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    findUsersForPicker(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user/picker",
          method: "GET",
          params: {
            query: parameters.query,
            maxResults: parameters.maxResults,
            showAvatar: parameters.showAvatar,
            excludeAccountIds: (0, paramSerializer_1.paramSerializer)("excludeAccountIds", parameters.excludeAccountIds),
            avatarSize: parameters.avatarSize,
            excludeConnectUsers: parameters.excludeConnectUsers
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    findUsers(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user/search",
          method: "GET",
          params: {
            query: parameters === null || parameters === undefined ? undefined : parameters.query,
            username: parameters === null || parameters === undefined ? undefined : parameters.username,
            accountId: parameters === null || parameters === undefined ? undefined : parameters.accountId,
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            property: parameters === null || parameters === undefined ? undefined : parameters.property
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    findUsersByQuery(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user/search/query",
          method: "GET",
          params: {
            query: parameters.query,
            startAt: parameters.startAt,
            maxResults: parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    findUserKeysByQuery(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user/search/query/key",
          method: "GET",
          params: {
            query: parameters.query,
            startAt: parameters.startAt,
            maxResults: parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    findUsersWithBrowsePermission(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/user/viewissue/search",
          method: "GET",
          params: {
            query: parameters === null || parameters === undefined ? undefined : parameters.query,
            username: parameters === null || parameters === undefined ? undefined : parameters.username,
            accountId: parameters === null || parameters === undefined ? undefined : parameters.accountId,
            issueKey: parameters === null || parameters === undefined ? undefined : parameters.issueKey,
            projectKey: parameters === null || parameters === undefined ? undefined : parameters.projectKey,
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.UserSearch = UserSearch;
});

// node_modules/jira.js/out/version2/webhooks.js
var require_webhooks = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Webhooks = undefined;
  var tslib_1 = require_tslib();

  class Webhooks {
    constructor(client) {
      this.client = client;
    }
    getDynamicWebhooksForApp(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/webhook",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    registerDynamicWebhooks(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/webhook",
          method: "POST",
          data: {
            webhooks: parameters.webhooks,
            url: parameters.url
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteWebhookById(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/webhook",
          method: "DELETE",
          data: {
            webhookIds: parameters.webhookIds
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getFailedWebhooks(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/webhook/failed",
          method: "GET",
          params: {
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            after: parameters === null || parameters === undefined ? undefined : parameters.after
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    refreshWebhooks(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/webhook/refresh",
          method: "PUT",
          data: {
            webhookIds: parameters.webhookIds
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Webhooks = Webhooks;
});

// node_modules/jira.js/out/version2/workflows.js
var require_workflows = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Workflows = undefined;
  var tslib_1 = require_tslib();
  var paramSerializer_1 = require_paramSerializer();

  class Workflows {
    constructor(client) {
      this.client = client;
    }
    createWorkflow(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/workflow",
          method: "POST",
          data: {
            description: parameters.description,
            name: parameters.name,
            statuses: parameters.statuses,
            transitions: parameters.transitions
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getWorkflowsPaginated(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/workflow/search",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults,
            workflowName: (0, paramSerializer_1.paramSerializer)("workflowName", parameters === null || parameters === undefined ? undefined : parameters.workflowName),
            expand: parameters === null || parameters === undefined ? undefined : parameters.expand,
            queryString: parameters === null || parameters === undefined ? undefined : parameters.queryString,
            orderBy: parameters === null || parameters === undefined ? undefined : parameters.orderBy,
            isActive: parameters === null || parameters === undefined ? undefined : parameters.isActive
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteInactiveWorkflow(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const entityId = typeof parameters === "string" ? parameters : parameters.entityId;
        const config = {
          url: `/rest/api/2/workflow/${entityId}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    readWorkflows(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/workflows",
          method: "POST",
          params: {
            expand: parameters.expand
          },
          data: {
            projectAndIssueTypes: parameters.projectAndIssueTypes,
            workflowIds: parameters.workflowIds,
            workflowNames: parameters.workflowNames
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    workflowCapabilities(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/workflows/capabilities",
          method: "GET",
          params: {
            workflowId: parameters.workflowId,
            projectId: parameters.projectId,
            issueTypeId: parameters.issueTypeId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createWorkflows(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/workflows/create",
          method: "POST",
          data: {
            scope: parameters.scope,
            statuses: parameters.statuses,
            workflows: parameters.workflows
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    validateCreateWorkflows(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/workflows/create/validation",
          method: "POST",
          data: {
            payload: parameters.payload,
            validationOptions: parameters.validationOptions
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateWorkflows(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/workflows/update",
          method: "POST",
          params: {
            expand: parameters.expand
          },
          data: {
            statuses: parameters.statuses,
            workflows: parameters.workflows
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    validateUpdateWorkflows(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/workflows/update/validation",
          method: "POST",
          data: {
            payload: parameters.payload,
            validationOptions: parameters.validationOptions
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.Workflows = Workflows;
});

// node_modules/jira.js/out/version2/workflowSchemeDrafts.js
var require_workflowSchemeDrafts = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.WorkflowSchemeDrafts = undefined;
  var tslib_1 = require_tslib();

  class WorkflowSchemeDrafts {
    constructor(client) {
      this.client = client;
    }
    createWorkflowSchemeDraftFromParent(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/workflowscheme/${id}/createdraft`,
          method: "POST"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getWorkflowSchemeDraft(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/workflowscheme/${id}/draft`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateWorkflowSchemeDraft(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflowscheme/${parameters.id}/draft`,
          method: "PUT",
          data: {
            name: parameters.name,
            description: parameters.description,
            defaultWorkflow: parameters.defaultWorkflow,
            issueTypeMappings: parameters.issueTypeMappings,
            updateDraftIfNeeded: parameters.updateDraftIfNeeded
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteWorkflowSchemeDraft(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/workflowscheme/${id}/draft`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getDraftDefaultWorkflow(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/workflowscheme/${id}/draft/default`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateDraftDefaultWorkflow(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflowscheme/${parameters.id}/draft/default`,
          method: "PUT",
          data: {
            workflow: parameters.workflow,
            updateDraftIfNeeded: parameters.updateDraftIfNeeded
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteDraftDefaultWorkflow(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/workflowscheme/${id}/draft/default`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getWorkflowSchemeDraftIssueType(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflowscheme/${parameters.id}/draft/issuetype/${parameters.issueType}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setWorkflowSchemeDraftIssueType(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflowscheme/${parameters.id}/draft/issuetype/${parameters.issueType}`,
          method: "PUT",
          data: parameters.details
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteWorkflowSchemeDraftIssueType(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflowscheme/${parameters.id}/draft/issuetype/${parameters.issueType}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    publishDraftWorkflowScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/workflowscheme/${id}/draft/publish`,
          method: "POST",
          params: {
            validateOnly: typeof parameters !== "string" && parameters.validateOnly
          },
          data: {
            statusMappings: typeof parameters !== "string" && parameters.statusMappings
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getDraftWorkflow(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflowscheme/${parameters.id}/draft/workflow`,
          method: "GET",
          params: {
            workflowName: parameters.workflowName
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateDraftWorkflowMapping(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflowscheme/${parameters.id}/draft/workflow`,
          method: "PUT",
          params: {
            workflowName: parameters.workflowName
          },
          data: {
            workflow: parameters.workflow,
            issueTypes: parameters.issueTypes,
            defaultMapping: parameters.defaultMapping,
            updateDraftIfNeeded: parameters.updateDraftIfNeeded
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteDraftWorkflowMapping(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflowscheme/${parameters.id}/draft/workflow`,
          method: "DELETE",
          params: {
            workflowName: parameters.workflowName
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.WorkflowSchemeDrafts = WorkflowSchemeDrafts;
});

// node_modules/jira.js/out/version2/workflowSchemeProjectAssociations.js
var require_workflowSchemeProjectAssociations = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.WorkflowSchemeProjectAssociations = undefined;
  var tslib_1 = require_tslib();

  class WorkflowSchemeProjectAssociations {
    constructor(client) {
      this.client = client;
    }
    getWorkflowSchemeProjectAssociations(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/workflowscheme/project",
          method: "GET",
          params: {
            projectId: parameters.projectId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    assignSchemeToProject(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/workflowscheme/project",
          method: "PUT",
          data: {
            workflowSchemeId: parameters === null || parameters === undefined ? undefined : parameters.workflowSchemeId,
            projectId: parameters === null || parameters === undefined ? undefined : parameters.projectId
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.WorkflowSchemeProjectAssociations = WorkflowSchemeProjectAssociations;
});

// node_modules/jira.js/out/version2/workflowSchemes.js
var require_workflowSchemes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.WorkflowSchemes = undefined;
  var tslib_1 = require_tslib();

  class WorkflowSchemes {
    constructor(client) {
      this.client = client;
    }
    getAllWorkflowSchemes(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/workflowscheme",
          method: "GET",
          params: {
            startAt: parameters === null || parameters === undefined ? undefined : parameters.startAt,
            maxResults: parameters === null || parameters === undefined ? undefined : parameters.maxResults
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createWorkflowScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/workflowscheme",
          method: "POST",
          data: {
            defaultWorkflow: parameters.defaultWorkflow,
            description: parameters.description,
            draft: parameters.draft,
            id: parameters.id,
            issueTypeMappings: parameters.issueTypeMappings,
            issueTypes: parameters.issueTypes,
            lastModified: parameters.lastModified,
            lastModifiedUser: parameters.lastModifiedUser,
            name: parameters.name,
            originalDefaultWorkflow: parameters.originalDefaultWorkflow,
            originalIssueTypeMappings: parameters.originalIssueTypeMappings,
            self: parameters.self,
            updateDraftIfNeeded: parameters.updateDraftIfNeeded
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getWorkflowScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/workflowscheme/${id}`,
          method: "GET",
          params: {
            returnDraftIfExists: typeof parameters !== "string" && parameters.returnDraftIfExists
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateWorkflowScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflowscheme/${parameters.id}`,
          method: "PUT",
          data: {
            name: parameters.name,
            description: parameters.description,
            defaultWorkflow: parameters.defaultWorkflow,
            issueTypeMappings: parameters.issueTypeMappings,
            updateDraftIfNeeded: parameters.updateDraftIfNeeded
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteWorkflowScheme(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/workflowscheme/${id}`,
          method: "DELETE"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getDefaultWorkflow(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/workflowscheme/${id}/default`,
          method: "GET",
          params: {
            returnDraftIfExists: typeof parameters !== "string" && parameters.returnDraftIfExists
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateDefaultWorkflow(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflowscheme/${parameters.id}/default`,
          method: "PUT",
          data: {
            updateDraftIfNeeded: parameters.updateDraftIfNeeded,
            workflow: parameters.workflow
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteDefaultWorkflow(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/workflowscheme/${id}/default`,
          method: "DELETE",
          params: {
            updateDraftIfNeeded: typeof parameters !== "string" && parameters.updateDraftIfNeeded
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getWorkflowSchemeIssueType(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflowscheme/${parameters.id}/issuetype/${parameters.issueType}`,
          method: "GET",
          params: {
            returnDraftIfExists: parameters.returnDraftIfExists
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    setWorkflowSchemeIssueType(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflowscheme/${parameters.id}/issuetype/${parameters.issueType}`,
          method: "PUT",
          data: parameters.details
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteWorkflowSchemeIssueType(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflowscheme/${parameters.id}/issuetype/${parameters.issueType}`,
          method: "DELETE",
          params: {
            updateDraftIfNeeded: parameters.updateDraftIfNeeded
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getWorkflow(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/workflowscheme/${id}/workflow`,
          method: "GET",
          params: {
            workflowName: typeof parameters !== "string" && parameters.workflowName,
            returnDraftIfExists: typeof parameters !== "string" && parameters.returnDraftIfExists
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateWorkflowMapping(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflowscheme/${parameters.id}/workflow`,
          method: "PUT",
          params: {
            workflowName: parameters.workflowName
          },
          data: {
            defaultMapping: parameters.defaultMapping,
            issueTypes: parameters.issueTypes,
            updateDraftIfNeeded: parameters.updateDraftIfNeeded,
            workflow: parameters.workflow
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteWorkflowMapping(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const id = typeof parameters === "string" ? parameters : parameters.id;
        const config = {
          url: `/rest/api/2/workflowscheme/${id}/workflow`,
          method: "DELETE",
          params: {
            workflowName: typeof parameters !== "string" && parameters.workflowName,
            updateDraftIfNeeded: typeof parameters !== "string" && parameters.updateDraftIfNeeded
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.WorkflowSchemes = WorkflowSchemes;
});

// node_modules/jira.js/out/version2/workflowStatusCategories.js
var require_workflowStatusCategories = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.WorkflowStatusCategories = undefined;
  var tslib_1 = require_tslib();

  class WorkflowStatusCategories {
    constructor(client) {
      this.client = client;
    }
    getStatusCategories(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/statuscategory",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getStatusCategory(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const idOrKey = typeof parameters === "string" ? parameters : parameters.idOrKey;
        const config = {
          url: `/rest/api/2/statuscategory/${idOrKey}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.WorkflowStatusCategories = WorkflowStatusCategories;
});

// node_modules/jira.js/out/version2/workflowStatuses.js
var require_workflowStatuses = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.WorkflowStatuses = undefined;
  var tslib_1 = require_tslib();

  class WorkflowStatuses {
    constructor(client) {
      this.client = client;
    }
    getStatuses(callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/status",
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
    getStatus(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const idOrName = typeof parameters === "string" ? parameters : parameters.idOrName;
        const config = {
          url: `/rest/api/2/status/${idOrName}`,
          method: "GET"
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.WorkflowStatuses = WorkflowStatuses;
});

// node_modules/jira.js/out/version2/workflowTransitionProperties.js
var require_workflowTransitionProperties = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.WorkflowTransitionProperties = undefined;
  var tslib_1 = require_tslib();

  class WorkflowTransitionProperties {
    constructor(client) {
      this.client = client;
    }
    getWorkflowTransitionProperties(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflow/transitions/${parameters.transitionId}/properties`,
          method: "GET",
          params: {
            includeReservedKeys: parameters.includeReservedKeys,
            key: parameters.key,
            workflowName: parameters.workflowName,
            workflowMode: parameters.workflowMode
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    createWorkflowTransitionProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflow/transitions/${parameters.transitionId}/properties`,
          method: "POST",
          params: {
            key: parameters.key,
            workflowName: parameters.workflowName,
            workflowMode: parameters.workflowMode
          },
          data: Object.assign(Object.assign({}, parameters), { transitionId: undefined, key: undefined, workflowName: undefined, workflowMode: undefined })
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateWorkflowTransitionProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflow/transitions/${parameters.transitionId}/properties`,
          method: "PUT",
          params: {
            key: parameters.key,
            workflowName: parameters.workflowName,
            workflowMode: parameters.workflowMode
          },
          data: Object.assign(Object.assign({}, parameters), { transitionId: undefined, key: undefined, workflowName: undefined, workflowMode: undefined })
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteWorkflowTransitionProperty(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: `/rest/api/2/workflow/transitions/${parameters.transitionId}/properties`,
          method: "DELETE",
          params: {
            key: parameters.key,
            workflowName: parameters.workflowName,
            workflowMode: parameters.workflowMode
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.WorkflowTransitionProperties = WorkflowTransitionProperties;
});

// node_modules/jira.js/out/version2/workflowTransitionRules.js
var require_workflowTransitionRules = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.WorkflowTransitionRules = undefined;
  var tslib_1 = require_tslib();

  class WorkflowTransitionRules {
    constructor(client) {
      this.client = client;
    }
    getWorkflowTransitionRuleConfigurations(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/workflow/rule/config",
          method: "GET",
          params: {
            startAt: parameters.startAt,
            maxResults: parameters.maxResults,
            types: parameters.types,
            keys: parameters.keys,
            workflowNames: parameters.workflowNames,
            withTags: parameters.withTags,
            draft: parameters.draft,
            expand: parameters.expand
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    updateWorkflowTransitionRuleConfigurations(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/workflow/rule/config",
          method: "PUT",
          data: {
            workflows: parameters.workflows
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
    deleteWorkflowTransitionRuleConfigurations(parameters, callback) {
      return tslib_1.__awaiter(this, undefined, undefined, function* () {
        const config = {
          url: "/rest/api/2/workflow/rule/config/delete",
          method: "PUT",
          data: {
            workflows: parameters === null || parameters === undefined ? undefined : parameters.workflows
          }
        };
        return this.client.sendRequest(config, callback);
      });
    }
  }
  exports.WorkflowTransitionRules = WorkflowTransitionRules;
});

// node_modules/jira.js/out/version2/models/actorInput.js
var require_actorInput = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/actorsMap.js
var require_actorsMap = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/addField.js
var require_addField = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/addGroup.js
var require_addGroup = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/addSecuritySchemeLevelsRequest.js
var require_addSecuritySchemeLevelsRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/announcementBannerConfiguration.js
var require_announcementBannerConfiguration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/announcementBannerConfigurationUpdate.js
var require_announcementBannerConfigurationUpdate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/application.js
var require_application = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/applicationProperty.js
var require_applicationProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/applicationRole.js
var require_applicationRole = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/associatedItem.js
var require_associatedItem = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/associateFieldConfigurationsWithIssueTypesRequest.js
var require_associateFieldConfigurationsWithIssueTypesRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/attachment.js
var require_attachment = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/attachmentArchiveEntry.js
var require_attachmentArchiveEntry = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/attachmentArchiveImpl.js
var require_attachmentArchiveImpl = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/attachmentArchiveItemReadable.js
var require_attachmentArchiveItemReadable = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/attachmentArchiveMetadataReadable.js
var require_attachmentArchiveMetadataReadable = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/attachmentMetadata.js
var require_attachmentMetadata = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/attachmentSettings.js
var require_attachmentSettings = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/auditRecord.js
var require_auditRecord = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/auditRecords.js
var require_auditRecords2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/autoCompleteSuggestion.js
var require_autoCompleteSuggestion = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/autoCompleteSuggestions.js
var require_autoCompleteSuggestions = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/availableDashboardGadget.js
var require_availableDashboardGadget = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/availableDashboardGadgetsResponse.js
var require_availableDashboardGadgetsResponse = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/availableWorkflowConnectRule.js
var require_availableWorkflowConnectRule = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/availableWorkflowForgeRule.js
var require_availableWorkflowForgeRule = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/availableWorkflowSystemRule.js
var require_availableWorkflowSystemRule = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/availableWorkflowTriggers.js
var require_availableWorkflowTriggers = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/availableWorkflowTriggerTypes.js
var require_availableWorkflowTriggerTypes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/avatar.js
var require_avatar = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/avatars.js
var require_avatars2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/avatarUrls.js
var require_avatarUrls2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/avatarWithDetails.js
var require_avatarWithDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/bulkChangeOwnerDetails.js
var require_bulkChangeOwnerDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/bulkCustomFieldOptionCreateRequest.js
var require_bulkCustomFieldOptionCreateRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/bulkCustomFieldOptionUpdateRequest.js
var require_bulkCustomFieldOptionUpdateRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/bulkEditShareableEntity.js
var require_bulkEditShareableEntity = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/bulkIssueIsWatching.js
var require_bulkIssueIsWatching = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/bulkIssuePropertyUpdateRequest.js
var require_bulkIssuePropertyUpdateRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/bulkOperationErrorResult.js
var require_bulkOperationErrorResult = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/bulkPermissionGrants.js
var require_bulkPermissionGrants = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/bulkPermissionsRequest.js
var require_bulkPermissionsRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/bulkProjectPermissionGrants.js
var require_bulkProjectPermissionGrants = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/bulkProjectPermissions.js
var require_bulkProjectPermissions = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/changeDetails.js
var require_changeDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/changedValue.js
var require_changedValue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/changedWorklog.js
var require_changedWorklog = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/changedWorklogs.js
var require_changedWorklogs = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/changelog.js
var require_changelog = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/columnItem.js
var require_columnItem = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/comment.js
var require_comment = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/componentIssuesCount.js
var require_componentIssuesCount = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/componentWithIssueCount.js
var require_componentWithIssueCount = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/conditionGroupConfiguration.js
var require_conditionGroupConfiguration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/conditionGroupUpdate.js
var require_conditionGroupUpdate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/configuration.js
var require_configuration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/connectCustomFieldValue.js
var require_connectCustomFieldValue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/connectCustomFieldValues.js
var require_connectCustomFieldValues = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/connectModule.js
var require_connectModule = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/connectModules.js
var require_connectModules = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/connectWorkflowTransitionRule.js
var require_connectWorkflowTransitionRule = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/containerForProjectFeatures.js
var require_containerForProjectFeatures = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/containerForRegisteredWebhooks.js
var require_containerForRegisteredWebhooks = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/containerForWebhookIDs.js
var require_containerForWebhookIDs = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/containerOfWorkflowSchemeAssociations.js
var require_containerOfWorkflowSchemeAssociations = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/contextForProjectAndIssueType.js
var require_contextForProjectAndIssueType = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/contextualConfiguration.js
var require_contextualConfiguration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/convertedJQLQueries.js
var require_convertedJQLQueries = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/createCustomFieldContext.js
var require_createCustomFieldContext = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/createdIssue.js
var require_createdIssue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/createdIssues.js
var require_createdIssues = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/createIssueSecuritySchemeDetails.js
var require_createIssueSecuritySchemeDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/createNotificationSchemeDetails.js
var require_createNotificationSchemeDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/createPriorityDetails.js
var require_createPriorityDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/createProjectDetails.js
var require_createProjectDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/createResolutionDetails.js
var require_createResolutionDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/createUiModificationDetails.js
var require_createUiModificationDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/createUpdateRoleRequest.js
var require_createUpdateRoleRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/createWorkflowCondition.js
var require_createWorkflowCondition = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/createWorkflowDetails.js
var require_createWorkflowDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/createWorkflowStatusDetails.js
var require_createWorkflowStatusDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/createWorkflowTransitionDetails.js
var require_createWorkflowTransitionDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/createWorkflowTransitionRule.js
var require_createWorkflowTransitionRule = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/createWorkflowTransitionRulesDetails.js
var require_createWorkflowTransitionRulesDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/createWorkflowTransitionScreenDetails.js
var require_createWorkflowTransitionScreenDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/customContextVariable.js
var require_customContextVariable = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/customFieldConfigurations.js
var require_customFieldConfigurations = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/customFieldContext.js
var require_customFieldContext = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/customFieldContextDefaultValue.js
var require_customFieldContextDefaultValue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/customFieldContextDefaultValueUpdate.js
var require_customFieldContextDefaultValueUpdate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/customFieldContextOption.js
var require_customFieldContextOption = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/customFieldContextProjectMapping.js
var require_customFieldContextProjectMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/customFieldContextUpdateDetails.js
var require_customFieldContextUpdateDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/customFieldCreatedContextOptionsList.js
var require_customFieldCreatedContextOptionsList = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/customFieldDefinitionJson.js
var require_customFieldDefinitionJson = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/customFieldOption.js
var require_customFieldOption = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/customFieldOptionCreate.js
var require_customFieldOptionCreate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/customFieldOptionUpdate.js
var require_customFieldOptionUpdate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/customFieldReplacement.js
var require_customFieldReplacement = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/customFieldUpdatedContextOptionsList.js
var require_customFieldUpdatedContextOptionsList = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/customFieldValueUpdate.js
var require_customFieldValueUpdate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/customFieldValueUpdateDetails.js
var require_customFieldValueUpdateDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/dashboard.js
var require_dashboard = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/dashboardDetails.js
var require_dashboardDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/dashboardGadget.js
var require_dashboardGadget = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/dashboardGadgetPosition.js
var require_dashboardGadgetPosition = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/dashboardGadgetResponse.js
var require_dashboardGadgetResponse = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/dashboardGadgetSettings.js
var require_dashboardGadgetSettings = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/dashboardGadgetUpdateRequest.js
var require_dashboardGadgetUpdateRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/dashboardUser.js
var require_dashboardUser = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/dateRangeFilter.js
var require_dateRangeFilter = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/defaultLevelValue.js
var require_defaultLevelValue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/defaultShareScope.js
var require_defaultShareScope = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/defaultWorkflow.js
var require_defaultWorkflow = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/documentVersion.js
var require_documentVersion = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/entityProperty.js
var require_entityProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/entityPropertyDetails.js
var require_entityPropertyDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/error.js
var require_error = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/errorCollection.js
var require_errorCollection = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/errors.js
var require_errors = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/eventNotification.js
var require_eventNotification = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/exportArchivedIssuesTaskProgress.js
var require_exportArchivedIssuesTaskProgress = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/failedWebhook.js
var require_failedWebhook = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/failedWebhooks.js
var require_failedWebhooks = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/field.js
var require_field = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/fieldConfiguration.js
var require_fieldConfiguration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/fieldConfigurationDetails.js
var require_fieldConfigurationDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/fieldConfigurationIssueTypeItem.js
var require_fieldConfigurationIssueTypeItem = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/fieldConfigurationItem.js
var require_fieldConfigurationItem = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/fieldConfigurationItemsDetails.js
var require_fieldConfigurationItemsDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/fieldConfigurationScheme.js
var require_fieldConfigurationScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/fieldConfigurationSchemeProjectAssociation.js
var require_fieldConfigurationSchemeProjectAssociation = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/fieldConfigurationSchemeProjects.js
var require_fieldConfigurationSchemeProjects = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/fieldConfigurationToIssueTypeMapping.js
var require_fieldConfigurationToIssueTypeMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/fieldDetails.js
var require_fieldDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/fieldLastUsed.js
var require_fieldLastUsed = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/fieldMetadata.js
var require_fieldMetadata = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/fieldReferenceData.js
var require_fieldReferenceData = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/fields.js
var require_fields2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/filter.js
var require_filter = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/filterDetails.js
var require_filterDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/filterSubscription.js
var require_filterSubscription = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/filterSubscriptionsList.js
var require_filterSubscriptionsList = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/fixVersion.js
var require_fixVersion2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/foundGroup.js
var require_foundGroup = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/foundGroups.js
var require_foundGroups = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/foundUsers.js
var require_foundUsers = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/foundUsersAndGroups.js
var require_foundUsersAndGroups = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/functionReferenceData.js
var require_functionReferenceData = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/globalScope.js
var require_globalScope = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/group.js
var require_group2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/groupDetails.js
var require_groupDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/groupLabel.js
var require_groupLabel = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/groupName.js
var require_groupName = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/hierarchy.js
var require_hierarchy = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/hierarchyLevel.js
var require_hierarchyLevel = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/historyMetadata.js
var require_historyMetadata = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/historyMetadataParticipant.js
var require_historyMetadataParticipant = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/icon.js
var require_icon = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/id.js
var require_id = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/idOrKey.js
var require_idOrKey = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/includedFields.js
var require_includedFields = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issue.js
var require_issue3 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueArchivalSync.js
var require_issueArchivalSync = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueChangelogIds.js
var require_issueChangelogIds = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueCommentListRequest.js
var require_issueCommentListRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueCreateMetadata.js
var require_issueCreateMetadata = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueEntityProperties.js
var require_issueEntityProperties = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueEntityPropertiesForMultiUpdate.js
var require_issueEntityPropertiesForMultiUpdate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueEvent.js
var require_issueEvent = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueFieldOption.js
var require_issueFieldOption = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueFieldOptionConfiguration.js
var require_issueFieldOptionConfiguration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueFieldOptionCreate.js
var require_issueFieldOptionCreate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueFieldOptionScope.js
var require_issueFieldOptionScope = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueFilterForBulkPropertyDelete.js
var require_issueFilterForBulkPropertyDelete = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueFilterForBulkPropertySet.js
var require_issueFilterForBulkPropertySet = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueLink.js
var require_issueLink = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueLinkType.js
var require_issueLinkType = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueLinkTypes.js
var require_issueLinkTypes2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueList.js
var require_issueList = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueMatches.js
var require_issueMatches = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueMatchesForJQL.js
var require_issueMatchesForJQL = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issuePickerSuggestions.js
var require_issuePickerSuggestions = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issuePickerSuggestionsIssueType.js
var require_issuePickerSuggestionsIssueType = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issuesAndJQLQueries.js
var require_issuesAndJQLQueries = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueSecurityLevelMember.js
var require_issueSecurityLevelMember = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueSecuritySchemeToProjectMapping.js
var require_issueSecuritySchemeToProjectMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issuesJqlMetaData.js
var require_issuesJqlMetaData = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issuesMeta.js
var require_issuesMeta = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issuesUpdate.js
var require_issuesUpdate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTransition.js
var require_issueTransition2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeCreate.js
var require_issueTypeCreate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeDetails.js
var require_issueTypeDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeIds.js
var require_issueTypeIds = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeIdsToRemove.js
var require_issueTypeIdsToRemove = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeInfo.js
var require_issueTypeInfo = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeIssueCreateMetadata.js
var require_issueTypeIssueCreateMetadata = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeScheme.js
var require_issueTypeScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeSchemeDetails.js
var require_issueTypeSchemeDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeSchemeID.js
var require_issueTypeSchemeID = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeSchemeMapping.js
var require_issueTypeSchemeMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeSchemeProjectAssociation.js
var require_issueTypeSchemeProjectAssociation = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeSchemeProjects.js
var require_issueTypeSchemeProjects = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeSchemeUpdateDetails.js
var require_issueTypeSchemeUpdateDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeScreenScheme.js
var require_issueTypeScreenScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeScreenSchemeDetails.js
var require_issueTypeScreenSchemeDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeScreenSchemeId.js
var require_issueTypeScreenSchemeId = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeScreenSchemeItem.js
var require_issueTypeScreenSchemeItem = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeScreenSchemeMapping.js
var require_issueTypeScreenSchemeMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeScreenSchemeMappingDetails.js
var require_issueTypeScreenSchemeMappingDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeScreenSchemeProjectAssociation.js
var require_issueTypeScreenSchemeProjectAssociation = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeScreenSchemesProjects.js
var require_issueTypeScreenSchemesProjects = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeScreenSchemeUpdateDetails.js
var require_issueTypeScreenSchemeUpdateDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypesWorkflowMapping.js
var require_issueTypesWorkflowMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeToContextMapping.js
var require_issueTypeToContextMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeUpdate.js
var require_issueTypeUpdate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeWithStatus.js
var require_issueTypeWithStatus = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueTypeWorkflowMapping.js
var require_issueTypeWorkflowMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueUpdateDetails.js
var require_issueUpdateDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/issueUpdateMetadata.js
var require_issueUpdateMetadata = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jexpIssues.js
var require_jexpIssues = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jexpJqlIssues.js
var require_jexpJqlIssues = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jiraExpressionAnalysis.js
var require_jiraExpressionAnalysis = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jiraExpressionComplexity.js
var require_jiraExpressionComplexity = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jiraExpressionEvalContext.js
var require_jiraExpressionEvalContext = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jiraExpressionEvalRequest.js
var require_jiraExpressionEvalRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jiraExpressionEvaluationMetaData.js
var require_jiraExpressionEvaluationMetaData = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jiraExpressionForAnalysis.js
var require_jiraExpressionForAnalysis = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jiraExpressionResult.js
var require_jiraExpressionResult = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jiraExpressionsAnalysis.js
var require_jiraExpressionsAnalysis = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jiraExpressionsComplexity.js
var require_jiraExpressionsComplexity = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jiraExpressionsComplexityValue.js
var require_jiraExpressionsComplexityValue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jiraExpressionValidationError.js
var require_jiraExpressionValidationError = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jiraStatus.js
var require_jiraStatus = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jiraWorkflow.js
var require_jiraWorkflow = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jiraWorkflowStatus.js
var require_jiraWorkflowStatus = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jqlFunctionPrecomputation.js
var require_jqlFunctionPrecomputation = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jqlFunctionPrecomputationUpdate.js
var require_jqlFunctionPrecomputationUpdate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jqlFunctionPrecomputationUpdateRequest.js
var require_jqlFunctionPrecomputationUpdateRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jQLPersonalDataMigrationRequest.js
var require_jQLPersonalDataMigrationRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jqlQueriesToParse.js
var require_jqlQueriesToParse = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jqlQueriesToSanitize.js
var require_jqlQueriesToSanitize = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jqlQuery.js
var require_jqlQuery = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jqlQueryClause.js
var require_jqlQueryClause = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jqlQueryField.js
var require_jqlQueryField = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jqlQueryFieldEntityProperty.js
var require_jqlQueryFieldEntityProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jqlQueryOrderByClause.js
var require_jqlQueryOrderByClause = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jqlQueryOrderByClauseElement.js
var require_jqlQueryOrderByClauseElement = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jqlQueryToSanitize.js
var require_jqlQueryToSanitize = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jQLQueryWithUnknownUsers.js
var require_jQLQueryWithUnknownUsers = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jQLReferenceData.js
var require_jQLReferenceData = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/jsonType.js
var require_jsonType2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/license.js
var require_license = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/licensedApplication.js
var require_licensedApplication = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/licenseMetric.js
var require_licenseMetric = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/linkedIssue.js
var require_linkedIssue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/linkGroup.js
var require_linkGroup2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/linkIssueRequestJson.js
var require_linkIssueRequestJson = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/listWrapperCallbackApplicationRole.js
var require_listWrapperCallbackApplicationRole = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/listWrapperCallbackGroupName.js
var require_listWrapperCallbackGroupName = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/locale.js
var require_locale = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/moveField.js
var require_moveField = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/multiIssueEntityProperties.js
var require_multiIssueEntityProperties = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/multipleCustomFieldValuesUpdate.js
var require_multipleCustomFieldValuesUpdate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/multipleCustomFieldValuesUpdateDetails.js
var require_multipleCustomFieldValuesUpdateDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/nestedResponse.js
var require_nestedResponse = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/newUserDetails.js
var require_newUserDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/notification.js
var require_notification = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/notificationEvent.js
var require_notificationEvent = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/notificationRecipients.js
var require_notificationRecipients = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/notificationRecipientsRestrictions.js
var require_notificationRecipientsRestrictions = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/notificationScheme.js
var require_notificationScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/notificationSchemeAndProjectMapping.js
var require_notificationSchemeAndProjectMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/notificationSchemeAndProjectMappingPage.js
var require_notificationSchemeAndProjectMappingPage = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/notificationSchemeEvent.js
var require_notificationSchemeEvent = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/notificationSchemeEventDetails.js
var require_notificationSchemeEventDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/notificationSchemeEventTypeId.js
var require_notificationSchemeEventTypeId = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/notificationSchemeId.js
var require_notificationSchemeId = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/notificationSchemeNotificationDetails.js
var require_notificationSchemeNotificationDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/oldToNewSecurityLevelMappings.js
var require_oldToNewSecurityLevelMappings = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/operationMessage.js
var require_operationMessage = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/operations.js
var require_operations2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/orderOfCustomFieldOptions.js
var require_orderOfCustomFieldOptions = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/orderOfIssueTypes.js
var require_orderOfIssueTypes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageChangelog.js
var require_pageChangelog = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageComment.js
var require_pageComment = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageComponentWithIssueCount.js
var require_pageComponentWithIssueCount = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageContextForProjectAndIssueType.js
var require_pageContextForProjectAndIssueType = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageContextualConfiguration.js
var require_pageContextualConfiguration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageCustomFieldContext.js
var require_pageCustomFieldContext = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageCustomFieldContextDefaultValue.js
var require_pageCustomFieldContextDefaultValue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageCustomFieldContextOption.js
var require_pageCustomFieldContextOption = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageCustomFieldContextProjectMapping.js
var require_pageCustomFieldContextProjectMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageDashboard.js
var require_pageDashboard = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pagedListUserDetailsApplicationUser.js
var require_pagedListUserDetailsApplicationUser = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageField.js
var require_pageField = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageFieldConfiguration.js
var require_pageFieldConfiguration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageFieldConfigurationIssueTypeItem.js
var require_pageFieldConfigurationIssueTypeItem = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageFieldConfigurationItem.js
var require_pageFieldConfigurationItem = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageFieldConfigurationScheme.js
var require_pageFieldConfigurationScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageFieldConfigurationSchemeProjects.js
var require_pageFieldConfigurationSchemeProjects = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageFilterDetails.js
var require_pageFilterDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageGroupDetails.js
var require_pageGroupDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageIssueFieldOption.js
var require_pageIssueFieldOption = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageIssueSecurityLevelMember.js
var require_pageIssueSecurityLevelMember = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageIssueSecuritySchemeToProjectMapping.js
var require_pageIssueSecuritySchemeToProjectMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageIssueTypeScheme.js
var require_pageIssueTypeScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageIssueTypeSchemeMapping.js
var require_pageIssueTypeSchemeMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageIssueTypeSchemeProjects.js
var require_pageIssueTypeSchemeProjects = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageIssueTypeScreenScheme.js
var require_pageIssueTypeScreenScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageIssueTypeScreenSchemeItem.js
var require_pageIssueTypeScreenSchemeItem = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageIssueTypeScreenSchemesProjects.js
var require_pageIssueTypeScreenSchemesProjects = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageIssueTypeToContextMapping.js
var require_pageIssueTypeToContextMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageJqlFunctionPrecomputation.js
var require_pageJqlFunctionPrecomputation = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageNotificationScheme.js
var require_pageNotificationScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageOfChangelogs.js
var require_pageOfChangelogs = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageOfComments.js
var require_pageOfComments = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageOfDashboards.js
var require_pageOfDashboards = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageOfStatuses.js
var require_pageOfStatuses = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageOfWorklogs.js
var require_pageOfWorklogs = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pagePriority.js
var require_pagePriority = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageProject.js
var require_pageProject = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageProjectDetails.js
var require_pageProjectDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageResolution.js
var require_pageResolution = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageScreen.js
var require_pageScreen = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageScreenScheme.js
var require_pageScreenScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageScreenWithTab.js
var require_pageScreenWithTab = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageSecurityLevel.js
var require_pageSecurityLevel = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageSecurityLevelMember.js
var require_pageSecurityLevelMember = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageSecuritySchemeWithProjects.js
var require_pageSecuritySchemeWithProjects = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageString.js
var require_pageString = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageUiModificationDetails.js
var require_pageUiModificationDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageUser.js
var require_pageUser = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageUserDetails.js
var require_pageUserDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageUserKey.js
var require_pageUserKey = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageVersion.js
var require_pageVersion = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageWebhook.js
var require_pageWebhook = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageWorkflow.js
var require_pageWorkflow = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageWorkflowScheme.js
var require_pageWorkflowScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/pageWorkflowTransitionRules.js
var require_pageWorkflowTransitionRules = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/parsedJqlQueries.js
var require_parsedJqlQueries = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/parsedJqlQuery.js
var require_parsedJqlQuery = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/permissionDetails.js
var require_permissionDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/permissionGrant.js
var require_permissionGrant = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/permissionGrants.js
var require_permissionGrants = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/permissionHolder.js
var require_permissionHolder = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/permissions.js
var require_permissions2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/permissionScheme.js
var require_permissionScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/permissionSchemes.js
var require_permissionSchemes2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/permissionsKeys.js
var require_permissionsKeys = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/permittedProjects.js
var require_permittedProjects = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/priority.js
var require_priority = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/priorityId.js
var require_priorityId = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/project.js
var require_project2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectAndIssueTypePair.js
var require_projectAndIssueTypePair = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectAvatars.js
var require_projectAvatars2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectCategory.js
var require_projectCategory = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectComponent.js
var require_projectComponent = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectDetails.js
var require_projectDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectEmailAddress.js
var require_projectEmailAddress = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectFeature.js
var require_projectFeature = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectFeatureToggleRequest.js
var require_projectFeatureToggleRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectId.js
var require_projectId = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectIdentifier.js
var require_projectIdentifier = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectIdentifiers.js
var require_projectIdentifiers = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectIds.js
var require_projectIds = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectInsight.js
var require_projectInsight = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectIssueCreateMetadata.js
var require_projectIssueCreateMetadata = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectIssueSecurityLevels.js
var require_projectIssueSecurityLevels = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectIssueTypeHierarchy.js
var require_projectIssueTypeHierarchy = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectIssueTypeMapping.js
var require_projectIssueTypeMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectIssueTypeMappings.js
var require_projectIssueTypeMappings = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectIssueTypes.js
var require_projectIssueTypes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectIssueTypesHierarchyLevel.js
var require_projectIssueTypesHierarchyLevel = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectLandingPageInfo.js
var require_projectLandingPageInfo = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectPermissions.js
var require_projectPermissions = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectRole.js
var require_projectRole = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectRoleActorsUpdate.js
var require_projectRoleActorsUpdate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectRoleDetails.js
var require_projectRoleDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectRoleGroup.js
var require_projectRoleGroup = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectRoleUser.js
var require_projectRoleUser = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectScope.js
var require_projectScope = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/projectType.js
var require_projectType = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/propertyKey.js
var require_propertyKey = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/propertyKeys.js
var require_propertyKeys = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/publishedWorkflowId.js
var require_publishedWorkflowId = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/registeredWebhook.js
var require_registeredWebhook = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/remoteIssueLink.js
var require_remoteIssueLink = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/remoteIssueLinkIdentifies.js
var require_remoteIssueLinkIdentifies = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/remoteIssueLinkRequest.js
var require_remoteIssueLinkRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/remoteObject.js
var require_remoteObject = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/reorderIssuePriorities.js
var require_reorderIssuePriorities = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/reorderIssueResolutionsRequest.js
var require_reorderIssueResolutionsRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/resolution.js
var require_resolution = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/resolutionId.js
var require_resolutionId = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/restrictedPermission.js
var require_restrictedPermission = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/richText.js
var require_richText = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/roleActor.js
var require_roleActor = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/ruleConfiguration.js
var require_ruleConfiguration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/sanitizedJqlQueries.js
var require_sanitizedJqlQueries = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/sanitizedJqlQuery.js
var require_sanitizedJqlQuery = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/scope.js
var require_scope = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/screen.js
var require_screen = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/screenableField.js
var require_screenableField = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/screenableTab.js
var require_screenableTab = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/screenDetails.js
var require_screenDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/screenScheme.js
var require_screenScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/screenSchemeDetails.js
var require_screenSchemeDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/screenSchemeId.js
var require_screenSchemeId = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/screenTypes.js
var require_screenTypes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/screenWithTab.js
var require_screenWithTab = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/searchAutoComplete.js
var require_searchAutoComplete = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/searchRequest.js
var require_searchRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/searchResults.js
var require_searchResults2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/securityLevel.js
var require_securityLevel = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/securityLevelMember.js
var require_securityLevelMember = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/securityScheme.js
var require_securityScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/securitySchemeId.js
var require_securitySchemeId = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/securitySchemeLevel.js
var require_securitySchemeLevel = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/securitySchemeLevelMember.js
var require_securitySchemeLevelMember = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/securitySchemeMembersRequest.js
var require_securitySchemeMembersRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/securitySchemes.js
var require_securitySchemes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/securitySchemeWithProjects.js
var require_securitySchemeWithProjects = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/serverInformation.js
var require_serverInformation = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/setDefaultLevelsRequest.js
var require_setDefaultLevelsRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/setDefaultPriorityRequest.js
var require_setDefaultPriorityRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/setDefaultResolutionRequest.js
var require_setDefaultResolutionRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/sharePermission.js
var require_sharePermission = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/sharePermissionInput.js
var require_sharePermissionInput = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/simpleApplicationProperty.js
var require_simpleApplicationProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/simpleLink.js
var require_simpleLink = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/simpleListWrapperApplicationRole.js
var require_simpleListWrapperApplicationRole = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/simpleListWrapperGroupName.js
var require_simpleListWrapperGroupName = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/status.js
var require_status3 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/statusCategory.js
var require_statusCategory2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/statusCreate.js
var require_statusCreate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/statusCreateRequest.js
var require_statusCreateRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/statusDetails.js
var require_statusDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/statusLayoutUpdate.js
var require_statusLayoutUpdate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/statusMapping.js
var require_statusMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/statusMappingDTO.js
var require_statusMappingDTO = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/statusMigration.js
var require_statusMigration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/statusReferenceAndPort.js
var require_statusReferenceAndPort = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/statusScope.js
var require_statusScope = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/statusUpdate.js
var require_statusUpdate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/statusUpdateRequest.js
var require_statusUpdateRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/suggestedIssue.js
var require_suggestedIssue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/systemAvatars.js
var require_systemAvatars = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/tabMetadata.js
var require_tabMetadata = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/taskProgressObject.js
var require_taskProgressObject = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/timeTrackingConfiguration.js
var require_timeTrackingConfiguration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/timeTrackingDetails.js
var require_timeTrackingDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/timeTrackingProvider.js
var require_timeTrackingProvider = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/transition.js
var require_transition = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/transitions.js
var require_transitions = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/transitionScreenDetails.js
var require_transitionScreenDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/transitionUpdateDTO.js
var require_transitionUpdateDTO = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/uiModificationContextDetails.js
var require_uiModificationContextDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/uiModificationDetails.js
var require_uiModificationDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/uiModificationIdentifiers.js
var require_uiModificationIdentifiers = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/unrestrictedUserEmail.js
var require_unrestrictedUserEmail = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/updateCustomFieldDetails.js
var require_updateCustomFieldDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/updatedProjectCategory.js
var require_updatedProjectCategory = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/updateFieldConfigurationSchemeDetails.js
var require_updateFieldConfigurationSchemeDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/updateIssueSecurityLevelDetails.js
var require_updateIssueSecurityLevelDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/updateIssueSecuritySchemeRequest.js
var require_updateIssueSecuritySchemeRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/updateNotificationSchemeDetails.js
var require_updateNotificationSchemeDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/updatePriorityDetails.js
var require_updatePriorityDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/updateProjectDetails.js
var require_updateProjectDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/updateResolutionDetails.js
var require_updateResolutionDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/updateScreenDetails.js
var require_updateScreenDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/updateScreenSchemeDetails.js
var require_updateScreenSchemeDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/updateScreenTypes.js
var require_updateScreenTypes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/updateUiModificationDetails.js
var require_updateUiModificationDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/updateUserToGroup.js
var require_updateUserToGroup = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/user.js
var require_user2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/userAvatarUrls.js
var require_userAvatarUrls = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/userDetails.js
var require_userDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/userKey.js
var require_userKey = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/userList.js
var require_userList = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/userMigration.js
var require_userMigration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/userPickerUser.js
var require_userPickerUser = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/validationOptionsForCreate.js
var require_validationOptionsForCreate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/validationOptionsForUpdate.js
var require_validationOptionsForUpdate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/version.js
var require_version2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/versionIssueCounts.js
var require_versionIssueCounts = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/versionIssuesStatus.js
var require_versionIssuesStatus = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/versionMove.js
var require_versionMove = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/versionUnresolvedIssuesCount.js
var require_versionUnresolvedIssuesCount = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/versionUsageInCustomField.js
var require_versionUsageInCustomField = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/visibility.js
var require_visibility = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/votes.js
var require_votes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/warningCollection.js
var require_warningCollection = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/watchers.js
var require_watchers = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/webhook.js
var require_webhook = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/webhookDetails.js
var require_webhookDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/webhookRegistrationDetails.js
var require_webhookRegistrationDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/webhooksExpirationDate.js
var require_webhooksExpirationDate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflow.js
var require_workflow = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowCapabilities.js
var require_workflowCapabilities = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowCondition.js
var require_workflowCondition = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowCreate.js
var require_workflowCreate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowCreateRequest.js
var require_workflowCreateRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowCreateResponse.js
var require_workflowCreateResponse = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowElementReference.js
var require_workflowElementReference = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowId.js
var require_workflowId = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowLayout.js
var require_workflowLayout = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowOperations.js
var require_workflowOperations = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowRead.js
var require_workflowRead = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowReferenceStatus.js
var require_workflowReferenceStatus = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowRuleConfiguration.js
var require_workflowRuleConfiguration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowRules.js
var require_workflowRules = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowRulesSearch.js
var require_workflowRulesSearch = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowRulesSearchDetails.js
var require_workflowRulesSearchDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowScheme.js
var require_workflowScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowSchemeAssociations.js
var require_workflowSchemeAssociations = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowSchemeIdName.js
var require_workflowSchemeIdName = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowSchemeProjectAssociation.js
var require_workflowSchemeProjectAssociation = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowScope.js
var require_workflowScope = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowStatus.js
var require_workflowStatus = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowStatusAndPort.js
var require_workflowStatusAndPort = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowStatusLayout.js
var require_workflowStatusLayout = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowStatusProperties.js
var require_workflowStatusProperties = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowStatusUpdate.js
var require_workflowStatusUpdate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowsWithTransitionRulesDetails.js
var require_workflowsWithTransitionRulesDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowTransition.js
var require_workflowTransition = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowTransitionProperty.js
var require_workflowTransitionProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowTransitionRule.js
var require_workflowTransitionRule = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowTransitionRules.js
var require_workflowTransitionRules2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowTransitionRulesDetails.js
var require_workflowTransitionRulesDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowTransitionRulesUpdate.js
var require_workflowTransitionRulesUpdate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowTransitionRulesUpdateErrorDetails.js
var require_workflowTransitionRulesUpdateErrorDetails = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowTransitionRulesUpdateErrors.js
var require_workflowTransitionRulesUpdateErrors = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowTransitions.js
var require_workflowTransitions = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowTrigger.js
var require_workflowTrigger = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowUpdate.js
var require_workflowUpdate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowUpdateRequest.js
var require_workflowUpdateRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowUpdateResponse.js
var require_workflowUpdateResponse = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowValidationError.js
var require_workflowValidationError = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/workflowValidationErrorList.js
var require_workflowValidationErrorList = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/worklog.js
var require_worklog = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/worklogIdsRequest.js
var require_worklogIdsRequest = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/models/index.js
var require_models2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  var tslib_1 = require_tslib();
  tslib_1.__exportStar(require_actorInput(), exports);
  tslib_1.__exportStar(require_actorsMap(), exports);
  tslib_1.__exportStar(require_addField(), exports);
  tslib_1.__exportStar(require_addGroup(), exports);
  tslib_1.__exportStar(require_addSecuritySchemeLevelsRequest(), exports);
  tslib_1.__exportStar(require_announcementBannerConfiguration(), exports);
  tslib_1.__exportStar(require_announcementBannerConfigurationUpdate(), exports);
  tslib_1.__exportStar(require_application(), exports);
  tslib_1.__exportStar(require_applicationProperty(), exports);
  tslib_1.__exportStar(require_applicationRole(), exports);
  tslib_1.__exportStar(require_associatedItem(), exports);
  tslib_1.__exportStar(require_associateFieldConfigurationsWithIssueTypesRequest(), exports);
  tslib_1.__exportStar(require_attachment(), exports);
  tslib_1.__exportStar(require_attachmentArchiveEntry(), exports);
  tslib_1.__exportStar(require_attachmentArchiveImpl(), exports);
  tslib_1.__exportStar(require_attachmentArchiveItemReadable(), exports);
  tslib_1.__exportStar(require_attachmentArchiveMetadataReadable(), exports);
  tslib_1.__exportStar(require_attachmentMetadata(), exports);
  tslib_1.__exportStar(require_attachmentSettings(), exports);
  tslib_1.__exportStar(require_auditRecord(), exports);
  tslib_1.__exportStar(require_auditRecords2(), exports);
  tslib_1.__exportStar(require_autoCompleteSuggestion(), exports);
  tslib_1.__exportStar(require_autoCompleteSuggestions(), exports);
  tslib_1.__exportStar(require_availableDashboardGadget(), exports);
  tslib_1.__exportStar(require_availableDashboardGadgetsResponse(), exports);
  tslib_1.__exportStar(require_availableWorkflowConnectRule(), exports);
  tslib_1.__exportStar(require_availableWorkflowForgeRule(), exports);
  tslib_1.__exportStar(require_availableWorkflowSystemRule(), exports);
  tslib_1.__exportStar(require_availableWorkflowTriggers(), exports);
  tslib_1.__exportStar(require_availableWorkflowTriggerTypes(), exports);
  tslib_1.__exportStar(require_avatar(), exports);
  tslib_1.__exportStar(require_avatars2(), exports);
  tslib_1.__exportStar(require_avatarUrls2(), exports);
  tslib_1.__exportStar(require_avatarWithDetails(), exports);
  tslib_1.__exportStar(require_bulkChangeOwnerDetails(), exports);
  tslib_1.__exportStar(require_bulkCustomFieldOptionCreateRequest(), exports);
  tslib_1.__exportStar(require_bulkCustomFieldOptionUpdateRequest(), exports);
  tslib_1.__exportStar(require_bulkEditShareableEntity(), exports);
  tslib_1.__exportStar(require_bulkIssueIsWatching(), exports);
  tslib_1.__exportStar(require_bulkIssuePropertyUpdateRequest(), exports);
  tslib_1.__exportStar(require_bulkOperationErrorResult(), exports);
  tslib_1.__exportStar(require_bulkPermissionGrants(), exports);
  tslib_1.__exportStar(require_bulkPermissionsRequest(), exports);
  tslib_1.__exportStar(require_bulkProjectPermissionGrants(), exports);
  tslib_1.__exportStar(require_bulkProjectPermissions(), exports);
  tslib_1.__exportStar(require_changeDetails(), exports);
  tslib_1.__exportStar(require_changedValue(), exports);
  tslib_1.__exportStar(require_changedWorklog(), exports);
  tslib_1.__exportStar(require_changedWorklogs(), exports);
  tslib_1.__exportStar(require_changelog(), exports);
  tslib_1.__exportStar(require_columnItem(), exports);
  tslib_1.__exportStar(require_comment(), exports);
  tslib_1.__exportStar(require_componentIssuesCount(), exports);
  tslib_1.__exportStar(require_componentWithIssueCount(), exports);
  tslib_1.__exportStar(require_conditionGroupConfiguration(), exports);
  tslib_1.__exportStar(require_conditionGroupUpdate(), exports);
  tslib_1.__exportStar(require_configuration(), exports);
  tslib_1.__exportStar(require_connectCustomFieldValue(), exports);
  tslib_1.__exportStar(require_connectCustomFieldValues(), exports);
  tslib_1.__exportStar(require_connectModule(), exports);
  tslib_1.__exportStar(require_connectModules(), exports);
  tslib_1.__exportStar(require_connectWorkflowTransitionRule(), exports);
  tslib_1.__exportStar(require_containerForProjectFeatures(), exports);
  tslib_1.__exportStar(require_containerForRegisteredWebhooks(), exports);
  tslib_1.__exportStar(require_containerForWebhookIDs(), exports);
  tslib_1.__exportStar(require_containerOfWorkflowSchemeAssociations(), exports);
  tslib_1.__exportStar(require_contextForProjectAndIssueType(), exports);
  tslib_1.__exportStar(require_contextualConfiguration(), exports);
  tslib_1.__exportStar(require_convertedJQLQueries(), exports);
  tslib_1.__exportStar(require_createCustomFieldContext(), exports);
  tslib_1.__exportStar(require_createdIssue(), exports);
  tslib_1.__exportStar(require_createdIssues(), exports);
  tslib_1.__exportStar(require_createIssueSecuritySchemeDetails(), exports);
  tslib_1.__exportStar(require_createNotificationSchemeDetails(), exports);
  tslib_1.__exportStar(require_createPriorityDetails(), exports);
  tslib_1.__exportStar(require_createProjectDetails(), exports);
  tslib_1.__exportStar(require_createResolutionDetails(), exports);
  tslib_1.__exportStar(require_createUiModificationDetails(), exports);
  tslib_1.__exportStar(require_createUpdateRoleRequest(), exports);
  tslib_1.__exportStar(require_createWorkflowCondition(), exports);
  tslib_1.__exportStar(require_createWorkflowDetails(), exports);
  tslib_1.__exportStar(require_createWorkflowStatusDetails(), exports);
  tslib_1.__exportStar(require_createWorkflowTransitionDetails(), exports);
  tslib_1.__exportStar(require_createWorkflowTransitionRule(), exports);
  tslib_1.__exportStar(require_createWorkflowTransitionRulesDetails(), exports);
  tslib_1.__exportStar(require_createWorkflowTransitionScreenDetails(), exports);
  tslib_1.__exportStar(require_customContextVariable(), exports);
  tslib_1.__exportStar(require_customFieldConfigurations(), exports);
  tslib_1.__exportStar(require_customFieldContext(), exports);
  tslib_1.__exportStar(require_customFieldContextDefaultValue(), exports);
  tslib_1.__exportStar(require_customFieldContextDefaultValueUpdate(), exports);
  tslib_1.__exportStar(require_customFieldContextOption(), exports);
  tslib_1.__exportStar(require_customFieldContextProjectMapping(), exports);
  tslib_1.__exportStar(require_customFieldContextUpdateDetails(), exports);
  tslib_1.__exportStar(require_customFieldCreatedContextOptionsList(), exports);
  tslib_1.__exportStar(require_customFieldDefinitionJson(), exports);
  tslib_1.__exportStar(require_customFieldOption(), exports);
  tslib_1.__exportStar(require_customFieldOptionCreate(), exports);
  tslib_1.__exportStar(require_customFieldOptionUpdate(), exports);
  tslib_1.__exportStar(require_customFieldReplacement(), exports);
  tslib_1.__exportStar(require_customFieldUpdatedContextOptionsList(), exports);
  tslib_1.__exportStar(require_customFieldValueUpdate(), exports);
  tslib_1.__exportStar(require_customFieldValueUpdateDetails(), exports);
  tslib_1.__exportStar(require_dashboard(), exports);
  tslib_1.__exportStar(require_dashboardDetails(), exports);
  tslib_1.__exportStar(require_dashboardGadget(), exports);
  tslib_1.__exportStar(require_dashboardGadgetPosition(), exports);
  tslib_1.__exportStar(require_dashboardGadgetResponse(), exports);
  tslib_1.__exportStar(require_dashboardGadgetSettings(), exports);
  tslib_1.__exportStar(require_dashboardGadgetUpdateRequest(), exports);
  tslib_1.__exportStar(require_dashboardUser(), exports);
  tslib_1.__exportStar(require_dateRangeFilter(), exports);
  tslib_1.__exportStar(require_defaultLevelValue(), exports);
  tslib_1.__exportStar(require_defaultShareScope(), exports);
  tslib_1.__exportStar(require_defaultWorkflow(), exports);
  tslib_1.__exportStar(require_documentVersion(), exports);
  tslib_1.__exportStar(require_entityProperty(), exports);
  tslib_1.__exportStar(require_entityPropertyDetails(), exports);
  tslib_1.__exportStar(require_error(), exports);
  tslib_1.__exportStar(require_errorCollection(), exports);
  tslib_1.__exportStar(require_errors(), exports);
  tslib_1.__exportStar(require_eventNotification(), exports);
  tslib_1.__exportStar(require_exportArchivedIssuesTaskProgress(), exports);
  tslib_1.__exportStar(require_failedWebhook(), exports);
  tslib_1.__exportStar(require_failedWebhooks(), exports);
  tslib_1.__exportStar(require_field(), exports);
  tslib_1.__exportStar(require_fieldConfiguration(), exports);
  tslib_1.__exportStar(require_fieldConfigurationDetails(), exports);
  tslib_1.__exportStar(require_fieldConfigurationIssueTypeItem(), exports);
  tslib_1.__exportStar(require_fieldConfigurationItem(), exports);
  tslib_1.__exportStar(require_fieldConfigurationItemsDetails(), exports);
  tslib_1.__exportStar(require_fieldConfigurationScheme(), exports);
  tslib_1.__exportStar(require_fieldConfigurationSchemeProjectAssociation(), exports);
  tslib_1.__exportStar(require_fieldConfigurationSchemeProjects(), exports);
  tslib_1.__exportStar(require_fieldConfigurationToIssueTypeMapping(), exports);
  tslib_1.__exportStar(require_fieldDetails(), exports);
  tslib_1.__exportStar(require_fieldLastUsed(), exports);
  tslib_1.__exportStar(require_fieldMetadata(), exports);
  tslib_1.__exportStar(require_fieldReferenceData(), exports);
  tslib_1.__exportStar(require_fields2(), exports);
  tslib_1.__exportStar(require_filter(), exports);
  tslib_1.__exportStar(require_filterDetails(), exports);
  tslib_1.__exportStar(require_filterSubscription(), exports);
  tslib_1.__exportStar(require_filterSubscriptionsList(), exports);
  tslib_1.__exportStar(require_fixVersion2(), exports);
  tslib_1.__exportStar(require_foundGroup(), exports);
  tslib_1.__exportStar(require_foundGroups(), exports);
  tslib_1.__exportStar(require_foundUsers(), exports);
  tslib_1.__exportStar(require_foundUsersAndGroups(), exports);
  tslib_1.__exportStar(require_functionReferenceData(), exports);
  tslib_1.__exportStar(require_globalScope(), exports);
  tslib_1.__exportStar(require_group2(), exports);
  tslib_1.__exportStar(require_groupDetails(), exports);
  tslib_1.__exportStar(require_groupLabel(), exports);
  tslib_1.__exportStar(require_groupName(), exports);
  tslib_1.__exportStar(require_hierarchy(), exports);
  tslib_1.__exportStar(require_hierarchyLevel(), exports);
  tslib_1.__exportStar(require_historyMetadata(), exports);
  tslib_1.__exportStar(require_historyMetadataParticipant(), exports);
  tslib_1.__exportStar(require_icon(), exports);
  tslib_1.__exportStar(require_id(), exports);
  tslib_1.__exportStar(require_idOrKey(), exports);
  tslib_1.__exportStar(require_includedFields(), exports);
  tslib_1.__exportStar(require_issue3(), exports);
  tslib_1.__exportStar(require_issueArchivalSync(), exports);
  tslib_1.__exportStar(require_issueChangelogIds(), exports);
  tslib_1.__exportStar(require_issueCommentListRequest(), exports);
  tslib_1.__exportStar(require_issueCreateMetadata(), exports);
  tslib_1.__exportStar(require_issueEntityProperties(), exports);
  tslib_1.__exportStar(require_issueEntityPropertiesForMultiUpdate(), exports);
  tslib_1.__exportStar(require_issueEvent(), exports);
  tslib_1.__exportStar(require_issueFieldOption(), exports);
  tslib_1.__exportStar(require_issueFieldOptionConfiguration(), exports);
  tslib_1.__exportStar(require_issueFieldOptionCreate(), exports);
  tslib_1.__exportStar(require_issueFieldOptionScope(), exports);
  tslib_1.__exportStar(require_issueFilterForBulkPropertyDelete(), exports);
  tslib_1.__exportStar(require_issueFilterForBulkPropertySet(), exports);
  tslib_1.__exportStar(require_issueLink(), exports);
  tslib_1.__exportStar(require_issueLinkType(), exports);
  tslib_1.__exportStar(require_issueLinkTypes2(), exports);
  tslib_1.__exportStar(require_issueList(), exports);
  tslib_1.__exportStar(require_issueMatches(), exports);
  tslib_1.__exportStar(require_issueMatchesForJQL(), exports);
  tslib_1.__exportStar(require_issuePickerSuggestions(), exports);
  tslib_1.__exportStar(require_issuePickerSuggestionsIssueType(), exports);
  tslib_1.__exportStar(require_issuesAndJQLQueries(), exports);
  tslib_1.__exportStar(require_issueSecurityLevelMember(), exports);
  tslib_1.__exportStar(require_issueSecuritySchemeToProjectMapping(), exports);
  tslib_1.__exportStar(require_issuesJqlMetaData(), exports);
  tslib_1.__exportStar(require_issuesMeta(), exports);
  tslib_1.__exportStar(require_issuesUpdate(), exports);
  tslib_1.__exportStar(require_issueTransition2(), exports);
  tslib_1.__exportStar(require_issueTypeCreate(), exports);
  tslib_1.__exportStar(require_issueTypeDetails(), exports);
  tslib_1.__exportStar(require_issueTypeIds(), exports);
  tslib_1.__exportStar(require_issueTypeIdsToRemove(), exports);
  tslib_1.__exportStar(require_issueTypeInfo(), exports);
  tslib_1.__exportStar(require_issueTypeIssueCreateMetadata(), exports);
  tslib_1.__exportStar(require_issueTypeScheme(), exports);
  tslib_1.__exportStar(require_issueTypeSchemeDetails(), exports);
  tslib_1.__exportStar(require_issueTypeSchemeID(), exports);
  tslib_1.__exportStar(require_issueTypeSchemeMapping(), exports);
  tslib_1.__exportStar(require_issueTypeSchemeProjectAssociation(), exports);
  tslib_1.__exportStar(require_issueTypeSchemeProjects(), exports);
  tslib_1.__exportStar(require_issueTypeSchemeUpdateDetails(), exports);
  tslib_1.__exportStar(require_issueTypeScreenScheme(), exports);
  tslib_1.__exportStar(require_issueTypeScreenSchemeDetails(), exports);
  tslib_1.__exportStar(require_issueTypeScreenSchemeId(), exports);
  tslib_1.__exportStar(require_issueTypeScreenSchemeItem(), exports);
  tslib_1.__exportStar(require_issueTypeScreenSchemeMapping(), exports);
  tslib_1.__exportStar(require_issueTypeScreenSchemeMappingDetails(), exports);
  tslib_1.__exportStar(require_issueTypeScreenSchemeProjectAssociation(), exports);
  tslib_1.__exportStar(require_issueTypeScreenSchemesProjects(), exports);
  tslib_1.__exportStar(require_issueTypeScreenSchemeUpdateDetails(), exports);
  tslib_1.__exportStar(require_issueTypesWorkflowMapping(), exports);
  tslib_1.__exportStar(require_issueTypeToContextMapping(), exports);
  tslib_1.__exportStar(require_issueTypeUpdate(), exports);
  tslib_1.__exportStar(require_issueTypeWithStatus(), exports);
  tslib_1.__exportStar(require_issueTypeWorkflowMapping(), exports);
  tslib_1.__exportStar(require_issueUpdateDetails(), exports);
  tslib_1.__exportStar(require_issueUpdateMetadata(), exports);
  tslib_1.__exportStar(require_jexpIssues(), exports);
  tslib_1.__exportStar(require_jexpJqlIssues(), exports);
  tslib_1.__exportStar(require_jiraExpressionAnalysis(), exports);
  tslib_1.__exportStar(require_jiraExpressionComplexity(), exports);
  tslib_1.__exportStar(require_jiraExpressionEvalContext(), exports);
  tslib_1.__exportStar(require_jiraExpressionEvalRequest(), exports);
  tslib_1.__exportStar(require_jiraExpressionEvaluationMetaData(), exports);
  tslib_1.__exportStar(require_jiraExpressionForAnalysis(), exports);
  tslib_1.__exportStar(require_jiraExpressionResult(), exports);
  tslib_1.__exportStar(require_jiraExpressionsAnalysis(), exports);
  tslib_1.__exportStar(require_jiraExpressionsComplexity(), exports);
  tslib_1.__exportStar(require_jiraExpressionsComplexityValue(), exports);
  tslib_1.__exportStar(require_jiraExpressionValidationError(), exports);
  tslib_1.__exportStar(require_jiraStatus(), exports);
  tslib_1.__exportStar(require_jiraWorkflow(), exports);
  tslib_1.__exportStar(require_jiraWorkflowStatus(), exports);
  tslib_1.__exportStar(require_jqlFunctionPrecomputation(), exports);
  tslib_1.__exportStar(require_jqlFunctionPrecomputationUpdate(), exports);
  tslib_1.__exportStar(require_jqlFunctionPrecomputationUpdateRequest(), exports);
  tslib_1.__exportStar(require_jQLPersonalDataMigrationRequest(), exports);
  tslib_1.__exportStar(require_jqlQueriesToParse(), exports);
  tslib_1.__exportStar(require_jqlQueriesToSanitize(), exports);
  tslib_1.__exportStar(require_jqlQuery(), exports);
  tslib_1.__exportStar(require_jqlQueryClause(), exports);
  tslib_1.__exportStar(require_jqlQueryField(), exports);
  tslib_1.__exportStar(require_jqlQueryFieldEntityProperty(), exports);
  tslib_1.__exportStar(require_jqlQueryOrderByClause(), exports);
  tslib_1.__exportStar(require_jqlQueryOrderByClauseElement(), exports);
  tslib_1.__exportStar(require_jqlQueryToSanitize(), exports);
  tslib_1.__exportStar(require_jQLQueryWithUnknownUsers(), exports);
  tslib_1.__exportStar(require_jQLReferenceData(), exports);
  tslib_1.__exportStar(require_jsonType2(), exports);
  tslib_1.__exportStar(require_license(), exports);
  tslib_1.__exportStar(require_licensedApplication(), exports);
  tslib_1.__exportStar(require_licenseMetric(), exports);
  tslib_1.__exportStar(require_linkedIssue(), exports);
  tslib_1.__exportStar(require_linkGroup2(), exports);
  tslib_1.__exportStar(require_linkIssueRequestJson(), exports);
  tslib_1.__exportStar(require_listWrapperCallbackApplicationRole(), exports);
  tslib_1.__exportStar(require_listWrapperCallbackGroupName(), exports);
  tslib_1.__exportStar(require_locale(), exports);
  tslib_1.__exportStar(require_moveField(), exports);
  tslib_1.__exportStar(require_multiIssueEntityProperties(), exports);
  tslib_1.__exportStar(require_multipleCustomFieldValuesUpdate(), exports);
  tslib_1.__exportStar(require_multipleCustomFieldValuesUpdateDetails(), exports);
  tslib_1.__exportStar(require_nestedResponse(), exports);
  tslib_1.__exportStar(require_newUserDetails(), exports);
  tslib_1.__exportStar(require_notification(), exports);
  tslib_1.__exportStar(require_notificationEvent(), exports);
  tslib_1.__exportStar(require_notificationRecipients(), exports);
  tslib_1.__exportStar(require_notificationRecipientsRestrictions(), exports);
  tslib_1.__exportStar(require_notificationScheme(), exports);
  tslib_1.__exportStar(require_notificationSchemeAndProjectMapping(), exports);
  tslib_1.__exportStar(require_notificationSchemeAndProjectMappingPage(), exports);
  tslib_1.__exportStar(require_notificationSchemeEvent(), exports);
  tslib_1.__exportStar(require_notificationSchemeEventDetails(), exports);
  tslib_1.__exportStar(require_notificationSchemeEventTypeId(), exports);
  tslib_1.__exportStar(require_notificationSchemeId(), exports);
  tslib_1.__exportStar(require_notificationSchemeNotificationDetails(), exports);
  tslib_1.__exportStar(require_oldToNewSecurityLevelMappings(), exports);
  tslib_1.__exportStar(require_operationMessage(), exports);
  tslib_1.__exportStar(require_operations2(), exports);
  tslib_1.__exportStar(require_orderOfCustomFieldOptions(), exports);
  tslib_1.__exportStar(require_orderOfIssueTypes(), exports);
  tslib_1.__exportStar(require_pageChangelog(), exports);
  tslib_1.__exportStar(require_pageComment(), exports);
  tslib_1.__exportStar(require_pageComponentWithIssueCount(), exports);
  tslib_1.__exportStar(require_pageContextForProjectAndIssueType(), exports);
  tslib_1.__exportStar(require_pageContextualConfiguration(), exports);
  tslib_1.__exportStar(require_pageCustomFieldContext(), exports);
  tslib_1.__exportStar(require_pageCustomFieldContextDefaultValue(), exports);
  tslib_1.__exportStar(require_pageCustomFieldContextOption(), exports);
  tslib_1.__exportStar(require_pageCustomFieldContextProjectMapping(), exports);
  tslib_1.__exportStar(require_pageDashboard(), exports);
  tslib_1.__exportStar(require_pagedListUserDetailsApplicationUser(), exports);
  tslib_1.__exportStar(require_pageField(), exports);
  tslib_1.__exportStar(require_pageFieldConfiguration(), exports);
  tslib_1.__exportStar(require_pageFieldConfigurationIssueTypeItem(), exports);
  tslib_1.__exportStar(require_pageFieldConfigurationItem(), exports);
  tslib_1.__exportStar(require_pageFieldConfigurationScheme(), exports);
  tslib_1.__exportStar(require_pageFieldConfigurationSchemeProjects(), exports);
  tslib_1.__exportStar(require_pageFilterDetails(), exports);
  tslib_1.__exportStar(require_pageGroupDetails(), exports);
  tslib_1.__exportStar(require_pageIssueFieldOption(), exports);
  tslib_1.__exportStar(require_pageIssueSecurityLevelMember(), exports);
  tslib_1.__exportStar(require_pageIssueSecuritySchemeToProjectMapping(), exports);
  tslib_1.__exportStar(require_pageIssueTypeScheme(), exports);
  tslib_1.__exportStar(require_pageIssueTypeSchemeMapping(), exports);
  tslib_1.__exportStar(require_pageIssueTypeSchemeProjects(), exports);
  tslib_1.__exportStar(require_pageIssueTypeScreenScheme(), exports);
  tslib_1.__exportStar(require_pageIssueTypeScreenSchemeItem(), exports);
  tslib_1.__exportStar(require_pageIssueTypeScreenSchemesProjects(), exports);
  tslib_1.__exportStar(require_pageIssueTypeToContextMapping(), exports);
  tslib_1.__exportStar(require_pageJqlFunctionPrecomputation(), exports);
  tslib_1.__exportStar(require_pageNotificationScheme(), exports);
  tslib_1.__exportStar(require_pageOfChangelogs(), exports);
  tslib_1.__exportStar(require_pageOfComments(), exports);
  tslib_1.__exportStar(require_pageOfDashboards(), exports);
  tslib_1.__exportStar(require_pageOfStatuses(), exports);
  tslib_1.__exportStar(require_pageOfWorklogs(), exports);
  tslib_1.__exportStar(require_pagePriority(), exports);
  tslib_1.__exportStar(require_pageProject(), exports);
  tslib_1.__exportStar(require_pageProjectDetails(), exports);
  tslib_1.__exportStar(require_pageResolution(), exports);
  tslib_1.__exportStar(require_pageScreen(), exports);
  tslib_1.__exportStar(require_pageScreenScheme(), exports);
  tslib_1.__exportStar(require_pageScreenWithTab(), exports);
  tslib_1.__exportStar(require_pageSecurityLevel(), exports);
  tslib_1.__exportStar(require_pageSecurityLevelMember(), exports);
  tslib_1.__exportStar(require_pageSecuritySchemeWithProjects(), exports);
  tslib_1.__exportStar(require_pageString(), exports);
  tslib_1.__exportStar(require_pageUiModificationDetails(), exports);
  tslib_1.__exportStar(require_pageUser(), exports);
  tslib_1.__exportStar(require_pageUserDetails(), exports);
  tslib_1.__exportStar(require_pageUserKey(), exports);
  tslib_1.__exportStar(require_pageVersion(), exports);
  tslib_1.__exportStar(require_pageWebhook(), exports);
  tslib_1.__exportStar(require_pageWorkflow(), exports);
  tslib_1.__exportStar(require_pageWorkflowScheme(), exports);
  tslib_1.__exportStar(require_pageWorkflowTransitionRules(), exports);
  tslib_1.__exportStar(require_parsedJqlQueries(), exports);
  tslib_1.__exportStar(require_parsedJqlQuery(), exports);
  tslib_1.__exportStar(require_permissionDetails(), exports);
  tslib_1.__exportStar(require_permissionGrant(), exports);
  tslib_1.__exportStar(require_permissionGrants(), exports);
  tslib_1.__exportStar(require_permissionHolder(), exports);
  tslib_1.__exportStar(require_permissions2(), exports);
  tslib_1.__exportStar(require_permissionScheme(), exports);
  tslib_1.__exportStar(require_permissionSchemes2(), exports);
  tslib_1.__exportStar(require_permissionsKeys(), exports);
  tslib_1.__exportStar(require_permittedProjects(), exports);
  tslib_1.__exportStar(require_priority(), exports);
  tslib_1.__exportStar(require_priorityId(), exports);
  tslib_1.__exportStar(require_project2(), exports);
  tslib_1.__exportStar(require_projectAndIssueTypePair(), exports);
  tslib_1.__exportStar(require_projectAvatars2(), exports);
  tslib_1.__exportStar(require_projectCategory(), exports);
  tslib_1.__exportStar(require_projectComponent(), exports);
  tslib_1.__exportStar(require_projectDetails(), exports);
  tslib_1.__exportStar(require_projectEmailAddress(), exports);
  tslib_1.__exportStar(require_projectFeature(), exports);
  tslib_1.__exportStar(require_projectFeatureToggleRequest(), exports);
  tslib_1.__exportStar(require_projectId(), exports);
  tslib_1.__exportStar(require_projectIdentifier(), exports);
  tslib_1.__exportStar(require_projectIdentifiers(), exports);
  tslib_1.__exportStar(require_projectIds(), exports);
  tslib_1.__exportStar(require_projectInsight(), exports);
  tslib_1.__exportStar(require_projectIssueCreateMetadata(), exports);
  tslib_1.__exportStar(require_projectIssueSecurityLevels(), exports);
  tslib_1.__exportStar(require_projectIssueTypeHierarchy(), exports);
  tslib_1.__exportStar(require_projectIssueTypeMapping(), exports);
  tslib_1.__exportStar(require_projectIssueTypeMappings(), exports);
  tslib_1.__exportStar(require_projectIssueTypes(), exports);
  tslib_1.__exportStar(require_projectIssueTypesHierarchyLevel(), exports);
  tslib_1.__exportStar(require_projectLandingPageInfo(), exports);
  tslib_1.__exportStar(require_projectPermissions(), exports);
  tslib_1.__exportStar(require_projectRole(), exports);
  tslib_1.__exportStar(require_projectRoleActorsUpdate(), exports);
  tslib_1.__exportStar(require_projectRoleDetails(), exports);
  tslib_1.__exportStar(require_projectRoleGroup(), exports);
  tslib_1.__exportStar(require_projectRoleUser(), exports);
  tslib_1.__exportStar(require_projectScope(), exports);
  tslib_1.__exportStar(require_projectType(), exports);
  tslib_1.__exportStar(require_propertyKey(), exports);
  tslib_1.__exportStar(require_propertyKeys(), exports);
  tslib_1.__exportStar(require_publishedWorkflowId(), exports);
  tslib_1.__exportStar(require_registeredWebhook(), exports);
  tslib_1.__exportStar(require_remoteIssueLink(), exports);
  tslib_1.__exportStar(require_remoteIssueLinkIdentifies(), exports);
  tslib_1.__exportStar(require_remoteIssueLinkRequest(), exports);
  tslib_1.__exportStar(require_remoteObject(), exports);
  tslib_1.__exportStar(require_reorderIssuePriorities(), exports);
  tslib_1.__exportStar(require_reorderIssueResolutionsRequest(), exports);
  tslib_1.__exportStar(require_resolution(), exports);
  tslib_1.__exportStar(require_resolutionId(), exports);
  tslib_1.__exportStar(require_restrictedPermission(), exports);
  tslib_1.__exportStar(require_richText(), exports);
  tslib_1.__exportStar(require_roleActor(), exports);
  tslib_1.__exportStar(require_ruleConfiguration(), exports);
  tslib_1.__exportStar(require_sanitizedJqlQueries(), exports);
  tslib_1.__exportStar(require_sanitizedJqlQuery(), exports);
  tslib_1.__exportStar(require_scope(), exports);
  tslib_1.__exportStar(require_screen(), exports);
  tslib_1.__exportStar(require_screenableField(), exports);
  tslib_1.__exportStar(require_screenableTab(), exports);
  tslib_1.__exportStar(require_screenDetails(), exports);
  tslib_1.__exportStar(require_screenScheme(), exports);
  tslib_1.__exportStar(require_screenSchemeDetails(), exports);
  tslib_1.__exportStar(require_screenSchemeId(), exports);
  tslib_1.__exportStar(require_screenTypes(), exports);
  tslib_1.__exportStar(require_screenWithTab(), exports);
  tslib_1.__exportStar(require_searchAutoComplete(), exports);
  tslib_1.__exportStar(require_searchRequest(), exports);
  tslib_1.__exportStar(require_searchResults2(), exports);
  tslib_1.__exportStar(require_securityLevel(), exports);
  tslib_1.__exportStar(require_securityLevelMember(), exports);
  tslib_1.__exportStar(require_securityScheme(), exports);
  tslib_1.__exportStar(require_securitySchemeId(), exports);
  tslib_1.__exportStar(require_securitySchemeLevel(), exports);
  tslib_1.__exportStar(require_securitySchemeLevelMember(), exports);
  tslib_1.__exportStar(require_securitySchemeMembersRequest(), exports);
  tslib_1.__exportStar(require_securitySchemes(), exports);
  tslib_1.__exportStar(require_securitySchemeWithProjects(), exports);
  tslib_1.__exportStar(require_serverInformation(), exports);
  tslib_1.__exportStar(require_setDefaultLevelsRequest(), exports);
  tslib_1.__exportStar(require_setDefaultPriorityRequest(), exports);
  tslib_1.__exportStar(require_setDefaultResolutionRequest(), exports);
  tslib_1.__exportStar(require_sharePermission(), exports);
  tslib_1.__exportStar(require_sharePermissionInput(), exports);
  tslib_1.__exportStar(require_simpleApplicationProperty(), exports);
  tslib_1.__exportStar(require_simpleLink(), exports);
  tslib_1.__exportStar(require_simpleListWrapperApplicationRole(), exports);
  tslib_1.__exportStar(require_simpleListWrapperGroupName(), exports);
  tslib_1.__exportStar(require_status3(), exports);
  tslib_1.__exportStar(require_statusCategory2(), exports);
  tslib_1.__exportStar(require_statusCreate(), exports);
  tslib_1.__exportStar(require_statusCreateRequest(), exports);
  tslib_1.__exportStar(require_statusDetails(), exports);
  tslib_1.__exportStar(require_statusLayoutUpdate(), exports);
  tslib_1.__exportStar(require_statusMapping(), exports);
  tslib_1.__exportStar(require_statusMappingDTO(), exports);
  tslib_1.__exportStar(require_statusMigration(), exports);
  tslib_1.__exportStar(require_statusReferenceAndPort(), exports);
  tslib_1.__exportStar(require_statusScope(), exports);
  tslib_1.__exportStar(require_statusUpdate(), exports);
  tslib_1.__exportStar(require_statusUpdateRequest(), exports);
  tslib_1.__exportStar(require_suggestedIssue(), exports);
  tslib_1.__exportStar(require_systemAvatars(), exports);
  tslib_1.__exportStar(require_tabMetadata(), exports);
  tslib_1.__exportStar(require_taskProgressObject(), exports);
  tslib_1.__exportStar(require_timeTrackingConfiguration(), exports);
  tslib_1.__exportStar(require_timeTrackingDetails(), exports);
  tslib_1.__exportStar(require_timeTrackingProvider(), exports);
  tslib_1.__exportStar(require_transition(), exports);
  tslib_1.__exportStar(require_transitions(), exports);
  tslib_1.__exportStar(require_transitionScreenDetails(), exports);
  tslib_1.__exportStar(require_transitionUpdateDTO(), exports);
  tslib_1.__exportStar(require_uiModificationContextDetails(), exports);
  tslib_1.__exportStar(require_uiModificationDetails(), exports);
  tslib_1.__exportStar(require_uiModificationIdentifiers(), exports);
  tslib_1.__exportStar(require_unrestrictedUserEmail(), exports);
  tslib_1.__exportStar(require_updateCustomFieldDetails(), exports);
  tslib_1.__exportStar(require_updatedProjectCategory(), exports);
  tslib_1.__exportStar(require_updateFieldConfigurationSchemeDetails(), exports);
  tslib_1.__exportStar(require_updateIssueSecurityLevelDetails(), exports);
  tslib_1.__exportStar(require_updateIssueSecuritySchemeRequest(), exports);
  tslib_1.__exportStar(require_updateNotificationSchemeDetails(), exports);
  tslib_1.__exportStar(require_updatePriorityDetails(), exports);
  tslib_1.__exportStar(require_updateProjectDetails(), exports);
  tslib_1.__exportStar(require_updateResolutionDetails(), exports);
  tslib_1.__exportStar(require_updateScreenDetails(), exports);
  tslib_1.__exportStar(require_updateScreenSchemeDetails(), exports);
  tslib_1.__exportStar(require_updateScreenTypes(), exports);
  tslib_1.__exportStar(require_updateUiModificationDetails(), exports);
  tslib_1.__exportStar(require_updateUserToGroup(), exports);
  tslib_1.__exportStar(require_user2(), exports);
  tslib_1.__exportStar(require_userAvatarUrls(), exports);
  tslib_1.__exportStar(require_userDetails(), exports);
  tslib_1.__exportStar(require_userKey(), exports);
  tslib_1.__exportStar(require_userList(), exports);
  tslib_1.__exportStar(require_userMigration(), exports);
  tslib_1.__exportStar(require_userPickerUser(), exports);
  tslib_1.__exportStar(require_validationOptionsForCreate(), exports);
  tslib_1.__exportStar(require_validationOptionsForUpdate(), exports);
  tslib_1.__exportStar(require_version2(), exports);
  tslib_1.__exportStar(require_versionIssueCounts(), exports);
  tslib_1.__exportStar(require_versionIssuesStatus(), exports);
  tslib_1.__exportStar(require_versionMove(), exports);
  tslib_1.__exportStar(require_versionUnresolvedIssuesCount(), exports);
  tslib_1.__exportStar(require_versionUsageInCustomField(), exports);
  tslib_1.__exportStar(require_visibility(), exports);
  tslib_1.__exportStar(require_votes(), exports);
  tslib_1.__exportStar(require_warningCollection(), exports);
  tslib_1.__exportStar(require_watchers(), exports);
  tslib_1.__exportStar(require_webhook(), exports);
  tslib_1.__exportStar(require_webhookDetails(), exports);
  tslib_1.__exportStar(require_webhookRegistrationDetails(), exports);
  tslib_1.__exportStar(require_webhooksExpirationDate(), exports);
  tslib_1.__exportStar(require_workflow(), exports);
  tslib_1.__exportStar(require_workflowCapabilities(), exports);
  tslib_1.__exportStar(require_workflowCondition(), exports);
  tslib_1.__exportStar(require_workflowCreate(), exports);
  tslib_1.__exportStar(require_workflowCreateRequest(), exports);
  tslib_1.__exportStar(require_workflowCreateResponse(), exports);
  tslib_1.__exportStar(require_workflowElementReference(), exports);
  tslib_1.__exportStar(require_workflowId(), exports);
  tslib_1.__exportStar(require_workflowLayout(), exports);
  tslib_1.__exportStar(require_workflowOperations(), exports);
  tslib_1.__exportStar(require_workflowRead(), exports);
  tslib_1.__exportStar(require_workflowReferenceStatus(), exports);
  tslib_1.__exportStar(require_workflowRuleConfiguration(), exports);
  tslib_1.__exportStar(require_workflowRules(), exports);
  tslib_1.__exportStar(require_workflowRulesSearch(), exports);
  tslib_1.__exportStar(require_workflowRulesSearchDetails(), exports);
  tslib_1.__exportStar(require_workflowScheme(), exports);
  tslib_1.__exportStar(require_workflowSchemeAssociations(), exports);
  tslib_1.__exportStar(require_workflowSchemeIdName(), exports);
  tslib_1.__exportStar(require_workflowSchemeProjectAssociation(), exports);
  tslib_1.__exportStar(require_workflowScope(), exports);
  tslib_1.__exportStar(require_workflowStatus(), exports);
  tslib_1.__exportStar(require_workflowStatusAndPort(), exports);
  tslib_1.__exportStar(require_workflowStatusLayout(), exports);
  tslib_1.__exportStar(require_workflowStatusProperties(), exports);
  tslib_1.__exportStar(require_workflowStatusUpdate(), exports);
  tslib_1.__exportStar(require_workflowsWithTransitionRulesDetails(), exports);
  tslib_1.__exportStar(require_workflowTransition(), exports);
  tslib_1.__exportStar(require_workflowTransitionProperty(), exports);
  tslib_1.__exportStar(require_workflowTransitionRule(), exports);
  tslib_1.__exportStar(require_workflowTransitionRules2(), exports);
  tslib_1.__exportStar(require_workflowTransitionRulesDetails(), exports);
  tslib_1.__exportStar(require_workflowTransitionRulesUpdate(), exports);
  tslib_1.__exportStar(require_workflowTransitionRulesUpdateErrorDetails(), exports);
  tslib_1.__exportStar(require_workflowTransitionRulesUpdateErrors(), exports);
  tslib_1.__exportStar(require_workflowTransitions(), exports);
  tslib_1.__exportStar(require_workflowTrigger(), exports);
  tslib_1.__exportStar(require_workflowUpdate(), exports);
  tslib_1.__exportStar(require_workflowUpdateRequest(), exports);
  tslib_1.__exportStar(require_workflowUpdateResponse(), exports);
  tslib_1.__exportStar(require_workflowValidationError(), exports);
  tslib_1.__exportStar(require_workflowValidationErrorList(), exports);
  tslib_1.__exportStar(require_worklog(), exports);
  tslib_1.__exportStar(require_worklogIdsRequest(), exports);
});

// node_modules/jira.js/out/version2/parameters/addActorUsers.js
var require_addActorUsers = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/addAttachment.js
var require_addAttachment = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/addComment.js
var require_addComment = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/addFieldToDefaultScreen.js
var require_addFieldToDefaultScreen = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/addGadget.js
var require_addGadget = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/addIssueTypesToContext.js
var require_addIssueTypesToContext = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/addIssueTypesToIssueTypeScheme.js
var require_addIssueTypesToIssueTypeScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/addProjectRoleActorsToRole.js
var require_addProjectRoleActorsToRole = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/addScreenTab.js
var require_addScreenTab = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/addScreenTabField.js
var require_addScreenTabField = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/addSecurityLevel.js
var require_addSecurityLevel = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/addSecurityLevelMembers.js
var require_addSecurityLevelMembers = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/addSharePermission.js
var require_addSharePermission = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/addUserToGroup.js
var require_addUserToGroup = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/addVote.js
var require_addVote = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/addWatcher.js
var require_addWatcher = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/addWorklog.js
var require_addWorklog = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/analyseExpression.js
var require_analyseExpression = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/appendMappingsForIssueTypeScreenScheme.js
var require_appendMappingsForIssueTypeScreenScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/archiveIssues.js
var require_archiveIssues = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/archiveIssuesAsync.js
var require_archiveIssuesAsync = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/archiveProject.js
var require_archiveProject = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/assignFieldConfigurationSchemeToProject.js
var require_assignFieldConfigurationSchemeToProject = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/assignIssue.js
var require_assignIssue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/assignIssueTypeSchemeToProject.js
var require_assignIssueTypeSchemeToProject = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/assignIssueTypeScreenSchemeToProject.js
var require_assignIssueTypeScreenSchemeToProject = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/assignPermissionScheme.js
var require_assignPermissionScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/assignProjectsToCustomFieldContext.js
var require_assignProjectsToCustomFieldContext = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/assignSchemeToProject.js
var require_assignSchemeToProject = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/associateSchemesToProjects.js
var require_associateSchemesToProjects = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/bulkDeleteIssueProperty.js
var require_bulkDeleteIssueProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/bulkEditDashboards.js
var require_bulkEditDashboards = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/bulkGetGroups.js
var require_bulkGetGroups = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/bulkGetUsers.js
var require_bulkGetUsers = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/bulkGetUsersMigration.js
var require_bulkGetUsersMigration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/bulkSetIssuePropertiesByIssue.js
var require_bulkSetIssuePropertiesByIssue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/bulkSetIssueProperty.js
var require_bulkSetIssueProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/bulkSetIssuesProperties.js
var require_bulkSetIssuesProperties = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/cancelTask.js
var require_cancelTask = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/changeFilterOwner.js
var require_changeFilterOwner = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/copyDashboard.js
var require_copyDashboard = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createComponent.js
var require_createComponent = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createCustomField.js
var require_createCustomField = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createCustomFieldContext.js
var require_createCustomFieldContext2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createCustomFieldOption.js
var require_createCustomFieldOption = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createDashboard.js
var require_createDashboard = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createFieldConfiguration.js
var require_createFieldConfiguration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createFieldConfigurationScheme.js
var require_createFieldConfigurationScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createFilter.js
var require_createFilter = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createGroup.js
var require_createGroup = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createIssue.js
var require_createIssue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createIssueFieldOption.js
var require_createIssueFieldOption = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createIssueLinkType.js
var require_createIssueLinkType = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createIssues.js
var require_createIssues = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createIssueSecurityScheme.js
var require_createIssueSecurityScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createIssueType.js
var require_createIssueType = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createIssueTypeAvatar.js
var require_createIssueTypeAvatar = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createIssueTypeScheme.js
var require_createIssueTypeScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createIssueTypeScreenScheme.js
var require_createIssueTypeScreenScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createNotificationScheme.js
var require_createNotificationScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createOrUpdateRemoteIssueLink.js
var require_createOrUpdateRemoteIssueLink = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createPermissionGrant.js
var require_createPermissionGrant = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createPermissionScheme.js
var require_createPermissionScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createPriority.js
var require_createPriority = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createProject.js
var require_createProject = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createProjectAvatar.js
var require_createProjectAvatar = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createProjectCategory.js
var require_createProjectCategory = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createProjectRole.js
var require_createProjectRole = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createResolution.js
var require_createResolution = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createScreen.js
var require_createScreen = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createScreenScheme.js
var require_createScreenScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createStatuses.js
var require_createStatuses = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createUiModification.js
var require_createUiModification = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createUser.js
var require_createUser = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createVersion.js
var require_createVersion = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createWorkflow.js
var require_createWorkflow = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createWorkflows.js
var require_createWorkflows = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createWorkflowScheme.js
var require_createWorkflowScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createWorkflowSchemeDraftFromParent.js
var require_createWorkflowSchemeDraftFromParent = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/createWorkflowTransitionProperty.js
var require_createWorkflowTransitionProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteActor.js
var require_deleteActor = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteAddonProperty.js
var require_deleteAddonProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteAndReplaceVersion.js
var require_deleteAndReplaceVersion = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteAppProperty.js
var require_deleteAppProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteAvatar.js
var require_deleteAvatar = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteComment.js
var require_deleteComment = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteCommentProperty.js
var require_deleteCommentProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteComponent.js
var require_deleteComponent = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteCustomField.js
var require_deleteCustomField = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteCustomFieldContext.js
var require_deleteCustomFieldContext = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteCustomFieldOption.js
var require_deleteCustomFieldOption = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteDashboard.js
var require_deleteDashboard = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteDashboardItemProperty.js
var require_deleteDashboardItemProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteDefaultWorkflow.js
var require_deleteDefaultWorkflow = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteDraftDefaultWorkflow.js
var require_deleteDraftDefaultWorkflow = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteDraftWorkflowMapping.js
var require_deleteDraftWorkflowMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteFavouriteForFilter.js
var require_deleteFavouriteForFilter = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteFieldConfiguration.js
var require_deleteFieldConfiguration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteFieldConfigurationScheme.js
var require_deleteFieldConfigurationScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteFilter.js
var require_deleteFilter = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteInactiveWorkflow.js
var require_deleteInactiveWorkflow = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteIssue.js
var require_deleteIssue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteIssueFieldOption.js
var require_deleteIssueFieldOption = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteIssueLink.js
var require_deleteIssueLink = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteIssueLinkType.js
var require_deleteIssueLinkType = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteIssueProperty.js
var require_deleteIssueProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteIssueType.js
var require_deleteIssueType = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteIssueTypeProperty.js
var require_deleteIssueTypeProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteIssueTypeScheme.js
var require_deleteIssueTypeScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteIssueTypeScreenScheme.js
var require_deleteIssueTypeScreenScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteNotificationScheme.js
var require_deleteNotificationScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deletePermissionScheme.js
var require_deletePermissionScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deletePermissionSchemeEntity.js
var require_deletePermissionSchemeEntity = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteProject.js
var require_deleteProject = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteProjectAsynchronously.js
var require_deleteProjectAsynchronously = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteProjectAvatar.js
var require_deleteProjectAvatar = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteProjectProperty.js
var require_deleteProjectProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteProjectRole.js
var require_deleteProjectRole = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteProjectRoleActorsFromRole.js
var require_deleteProjectRoleActorsFromRole = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteRemoteIssueLinkByGlobalId.js
var require_deleteRemoteIssueLinkByGlobalId = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteRemoteIssueLinkById.js
var require_deleteRemoteIssueLinkById = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteResolution.js
var require_deleteResolution = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteScreen.js
var require_deleteScreen = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteScreenScheme.js
var require_deleteScreenScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteScreenTab.js
var require_deleteScreenTab = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteSecurityScheme.js
var require_deleteSecurityScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteSharePermission.js
var require_deleteSharePermission = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteStatusesById.js
var require_deleteStatusesById = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteUiModification.js
var require_deleteUiModification = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteUserProperty.js
var require_deleteUserProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteWebhookById.js
var require_deleteWebhookById = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteWorkflowMapping.js
var require_deleteWorkflowMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteWorkflowScheme.js
var require_deleteWorkflowScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteWorkflowSchemeDraft.js
var require_deleteWorkflowSchemeDraft = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteWorkflowSchemeDraftIssueType.js
var require_deleteWorkflowSchemeDraftIssueType = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteWorkflowSchemeIssueType.js
var require_deleteWorkflowSchemeIssueType = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteWorkflowTransitionProperty.js
var require_deleteWorkflowTransitionProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteWorkflowTransitionRuleConfigurations.js
var require_deleteWorkflowTransitionRuleConfigurations = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteWorklog.js
var require_deleteWorklog = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/deleteWorklogProperty.js
var require_deleteWorklogProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/doTransition.js
var require_doTransition = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/editIssue.js
var require_editIssue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/evaluateJiraExpression.js
var require_evaluateJiraExpression = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/expandAttachmentForHumans.js
var require_expandAttachmentForHumans = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/expandAttachmentForMachines.js
var require_expandAttachmentForMachines = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/exportArchivedIssues.js
var require_exportArchivedIssues = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/findAssignableUsers.js
var require_findAssignableUsers = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/findBulkAssignableUsers.js
var require_findBulkAssignableUsers = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/findGroups.js
var require_findGroups = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/findUserKeysByQuery.js
var require_findUserKeysByQuery = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/findUsers.js
var require_findUsers = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/findUsersAndGroups.js
var require_findUsersAndGroups = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/findUsersByQuery.js
var require_findUsersByQuery = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/findUsersForPicker.js
var require_findUsersForPicker = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/findUsersWithAllPermissions.js
var require_findUsersWithAllPermissions = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/findUsersWithBrowsePermission.js
var require_findUsersWithBrowsePermission = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/fullyUpdateProjectRole.js
var require_fullyUpdateProjectRole = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAccessibleProjectTypeByKey.js
var require_getAccessibleProjectTypeByKey = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAddonProperties.js
var require_getAddonProperties = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAddonProperty.js
var require_getAddonProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAllDashboards.js
var require_getAllDashboards = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAllFieldConfigurations.js
var require_getAllFieldConfigurations = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAllFieldConfigurationSchemes.js
var require_getAllFieldConfigurationSchemes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAllGadgets.js
var require_getAllGadgets = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAllIssueFieldOptions.js
var require_getAllIssueFieldOptions = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAllIssueTypeSchemes.js
var require_getAllIssueTypeSchemes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAllLabels.js
var require_getAllLabels = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAllPermissionSchemes.js
var require_getAllPermissionSchemes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAllProjectAvatars.js
var require_getAllProjectAvatars = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAllScreenTabFields.js
var require_getAllScreenTabFields = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAllScreenTabs.js
var require_getAllScreenTabs = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAllStatuses.js
var require_getAllStatuses = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAllSystemAvatars.js
var require_getAllSystemAvatars = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAllUsers.js
var require_getAllUsers = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAllUsersDefault.js
var require_getAllUsersDefault = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAllWorkflowSchemes.js
var require_getAllWorkflowSchemes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAlternativeIssueTypes.js
var require_getAlternativeIssueTypes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getApplicationProperty.js
var require_getApplicationProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getApplicationRole.js
var require_getApplicationRole = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAssignedPermissionScheme.js
var require_getAssignedPermissionScheme = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAttachment.js
var require_getAttachment = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAttachmentContent.js
var require_getAttachmentContent = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAttachmentThumbnail.js
var require_getAttachmentThumbnail = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAuditRecords.js
var require_getAuditRecords = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAutoCompletePost.js
var require_getAutoCompletePost = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAvailableScreenFields.js
var require_getAvailableScreenFields = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAvatarImageByID.js
var require_getAvatarImageByID = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAvatarImageByOwner.js
var require_getAvatarImageByOwner = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAvatarImageByType.js
var require_getAvatarImageByType = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getAvatars.js
var require_getAvatars = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getBulkPermissions.js
var require_getBulkPermissions = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getChangeLogs.js
var require_getChangeLogs = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getChangeLogsByIds.js
var require_getChangeLogsByIds = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getColumns.js
var require_getColumns = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getComment.js
var require_getComment = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getCommentProperty.js
var require_getCommentProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getCommentPropertyKeys.js
var require_getCommentPropertyKeys = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getComments.js
var require_getComments = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getCommentsByIds.js
var require_getCommentsByIds = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getComponent.js
var require_getComponent = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getComponentRelatedIssues.js
var require_getComponentRelatedIssues = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getContextsForField.js
var require_getContextsForField = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getCreateIssueMeta.js
var require_getCreateIssueMeta = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getCurrentUser.js
var require_getCurrentUser = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getCustomFieldConfiguration.js
var require_getCustomFieldConfiguration = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getCustomFieldContextsForProjectsAndIssueTypes.js
var require_getCustomFieldContextsForProjectsAndIssueTypes = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getCustomFieldOption.js
var require_getCustomFieldOption = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getDashboard.js
var require_getDashboard = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getDashboardItemProperty.js
var require_getDashboardItemProperty = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getDashboardItemPropertyKeys.js
var require_getDashboardItemPropertyKeys = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getDashboardsPaginated.js
var require_getDashboardsPaginated = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getDefaultValues.js
var require_getDefaultValues = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getDefaultWorkflow.js
var require_getDefaultWorkflow = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getDraftDefaultWorkflow.js
var require_getDraftDefaultWorkflow = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getDraftWorkflow.js
var require_getDraftWorkflow = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getDynamicWebhooksForApp.js
var require_getDynamicWebhooksForApp = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getEditIssueMeta.js
var require_getEditIssueMeta = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getFailedWebhooks.js
var require_getFailedWebhooks = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getFavouriteFilters.js
var require_getFavouriteFilters = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getFeaturesForProject.js
var require_getFeaturesForProject = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getFieldAutoCompleteForQueryString.js
var require_getFieldAutoCompleteForQueryString = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getFieldConfigurationItems.js
var require_getFieldConfigurationItems = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getFieldConfigurationSchemeMappings.js
var require_getFieldConfigurationSchemeMappings = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getFieldConfigurationSchemeProjectMapping.js
var require_getFieldConfigurationSchemeProjectMapping = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getFieldsPaginated.js
var require_getFieldsPaginated = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getFilter.js
var require_getFilter = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getFiltersPaginated.js
var require_getFiltersPaginated = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// node_modules/jira.js/out/version2/parameters/getHierarchy.js
var require_getHierarchy = __commonJS((exports) => {
  Object.defineProperty(expor