
import { Client } from "@modelcontextprotocol/sdk/client/index.js";
import { StdioClientTransport } from "@modelcontextprotocol/sdk/client/stdio.js";
import dotenv from "dotenv";
import path from "path";
import { fileURLToPath } from "url";

// Load environment variables
function loadEnv() {
  const __dirname = path.dirname(fileURLToPath(import.meta.url));
  const envPath = path.resolve(__dirname, "../../.env");
  const result = dotenv.config({ path: envPath });
  if (result.error) {
    console.warn(`Warning: .env file not found at ${envPath}`);
  }
  return process.env;
}

async function main() {
  console.log("=== Test Jira Users Resource ===");

  const envVars = loadEnv();
  const serverPath = "/home/lethdat/projects/awing/mcp-jira-server/dist/index.js";

  const client = new Client({ name: "test-client", version: "1.0.0" }, {
    capabilities: { promts: {}, resources: {}, tools: {} }
  });

  const transport = new StdioClientTransport({
    command: "node",
    args: [serverPath],
    env: { ...process.env, ...envVars }
  });

  await client.connect(transport);
  console.log("Connected to MCP server");

  const projectKey = "ACMS"; // Testing with the project user reported

  try {
    // 1. Test assignable users
    console.log(`\nTesting jira://users/assignable/${projectKey}...`);
    const assignableUsers = await client.readResource({ uri: `jira://users/assignable/${projectKey}` });
    const assignableData = JSON.parse(String(assignableUsers.contents[0].text));
    console.log(`Found ${assignableData.users?.length || assignableData.length || 0} assignable users.`);
    if (assignableData.users && assignableData.users.length > 0) {
      console.log("Example user:", assignableData.users[0].displayName);
    }
  } catch (error) {
    console.error(`Error testing assignable users:`, error);
  }

  try {
    // 2. Test users root (search) - expecting message
    console.log(`\nTesting jira://users...`);
    const usersRoot = await client.readResource({ uri: `jira://users` });
    console.log("Response:", JSON.parse(String(usersRoot.contents[0].text)));
  } catch (error) {
    console.error(`Error testing users root:`, error);
  }

  client.close();
}

main().catch(console.error);