import fs from "fs";
import path from "path";

export interface UILibraryContext {
  packageName: string;
  packageRoot: string;
}

export function loadUILibraryContext(packageName: string): UILibraryContext {
  const pkgJsonPath = require.resolve(`${packageName}/package.json`);
  const packageRoot = path.dirname(pkgJsonPath);

  return {
    packageName,
    packageRoot,
  };
}
