import { executeTool, tools } from "../src/tools/index.js";

describe("MCP Tools", () => {
  describe("Tool Definitions", () => {
    it("should have all required tools defined", () => {
      const toolNames = tools.map((t) => t.name);
      expect(toolNames).toContain("analyze_design_system");
      expect(toolNames).toContain("analyze_storybook");
      expect(toolNames).toContain("parse_ui_intent");
      expect(toolNames).toContain("get_project_context");
      expect(toolNames).toContain("generate_ui_code");
    });

    it("should have valid tool schemas", () => {
      tools.forEach((tool) => {
        expect(tool.name).toBeDefined();
        expect(tool.description).toBeDefined();
        expect(tool.inputSchema).toBeDefined();
        expect(tool.inputSchema.type).toBe("object");
      });
    });
  });

  describe("executeTool", () => {
    it("should throw error for unknown tool", async () => {
      await expect(executeTool("unknown_tool", {})).rejects.toThrow(
        "Unknown tool: unknown_tool",
      );
    });

    it("should execute parse_ui_intent tool", async () => {
      const result = await executeTool("parse_ui_intent", {
        prompt: "Create a button and modal",
      });

      expect(result).toHaveProperty("description");
      expect(result).toHaveProperty("components");
      expect((result as any).components).toContain("Button");
      expect((result as any).components).toContain("Modal");
    });

    it("should execute get_project_context tool", async () => {
      const result = await executeTool("get_project_context", {});

      expect(result).toHaveProperty("framework");
      expect(result).toHaveProperty("hasPackageJson");
    });

    it("should execute generate_ui_code tool", async () => {
      const result = await executeTool("generate_ui_code", {
        description: "A simple button",
        components: ["Button"],
      });

      expect(result).toHaveProperty("code");
      expect((result as any).code).toContain("Button");
    });
  });
});
