import fs from "fs";
import path from "path";
export function analyzeDesignSystem(ctx) {
    const indexPath = path.join(ctx.packageRoot, "index.ts");
    if (!fs.existsSync(indexPath))
        return [];
    const content = fs.readFileSync(indexPath, "utf-8");
    const exports = [...content.matchAll(/export \{ (\w+)/g)];
    return exports.map((m) => ({
        name: m[1],
        importPath: ctx.packageName,
    }));
}
