import fs from "fs";
import path from "path";

export interface ProjectContext {
  framework: "react";
  language: "ts" | "js";
  hasPackageJson: boolean;
}

export function inferProjectContext(): ProjectContext {
  const hasPackageJson = fs.existsSync(
    path.join(process.cwd(), "package.json"),
  );

  return {
    framework: "react",
    language: "ts",
    hasPackageJson,
  };
}
