import fs from "fs";
import path from "path";
import { UILibraryContext } from "../context/ui-library.context.js";

export interface UIComponentMeta {
  name: string;
  importPath: string;
}

export function analyzeDesignSystem(ctx: UILibraryContext): UIComponentMeta[] {
  const indexPath = path.join(ctx.packageRoot, "index.ts");

  if (!fs.existsSync(indexPath)) return [];

  const content = fs.readFileSync(indexPath, "utf-8");

  const exports = [...content.matchAll(/export \{ (\w+)/g)];

  return exports.map((m) => ({
    name: m[1],
    importPath: ctx.packageName,
  }));
}
