import { generateReactCode } from "../src/core/codegen.core.js";
import { UIIntent } from "../src/core/intent.core.js";

describe("Code Generator", () => {
  it("should generate code with Button component", () => {
    const intent: UIIntent = {
      description: "A simple button",
      components: ["Button"],
    };

    const result = generateReactCode(intent);

    expect(result.code).toContain("import");
    expect(result.code).toContain("Button");
    expect(result.code).toContain("export");
  });

  it("should generate code with multiple components", () => {
    const intent: UIIntent = {
      description: "Button and Modal",
      components: ["Button", "Modal"],
    };

    const result = generateReactCode(intent);

    expect(result.code).toContain("Button");
    expect(result.code).toContain("Modal");
  });

  it("should include description in code", () => {
    const intent: UIIntent = {
      description: "User profile form",
      components: ["Form"],
    };

    const result = generateReactCode(intent);

    expect(result.code).toContain("User profile form");
  });

  it("should return valid React component structure", () => {
    const intent: UIIntent = {
      description: "Test component",
      components: ["Button"],
    };

    const result = generateReactCode(intent);

    expect(result.code).toMatch(/export\s+(default\s+)?function/);
  });
});
