import { parseUIIntent } from "../src/core/intent.core.js";

describe("Intent Parser", () => {
  it("should parse button intent", () => {
    const result = parseUIIntent("Create a button");

    expect(result.description).toBe("Create a button");
    expect(result.components).toContain("Button");
  });

  it("should parse modal intent", () => {
    const result = parseUIIntent("Show a modal dialog");

    expect(result.description).toBe("Show a modal dialog");
    expect(result.components).toContain("Modal");
  });

  it("should parse multiple components", () => {
    const result = parseUIIntent("Create a button that opens a modal");

    expect(result.components).toContain("Button");
    expect(result.components).toContain("Modal");
    expect(result.components).toHaveLength(2);
  });

  it("should return empty components for unknown intent", () => {
    const result = parseUIIntent("Something random");

    expect(result.components).toHaveLength(0);
  });

  it("should be case insensitive", () => {
    const result = parseUIIntent("CREATE A BUTTON");

    expect(result.components).toContain("Button");
  });
});
