# CLAUDE CODE SYSTEM INSTRUCTIONS & WORKFLOWS

## I. Global Rules

### 1. Code & Tiêu chuẩn
**Ngôn ngữ**: Communications/docs/comments/commits → Tiếng Việt. Code/biến/file → English.

**Chất lượng**: SOLID, DRY, KISS, YAGNI, Clean Code. Code phải pass compiler, linter, formatter trước khi commit.

**Bảo mật**: Không hardcode secrets. Dùng .env, appsettings.json.

**Validation**: Validate chặt chẽ mọi input (type, range, format, business rules).

**Hiệu năng**: Ưu tiên thư viện chuẩn thay vì tự code thuật toán phổ biến.

**Comment**: Giải thích WHY, không chỉ WHAT. Code tự giải thích thì không cần comment.

**Logging**: DEBUG→INFO→WARN→ERROR. Catch specific exceptions. Error message sạch cho user, log đầy đủ stack trace. Mask sensitive data.

**Dependencies**: Chỉ install khi cần. Pin version cho production.

**Ưu tiên**: Workspace Rules > Global Rules khi có xung đột.

### 2. Testing
- Viết unit test trong quá trình implement
- AI phải tự động viết test, không chờ được yêu cầu
- Coverage tối thiểu: 90%
- @critical (Path Coverage 100%): Thanh toán, Auth, Validation, Logic phức tạp, Public APIs

### 3. Debug
- Đọc log/test để tìm Root Cause trong codebase
- Không lặp lại giải pháp sai quá 2 lần
- Đổi Plan phải chờ phê duyệt

### 4. Version Control & Task Management
**TaskId**: Jira Issue {PROJECT-NUMBER} (VD: AID-123)
- Branch: {tên nhánh hiện tại}-{taskId}
- Commit: {taskId} - {Nội dung Tiếng Việt}

### 5. Claude Code Rules

**Tools Policy:**
- **BẮT BUỘC:**
  - Read trước khi Edit/Write
  - TodoWrite khi task ≥3 steps: Update real-time, exactly 1 in_progress
  - Edit > Write cho file đã tồn tại
- **CẤM:**
  - ❌ bash cat/grep/find/sed/echo cho file operations
  - ❌ Tạo docs/README trừ khi được yêu cầu

**Model Selection:**

BẮT BUỘC phải chọn model theo hướng dẫn sau:

| Bước | Model | Cách thực hiện |
|------|-------|----------------|
| 1. Context Discovery | Haiku | Delegate qua Task tool |
| 2-3. Design + Plan | Sonnet* | Main assistant xử lý |
| 4-6. Implement + Test | Haiku | Delegate qua Task tool |

*User có thể chọn Opus nếu cần (xem escalation flow)

**Thông báo:** Phải thông báo model trước mỗi bước, ở mỗi task. Ví dụ : 
- "Bước 1 với Sonnet model"
- "Task(Explore) với Haiku model"

---

## II. Workflows (Tuần tự & Bắt buộc)

### 1. Context Discovery
- Quét cấu trúc dự án, hiểu tech stack
- Scan các file liên quan để hiểu patterns và conventions
- Xác định {taskId} (format: xem Global Rules)
- **ƯU TIÊN:** Task(Explore) cho broad exploration | Glob/Grep cho needle queries

**🛑 DỪNG NGAY TẠI ĐÂY** nếu chưa có {taskId}:
- Không làm công việc nào khác
- Yêu cầu user bổ sung {taskId}


### 2. High-level Design
- Đề xuất các phương án với ưu/nhược điểm
- **ƯU TIÊN:** AskUserQuestion (2-4 options) | Manual text

**🛑 DỪNG NGAY TẠI ĐÂY**:
- KHÔNG ĐƯỢC tiếp tục sang Bước 3
- Chờ user xác nhận phương án được chọn
- User có thể yêu cầu điều chỉnh hoặc xem xét phương án khác

### 3. Implementation Plan

**Xác định (>3 files):** BẮT BUỘC vào EnterPlanMode, ngược lại thì tiếp tục Manual planning

**Scan References & Planning:**
- Quét codebase tìm references phù hợp
- Liệt kê references với lý do (similarity, patterns, priority)
- List files cần tạo/sửa
- Xác định thư viện cần cài (nếu có)
- Các bước thực hiện tổng quan

**🛑 DỪNG:** Chờ user approve plan

**SAU KHI APPROVE:**
- **Nếu Plan Mode:** Viết final plan gọn (files, refs, deps, steps. KHÔNG: explore logs, scan details) → ExitPlanMode
- **BẮT BUỘC:** TodoWrite (tạo todo list)
- Tiếp tục Bước 4

### 4. Implementation
- Thực thi theo Plan
- Follow references và patterns đã xác định
- **BẮT BUỘC:** Read trước Edit/Write, TodoWrite update (`in_progress` → `completed`)

### 5. Verification Loop
- Chạy test (Bash: dotnet test, npm test, pytest...)
- **Nếu FAIL:** Đọc log → Sửa lỗi → TodoWrite update → Chạy lại
- **Đếm tổng số lần fail** (kể cả lỗi khác nhau)

**🛑 DỪNG NGAY sau 3 lần fail**:
- KHÔNG ĐƯỢC tự tiếp tục fix
- Báo cáo tình trạng cho user (lỗi gì, đã fix gì)
- Chờ user quyết định: Escalate / Về Bước 2 / Về Bước 3
- Nếu về Bước 2/3: Hỏi user có muốn chuyển lên Opus không (mặc định Sonnet)


### 6. Finalize
- TodoWrite: Mark all completed
- Tự đánh giá kết quả vs yêu cầu
- Cập nhật docs nếu cần (API docs, migration script, README quan trọng). Tất cả các docs đưa vào thư mục `implementation_plan_{taskId}` trong root project
- Ghi lại bài học cho lần sau
- Commit: `git add [files] && git commit -m "{taskId} - {Nội dung Tiếng Việt}"`
